/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttTask;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.task.CustomColumn;
import net.sourceforge.ganttproject.task.CustomColumnsException;
import net.sourceforge.ganttproject.task.CustomColumnsStorage;
import net.sourceforge.ganttproject.task.CustomColumnsValues;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskDocumentOrderComparator;
import net.sourceforge.ganttproject.task.TaskImpl;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskLengthImpl;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskManagerConfig;
import net.sourceforge.ganttproject.task.TaskNode;
import net.sourceforge.ganttproject.task.algorithm.AdjustTaskBoundsAlgorithm;
import net.sourceforge.ganttproject.task.algorithm.AlgorithmCollection;
import net.sourceforge.ganttproject.task.algorithm.CriticalPathAlgorithmImpl;
import net.sourceforge.ganttproject.task.algorithm.FindPossibleDependeesAlgorithmImpl;
import net.sourceforge.ganttproject.task.algorithm.ProjectBoundsAlgorithm;
import net.sourceforge.ganttproject.task.algorithm.RecalculateTaskCompletionPercentageAlgorithm;
import net.sourceforge.ganttproject.task.algorithm.RecalculateTaskScheduleAlgorithm;
import net.sourceforge.ganttproject.task.dependency.EventDispatcher;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyCollection;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyCollectionImpl;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyException;
import net.sourceforge.ganttproject.task.dependency.constraint.ConstraintImpl;
import net.sourceforge.ganttproject.task.dependency.constraint.FinishFinishConstraintImpl;
import net.sourceforge.ganttproject.task.dependency.constraint.FinishStartConstraintImpl;
import net.sourceforge.ganttproject.task.dependency.constraint.StartFinishConstraintImpl;
import net.sourceforge.ganttproject.task.dependency.constraint.StartStartConstraintImpl;
import net.sourceforge.ganttproject.task.event.TaskDependencyEvent;
import net.sourceforge.ganttproject.task.event.TaskHierarchyEvent;
import net.sourceforge.ganttproject.task.event.TaskListener;
import net.sourceforge.ganttproject.task.event.TaskPropertyEvent;
import net.sourceforge.ganttproject.task.event.TaskScheduleEvent;
import net.sourceforge.ganttproject.task.hierarchy.TaskHierarchyManagerImpl;
import net.sourceforge.ganttproject.time.DateFrameable;
import net.sourceforge.ganttproject.time.TimeUnit;
import net.sourceforge.ganttproject.time.gregorian.GregorianCalendar;

public class TaskManagerImpl
implements TaskManager {
    private final TaskHierarchyManagerImpl myHierarchyManager;
    private final TaskDependencyCollectionImpl myDependencyCollection;
    private final AlgorithmCollection myAlgorithmCollection;
    private final List myListeners = new ArrayList();
    private int myMaxID = -1;
    private Task myRoot;
    private final TaskManagerConfig myConfig;
    private final TaskContainmentHierarchyFacade.Factory myFacadeFactory;
    private TaskContainmentHierarchyFacade myTaskContainment;
    private boolean areEventsEnabled = true;
    private final TaskMap myTaskMap = new TaskMap(this);
    private final CustomColumnsStorage myCustomColumnStorage;
    static /* synthetic */ Class class$net$sourceforge$ganttproject$task$TaskManagerImpl;

    TaskManagerImpl(TaskContainmentHierarchyFacade.Factory containmentFacadeFactory, TaskManagerConfig config, CustomColumnsStorage columnStorage) {
        this.myCustomColumnStorage = columnStorage == null ? new CustomColumnsStorage() : columnStorage;
        this.myConfig = config;
        this.myHierarchyManager = new TaskHierarchyManagerImpl();
        EventDispatcher dispatcher = new EventDispatcher(){

            public void fireDependencyAdded(TaskDependency dep) {
                TaskManagerImpl.this.fireDependencyAdded(dep);
            }

            public void fireDependencyRemoved(TaskDependency dep) {
                TaskManagerImpl.this.fireDependencyRemoved(dep);
            }
        };
        this.myDependencyCollection = new TaskDependencyCollectionImpl(containmentFacadeFactory, dispatcher){
            private TaskContainmentHierarchyFacade myTaskHierarchy;

            protected TaskContainmentHierarchyFacade getTaskHierarchy() {
                if (this.myTaskHierarchy == null) {
                    this.myTaskHierarchy = TaskManagerImpl.this.getTaskHierarchy();
                }
                return this.myTaskHierarchy;
            }
        };
        this.myFacadeFactory = containmentFacadeFactory == null ? new FacadeFactoryImpl() : containmentFacadeFactory;
        Date today = GregorianCalendar.getInstance().getTime();
        this.myRoot = new GanttTask(null, new GanttCalendar(today), 1L, this, -1);
        this.myRoot.setStart(new GanttCalendar(GregorianCalendar.getInstance().getTime()));
        this.myRoot.setDuration(this.createLength(this.getConfig().getTimeUnitStack().getDefaultTimeUnit(), 1.0f));
        this.myRoot.setExpand(true);
        FindPossibleDependeesAlgorithmImpl alg1 = new FindPossibleDependeesAlgorithmImpl(){

            protected TaskContainmentHierarchyFacade createContainmentFacade() {
                return TaskManagerImpl.this.getTaskHierarchy();
            }
        };
        AdjustTaskBoundsAlgorithm alg3 = new AdjustTaskBoundsAlgorithm(){

            protected TaskContainmentHierarchyFacade createContainmentFacade() {
                return TaskManagerImpl.this.getTaskHierarchy();
            }
        };
        RecalculateTaskScheduleAlgorithm alg2 = new RecalculateTaskScheduleAlgorithm(alg3){

            protected TaskContainmentHierarchyFacade createContainmentFacade() {
                return TaskManagerImpl.this.getTaskHierarchy();
            }
        };
        RecalculateTaskCompletionPercentageAlgorithm alg4 = new RecalculateTaskCompletionPercentageAlgorithm(){

            protected TaskContainmentHierarchyFacade createContainmentFacade() {
                return TaskManagerImpl.this.getTaskHierarchy();
            }
        };
        ProjectBoundsAlgorithm alg5 = new ProjectBoundsAlgorithm();
        this.myAlgorithmCollection = new AlgorithmCollection(alg1, alg2, alg3, alg4, alg5);
    }

    public GanttTask getTask(int taskId) {
        return (GanttTask)this.myTaskMap.getTask(taskId);
    }

    public Task getRootTask() {
        if (this.myRoot == null) {
            // empty if block
        }
        return this.myRoot;
    }

    public Task[] getTasks() {
        return this.myTaskMap.getTasks();
    }

    public void clear() {
        this.myTaskMap.clear();
        this.setMaxID(-1);
        this.myDependencyCollection.clear();
        Date today = GregorianCalendar.getInstance().getTime();
        this.myRoot = new GanttTask(null, new GanttCalendar(today), 1L, this, -1);
        this.myRoot.setStart(new GanttCalendar(GregorianCalendar.getInstance().getTime()));
        this.myRoot.setDuration(this.createLength(this.getConfig().getTimeUnitStack().getDefaultTimeUnit(), 1.0f));
        this.myRoot.setExpand(true);
    }

    public void deleteTask(Task tasktoRemove) {
        this.myTaskMap.removeTask(tasktoRemove);
    }

    public GanttTask createTask() {
        GanttTask result = this.createTask(-1);
        return result;
    }

    public GanttTask createTask(int taskID) {
        GanttTask result = new GanttTask("", new GanttCalendar(), 1L, this, taskID);
        if (result.getTaskID() >= this.getMaxID()) {
            this.setMaxID(result.getTaskID() + 1);
        }
        this.fireTaskAdded(result);
        return result;
    }

    public void registerTask(Task task) {
        int taskID = task.getTaskID();
        if (this.myTaskMap.getTask(taskID) == null) {
            this.myTaskMap.addTask(task);
            if (this.getMaxID() < taskID) {
                this.setMaxID(taskID + 1);
            }
        } else {
            throw new RuntimeException("There is a task that already has the ID " + taskID);
        }
    }

    boolean isRegistered(TaskImpl task) {
        return this.myTaskMap.getTask(task.getTaskID()) != null;
    }

    public int getTaskCount() {
        return this.myTaskMap.size();
    }

    public TaskLength getProjectLength() {
        if (this.myTaskMap.isEmpty()) {
            return this.createLength(this.getConfig().getTimeUnitStack().getDefaultTimeUnit(), 0.0f);
        }
        ProjectBoundsAlgorithm.Result result = this.getAlgorithmCollection().getProjectBoundsAlgorithm().getBounds(Arrays.asList(this.myTaskMap.getTasks()));
        return this.createLength(this.getConfig().getTimeUnitStack().getDefaultTimeUnit(), result.lowerBound, result.upperBound);
    }

    public Date getProjectStart() {
        if (this.myTaskMap.isEmpty()) {
            return this.myRoot.getStart().getTime();
        }
        ProjectBoundsAlgorithm.Result result = this.getAlgorithmCollection().getProjectBoundsAlgorithm().getBounds(Arrays.asList(this.myTaskMap.getTasks()));
        return result.lowerBound;
    }

    public Date getProjectEnd() {
        if (this.myTaskMap.isEmpty()) {
            return this.myRoot.getStart().getTime();
        }
        ProjectBoundsAlgorithm.Result result = this.getAlgorithmCollection().getProjectBoundsAlgorithm().getBounds(Arrays.asList(this.myTaskMap.getTasks()));
        return result.upperBound;
    }

    public TaskLength createLength(TimeUnit unit, float length) {
        return new TaskLengthImpl(unit, length);
    }

    public TaskLength createLength(long count) {
        return new TaskLengthImpl(this.getConfig().getTimeUnitStack().getDefaultTimeUnit(), count);
    }

    public TaskLength createLength(TimeUnit timeUnit, Date startDate, Date endDate) {
        int unitCount;
        int sign = 1;
        if (endDate.before(startDate)) {
            sign = -1;
            Date temp = endDate;
            endDate = startDate;
            startDate = temp;
        }
        if (timeUnit instanceof DateFrameable) {
            TimeUnit df = timeUnit;
            unitCount = 0;
            while (startDate.before(endDate)) {
                startDate = df.adjustRight(startDate);
                ++unitCount;
            }
        } else {
            throw new IllegalArgumentException("Time unit=" + timeUnit + " is not date frameable");
        }
        TaskLengthImpl result = new TaskLengthImpl(timeUnit, unitCount * sign);
        return result;
    }

    public TaskDependencyCollection getDependencyCollection() {
        return this.myDependencyCollection;
    }

    public AlgorithmCollection getAlgorithmCollection() {
        return this.myAlgorithmCollection;
    }

    public TaskHierarchyManagerImpl getHierarchyManager() {
        return this.myHierarchyManager;
    }

    /*
     * WARNING - void declaration
     */
    public TaskDependencyConstraint createConstraint(int constraintID) {
        void var2_2;
        switch (constraintID) {
            case 2: {
                ConstraintImpl result = new FinishStartConstraintImpl();
                break;
            }
            case 3: {
                ConstraintImpl result = new FinishFinishConstraintImpl();
                break;
            }
            case 4: {
                ConstraintImpl result = new StartFinishConstraintImpl();
                break;
            }
            case 1: {
                ConstraintImpl result = new StartStartConstraintImpl();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown constraint ID=" + constraintID);
            }
        }
        return var2_2;
    }

    public int getMaxID() {
        return this.myMaxID;
    }

    private void setMaxID(int id) {
        this.myMaxID = id;
    }

    void increaseMaxID() {
        ++this.myMaxID;
    }

    public void addTaskListener(TaskListener listener) {
        this.myListeners.add(listener);
    }

    public GPCalendar getCalendar() {
        return this.getConfig().getCalendar();
    }

    public void fireTaskProgressChanged(Task changedTask) {
        if (this.areEventsEnabled) {
            TaskPropertyEvent e = new TaskPropertyEvent(changedTask);
            for (int i = 0; i < this.myListeners.size(); ++i) {
                TaskListener next = (TaskListener)this.myListeners.get(i);
                next.taskProgressChanged(e);
            }
        }
    }

    void fireTaskScheduleChanged(Task changedTask, GanttCalendar oldStartDate, GanttCalendar oldFinishDate) {
        if (this.areEventsEnabled) {
            TaskScheduleEvent e = new TaskScheduleEvent(changedTask, oldStartDate, oldFinishDate, changedTask.getStart(), changedTask.getEnd());
            for (int i = 0; i < this.myListeners.size(); ++i) {
                TaskListener next = (TaskListener)this.myListeners.get(i);
                next.taskScheduleChanged(e);
            }
        }
    }

    private void fireDependencyAdded(TaskDependency newDependency) {
        if (this.areEventsEnabled) {
            TaskDependencyEvent e = new TaskDependencyEvent(this.getDependencyCollection(), newDependency);
            for (int i = 0; i < this.myListeners.size(); ++i) {
                TaskListener next = (TaskListener)this.myListeners.get(i);
                next.dependencyAdded(e);
            }
        }
    }

    private void fireDependencyRemoved(TaskDependency dep) {
        TaskDependencyEvent e = new TaskDependencyEvent(this.getDependencyCollection(), dep);
        for (int i = 0; i < this.myListeners.size(); ++i) {
            TaskListener next = (TaskListener)this.myListeners.get(i);
            next.dependencyRemoved(e);
        }
    }

    private void fireTaskAdded(Task task) {
        if (this.areEventsEnabled) {
            TaskHierarchyEvent e = new TaskHierarchyEvent(this, task, null, this.getTaskHierarchy().getContainer(task));
            for (int i = 0; i < this.myListeners.size(); ++i) {
                TaskListener next = (TaskListener)this.myListeners.get(i);
                next.taskAdded(e);
            }
        }
    }

    private void fireTaskRemoved(Task task, Task oldSupertask) {
        TaskHierarchyEvent e = new TaskHierarchyEvent(this, task, oldSupertask, null);
        for (int i = 0; i < this.myListeners.size(); ++i) {
            TaskListener next = (TaskListener)this.myListeners.get(i);
            next.taskRemoved(e);
        }
    }

    void fireTaskPropertiesChanged(Task task) {
        if (this.areEventsEnabled) {
            TaskPropertyEvent e = new TaskPropertyEvent(task);
            for (int i = 0; i < this.myListeners.size(); ++i) {
                TaskListener next = (TaskListener)this.myListeners.get(i);
                next.taskPropertiesChanged(e);
            }
        }
    }

    public TaskManagerConfig getConfig() {
        return this.myConfig;
    }

    public TaskContainmentHierarchyFacade getTaskHierarchy() {
        return this.myFacadeFactory.createFacede();
    }

    public TaskManager emptyClone() {
        return new TaskManagerImpl(null, this.myConfig, null);
    }

    public Map importData(TaskManager taskManager) {
        Task importRoot = taskManager.getRootTask();
        HashMap original2imported = new HashMap();
        this.importData(importRoot, this.getRootTask(), original2imported);
        TaskDependency[] deps = taskManager.getDependencyCollection().getDependencies();
        for (int i = 0; i < deps.length; ++i) {
            Task nextDependant = deps[i].getDependant();
            Task nextDependee = deps[i].getDependee();
            Task importedDependant = (Task)original2imported.get(nextDependant);
            Task importedDependee = (Task)original2imported.get(nextDependee);
            try {
                TaskDependency dependency = this.getDependencyCollection().createDependency(importedDependant, importedDependee, new FinishStartConstraintImpl());
                dependency.setConstraint(deps[i].getConstraint());
                dependency.setDifference(deps[i].getDifference());
                dependency.setHardness(deps[i].getHardness());
                continue;
            }
            catch (TaskDependencyException e) {
                e.printStackTrace();
            }
        }
        return original2imported;
    }

    private void importData(Task importRoot, Task root, Map original2imported) {
        Task[] nested = importRoot.getManager().getTaskHierarchy().getNestedTasks(importRoot);
        for (int i = nested.length - 1; i >= 0; --i) {
            GanttTask nextImported = this.createTask();
            this.registerTask(nextImported);
            nextImported.setName(nested[i].getName());
            nextImported.setStart(nested[i].getStart().Clone());
            nextImported.setDuration(nested[i].getDuration());
            nextImported.setMilestone(nested[i].isMilestone());
            nextImported.setColor(nested[i].getColor());
            nextImported.setShape(nested[i].getShape());
            nextImported.setCompletionPercentage(nested[i].getCompletionPercentage());
            nextImported.setNotes(nested[i].getNotes());
            nextImported.setTaskInfo(nested[i].getTaskInfo());
            nextImported.setExpand(nested[i].getExpand());
            if (nested[i].getThird() != null) {
                nextImported.setThirdDate(nested[i].getThird().Clone());
                nextImported.setThirdDateConstraint(nested[i].getThirdDateConstraint());
            }
            this.myCustomColumnStorage.processNewTask(nextImported);
            CustomColumnsValues customValues = nested[i].getCustomValues();
            Collection customColums = this.myCustomColumnStorage.getCustomColums();
            Iterator it = customColums.iterator();
            while (it.hasNext()) {
                CustomColumn nextColumn = (CustomColumn)it.next();
                Object value = customValues.getValue(nextColumn.getName());
                if (value == null) continue;
                try {
                    nextImported.getCustomValues().setValue(nextColumn.getName(), value);
                }
                catch (CustomColumnsException e) {
                    e.printStackTrace();
                }
            }
            original2imported.put(nested[i], nextImported);
            this.getTaskHierarchy().move(nextImported, root);
            this.importData(nested[i], nextImported, original2imported);
        }
    }

    public Date findClosestWorkingTime(Date time) {
        return this.getCalendar().findClosestWorkingTime(time);
    }

    public void processCriticalPath(TaskNode root) {
        try {
            this.myAlgorithmCollection.getRecalculateTaskScheduleAlgorithm().run();
        }
        catch (TaskDependencyException e) {
            e.printStackTrace();
        }
        CriticalPathAlgorithmImpl criticAlgo = new CriticalPathAlgorithmImpl(root, this.getCalendar());
        Task[] tasks = criticAlgo.getCriticalTasks();
        this.resetCriticalPath(root);
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i].setCritical(true);
        }
    }

    private void resetCriticalPath(TaskNode root) {
        Enumeration<TreeNode> en = root.preorderEnumeration();
        while (en.hasMoreElements()) {
            TreeNode next = en.nextElement();
            if (!(next instanceof TaskNode)) continue;
            Task t = (Task)((TaskNode)next).getUserObject();
            t.setCritical(false);
        }
    }

    public void importAssignments(TaskManager importedTaskManager, ResourceManager hrManager, Map original2importedTask, Map original2importedResource) {
        Task[] tasks = importedTaskManager.getTasks();
        for (int i = 0; i < tasks.length; ++i) {
            ResourceAssignment[] assignments = tasks[i].getAssignments();
            for (int j = 0; j < assignments.length; ++j) {
                GanttTask task = this.getTask(((Task)original2importedTask.get(tasks[i])).getTaskID());
                ResourceAssignment assignment = task.getAssignmentCollection().addAssignment((HumanResource)original2importedResource.get(assignments[j].getResource()));
                assignment.setLoad(assignments[j].getLoad());
                assignment.setCoordinator(assignments[j].isCoordinator());
            }
        }
    }

    void onTaskMoved(TaskImpl task) {
        if (!this.isRegistered(task)) {
            this.registerTask(task);
        }
        this.myTaskMap.setDirty();
    }

    public void setEventsEnabled(boolean enabled) {
        this.areEventsEnabled = enabled;
    }

    public CustomColumnsStorage getCustomColumnStorage() {
        return this.myCustomColumnStorage;
    }

    private class FacadeFactoryImpl
    implements TaskContainmentHierarchyFacade.Factory {
        private FacadeFactoryImpl() {
        }

        public TaskContainmentHierarchyFacade createFacede() {
            return new FacadeImpl();
        }
    }

    private final class FacadeImpl
    implements TaskContainmentHierarchyFacade {
        private List myPathBuffer = new ArrayList();
        static final /* synthetic */ boolean $assertionsDisabled;

        private FacadeImpl() {
        }

        public Task[] getNestedTasks(Task container) {
            return container.getNestedTasks();
        }

        public boolean hasNestedTasks(Task container) {
            return TaskManagerImpl.this.myRoot == null ? false : TaskManagerImpl.this.myRoot.isMilestone();
        }

        public Task getRootTask() {
            return TaskManagerImpl.this.getRootTask();
        }

        public Task getContainer(Task nestedTask) {
            return nestedTask.getSupertask();
        }

        public boolean areUnrelated(Task first, Task second) {
            this.myPathBuffer.clear();
            Task container = this.getContainer(first);
            while (container != null) {
                this.myPathBuffer.add(container);
                container = this.getContainer(container);
            }
            if (this.myPathBuffer.contains(second)) {
                return false;
            }
            this.myPathBuffer.clear();
            container = this.getContainer(second);
            while (container != null) {
                this.myPathBuffer.add(container);
                container = this.getContainer(container);
            }
            return !this.myPathBuffer.contains(first);
        }

        public void move(Task whatMove, Task whereMove) {
            whatMove.move(whereMove);
        }

        public int getDepth(Task task) {
            int depth = 0;
            while (task != TaskManagerImpl.this.myRoot) {
                task = task.getSupertask();
                ++depth;
            }
            return depth;
        }

        public int compareDocumentOrder(Task task1, Task task2) {
            if (task1 == task2) {
                return 0;
            }
            ArrayList<Task> buffer1 = new ArrayList<Task>();
            Task container = task1;
            while (container != null) {
                buffer1.add(0, container);
                container = this.getContainer(container);
            }
            ArrayList<Task> buffer2 = new ArrayList<Task>();
            Task container2 = task2;
            while (container2 != null) {
                buffer2.add(0, container2);
                container2 = this.getContainer(container2);
            }
            if (buffer1.get(0) != this.getRootTask() && buffer2.get(0) == this.getRootTask()) {
                return -1;
            }
            if (buffer1.get(0) == this.getRootTask() && buffer2.get(0) != this.getRootTask()) {
                return 1;
            }
            boolean result = false;
            int i = 0;
            Task commonRoot = null;
            while (i != buffer1.size()) {
                Task root2;
                if (i == buffer2.size()) {
                    return 1;
                }
                Task root1 = (Task)buffer1.get(i);
                if (root1 != (root2 = (Task)buffer2.get(i))) {
                    if (!$assertionsDisabled && commonRoot == null) {
                        throw new AssertionError((Object)("Failure comparing task=" + task1 + " and task=" + task2 + "\n. Path1=" + buffer1 + "\nPath2=" + buffer2));
                    }
                    Task[] nestedTasks = commonRoot.getNestedTasks();
                    for (int j = 0; j < nestedTasks.length; ++j) {
                        if (nestedTasks[j] == root1) {
                            return -1;
                        }
                        if (nestedTasks[j] != root2) continue;
                        return 1;
                    }
                    throw new IllegalStateException("We should not be here");
                }
                ++i;
                commonRoot = root1;
            }
            return -1;
        }

        public boolean contains(Task task) {
            throw new UnsupportedOperationException();
        }

        static {
            $assertionsDisabled = !(class$net$sourceforge$ganttproject$task$TaskManagerImpl == null ? (class$net$sourceforge$ganttproject$task$TaskManagerImpl = TaskManagerImpl.class$("net.sourceforge.ganttproject.task.TaskManagerImpl")) : class$net$sourceforge$ganttproject$task$TaskManagerImpl).desiredAssertionStatus();
        }
    }

    private static class TaskMap {
        private final Map myId2task = new HashMap();
        private TaskDocumentOrderComparator myComparator;
        private boolean isModified = true;
        private Task[] myArray;
        private final TaskManagerImpl myManager;

        TaskMap(TaskManagerImpl taskManager) {
            this.myComparator = new TaskDocumentOrderComparator(taskManager);
            this.myManager = taskManager;
        }

        void addTask(Task task) {
            this.myId2task.put(new Integer(task.getTaskID()), task);
            this.isModified = true;
        }

        Task getTask(int id) {
            return (Task)this.myId2task.get(new Integer(id));
        }

        public Task[] getTasks() {
            if (this.isModified) {
                this.myArray = this.myId2task.values().toArray(new Task[this.myId2task.size()]);
                Arrays.sort(this.myArray, this.myComparator);
                this.isModified = false;
            }
            return this.myArray;
        }

        public void clear() {
            this.myId2task.clear();
            this.isModified = true;
        }

        public void removeTask(Task task) {
            this.myId2task.remove(new Integer(task.getTaskID()));
            Task[] nestedTasks = this.myManager.getTaskHierarchy().getNestedTasks(task);
            for (int i = 0; i < nestedTasks.length; ++i) {
                this.removeTask(nestedTasks[i]);
            }
            this.isModified = true;
        }

        public int size() {
            return this.myId2task.size();
        }

        public boolean isEmpty() {
            return this.myId2task.isEmpty();
        }

        void setDirty() {
            this.isModified = true;
        }
    }
}

