/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.ResourceAssignmentCollection;
import net.sourceforge.ganttproject.task.ResourceAssignmentMutator;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskImpl;

class ResourceAssignmentCollectionImpl
implements ResourceAssignmentCollection {
    private final Map myAssignments = new HashMap();
    private final TaskImpl myTask;
    private ResourceManager myResourceManager;

    public ResourceAssignmentCollectionImpl(TaskImpl task, ResourceManager resourceManager) {
        this.myTask = task;
        this.myResourceManager = resourceManager;
    }

    private ResourceAssignmentCollectionImpl(ResourceAssignmentCollectionImpl collection) {
        this.myTask = collection.myTask;
        ResourceAssignment[] assignments = collection.getAssignments();
        for (int i = 0; i < assignments.length; ++i) {
            ResourceAssignment next = assignments[i];
            ResourceAssignmentImpl copy = new ResourceAssignmentImpl(next.getResource());
            copy.setLoad(next.getLoad());
            copy.setCoordinator(next.isCoordinator());
            copy.setRoleForAssignment(next.getRoleForAssignment());
            this.addAssignment(copy);
        }
    }

    public void clear() {
        ResourceAssignment[] assignments = this.getAssignments();
        for (int i = 0; i < assignments.length; ++i) {
            assignments[i].delete();
        }
    }

    public ResourceAssignment[] getAssignments() {
        return this.myAssignments.values().toArray(new ResourceAssignment[this.myAssignments.size()]);
    }

    public ResourceAssignment getAssignment(ProjectResource resource) {
        return (ResourceAssignment)this.myAssignments.get(resource);
    }

    public ResourceAssignmentMutator createMutator() {
        return new ResourceAssignmentMutatorImpl();
    }

    ResourceAssignmentCollectionImpl copy() {
        return new ResourceAssignmentCollectionImpl(this);
    }

    public ResourceAssignment addAssignment(ProjectResource resource) {
        return this.auxAddAssignment(resource);
    }

    public void deleteAssignment(ProjectResource resource) {
        this.myAssignments.remove(resource);
    }

    private ResourceAssignment auxAddAssignment(ProjectResource resource) {
        ResourceAssignmentImpl result = new ResourceAssignmentImpl(resource);
        this.addAssignment(result);
        return result;
    }

    private void addAssignment(ResourceAssignment assignment) {
        this.myAssignments.put(assignment.getResource(), assignment);
    }

    public void removeAssignment(ProjectResource resource) {
        new ResourceAssignmentImpl(resource).delete();
    }

    private Task getTask() {
        return this.myTask;
    }

    public void importData(ResourceAssignmentCollection assignmentCollection) {
        if (this.myTask.isUnplugged()) {
            ResourceAssignment[] assignments = assignmentCollection.getAssignments();
            for (int i = 0; i < assignments.length; ++i) {
                ResourceAssignment next = assignments[i];
                this.addAssignment(next);
            }
        } else {
            ResourceAssignment[] assignments = assignmentCollection.getAssignments();
            for (int i = 0; i < assignments.length; ++i) {
                ResourceAssignment next = assignments[i];
                ProjectResource nextResource = next.getResource();
                ProjectResource nextImportedResource = this.myResourceManager.getById(nextResource.getId());
                if (nextImportedResource == null) continue;
                ResourceAssignmentImpl copy = new ResourceAssignmentImpl(nextImportedResource);
                copy.setLoad(next.getLoad());
                copy.setCoordinator(next.isCoordinator());
                copy.setRoleForAssignment(next.getRoleForAssignment());
                this.addAssignment(copy);
            }
        }
    }

    public ProjectResource getCoordinator() {
        Iterator assignments = this.myAssignments.values().iterator();
        while (assignments.hasNext()) {
            ResourceAssignment next = (ResourceAssignment)assignments.next();
            if (!next.isCoordinator()) continue;
            return next.getResource();
        }
        return null;
    }

    private static class MutationInfo
    implements Comparable {
        static final int ADD = 0;
        static final int DELETE = 1;
        private final ResourceAssignment myAssignment;
        private final int myOrder;
        private static int ourOrder;
        private int myOperation;
        private final ProjectResource myResource;

        public MutationInfo(ResourceAssignment assignment, int operation) {
            this.myAssignment = assignment;
            this.myOrder = ourOrder++;
            this.myOperation = operation;
            this.myResource = assignment.getResource();
        }

        public MutationInfo(ProjectResource resource, int operation) {
            this.myAssignment = null;
            this.myOrder = ourOrder++;
            this.myOperation = operation;
            this.myResource = resource;
        }

        public boolean equals(Object o) {
            boolean result = o instanceof MutationInfo;
            if (result) {
                result = this.myAssignment.getResource().equals(((MutationInfo)o).myAssignment.getResource());
            }
            return result;
        }

        public int compareTo(Object o) {
            if (!(o instanceof MutationInfo)) {
                throw new IllegalArgumentException();
            }
            return this.myOrder - ((MutationInfo)o).myOrder;
        }
    }

    private class ResourceAssignmentMutatorImpl
    implements ResourceAssignmentMutator {
        private Map myQueue = new HashMap();

        private ResourceAssignmentMutatorImpl() {
        }

        public ResourceAssignment addAssignment(ProjectResource resource) {
            ResourceAssignmentStub result = new ResourceAssignmentStub(resource);
            this.myQueue.put(resource, new MutationInfo(result, 0));
            return result;
        }

        public void deleteAssignment(ProjectResource resource) {
            MutationInfo info = (MutationInfo)this.myQueue.get(resource);
            if (info == null) {
                this.myQueue.put(resource, new MutationInfo(resource, 1));
            } else if (info.myOperation == 0) {
                this.myQueue.remove(resource);
            }
        }

        public void commit() {
            ArrayList mutations = new ArrayList(this.myQueue.values());
            Collections.sort(mutations);
            block4: for (int i = 0; i < mutations.size(); ++i) {
                MutationInfo next = (MutationInfo)mutations.get(i);
                switch (next.myOperation) {
                    case 1: {
                        ResourceAssignmentCollectionImpl.this.myAssignments.remove(next.myResource);
                        continue block4;
                    }
                    case 0: {
                        ResourceAssignment result = ResourceAssignmentCollectionImpl.this.auxAddAssignment(next.myResource);
                        result.setLoad(next.myAssignment.getLoad());
                        result.setCoordinator(next.myAssignment.isCoordinator());
                        result.setRoleForAssignment(next.myAssignment.getRoleForAssignment());
                    }
                }
            }
        }
    }

    private class ResourceAssignmentStub
    implements ResourceAssignment {
        private final ProjectResource myResource;
        private float myLoad;
        private boolean myCoordinator;
        private Role myRoleForAssignment;

        public ResourceAssignmentStub(ProjectResource resource) {
            this.myResource = resource;
        }

        public Task getTask() {
            return ResourceAssignmentCollectionImpl.this.getTask();
        }

        public ProjectResource getResource() {
            return this.myResource;
        }

        public float getLoad() {
            return this.myLoad;
        }

        public void setLoad(float load) {
            this.myLoad = load;
        }

        public void delete() {
        }

        public void deleteLocal() {
        }

        public void setCoordinator(boolean responsible) {
            this.myCoordinator = responsible;
        }

        public boolean isCoordinator() {
            return this.myCoordinator;
        }

        public Role getRoleForAssignment() {
            return this.myRoleForAssignment;
        }

        public void setRoleForAssignment(Role role) {
            this.myRoleForAssignment = role;
        }

        public String toString() {
            return this.getResource().getName() + " -> " + this.getTask().getName();
        }
    }

    private class ResourceAssignmentImpl
    implements ResourceAssignment {
        private ResourceAssignment myAssignmentToResource;

        public ResourceAssignmentImpl(ProjectResource resource) {
            this.myAssignmentToResource = resource.createAssignment(this);
        }

        public Task getTask() {
            return ResourceAssignmentCollectionImpl.this.getTask();
        }

        public ProjectResource getResource() {
            return this.myAssignmentToResource.getResource();
        }

        public float getLoad() {
            return this.myAssignmentToResource.getLoad();
        }

        public void setLoad(float load) {
            this.myAssignmentToResource.setLoad(load);
        }

        public void delete() {
            ResourceAssignmentCollectionImpl.this.deleteAssignment(this.getResource());
            this.myAssignmentToResource.delete();
        }

        public void setCoordinator(boolean responsible) {
            this.myAssignmentToResource.setCoordinator(responsible);
        }

        public boolean isCoordinator() {
            return this.myAssignmentToResource.isCoordinator();
        }

        public Role getRoleForAssignment() {
            return this.myAssignmentToResource.getRoleForAssignment();
        }

        public void setRoleForAssignment(Role role) {
            this.myAssignmentToResource.setRoleForAssignment(role);
        }

        public String toString() {
            return this.getResource().getName() + " -> " + this.getTask().getName();
        }
    }
}

