/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import net.sourceforge.ganttproject.CustomProperty;
import net.sourceforge.ganttproject.CustomPropertyDefinition;
import net.sourceforge.ganttproject.CustomPropertyHolder;
import net.sourceforge.ganttproject.CustomPropertyManager;
import net.sourceforge.ganttproject.calendar.GanttDaysOff;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.task.ResourceAssignment;

public class HumanResource
extends ProjectResource
implements CustomPropertyHolder {
    private boolean areEventsEnabled = true;
    private String phone = "";
    private String email = "";
    private int function;
    private Role myRole;
    private final DefaultListModel myDaysOffList = new DefaultListModel();
    private final Map customFields;
    private final HumanResourceManager myManager;

    HumanResource(HumanResourceManager manager) {
        this.name = "";
        this.customFields = new HashMap();
        this.myManager = manager;
    }

    HumanResource(String name, int id, HumanResourceManager manager) {
        super(id);
        this.name = name;
        this.customFields = new HashMap();
        this.myManager = manager;
    }

    void initCustomProperties() {
        List defs = this.myManager.getCustomPropertyManager().getDefinitions();
        for (int i = 0; i < defs.size(); ++i) {
            CustomPropertyDefinition nextDefinition = (CustomPropertyDefinition)defs.get(i);
            this.customFields.put(nextDefinition.getName(), nextDefinition.getDefaultValue());
        }
    }

    private HumanResource(HumanResource copy) {
        this.areEventsEnabled = false;
        this.setId(-1);
        this.setName(GanttLanguage.getInstance().getText("copy2") + "_" + copy.getName());
        this.setCostsPerUnit(copy.getCostsPerUnit());
        this.setDescription(copy.getDescription());
        this.setMaximumUnitsPerDay(copy.getMaximumUnitsPerDay());
        this.setUnitMeasure(copy.getUnitMeasure());
        this.setMail(copy.getMail());
        this.setPhone(copy.getPhone());
        this.setRole(copy.getRole());
        this.myManager = copy.myManager;
        DefaultListModel copyDaysOff = copy.getDaysOff();
        for (int i = 0; i < copyDaysOff.getSize(); ++i) {
            this.myDaysOffList.addElement(copyDaysOff.get(i));
        }
        this.customFields = new HashMap(copy.customFields);
        this.areEventsEnabled = true;
    }

    public void delete() {
        super.delete();
        this.myManager.remove(this);
    }

    public void setMail(String email) {
        this.email = email;
        this.fireResourceChanged();
    }

    public String getMail() {
        return this.email;
    }

    public void setPhone(String phone) {
        this.phone = phone;
        this.fireResourceChanged();
    }

    public String getPhone() {
        return this.phone;
    }

    public void setRole(Role role) {
        this.myRole = role;
        this.fireResourceChanged();
    }

    public Role getRole() {
        if (this.myRole == null) {
            System.err.println("[HumanResource] getRole(): I have no role :( name=" + this.getName());
        }
        return this.myRole;
    }

    public void addDaysOff(GanttDaysOff gdo) {
        this.myDaysOffList.addElement(gdo);
        this.fireResourceChanged();
    }

    public DefaultListModel getDaysOff() {
        return this.myDaysOffList;
    }

    public void addCustomField(String title, Object value) {
        this.customFields.put(title, value);
    }

    public void removeCustomField(String title) {
        this.customFields.remove(title);
    }

    public Object getCustomFieldVal(String title) {
        return this.customFields.get(title);
    }

    public void setCustomFieldVal(String title, Object val) {
        this.customFields.put(title, val);
    }

    public ResourceAssignment createAssignment(ResourceAssignment assignmentToTask) {
        ResourceAssignment result = super.createAssignment(assignmentToTask);
        this.fireAssignmentsChanged();
        return result;
    }

    public ProjectResource unpluggedClone() {
        return new HumanResource(this);
    }

    private void fireResourceChanged() {
        if (this.areEventsEnabled) {
            this.myManager.fireResourceChanged(this);
        }
    }

    protected void fireAssignmentsChanged() {
        if (this.areEventsEnabled) {
            this.myManager.fireAssignmentsChanged(this);
        }
    }

    public List getCustomProperties() {
        ArrayList<CustomPropertyImpl> result = new ArrayList<CustomPropertyImpl>(this.customFields.size());
        Iterator entries = this.customFields.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry nextEntry = entries.next();
            String nextName = (String)nextEntry.getKey();
            Object nextValue = nextEntry.getValue();
            CustomPropertyDefinition nextDefinition = this.myManager.getCustomPropertyDefinition(nextName);
            result.add(new CustomPropertyImpl(nextDefinition, nextValue));
        }
        return result;
    }

    public CustomProperty addCustomProperty(CustomPropertyDefinition definition, String valueAsString) {
        CustomPropertyDefinition stubDefinition = CustomPropertyManager.PropertyTypeEncoder.decodeTypeAndDefaultValue(definition.getTypeAsString(), valueAsString);
        this.addCustomField(definition.getName(), stubDefinition.getDefaultValue());
        return new CustomPropertyImpl(definition, stubDefinition.getDefaultValue());
    }

    private static class CustomPropertyImpl
    implements CustomProperty {
        private CustomPropertyDefinition myDefinition;
        private Object myValue;

        public CustomPropertyImpl(CustomPropertyDefinition definition, Object value) {
            this.myDefinition = definition;
            this.myValue = value;
        }

        public CustomPropertyDefinition getDefinition() {
            return this.myDefinition;
        }

        public Object getValue() {
            return this.myValue;
        }

        public String getValueAsString() {
            return HumanResourceManager.getValueAsString(this.myValue);
        }
    }
}

