/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.print;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.util.Date;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;
import net.sourceforge.ganttproject.GanttExportSettings;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.action.ZoomInAction;
import net.sourceforge.ganttproject.action.ZoomOutAction;
import net.sourceforge.ganttproject.chart.Chart;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.OptionsPageBuilder;
import net.sourceforge.ganttproject.gui.options.model.DateOption;
import net.sourceforge.ganttproject.gui.options.model.DefaultDateOption;
import net.sourceforge.ganttproject.gui.zoom.ZoomManager;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.print.GanttPrintable;

public class PrintPreview
extends JDialog {
    private static final MediaSizeName DEFAULT_MEDIA_SIZE_NAME = MediaSizeName.ISO_A4;
    private static GanttLanguage language = GanttLanguage.getInstance();
    private int myPageWidth;
    private int myPageHeight;
    private Printable myPrintable = null;
    private JComboBox myComboScale = null;
    private PreviewContainer myPreviewContainer = null;
    private int myOrientation = 0;
    private PageFormat myPageFormat = null;
    private int myScale;
    private Chart myChart = null;
    private GanttExportSettings myExportSettings = null;
    private JButton myWholeProjectButton = null;
    private MediaSizeName myMediaSizeName;
    private JComboBox myComboMediaSize = null;
    private StatusBar statusBar;
    private DateOption myStart = new DefaultDateOption("generic.startDate"){

        public void setValue(Date value) {
            super.setValue(value);
            this.commit();
            PrintPreview.this.onChangingDates();
            this.lock();
        }
    };
    private DateOption myFinish = new DefaultDateOption("generic.endDate"){

        public void setValue(Date value) {
            super.setValue(value);
            this.commit();
            PrintPreview.this.onChangingDates();
            this.lock();
        }
    };
    private final IGanttProject myProject;
    private final UIFacade myUIfacade;

    private void onChangingDates() {
        this.myExportSettings.setStartDate(this.myStart.getValue());
        this.myExportSettings.setEndDate(this.myFinish.getValue());
        this.updateSourceImage();
    }

    public PrintPreview(IGanttProject project, UIFacade uifacade, Chart chart, Date start, Date end) {
        super(uifacade.getMainFrame(), GanttLanguage.getInstance().getText("preview"), false);
        JButton bZoomIn;
        JButton bZoomOut;
        this.myProject = project;
        this.myUIfacade = uifacade;
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize((int)((double)screenDim.width * 0.75), (int)((double)screenDim.height * 0.75));
        this.setLocationRelativeTo(null);
        this.myChart = chart;
        if (start == null) {
            start = this.myChart.getStartDate();
        }
        if (end == null) {
            end = this.myChart.getEndDate();
        }
        this.myExportSettings = new GanttExportSettings();
        this.myPrintable = new GanttPrintable(this.myChart.getChart(this.myExportSettings), 1.5);
        JToolBar tb = new JToolBar();
        JToolBar tb2 = new JToolBar();
        TestGanttRolloverButton bPrint = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/print_16.gif")));
        bPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.print();
            }
        });
        TestGanttRolloverButton bClose = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/exit_16.gif")));
        bClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.setVisible(false);
                PrintPreview.this.dispose();
            }
        });
        final TestGanttRolloverButton bPortrait = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/portrait_16.gif")));
        final TestGanttRolloverButton bLandscape = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/landscape_16.gif")));
        bPortrait.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.run(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        PrintPreview.access$300(5.access$200(this.this$1), 1);
                        5.access$400(this.this$1).setEnabled(true);
                        5.access$500(this.this$1).setEnabled(false);
                    }
                });
            }

            static /* synthetic */ PrintPreview access$200(5 x0) {
                return x0.PrintPreview.this;
            }

            static /* synthetic */ JButton access$400(5 x0) {
                return x0.bLandscape;
            }

            static /* synthetic */ JButton access$500(5 x0) {
                return x0.bPortrait;
            }
        });
        bLandscape.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.run(new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        PrintPreview.access$300(7.access$700(this.this$1), 0);
                        7.access$800(this.this$1).setEnabled(false);
                        7.access$900(this.this$1).setEnabled(true);
                    }
                });
            }

            static /* synthetic */ PrintPreview access$700(7 x0) {
                return x0.PrintPreview.this;
            }

            static /* synthetic */ JButton access$800(7 x0) {
                return x0.bLandscape;
            }

            static /* synthetic */ JButton access$900(7 x0) {
                return x0.bPortrait;
            }
        });
        ((AbstractButton)bLandscape).setEnabled(false);
        String[] scales = new String[]{"10 %", "25 %", "50 %", "100 %"};
        this.myComboScale = new JComboBox<String>(scales);
        this.myComboScale.setSelectedIndex(2);
        this.myComboScale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.run(new Runnable(this){
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        PrintPreview.access$1100(9.access$1000(this.this$1));
                    }
                });
            }

            static /* synthetic */ PrintPreview access$1000(9 x0) {
                return x0.PrintPreview.this;
            }
        });
        this.myComboScale.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                PrintPreview.this.run(new Runnable(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        PrintPreview.access$1100(11.access$1200(this.this$1));
                    }
                });
            }

            static /* synthetic */ PrintPreview access$1200(11 x0) {
                return x0.PrintPreview.this;
            }
        });
        Dimension dim = this.myComboScale.getPreferredSize();
        dim.setSize(dim.getWidth() + 20.0, dim.getHeight());
        this.myComboScale.setMaximumSize(dim);
        this.myComboScale.setPreferredSize(dim);
        this.myComboScale.setEditable(true);
        boolean isDate = start != null && end != null;
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/icons/calendar_16.gif"));
        this.myStart.lock();
        this.myFinish.lock();
        if (isDate) {
            this.myWholeProjectButton = new JButton(language.getText("wholeProject"));
            this.myWholeProjectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PrintPreview.this.myStart.setValue(PrintPreview.this.myChart.getStartDate());
                    PrintPreview.this.myFinish.setValue(PrintPreview.this.myChart.getEndDate());
                }
            });
        }
        Vector<MediaSizeName> vMedia = new Vector<MediaSizeName>();
        vMedia.add(MediaSizeName.ISO_A0);
        vMedia.add(MediaSizeName.ISO_A1);
        vMedia.add(MediaSizeName.ISO_A2);
        vMedia.add(MediaSizeName.ISO_A3);
        vMedia.add(MediaSizeName.ISO_A4);
        vMedia.add(MediaSizeName.ISO_A5);
        vMedia.add(MediaSizeName.ISO_A6);
        if (vMedia != null) {
            this.myComboMediaSize = new JComboBox(vMedia);
            dim = this.myComboMediaSize.getPreferredSize();
            dim.setSize(dim.getWidth() + 20.0, dim.getHeight());
            this.myComboMediaSize.setMaximumSize(dim);
            this.myComboMediaSize.setPreferredSize(dim);
            this.myComboMediaSize.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent arg0) {
                    PrintPreview.this.run(new Runnable(this){
                        private final /* synthetic */ 14 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            Object selectedItem = PrintPreview.access$1700(14.access$1600(this.this$1)).getSelectedItem();
                            if (selectedItem != null) {
                                PrintPreview.access$1802(14.access$1600(this.this$1), (MediaSizeName)selectedItem);
                                MediaSize ms = MediaSize.getMediaSizeForName(PrintPreview.access$1800(14.access$1600(this.this$1)));
                                Paper p = new Paper();
                                float[] size = ms.getSize(25400);
                                p.setSize(size[0] * 72.0f, size[1] * 72.0f);
                                p.setImageableArea(72.0, 72.0, p.getWidth() - 144.0, p.getHeight() - 144.0);
                                PrintPreview.access$1900(14.access$1600(this.this$1)).setPaper(p);
                                PrintPreview.access$300(14.access$1600(this.this$1), PrintPreview.access$2000(14.access$1600(this.this$1)));
                                PrintPreview.access$2100(14.access$1600(this.this$1)).setText1(ms.getX(1000) + " x " + ms.getY(1000));
                                PrintPreview.access$2200(14.access$1600(this.this$1)).repaint();
                            }
                        }
                    });
                }

                static /* synthetic */ PrintPreview access$1600(14 x0) {
                    return x0.PrintPreview.this;
                }
            });
        }
        bPrint.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(language.getText("printProject"))));
        bPortrait.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(language.getText("portrait"))));
        bLandscape.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(language.getText("landscape"))));
        bClose.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(language.getText("close"))));
        if (isDate) {
            this.myWholeProjectButton.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(language.getText("displayWholeProject"))));
            final ZoomManager zoomManager = this.myUIfacade.getZoomManager();
            final ZoomOutAction zoomOut = new ZoomOutAction(zoomManager, "16");
            final ZoomInAction zoomIn = new ZoomInAction(zoomManager, "16");
            bZoomOut = new JButton((Icon)zoomOut.getValue("SmallIcon"));
            bZoomIn = new JButton((Icon)zoomIn.getValue("SmallIcon"));
            bZoomOut.setHorizontalTextPosition(4);
            bZoomOut.setText(language.getText("narrowChart"));
            bZoomOut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    PrintPreview.this.run(new Runnable(this){
                        private final /* synthetic */ 16 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            16.access$2300(this.this$1).actionPerformed(null);
                            PrintPreview.access$2500(16.access$2400(this.this$1));
                            16.access$2700(this.this$1).setEnabled(16.access$2600(this.this$1).canZoomOut());
                            16.access$2800(this.this$1).setEnabled(16.access$2600(this.this$1).canZoomIn());
                        }
                    });
                }

                static /* synthetic */ Action access$2300(16 x0) {
                    return x0.zoomOut;
                }

                static /* synthetic */ PrintPreview access$2400(16 x0) {
                    return x0.PrintPreview.this;
                }

                static /* synthetic */ ZoomManager access$2600(16 x0) {
                    return x0.zoomManager;
                }

                static /* synthetic */ JButton access$2700(16 x0) {
                    return x0.bZoomOut;
                }

                static /* synthetic */ JButton access$2800(16 x0) {
                    return x0.bZoomIn;
                }
            });
            bZoomIn.setHorizontalTextPosition(4);
            bZoomIn.setText(language.getText("widenChart"));
            bZoomIn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    PrintPreview.this.run(new Runnable(this){
                        private final /* synthetic */ 18 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            18.access$2900(this.this$1).actionPerformed(null);
                            PrintPreview.access$2500(18.access$3000(this.this$1));
                            18.access$3200(this.this$1).setEnabled(18.access$3100(this.this$1).canZoomOut());
                            18.access$3300(this.this$1).setEnabled(18.access$3100(this.this$1).canZoomIn());
                        }
                    });
                }

                static /* synthetic */ Action access$2900(18 x0) {
                    return x0.zoomIn;
                }

                static /* synthetic */ PrintPreview access$3000(18 x0) {
                    return x0.PrintPreview.this;
                }

                static /* synthetic */ ZoomManager access$3100(18 x0) {
                    return x0.zoomManager;
                }

                static /* synthetic */ JButton access$3200(18 x0) {
                    return x0.bZoomOut;
                }

                static /* synthetic */ JButton access$3300(18 x0) {
                    return x0.bZoomIn;
                }
            });
        } else {
            bZoomOut = null;
            bZoomIn = null;
        }
        tb2.setFloatable(false);
        tb.setFloatable(false);
        tb.add(bClose);
        tb.addSeparator(new Dimension(16, 16));
        tb.add(bPrint);
        tb.addSeparator(new Dimension(16, 16));
        tb.add(bPortrait);
        tb.add(bLandscape);
        tb.addSeparator(new Dimension(16, 16));
        tb.add(new JLabel(language.getText("zoom") + " "));
        tb.add(this.myComboScale);
        if (vMedia != null && !vMedia.isEmpty()) {
            tb.addSeparator(new Dimension(16, 16));
            tb.add(new JLabel(language.getText("choosePaperFormat") + " "));
            tb.addSeparator(new Dimension(0, 10));
            tb.add(this.myComboMediaSize);
        }
        if (isDate) {
            tb2.add(bZoomOut);
            tb2.addSeparator(new Dimension(5, 0));
            tb2.add(bZoomIn);
            tb2.addSeparator(new Dimension(20, 0));
            tb2.add(this.myWholeProjectButton);
            tb2.addSeparator(new Dimension(16, 16));
            OptionsPageBuilder builder = new OptionsPageBuilder();
            builder.setOptionKeyPrefix("");
            tb2.add(builder.createStandaloneOptionPanel(this.myStart));
            URL iconArrow = this.getClass().getClassLoader().getResource("icons/fromto.gif");
            tb2.add(new JLabel(new ImageIcon(iconArrow)));
            tb2.add(builder.createStandaloneOptionPanel(this.myFinish));
        }
        JPanel topPanel = new JPanel(new BorderLayout());
        tb.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        tb2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        topPanel.add((Component)tb, "North");
        topPanel.add((Component)tb2, "South");
        this.getContentPane().add((Component)topPanel, "North");
        this.statusBar = new StatusBar();
        this.statusBar.setLabel0(language.getText("pageNumber"));
        this.statusBar.setLabel1(language.getText("paperSize"));
        this.getContentPane().add((Component)this.statusBar, "South");
        this.myPreviewContainer = new PreviewContainer();
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        this.myPageFormat = new PageFormat();
        this.myPageFormat.setOrientation(this.myOrientation);
        this.myMediaSizeName = DEFAULT_MEDIA_SIZE_NAME;
        MediaSize ms = MediaSize.getMediaSizeForName(this.myMediaSizeName);
        Paper p = new Paper();
        float[] size = ms.getSize(25400);
        p.setSize(size[0] * 72.0f, size[1] * 72.0f);
        p.setImageableArea(72.0, 72.0, p.getWidth() - 144.0, p.getHeight() - 144.0);
        this.myPageFormat.setPaper(p);
        this.statusBar.setText1(ms.getX(1000) + " x " + ms.getY(1000));
        if (this.myPageFormat.getHeight() == 0.0 || this.myPageFormat.getWidth() == 0.0) {
            this.myUIfacade.showErrorDialog("Unable to determine default page size");
            return;
        }
        this.myPageWidth = (int)this.myPageFormat.getWidth();
        this.myPageHeight = (int)this.myPageFormat.getHeight();
        this.myScale = 50;
        int w = this.myPageWidth * this.myScale / 100;
        int h = this.myPageHeight * this.myScale / 100;
        this.createPages();
        JScrollPane ps = new JScrollPane(this.myPreviewContainer);
        this.getContentPane().add((Component)ps, "Center");
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        this.myComboMediaSize.setSelectedItem(this.myMediaSizeName);
        this.myStart.setValue(start);
        this.myFinish.setValue(end);
    }

    private void createPages() {
        int pageIndex = 0;
        try {
            while (true) {
                BufferedImage img = new BufferedImage(this.myPageWidth, this.myPageHeight, 1);
                Graphics g = img.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.myPageWidth, this.myPageHeight);
                if (this.myPrintable.print(g, this.myPageFormat, pageIndex) != 0) break;
                PagePreview pp = new PagePreview(pageIndex, this.myPageFormat, this.myPrintable, this.myScale);
                this.myPreviewContainer.add(pp);
                ++pageIndex;
            }
            this.statusBar.setText0("" + pageIndex);
        }
        catch (PrinterException e) {
            e.printStackTrace();
            this.myUIfacade.showErrorDialog(e);
        }
    }

    private void changeScale() {
        String str = this.myComboScale.getSelectedItem().toString();
        if (str.endsWith("%")) {
            str = str.substring(0, str.length() - 1);
        }
        str = str.trim();
        this.myScale = 0;
        try {
            this.myScale = Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            return;
        }
        Component[] comps = this.myPreviewContainer.getComponents();
        for (int k = 0; k < comps.length; ++k) {
            if (!(comps[k] instanceof PagePreview)) continue;
            PagePreview pp = (PagePreview)comps[k];
            pp.setScale(this.myScale);
        }
        this.myPreviewContainer.doLayout();
        this.myPreviewContainer.getParent().getParent().validate();
    }

    private void run(Runnable runnable) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        runnable.run();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void changePageOrientation(int newOrientation) {
        this.myOrientation = newOrientation;
        this.myPageFormat.setOrientation(this.myOrientation);
        this.myPageWidth = (int)this.myPageFormat.getWidth();
        this.myPageHeight = (int)this.myPageFormat.getHeight();
        this.myPreviewContainer.removeAll();
        this.myPreviewContainer.repaint();
        this.createPages();
        this.myPreviewContainer.doLayout();
        this.myPreviewContainer.getParent().getParent().validate();
        this.myPreviewContainer.validate();
    }

    private void print() {
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        prnJob.setPrintable(this.myPrintable);
        this.setCursor(Cursor.getPredefinedCursor(3));
        HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
        attr.add(this.myMediaSizeName);
        attr.add(this.myOrientation == 0 ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT);
        Document doc = this.myProject.getDocument();
        if (doc != null) {
            attr.add(new JobName(doc.getDescription(), language.getLocale()));
        }
        if (prnJob.printDialog(attr)) {
            try {
                prnJob.print(attr);
                this.setVisible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.myUIfacade.showErrorDialog(e);
            }
            this.dispose();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void updateSourceImage() {
        try {
            BufferedImage image = this.myChart.getChart(this.myExportSettings);
            this.myPrintable = new GanttPrintable(image, 1.5);
            this.changePageOrientation(this.myOrientation);
        }
        catch (OutOfMemoryError e) {
            this.myUIfacade.showErrorDialog(GanttLanguage.getInstance().getText("printing.out_of_memory"));
        }
    }

    static /* synthetic */ void access$300(PrintPreview x0, int x1) {
        x0.changePageOrientation(x1);
    }

    static /* synthetic */ void access$1100(PrintPreview x0) {
        x0.changeScale();
    }

    static /* synthetic */ JComboBox access$1700(PrintPreview x0) {
        return x0.myComboMediaSize;
    }

    static /* synthetic */ MediaSizeName access$1802(PrintPreview x0, MediaSizeName x1) {
        x0.myMediaSizeName = x1;
        return x0.myMediaSizeName;
    }

    static /* synthetic */ MediaSizeName access$1800(PrintPreview x0) {
        return x0.myMediaSizeName;
    }

    static /* synthetic */ PageFormat access$1900(PrintPreview x0) {
        return x0.myPageFormat;
    }

    static /* synthetic */ int access$2000(PrintPreview x0) {
        return x0.myOrientation;
    }

    static /* synthetic */ StatusBar access$2100(PrintPreview x0) {
        return x0.statusBar;
    }

    static /* synthetic */ PreviewContainer access$2200(PrintPreview x0) {
        return x0.myPreviewContainer;
    }

    static /* synthetic */ void access$2500(PrintPreview x0) {
        x0.updateSourceImage();
    }

    static class StatusBar
    extends JPanel {
        JLabel label0 = new JLabel();
        JLabel message0 = new JLabel();
        JLabel label1;
        JLabel message1;

        public StatusBar() {
            super(new BorderLayout());
            JPanel panel0 = new JPanel();
            panel0.add(this.label0);
            panel0.add(this.message0);
            this.add((Component)panel0, "West");
            this.label1 = new JLabel();
            this.message1 = new JLabel();
            JPanel panel1 = new JPanel();
            panel1.add(this.label1);
            panel1.add(this.message1);
            this.add((Component)panel1, "East");
        }

        public void setLabel0(String label) {
            this.label0.setText(label);
        }

        public void setText0(String text) {
            this.message0.setText(text);
        }

        public void setLabel1(String label) {
            this.label1.setText(label);
        }

        public void setText1(String text) {
            this.message1.setText(text);
        }
    }

    static class PagePreview
    extends JPanel {
        static SortedMap ourImageCache = new TreeMap();
        private final int myPageIndex;
        private final PageFormat myPageFormat;
        private final Printable myChart;
        private int myScalePercents;

        public PagePreview(int pageIndex, PageFormat pageFormat, Printable chart, int scalePercents) {
            this.myScalePercents = scalePercents;
            this.myPageIndex = pageIndex;
            this.myPageFormat = pageFormat;
            this.myChart = chart;
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        void setScale(int scale) {
            this.myScalePercents = scale;
            this.repaint();
        }

        private int getScaledWidth() {
            return (int)(this.myPageFormat.getWidth() * (double)this.myScalePercents / 100.0);
        }

        private int getScaledHeight() {
            return (int)(this.myPageFormat.getHeight() * (double)this.myScalePercents / 100.0);
        }

        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(this.getScaledWidth() + ins.left + ins.right, this.getScaledHeight() + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            BufferedImage bufferImage = (BufferedImage)ourImageCache.get(new Integer(this.myPageIndex));
            if (bufferImage == null) {
                bufferImage = new BufferedImage((int)this.myPageFormat.getWidth(), (int)this.myPageFormat.getHeight(), 1);
                if (ourImageCache.size() >= 4) {
                    ourImageCache.remove(ourImageCache.firstKey());
                }
                ourImageCache.put(new Integer(this.myPageIndex), bufferImage);
            }
            Graphics bufferGraphics = bufferImage.getGraphics();
            bufferGraphics.setColor(Color.white);
            bufferGraphics.fillRect(0, 0, bufferImage.getWidth(), bufferImage.getHeight());
            try {
                this.myChart.print(bufferGraphics, this.myPageFormat, this.myPageIndex);
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
            Image scaledImage = bufferImage.getScaledInstance(this.getScaledWidth(), this.getScaledHeight(), 4);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(scaledImage, 0, 0, null);
        }
    }

    static class PreviewContainer
    extends JPanel {
        protected final int H_GAP = 16;
        protected final int V_GAP = 10;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(16, 10);
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - 16) / (w + 16), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int ww = nCol * (w + 16) + 16;
            int hh = nRow * (h + 10) + 10;
            Insets ins = this.getInsets();
            return new Dimension(ww + ins.left + ins.right, hh + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void doLayout() {
            Insets ins = this.getInsets();
            int x = ins.left + 16;
            int y = ins.top + 10;
            int n = this.getComponentCount();
            if (n == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - 16) / (w + 16), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int index = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int m = 0; m < nCol; ++m) {
                    if (index >= n) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, w, h);
                    x += w + 16;
                }
                y += h + 10;
                x = ins.left + 16;
            }
        }
    }
}

