/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.parser;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.ganttproject.gui.TableHeaderUIFacade;
import net.sourceforge.ganttproject.parser.FileFormatException;
import net.sourceforge.ganttproject.parser.ParsingListener;
import net.sourceforge.ganttproject.parser.TagHandler;
import org.xml.sax.Attributes;

public class TaskDisplayColumnsTagHandler
implements TagHandler,
ParsingListener {
    private final TableHeaderUIFacade myVisibleFields;
    private final TableHeaderUIFacade myBuffer = new VisibleFieldsImpl();
    private final String myIDPropertyName;
    private final String myOrderPropertyName;
    private final String myWidthPropertyName;
    private final String myTagName;

    public TaskDisplayColumnsTagHandler(TableHeaderUIFacade visibleFields) {
        this(visibleFields, "displaycolumn", "property-id", "order", "width");
    }

    public TaskDisplayColumnsTagHandler(TableHeaderUIFacade visibleFields, String tagName, String idPropertyName, String orderPropertyName, String widthPropertyName) {
        this.myVisibleFields = visibleFields;
        this.myTagName = tagName;
        this.myIDPropertyName = idPropertyName;
        this.myOrderPropertyName = orderPropertyName;
        this.myWidthPropertyName = widthPropertyName;
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws FileFormatException {
        if (qName.equals(this.myTagName)) {
            this.loadTaskDisplay(attrs);
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) {
    }

    public void parsingStarted() {
        this.myVisibleFields.clear();
    }

    public void parsingFinished() {
        this.myVisibleFields.importData(this.myBuffer);
    }

    private void loadTaskDisplay(Attributes atts) {
        String id = atts.getValue(this.myIDPropertyName);
        String orderStr = this.myOrderPropertyName == null ? "0" : atts.getValue(this.myOrderPropertyName);
        String widthStr = atts.getValue(this.myWidthPropertyName);
        int order = Integer.parseInt(orderStr);
        int width = widthStr == null ? -1 : Integer.parseInt(widthStr);
        this.myBuffer.add(id, order, width);
    }

    private static class VisibleFieldsImpl
    implements TableHeaderUIFacade {
        private List myFields = new ArrayList();

        private VisibleFieldsImpl() {
        }

        public void add(String name, int order, int width) {
            this.myFields.add(new TaskFieldImpl(name, order, width));
        }

        public void clear() {
            this.myFields.clear();
        }

        public TableHeaderUIFacade.Column getField(int index) {
            return (TableHeaderUIFacade.Column)this.myFields.get(index);
        }

        public int getSize() {
            return this.myFields.size();
        }

        public void importData(TableHeaderUIFacade source) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TaskFieldImpl
    implements TableHeaderUIFacade.Column {
        private final String myID;
        private final int myOrder;
        private final int myWidth;

        TaskFieldImpl(String id, int order, int width) {
            this.myID = id;
            this.myOrder = order;
            this.myWidth = width;
        }

        public String getID() {
            return this.myID;
        }

        public int getOrder() {
            return this.myOrder;
        }

        public int getWidth() {
            return this.myWidth;
        }

        public boolean isVisible() {
            return true;
        }

        public String getName() {
            return null;
        }
    }
}

