/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.ganttproject.CustomPropertyDefinition;
import net.sourceforge.ganttproject.CustomPropertyManager;
import net.sourceforge.ganttproject.parser.ParsingListener;
import net.sourceforge.ganttproject.parser.TagHandler;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.roles.RoleManager;
import net.sourceforge.ganttproject.roles.RolePersistentID;
import net.sourceforge.ganttproject.roles.RoleSet;
import org.xml.sax.Attributes;

public class ResourceTagHandler
implements TagHandler,
ParsingListener {
    private final CustomPropertyManager myCustomPropertyManager;
    private HumanResource myCurrentResource;
    private final HashMap myLateResource2roleBinding = new HashMap();
    private final HumanResourceManager myResourceManager;
    private final RoleManager myRoleManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ResourceTagHandler(ResourceManager resourceManager, RoleManager roleManager, CustomPropertyManager resourceCustomPropertyManager) {
        this.myResourceManager = (HumanResourceManager)resourceManager;
        this.myCustomPropertyManager = resourceCustomPropertyManager;
        this.myRoleManager = roleManager;
    }

    public void endElement(String namespaceURI, String sName, String qName) {
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (qName.equals("resource")) {
            this.loadResource(attrs);
        }
        if ("custom-property".equals(qName)) {
            if (!$assertionsDisabled && this.myCurrentResource == null) {
                throw new AssertionError();
            }
            this.loadCustomProperty(attrs);
        }
        if ("custom-property-definition".equals(qName)) {
            this.loadCustomPropertyDefinition(attrs);
        }
    }

    private void loadCustomProperty(Attributes attrs) {
        String id = attrs.getValue("definition-id");
        String value = attrs.getValue("value");
        List definitions = this.myCustomPropertyManager.getDefinitions();
        for (int i = 0; i < definitions.size(); ++i) {
            CustomPropertyDefinition nextDefinition = (CustomPropertyDefinition)definitions.get(i);
            if (!id.equals(nextDefinition.getID())) continue;
            this.myCurrentResource.addCustomProperty(nextDefinition, value);
            break;
        }
    }

    private void loadCustomPropertyDefinition(Attributes attrs) {
        String id = attrs.getValue("id");
        String name = attrs.getValue("name");
        String type = attrs.getValue("type");
        String defaultValue = attrs.getValue("default-value");
        this.myCustomPropertyManager.createDefinition(id, type, name, defaultValue);
    }

    private void loadResource(Attributes atts) {
        HumanResource hr;
        try {
            String id = atts.getValue("id");
            if (id == null) {
                hr = this.getResourceManager().newHumanResource();
                hr.setName(atts.getValue("name"));
                this.getResourceManager().add(hr);
            } else {
                hr = (HumanResource)this.getResourceManager().create(atts.getValue("name"), Integer.parseInt(id));
            }
            this.myCurrentResource = hr;
        }
        catch (NumberFormatException e) {
            System.out.println("ERROR in parsing XML File id is not numeric: " + e.toString());
            return;
        }
        hr.setMail(atts.getValue("contacts"));
        hr.setPhone(atts.getValue("phone"));
        try {
            String roleID = atts.getValue("function");
            this.myLateResource2roleBinding.put(hr, roleID);
        }
        catch (NumberFormatException e) {
            System.out.println("ERROR in parsing XML File function id is not numeric: " + e.toString());
        }
    }

    private HumanResourceManager getResourceManager() {
        return this.myResourceManager;
    }

    private Role findRole(String persistentIDasString) {
        RoleSet roleSet;
        RolePersistentID persistentID = new RolePersistentID(persistentIDasString);
        String rolesetName = persistentID.getRoleSetID();
        int roleID = persistentID.getRoleID();
        if (rolesetName == null) {
            roleSet = this.myRoleManager.getProjectRoleSet();
            if (roleSet.findRole(roleID) == null) {
                if (roleID <= 10 && roleID > 2) {
                    roleSet = this.myRoleManager.getRoleSet("SoftwareDevelopment");
                    roleSet.setEnabled(true);
                } else if (roleID <= 2) {
                    roleSet = this.myRoleManager.getRoleSet("Default");
                }
            }
        } else {
            roleSet = this.myRoleManager.getRoleSet(rolesetName);
        }
        Role result = roleSet.findRole(roleID);
        return result;
    }

    public void parsingStarted() {
    }

    public void parsingFinished() {
        Iterator lateBindingEntries = this.myLateResource2roleBinding.entrySet().iterator();
        while (lateBindingEntries.hasNext()) {
            Map.Entry nextEntry = lateBindingEntries.next();
            String persistentID = (String)nextEntry.getValue();
            Role nextRole = this.findRole(persistentID);
            if (nextRole == null) continue;
            lateBindingEntries.remove();
            ((HumanResource)nextEntry.getKey()).setRole(nextRole);
        }
        if (!this.myLateResource2roleBinding.isEmpty()) {
            System.err.println("[ResourceTagHandler] parsingFinished(): not found roles:\n" + this.myLateResource2roleBinding);
        }
    }

    static {
        $assertionsDisabled = !ResourceTagHandler.class.desiredAssertionStatus();
    }
}

