/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.language;

import java.awt.ComponentOrientation;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.time.gregorian.GregorianCalendar;

public class GanttLanguage {
    private static GanttLanguage ganttLanguage = null;
    private ArrayList myListeners = new ArrayList();
    Locale currentLocale = null;
    ResourceBundle i18n = null;
    SimpleDateFormat currentDateFormat = null;
    SimpleDateFormat shortCurrentDateFormat = null;
    SimpleDateFormat myLongFormat;
    DateFormat currentTimeFormat = null;
    public static final String MISSING_RESOURCE = "Missing Resource";

    public static GanttLanguage getInstance() {
        if (ganttLanguage == null) {
            ganttLanguage = new GanttLanguage();
        }
        return ganttLanguage;
    }

    public DateFormat getMediumDateFormat() {
        return this.currentDateFormat;
    }

    public DateFormat getShortDateFormat() {
        return this.shortCurrentDateFormat;
    }

    public DateFormat getLongDateFormat() {
        return this.myLongFormat;
    }

    private GanttLanguage() {
        this.setLocale(Locale.getDefault());
    }

    public void setLocale(Locale locale) {
        this.currentLocale = locale;
        Locale.setDefault(locale);
        this.currentDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(2, this.currentLocale);
        this.shortCurrentDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.currentLocale);
        this.currentTimeFormat = DateFormat.getTimeInstance(2, this.currentLocale);
        this.myLongFormat = (SimpleDateFormat)DateFormat.getDateInstance(1, locale);
        UIManager.put("JXDatePicker.longFormat", this.myLongFormat.toPattern());
        UIManager.put("JXDatePicker.mediumFormat", this.currentDateFormat.toPattern());
        UIManager.put("JXDatePicker.shortFormat", this.shortCurrentDateFormat.toPattern());
        UIManager.put("JXDatePicker.numColumns", new Integer(10));
        String[] dayShortNames = new String[7];
        for (int i = 0; i < 7; ++i) {
            dayShortNames[i] = this.getDay(i).substring(0, 1);
        }
        UIManager.put("JXMonthView.daysOfTheWeek", dayShortNames);
        String resourceBase = System.getProperty("org.ganttproject.resourcebase", "language/i18n");
        this.i18n = ResourceBundle.getBundle(resourceBase, this.currentLocale);
        this.fireLanguageChanged();
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    public DateFormat getDateFormat() {
        return this.currentDateFormat;
    }

    public String formatDate(GanttCalendar date) {
        return this.currentDateFormat.format(date.getTime());
    }

    public String formatShortDate(GanttCalendar date) {
        return this.shortCurrentDateFormat.format(date.getTime());
    }

    public String formatTime(GanttCalendar date) {
        return this.currentTimeFormat.format(date.getTime());
    }

    public GanttCalendar parseDate(String date) throws ParseException {
        Calendar tmp = Calendar.getInstance(this.currentLocale);
        tmp.setTime(this.currentDateFormat.parse(date));
        return new GanttCalendar(tmp.get(1), tmp.get(2), tmp.get(5));
    }

    public String getMonth(int m) {
        GregorianCalendar month = new GregorianCalendar(2000, m, 1);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM", this.currentLocale);
        StringBuffer result = new StringBuffer();
        result = dateFormat.format(month.getTime(), result, new FieldPosition(2));
        return result.toString();
    }

    public String getDay(int d) {
        GregorianCalendar day = new GregorianCalendar(2000, 1, 1);
        while (day.get(7) != 1) {
            day.add(5, 1);
        }
        day.add(5, d);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE", this.currentLocale);
        StringBuffer result = new StringBuffer();
        result = dateFormat.format(day.getTime(), result, new FieldPosition(9));
        return result.toString();
    }

    public String getText(String key) {
        try {
            return this.i18n.getString(key);
        }
        catch (MissingResourceException e) {
            return "Missing Resource '" + key + "'";
        }
    }

    public ComponentOrientation getComponentOrientation() {
        return ComponentOrientation.getOrientation(this.currentLocale);
    }

    public void addListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.myListeners.remove(listener);
    }

    private void fireLanguageChanged() {
        Event event = new Event(this);
        for (int i = 0; i < this.myListeners.size(); ++i) {
            Listener next = (Listener)this.myListeners.get(i);
            next.languageChanged(event);
        }
    }

    public SimpleDateFormat createDateFormat(String string) {
        return new SimpleDateFormat(string, this.currentLocale);
    }

    public String correctLabel(String label) {
        int index = label.indexOf(36);
        if (index != -1 && label.length() - index > 1) {
            label = label.substring(0, index).concat(label.substring(++index));
        }
        return label;
    }

    public Calendar newCalendar() {
        return (Calendar)Calendar.getInstance(this.currentLocale).clone();
    }

    public static interface Listener
    extends EventListener {
        public void languageChanged(Event var1);
    }

    public class Event
    extends EventObject {
        public Event(GanttLanguage language) {
            super(language);
        }

        public GanttLanguage getLanguage() {
            return (GanttLanguage)this.getSource();
        }
    }
}

