/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.io;

import javax.xml.transform.sax.TransformerHandler;
import net.sourceforge.ganttproject.gui.TableHeaderUIFacade;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.io.SaverBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class ViewSaver
extends SaverBase {
    ViewSaver() {
    }

    public void save(UIFacade facade, TransformerHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addAttribute("zooming-state", facade.getZoomManager().getZoomState().getPersistentName(), attrs);
        this.addAttribute("id", "gantt-chart", attrs);
        this.emptyElement("view", attrs, handler);
        this.addAttribute("id", "resource-table", attrs);
        this.startElement("view", attrs, handler);
        this.writeColumns(facade.getResourceTree().getVisibleFields(), handler);
        this.endElement("view", handler);
    }

    protected void writeColumns(TableHeaderUIFacade visibleFields, TransformerHandler handler) throws SAXException {
        int i;
        AttributesImpl attrs = new AttributesImpl();
        int totalWidth = 0;
        for (i = 0; i < visibleFields.getSize(); ++i) {
            if (!visibleFields.getField(i).isVisible()) continue;
            totalWidth += visibleFields.getField(i).getWidth();
        }
        for (i = 0; i < visibleFields.getSize(); ++i) {
            TableHeaderUIFacade.Column field = visibleFields.getField(i);
            if (!field.isVisible()) continue;
            this.addAttribute("id", field.getID(), attrs);
            this.addAttribute("name", field.getName(), attrs);
            this.addAttribute("width", field.getWidth() * 100 / totalWidth, attrs);
            this.emptyElement("field", attrs, handler);
        }
    }
}

