/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.io;

import java.awt.Color;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.xml.transform.sax.TransformerHandler;
import net.sourceforge.ganttproject.CustomPropertyManager;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttTask;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.io.SaverBase;
import net.sourceforge.ganttproject.task.CustomColumn;
import net.sourceforge.ganttproject.task.CustomColumnsStorage;
import net.sourceforge.ganttproject.task.CustomColumnsValues;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import net.sourceforge.ganttproject.util.ColorConvertion;
import org.w3c.util.DateParser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class TaskSaver
extends SaverBase {
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static final /* synthetic */ boolean $assertionsDisabled;

    TaskSaver() {
    }

    void save(IGanttProject project, TransformerHandler handler, Color defaultColor) throws SAXException, IOException {
        AttributesImpl attrs = new AttributesImpl();
        if (defaultColor != null) {
            this.addAttribute("color", ColorConvertion.getColor(defaultColor), attrs);
        }
        this.startElement("tasks", attrs, handler);
        this.startElement("taskproperties", handler);
        this.writeTaskProperties(handler, project.getCustomColumnsStorage());
        this.endElement("taskproperties", handler);
        Task rootTask = project.getTaskManager().getTaskHierarchy().getRootTask();
        Task[] tasks = project.getTaskManager().getTaskHierarchy().getNestedTasks(rootTask);
        for (int i = 0; i < tasks.length; ++i) {
            this.writeTask(handler, (GanttTask)tasks[i], project.getCustomColumnsStorage());
        }
        this.endElement("tasks", handler);
    }

    private void writeTask(TransformerHandler handler, GanttTask task, CustomColumnsStorage customColumns) throws SAXException, IOException {
        if (task.getTaskID() == -1) {
            throw new IllegalArgumentException("Is it a fake root task? Task=" + task);
        }
        AttributesImpl attrs = new AttributesImpl();
        this.addAttribute("id", String.valueOf(task.getTaskID()), attrs);
        this.addAttribute("name", task.getName(), attrs);
        if (task.colorDefined()) {
            this.addAttribute("color", ColorConvertion.getColor(task.getColor()), attrs);
        }
        if (task.shapeDefined()) {
            this.addAttribute("shape", task.getShape().getArray(), attrs);
        }
        this.addAttribute("meeting", Boolean.valueOf(task.isMilestone()).toString(), attrs);
        if (task.isProjectTask()) {
            this.addAttribute("project", Boolean.TRUE.toString(), attrs);
        }
        this.addAttribute("start", task.getStart().toXMLString(), attrs);
        this.addAttribute("duration", String.valueOf(task.getLength()), attrs);
        this.addAttribute("complete", String.valueOf(task.getCompletionPercentage()), attrs);
        if (task.getThird() != null) {
            this.addAttribute("thirdDate", task.getThird().toXMLString(), attrs);
            this.addAttribute("thirdDate-constraint", String.valueOf(task.getThirdDateConstraint()), attrs);
        }
        this.addAttribute("priority", String.valueOf(task.getPriority()), attrs);
        String sWebLink = task.getWebLink();
        if (sWebLink != null && !sWebLink.equals("") && !sWebLink.equals("http://")) {
            this.addAttribute("webLink", URLEncoder.encode(sWebLink, "ISO-8859-1"), attrs);
        }
        this.addAttribute("expand", String.valueOf(task.getExpand()), attrs);
        this.startElement("task", attrs, handler);
        if (task.getNotes() != null && task.getNotes().length() > 0) {
            this.cdataElement("notes", task.getNotes(), attrs, handler);
        }
        TaskDependency[] depsAsDependee = task.getDependenciesAsDependee().toArray();
        for (int i = 0; i < depsAsDependee.length; ++i) {
            TaskDependency next = depsAsDependee[i];
            this.addAttribute("id", String.valueOf(next.getDependant().getTaskID()), attrs);
            this.addAttribute("type", String.valueOf(next.getConstraint().getID()), attrs);
            this.addAttribute("difference", String.valueOf(next.getDifference()), attrs);
            this.addAttribute("hardness", next.getHardness().getIdentifier(), attrs);
            this.emptyElement("depend", attrs, handler);
        }
        CustomColumnsValues ccv = task.getCustomValues();
        Iterator it = customColumns.getCustomColums().iterator();
        while (it.hasNext()) {
            CustomColumn nextColumn = (CustomColumn)it.next();
            String name = nextColumn.getName();
            String idc = nextColumn.getId();
            Object value = ccv.getValue(name);
            if ((class$java$util$GregorianCalendar == null ? TaskSaver.class$("java.util.GregorianCalendar") : class$java$util$GregorianCalendar).isAssignableFrom(nextColumn.getType())) {
                value = DateParser.getIsoDate(((GanttCalendar)value).getTime());
            }
            this.addAttribute("taskproperty-id", idc, attrs);
            this.addAttribute("value", String.valueOf(value), attrs);
            this.emptyElement("customproperty", attrs, handler);
        }
        if (task.getManager().getTaskHierarchy().hasNestedTasks(task)) {
            Task[] nestedTasks = task.getManager().getTaskHierarchy().getNestedTasks(task);
            for (int i = 0; i < nestedTasks.length; ++i) {
                this.writeTask(handler, (GanttTask)nestedTasks[i], customColumns);
            }
        }
        this.endElement("task", handler);
    }

    private void writeTaskProperty(TransformerHandler handler, String id, String name, String type, String valueType) throws SAXException {
        this.writeTaskProperty(handler, id, name, type, valueType, null);
    }

    private void writeTaskProperty(TransformerHandler handler, String id, String name, String type, String valueType, String defaultValue) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addAttribute("id", id, attrs);
        this.addAttribute("name", name, attrs);
        this.addAttribute("type", type, attrs);
        this.addAttribute("valuetype", valueType, attrs);
        if (defaultValue != null) {
            this.addAttribute("defaultvalue", defaultValue, attrs);
        }
        this.emptyElement("taskproperty", attrs, handler);
    }

    private void writeTaskProperties(TransformerHandler handler, CustomColumnsStorage customCol) throws SAXException {
        this.writeTaskProperty(handler, "tpd0", "type", "default", "icon");
        this.writeTaskProperty(handler, "tpd1", "priority", "default", "icon");
        this.writeTaskProperty(handler, "tpd2", "info", "default", "icon");
        this.writeTaskProperty(handler, "tpd3", "name", "default", "text");
        this.writeTaskProperty(handler, "tpd4", "begindate", "default", "date");
        this.writeTaskProperty(handler, "tpd5", "enddate", "default", "date");
        this.writeTaskProperty(handler, "tpd6", "duration", "default", "int");
        this.writeTaskProperty(handler, "tpd7", "completion", "default", "int");
        this.writeTaskProperty(handler, "tpd8", "coordinator", "default", "text");
        this.writeTaskProperty(handler, "tpd9", "predecessorsr", "default", "text");
        Iterator it = customCol.getCustomColums().iterator();
        while (it.hasNext()) {
            CustomColumn cc = (CustomColumn)it.next();
            Object defVal = cc.getDefaultValue();
            Class cla = cc.getType();
            String valueType = TaskSaver.encodeFieldType(cla);
            if (valueType == null) continue;
            if ("date".equals(valueType)) {
                if (!$assertionsDisabled && !(defVal instanceof GanttCalendar)) {
                    throw new AssertionError();
                }
                defVal = DateParser.getIsoDate(((GanttCalendar)defVal).getTime());
            }
            String idcStr = cc.getId();
            this.writeTaskProperty(handler, idcStr, cc.getName(), "custom", valueType, String.valueOf(defVal));
        }
    }

    static String encodeFieldType(Class fieldType) {
        return CustomPropertyManager.PropertyTypeEncoder.encodeFieldType(fieldType);
    }

    static {
        $assertionsDisabled = !TaskSaver.class.desiredAssertionStatus();
    }
}

