/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.io;

import java.util.List;
import javax.xml.transform.sax.TransformerHandler;
import net.sourceforge.ganttproject.CustomProperty;
import net.sourceforge.ganttproject.CustomPropertyDefinition;
import net.sourceforge.ganttproject.CustomPropertyManager;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.io.SaverBase;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.ProjectResource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class ResourceSaver
extends SaverBase {
    ResourceSaver() {
    }

    void save(IGanttProject project, TransformerHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.startElement("resources", handler);
        this.saveCustomColumnDefinitions(project, handler);
        ProjectResource[] resources = project.getHumanResourceManager().getResourcesArray();
        for (int i = 0; i < resources.length; ++i) {
            HumanResource p = (HumanResource)resources[i];
            this.addAttribute("id", String.valueOf(p.getId()), attrs);
            this.addAttribute("name", p.getName(), attrs);
            this.addAttribute("function", p.getRole().getPersistentID(), attrs);
            this.addAttribute("contacts", p.getMail(), attrs);
            this.addAttribute("phone", p.getPhone(), attrs);
            this.startElement("resource", attrs, handler);
            this.saveCustomProperties(project, p, handler);
            this.endElement("resource", handler);
        }
        this.endElement("resources", handler);
    }

    private void saveCustomProperties(IGanttProject project, HumanResource resource, TransformerHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        List properties = resource.getCustomProperties();
        for (int i = 0; i < properties.size(); ++i) {
            CustomProperty nextProperty = (CustomProperty)properties.get(i);
            CustomPropertyDefinition nextDefinition = nextProperty.getDefinition();
            if (nextProperty.getValue() == null || nextProperty.getValue().equals(nextDefinition.getDefaultValue())) continue;
            this.addAttribute("definition-id", nextDefinition.getID(), attrs);
            this.addAttribute("value", nextProperty.getValueAsString(), attrs);
            this.emptyElement("custom-property", attrs, handler);
        }
    }

    private void saveCustomColumnDefinitions(IGanttProject project, TransformerHandler handler) throws SAXException {
        CustomPropertyManager customPropsManager = project.getHumanResourceManager().getCustomPropertyManager();
        List definitions = customPropsManager.getDefinitions();
        AttributesImpl attrs = new AttributesImpl();
        for (int i = 0; i < definitions.size(); ++i) {
            CustomPropertyDefinition nextDefinition = (CustomPropertyDefinition)definitions.get(i);
            this.addAttribute("id", nextDefinition.getID(), attrs);
            this.addAttribute("name", nextDefinition.getName(), attrs);
            this.addAttribute("type", nextDefinition.getTypeAsString(), attrs);
            this.addAttribute("default-value", nextDefinition.getDefaultValueAsString(), attrs);
            this.emptyElement("custom-property-definition", attrs, handler);
        }
    }
}

