/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.io;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttGraphicArea;
import net.sourceforge.ganttproject.GanttTask;
import net.sourceforge.ganttproject.PrjInfos;
import net.sourceforge.ganttproject.gui.UIConfiguration;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.parser.FileFormatException;
import net.sourceforge.ganttproject.parser.GPParser;
import net.sourceforge.ganttproject.parser.ParsingContext;
import net.sourceforge.ganttproject.parser.ParsingListener;
import net.sourceforge.ganttproject.parser.TagHandler;
import net.sourceforge.ganttproject.task.TaskManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GanttXMLOpen
implements GPParser {
    private PrjInfos myProjectInfo = null;
    int typeChar = -1;
    String indent = "";
    String marge = "    ";
    GanttLanguage language = GanttLanguage.getInstance();
    private ArrayList myTagHandlers = new ArrayList();
    private ArrayList myListeners = new ArrayList();
    private ParsingContext myContext;
    private final TaskManager myTaskManager;
    private int viewIndex;
    private int ganttDividerLocation;
    private int resourceDividerLocation;
    private UIFacade myUIFacade = null;
    private boolean bMerge = false;
    private UIConfiguration myUIConfig;
    private StringBuffer myCharacterBuffer = new StringBuffer();
    private final Stack myTagStack = new Stack();
    static Pattern IGNORABLE_WHITESPACE = Pattern.compile("^\\s*$");

    public GanttXMLOpen(PrjInfos info, UIConfiguration uiConfig, TaskManager taskManager, UIFacade uiFacade) {
        this(taskManager);
        this.myProjectInfo = info;
        this.myUIConfig = uiConfig;
        this.viewIndex = 0;
        this.ganttDividerLocation = 300;
        this.resourceDividerLocation = 300;
        this.myUIFacade = uiFacade;
    }

    public GanttXMLOpen(TaskManager taskManager) {
        this.myContext = new ParsingContext();
        this.myTaskManager = taskManager;
    }

    public boolean load(String filename) {
        boolean temp = this.load(new File(filename));
        return temp;
    }

    public boolean load(InputStream inStream) throws IOException {
        this.myTaskManager.getAlgorithmCollection().getAdjustTaskBoundsAlgorithm().setEnabled(false);
        this.myTaskManager.getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm().setEnabled(false);
        GanttXMLParser handler = new GanttXMLParser();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(inStream, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        this.myTaskManager.getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm().setEnabled(true);
        this.myTaskManager.getAlgorithmCollection().getAdjustTaskBoundsAlgorithm().setEnabled(true);
        if (!this.bMerge) {
            this.myUIFacade.setViewIndex(this.viewIndex);
            this.myUIFacade.setGanttDividerLocation(this.ganttDividerLocation);
            if (this.resourceDividerLocation != 0) {
                this.myUIFacade.setResourceDividerLocation(this.resourceDividerLocation);
            }
        }
        return true;
    }

    public boolean load(File file) {
        GanttXMLParser handler = new GanttXMLParser();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(file, (DefaultHandler)handler);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.myUIFacade.showErrorDialog(e);
            return false;
        }
        return true;
    }

    public void addTagHandler(TagHandler handler) {
        this.myTagHandlers.add(handler);
    }

    public void addParsingListener(ParsingListener listener) {
        this.myListeners.add(listener);
    }

    public ParsingContext getContext() {
        return this.myContext;
    }

    public TagHandler getDefaultTagHandler() {
        return new DefaultTagHandler();
    }

    private String getCorrectString(String s) {
        s = s.replaceAll("\n" + this.indent, "\n");
        s = s.replaceAll(this.marge, "");
        while (s.startsWith("\n")) {
            s = s.substring(1, s.length());
        }
        while (s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        s = s.replaceAll("&#38;", "&");
        s = s.replaceAll("&#60;", "<");
        s = s.replaceAll("&#62;", ">");
        s = s.replaceAll("&#47;", "/");
        s = s.replaceAll("&#34;", "\"");
        return s;
    }

    public void isMerging(boolean b) {
        this.bMerge = b;
    }

    class GanttXMLParser
    extends DefaultHandler {
        StringBuffer textBuffer;

        GanttXMLParser() {
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            GanttXMLOpen.this.myTagStack.clear();
        }

        public void endDocument() throws SAXException {
            for (int i = 0; i < GanttXMLOpen.this.myListeners.size(); ++i) {
                ParsingListener l = (ParsingListener)GanttXMLOpen.this.myListeners.get(i);
                l.parsingFinished();
            }
        }

        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            GanttXMLOpen.this.myTagStack.push(qName);
            Iterator handlers = GanttXMLOpen.this.myTagHandlers.iterator();
            while (handlers.hasNext()) {
                TagHandler next = (TagHandler)handlers.next();
                try {
                    next.startElement(namespaceURI, sName, qName, attrs);
                }
                catch (FileFormatException e) {
                    System.err.println(e.getMessage());
                }
            }
        }

        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            Iterator handlers = GanttXMLOpen.this.myTagHandlers.iterator();
            while (handlers.hasNext()) {
                TagHandler next = (TagHandler)handlers.next();
                next.endElement(namespaceURI, sName, qName);
            }
            GanttXMLOpen.this.myTagStack.pop();
        }

        public void characters(char[] buf, int offset, int len) throws SAXException {
            String s = new String(buf, offset, len);
            if (GanttXMLOpen.this.typeChar >= 0) {
                if (IGNORABLE_WHITESPACE.matcher(s).matches()) {
                    return;
                }
                s = s.replaceAll("^\\n\\x20*", "\n");
                GanttXMLOpen.this.myCharacterBuffer.append(s);
            }
        }
    }

    private class DefaultTagHandler
    implements TagHandler {
        private DefaultTagHandler() {
        }

        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
            GanttXMLOpen.this.indent = GanttXMLOpen.this.indent + "    ";
            String eName = sName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (eName.equals("description")) {
                GanttXMLOpen.this.myCharacterBuffer = new StringBuffer();
                GanttXMLOpen.this.typeChar = 0;
            }
            if (eName.equals("notes")) {
                GanttXMLOpen.this.myCharacterBuffer = new StringBuffer();
                GanttXMLOpen.this.typeChar = 1;
            }
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if ("".equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if (eName.equals("project") && GanttXMLOpen.this.myTagStack.size() == 1) {
                        if (aName.equals("name")) {
                            ((GanttXMLOpen)GanttXMLOpen.this).myProjectInfo._sProjectName = attrs.getValue(i);
                            continue;
                        }
                        if (aName.equals("company")) {
                            ((GanttXMLOpen)GanttXMLOpen.this).myProjectInfo._sOrganization = attrs.getValue(i);
                            continue;
                        }
                        if (aName.equals("webLink")) {
                            ((GanttXMLOpen)GanttXMLOpen.this).myProjectInfo._sWebLink = attrs.getValue(i);
                            continue;
                        }
                        if (aName.equals("view-date")) {
                            GanttXMLOpen.this.myUIFacade.getScrollingManager().scrollLeft(GanttCalendar.parseXMLDate(attrs.getValue(i)).getTime());
                            continue;
                        }
                        if (aName.equals("view-index")) {
                            GanttXMLOpen.this.viewIndex = new Integer(attrs.getValue(i)).hashCode();
                            continue;
                        }
                        if (aName.equals("gantt-divider-location")) {
                            GanttXMLOpen.this.ganttDividerLocation = new Integer(attrs.getValue(i));
                            continue;
                        }
                        if (!aName.equals("resource-divider-location")) continue;
                        GanttXMLOpen.this.resourceDividerLocation = new Integer(attrs.getValue(i));
                        continue;
                    }
                    if (!eName.equals("tasks") || !aName.equals("color")) continue;
                    GanttXMLOpen.this.myUIConfig.setProjectLevelTaskColor(this.determineColor(attrs.getValue(i)));
                }
            }
        }

        public void endElement(String namespaceURI, String sName, String qName) {
            GanttXMLOpen.this.indent = GanttXMLOpen.this.indent.substring(0, GanttXMLOpen.this.indent.length() - 4);
            if ("description".equals(qName)) {
                ((GanttXMLOpen)GanttXMLOpen.this).myProjectInfo._sDescription = GanttXMLOpen.this.getCorrectString(GanttXMLOpen.this.myCharacterBuffer.toString());
            } else if ("notes".equals(qName)) {
                GanttTask currentTask = GanttXMLOpen.this.myTaskManager.getTask(GanttXMLOpen.this.getContext().getTaskID());
                currentTask.setNotes(GanttXMLOpen.this.getCorrectString(GanttXMLOpen.this.myCharacterBuffer.toString()));
            }
        }

        private final Color determineColor(String hexString) {
            if (!Pattern.matches("#[0-9abcdefABCDEF]{6}+", hexString)) {
                return GanttGraphicArea.taskDefaultColor;
            }
            int r = Integer.valueOf(hexString.substring(1, 3), 16);
            int g = Integer.valueOf(hexString.substring(3, 5), 16);
            int b = Integer.valueOf(hexString.substring(5, 7), 16);
            return new Color(r, g, b);
        }
    }
}

