/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import net.sourceforge.ganttproject.GanttGraphicArea;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.GanttTask;
import net.sourceforge.ganttproject.GanttTree2;
import net.sourceforge.ganttproject.task.TaskManager;

public class GanttTXTOpen {
    GanttTree2 treePanel;
    GanttProject prj;
    GanttGraphicArea area;
    private final TaskManager myTaskManager;

    public GanttTXTOpen(GanttTree2 tree, GanttProject appli, GanttGraphicArea gra, TaskManager taskManager) {
        this(taskManager);
        this.treePanel = tree;
        this.prj = appli;
        this.area = gra;
    }

    public GanttTXTOpen(TaskManager taskManager) {
        this.myTaskManager = taskManager;
    }

    public boolean load(File f) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while (br.ready()) {
                String sTaskName = br.readLine();
                if (sTaskName.equals("")) continue;
                GanttTask task = this.myTaskManager.createTask();
                task.setColor(this.area.getTaskColor());
                task.setName(sTaskName);
                task.setLength(1);
                this.myTaskManager.registerTask(task);
                this.treePanel.addObject(task, null, -1);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

