/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.ganttproject.CustomProperty;
import net.sourceforge.ganttproject.CustomPropertyDefinition;
import net.sourceforge.ganttproject.GanttTask;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.io.CSVOptions;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.task.CustomColumnsValues;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.Task;

public class GanttCSVExport {
    private final CSVOptions csvOptions;
    private final HumanResourceManager myHrManager;
    private final Task[] myTasks;
    List resources = new ArrayList();
    int iMaxSize = 0;
    boolean bFixedSize = false;
    private final IGanttProject myProject;

    public GanttCSVExport(IGanttProject project, CSVOptions csvOptions) {
        this.myProject = project;
        this.myTasks = project.getTaskManager().getTasks();
        this.myHrManager = (HumanResourceManager)project.getHumanResourceManager();
        this.csvOptions = csvOptions;
    }

    public void save(OutputStream stream) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(stream);
        this.beginToSave(out);
        out.close();
    }

    public void beginToSave(OutputStreamWriter out) throws IOException {
        this.resources = this.myHrManager.getResources();
        this.bFixedSize = this.csvOptions.bFixedSize;
        if (this.csvOptions.bFixedSize) {
            this.getMaxSize();
        }
        this.writeTasks(out);
        out.write("\n\n\n");
        this.writeResources(out);
        out.write("\n");
    }

    private void writeCell(OutputStreamWriter out, String cellValue) throws IOException {
        out.write(this.correctField(cellValue) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedChar));
    }

    private void writeTextCell(OutputStreamWriter out, String cellValue) throws IOException {
        out.write((this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar) + this.correctField(cellValue) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar + this.csvOptions.sSeparatedChar));
    }

    private void writeTaskHeaders(OutputStreamWriter out) throws IOException {
        if (this.csvOptions.bExportTaskID) {
            this.writeCell(out, this.i18n("tableColID"));
        }
        if (this.csvOptions.bExportTaskName) {
            this.writeCell(out, this.i18n("tableColName"));
        }
        if (this.csvOptions.bExportTaskStartDate) {
            this.writeCell(out, this.i18n("tableColBegDate"));
        }
        if (this.csvOptions.bExportTaskEndDate) {
            this.writeCell(out, this.i18n("tableColEndDate"));
        }
        if (this.csvOptions.bExportTaskDuration) {
            this.writeCell(out, this.i18n("tableColDuration"));
        }
        if (this.csvOptions.bExportTaskPercent) {
            this.writeCell(out, this.i18n("tableColCompletion"));
        }
        if (this.csvOptions.bExportTaskWebLink) {
            this.writeCell(out, this.i18n("webLink"));
        }
        if (this.csvOptions.bExportTaskResources) {
            this.writeCell(out, this.i18n("resources"));
        }
        if (this.csvOptions.bExportTaskNotes) {
            this.writeCell(out, this.i18n("notes"));
        }
        List customFields = this.myProject.getCustomColumnsStorage().getCustomColumnsNames();
        for (int i = 0; i < customFields.size(); ++i) {
            this.writeCell(out, String.valueOf(customFields.get(i)));
        }
        out.write("\n\n");
    }

    private String i18n(String key) {
        return GanttLanguage.getInstance().getText(key);
    }

    private void writeTasks(OutputStreamWriter out) throws IOException {
        this.writeTaskHeaders(out);
        List customFields = this.myProject.getCustomColumnsStorage().getCustomColumnsNames();
        for (int i = 0; i < this.myTasks.length; ++i) {
            Task task = this.myTasks[i];
            if (this.csvOptions.bExportTaskID) {
                this.writeCell(out, "" + task.getTaskID());
            }
            if (this.csvOptions.bExportTaskName) {
                this.writeTextCell(out, this.getName(task));
            }
            if (this.csvOptions.bExportTaskStartDate) {
                this.writeCell(out, task.getStart().toString());
            }
            if (this.csvOptions.bExportTaskEndDate) {
                this.writeCell(out, task.getEnd().toString());
            }
            if (this.csvOptions.bExportTaskDuration) {
                this.writeCell(out, "" + task.getDuration().getLength());
            }
            if (this.csvOptions.bExportTaskPercent) {
                this.writeCell(out, "" + task.getCompletionPercentage());
            }
            if (this.csvOptions.bExportTaskWebLink) {
                this.writeTextCell(out, this.getWebLink((GanttTask)task));
            }
            if (this.csvOptions.bExportTaskResources) {
                this.writeTextCell(out, this.getAssignments(task));
            }
            if (this.csvOptions.bExportTaskNotes) {
                this.writeTextCell(out, task.getNotes());
            }
            CustomColumnsValues customValues = task.getCustomValues();
            for (int j = 0; j < customFields.size(); ++j) {
                Object nextCustomFieldValue = customValues.getValue(String.valueOf(customFields.get(j)));
                this.writeCell(out, String.valueOf(nextCustomFieldValue));
            }
            out.write("\n");
        }
    }

    private void writeResourceHeaders(OutputStreamWriter out) throws IOException {
        if (this.csvOptions.bExportResourceID) {
            this.writeCell(out, this.i18n("tableColID"));
        }
        if (this.csvOptions.bExportResourceName) {
            this.writeCell(out, this.i18n("tableColResourceName"));
        }
        if (this.csvOptions.bExportResourceMail) {
            this.writeCell(out, this.i18n("tableColResourceEMail"));
        }
        if (this.csvOptions.bExportResourcePhone) {
            this.writeCell(out, this.i18n("tableColResourcePhone"));
        }
        if (this.csvOptions.bExportResourceRole) {
            this.writeCell(out, this.i18n("tableColResourceRole"));
        }
        List customFieldDefs = this.myProject.getResourceCustomPropertyManager().getDefinitions();
        for (int i = 0; i < customFieldDefs.size(); ++i) {
            CustomPropertyDefinition nextDef = (CustomPropertyDefinition)customFieldDefs.get(i);
            this.writeCell(out, nextDef.getName());
        }
        out.write("\n\n");
    }

    private void writeResources(OutputStreamWriter out) throws IOException {
        this.writeResourceHeaders(out);
        for (int i = 0; i < this.resources.size(); ++i) {
            HumanResource p = (HumanResource)this.resources.get(i);
            if (this.csvOptions.bExportResourceID) {
                this.writeCell(out, "" + p.getId());
            }
            if (this.csvOptions.bExportResourceName) {
                this.writeTextCell(out, p.getName());
            }
            if (this.csvOptions.bExportResourceMail) {
                this.writeTextCell(out, p.getMail());
            }
            if (this.csvOptions.bExportResourcePhone) {
                this.writeTextCell(out, p.getPhone());
            }
            if (this.csvOptions.bExportResourceRole) {
                Role role = p.getRole();
                String sRoleID = role == null ? "0" : role.getPersistentID();
                this.writeTextCell(out, sRoleID);
            }
            List customProps = p.getCustomProperties();
            for (int j = 0; j < customProps.size(); ++j) {
                CustomProperty nextProperty = (CustomProperty)customProps.get(j);
                this.writeTextCell(out, nextProperty.getValueAsString());
            }
            out.write("\n");
        }
    }

    void getMaxSize() {
        int j;
        String s;
        int i;
        List customFields = this.myProject.getCustomColumnsStorage().getCustomColumnsNames();
        this.iMaxSize = 0;
        for (i = 0; i < this.myTasks.length; ++i) {
            Task task = this.myTasks[i];
            if (this.csvOptions.bExportTaskID && (s = "" + task.getTaskID()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskName && (s = "" + this.getName(task)).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskStartDate && (s = "" + task.getStart()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskEndDate && (s = "" + task.getEnd()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskDuration && (s = "" + task.getDuration().getLength()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskPercent && (s = "" + task.getCompletionPercentage()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskWebLink && (s = "" + this.getWebLink((GanttTask)task)).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskResources && (s = "" + this.getAssignments(task)).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskNotes && (s = "" + task.getNotes()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            CustomColumnsValues customValues = task.getCustomValues();
            for (j = 0; j < customFields.size(); ++j) {
                Object nextCustomFieldValue = customValues.getValue(String.valueOf(customFields.get(j)));
                String nextValueAsString = String.valueOf(nextCustomFieldValue);
                if (nextValueAsString.length() <= this.iMaxSize) continue;
                this.iMaxSize = nextValueAsString.length();
            }
        }
        for (i = 0; i < this.resources.size(); ++i) {
            HumanResource p = (HumanResource)this.resources.get(i);
            if (this.csvOptions.bExportResourceID && (s = "" + p.getId()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportResourceName && (s = "" + p.getName()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportResourceMail && (s = "" + p.getMail()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportResourcePhone && (s = "" + p.getPhone()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportResourceRole) {
                String s2;
                Role role = p.getRole();
                String sRoleID = "0";
                if (role != null) {
                    sRoleID = role.getPersistentID();
                }
                if ((s2 = "" + sRoleID).length() > this.iMaxSize) {
                    this.iMaxSize = s2.length();
                }
            }
            List customProps = p.getCustomProperties();
            for (j = 0; j < customProps.size(); ++j) {
                CustomProperty nextProperty = (CustomProperty)customProps.get(j);
                if (nextProperty.getValueAsString().length() <= this.iMaxSize) continue;
                this.iMaxSize = nextProperty.getValueAsString().length();
            }
        }
    }

    private String getName(Task task) {
        if (this.bFixedSize) {
            return task.getName();
        }
        String res = "";
        int depth = task.getManager().getTaskHierarchy().getDepth(task);
        for (int i = 0; i < depth; ++i) {
            res = res + "  ";
        }
        return res + task.getName();
    }

    private String getWebLink(GanttTask task) {
        return task.getWebLink().equals("http://") ? "" : task.getWebLink();
    }

    private String getAssignments(Task task) {
        String res = "";
        ResourceAssignment[] assignment = task.getAssignments();
        for (int i = 0; i < assignment.length; ++i) {
            res = res + assignment[i].getResource() + (i == assignment.length - 1 ? "" : (this.csvOptions.sSeparatedChar.equals(";") ? "," : ";"));
        }
        return res;
    }

    private String correctField(String field) {
        String res = "";
        for (int i = 0; i < this.iMaxSize - field.length(); ++i) {
            res = res + " ";
        }
        res = res + field;
        return res;
    }
}

