/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.importer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.ganttproject.CustomPropertyManager;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.GanttProjectImpl;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.PrjInfos;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.document.DocumentCreator;
import net.sourceforge.ganttproject.document.DocumentManager;
import net.sourceforge.ganttproject.document.FileDocument;
import net.sourceforge.ganttproject.gui.TableHeaderUIFacade;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.importer.Importer;
import net.sourceforge.ganttproject.importer.ImporterBase;
import net.sourceforge.ganttproject.io.GPSaver;
import net.sourceforge.ganttproject.io.GanttXMLOpen;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.parser.GPParser;
import net.sourceforge.ganttproject.parser.ParserFactory;
import net.sourceforge.ganttproject.task.CustomColumnsManager;
import net.sourceforge.ganttproject.task.CustomColumnsStorage;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskManagerImpl;

public class ImporterFromGanttFile
extends ImporterBase
implements Importer {
    private UIFacade myUIFacade;

    public String getFileNamePattern() {
        return "xml|gan";
    }

    public String getFileTypeDescription() {
        return GanttLanguage.getInstance().getText("ganttprojectFiles");
    }

    public void run(GanttProject project, final UIFacade uiFacade, final File selectedFile) {
        final boolean bMerge = this.acceptImport(project);
        this.myUIFacade = project.getUIFacade();
        final GanttProject targetProject = project;
        final BufferProject bufferProject = this.createBufferProject(targetProject, uiFacade);
        project.getUndoManager().undoableEdit("Import", new Runnable(){

            public void run() {
                ImporterFromGanttFile.this.openDocument(targetProject, bufferProject, uiFacade, selectedFile, bMerge);
                ImporterFromGanttFile.this.myUIFacade.getTaskTree().getVisibleFields().importData(bufferProject.getVisibleFields());
            }
        });
    }

    private BufferProject createBufferProject(GanttProject targetProject, UIFacade uiFacade) {
        return new BufferProject(targetProject, uiFacade);
    }

    protected Document getDocument(File selectedFile) {
        return new FileDocument(selectedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openDocument(GanttProject targetProject, IGanttProject bufferProject, UIFacade uiFacade, File selectedFile, boolean bMerge) {
        try {
            Document document = bufferProject.getDocumentManager().getDocument(selectedFile.getAbsolutePath());
            document.read();
            targetProject.getRoleManager().importData(bufferProject.getRoleManager());
            CustomPropertyManager targetResCustomPropertyMgr = targetProject.getResourceCustomPropertyManager();
            targetResCustomPropertyMgr.importData(bufferProject.getResourceCustomPropertyManager());
            Map original2ImportedResource = targetProject.getHumanResourceManager().importData(bufferProject.getHumanResourceManager());
            CustomColumnsStorage targetCustomColumnStorage = targetProject.getCustomColumnsStorage();
            targetCustomColumnStorage.importData(bufferProject.getCustomColumnsStorage());
            TaskManagerImpl origTaskManager = (TaskManagerImpl)targetProject.getTaskManager();
            try {
                origTaskManager.setEventsEnabled(false);
                Map original2ImportedTask = origTaskManager.importData(bufferProject.getTaskManager());
                origTaskManager.importAssignments(bufferProject.getTaskManager(), targetProject.getHumanResourceManager(), original2ImportedTask, original2ImportedResource);
            }
            finally {
                origTaskManager.setEventsEnabled(true);
            }
            targetProject.getResourcePanel().getResourceTreeTableModel().updateResources();
        }
        catch (IOException e) {
            uiFacade.showErrorDialog(e);
        }
    }

    class BufferProject
    extends GanttProjectImpl
    implements ParserFactory {
        PrjInfos myProjectInfo = new PrjInfos();
        final DocumentManager myDocumentManager;
        final TaskManager myTaskManager;
        final UIFacade myUIfacade;
        private final TableHeaderUIFacade myVisibleFields = new VisibleFieldsImpl();

        BufferProject(GanttProject targetProject, UIFacade uiFacade) {
            this.myDocumentManager = new DocumentCreator(this, this, uiFacade, this){
                private final /* synthetic */ BufferProject this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1, x2);
                }

                protected TableHeaderUIFacade getVisibleFields() {
                    return BufferProject.access$200(this.this$1);
                }
            };
            this.myTaskManager = targetProject.getTaskManager().emptyClone();
            this.myUIfacade = uiFacade;
        }

        public TableHeaderUIFacade getVisibleFields() {
            return this.myVisibleFields;
        }

        public GPParser newParser() {
            return new GanttXMLOpen(this.myProjectInfo, this.getUIConfiguration(), this.getTaskManager(), this.myUIfacade);
        }

        public GPSaver newSaver() {
            return null;
        }

        public DocumentManager getDocumentManager() {
            return this.myDocumentManager;
        }

        public TaskManager getTaskManager() {
            return this.myTaskManager;
        }

        public CustomColumnsStorage getCustomColumnsStorage() {
            return this.myTaskManager.getCustomColumnStorage();
        }

        public CustomColumnsManager getTaskCustomColumnManager() {
            return super.getTaskCustomColumnManager();
        }

        static /* synthetic */ TableHeaderUIFacade access$200(BufferProject x0) {
            return x0.myVisibleFields;
        }
    }

    private static class VisibleFieldsImpl
    implements TableHeaderUIFacade {
        private List myFields = new ArrayList();

        private VisibleFieldsImpl() {
        }

        public void add(String name, int order, int width) {
            this.myFields.add(new TaskFieldImpl(name, order, width));
        }

        public void clear() {
            this.myFields.clear();
        }

        public TableHeaderUIFacade.Column getField(int index) {
            return (TableHeaderUIFacade.Column)this.myFields.get(index);
        }

        public int getSize() {
            return this.myFields.size();
        }

        public void importData(TableHeaderUIFacade source) {
            for (int i = 0; i < source.getSize(); ++i) {
                TableHeaderUIFacade.Column nextField = source.getField(i);
                this.myFields.add(nextField);
            }
        }
    }

    private static class TaskFieldImpl
    implements TableHeaderUIFacade.Column {
        private final String myID;
        private final int myOrder;
        private final int myWidth;

        TaskFieldImpl(String id, int order, int width) {
            this.myID = id;
            this.myOrder = order;
            this.myWidth = width;
        }

        public String getID() {
            return this.myID;
        }

        public int getOrder() {
            return this.myOrder;
        }

        public int getWidth() {
            return this.myWidth;
        }

        public boolean isVisible() {
            return true;
        }

        public String getName() {
            return null;
        }
    }
}

