/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.taskproperties;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sourceforge.ganttproject.gui.GanttDialogCustomColumn;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.CustomColumn;
import net.sourceforge.ganttproject.task.CustomColumnsException;
import net.sourceforge.ganttproject.task.CustomColumnsManager;
import net.sourceforge.ganttproject.task.CustomColumnsStorage;
import org.jdesktop.jdnc.JNTable;
import org.jdesktop.swing.decorator.AlternateRowHighlighter;
import org.jdesktop.swing.decorator.Highlighter;
import org.jdesktop.swing.decorator.HighlighterPipeline;

public class CustomColumnsPanel
extends JPanel {
    private static GanttLanguage language = GanttLanguage.getInstance();
    private final CustomColumnsStorage customColumnStorage;
    private Vector titles = null;
    private JNTable table = null;
    private JButton buttonAdd = null;
    private JButton buttonDel = null;
    private final CustomColumnsManager myColumnManager;
    private final UIFacade myUIfacade;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    public CustomColumnsPanel(CustomColumnsManager manager, CustomColumnsStorage customColHandler, UIFacade uifacade) {
        this.myColumnManager = manager;
        this.customColumnStorage = customColHandler;
        this.myUIfacade = uifacade;
        this.initComponents();
    }

    private void initComponents() {
        this.titles = new Vector(3);
        this.titles.add(language.getText("name"));
        this.titles.add(language.getText("typeClass"));
        this.titles.add(language.getText("default"));
        final CustomColumnTableModel model = new CustomColumnTableModel(this.customColumnStorage);
        this.table = new JNTable((TableModel)model);
        this.table.setPreferredVisibleRowCount(10);
        this.add((Component)this.table);
        this.table.getColumn((String)this.titles.get(0)).setPreferredWidth(150);
        this.table.getColumn((String)this.titles.get(1)).setPreferredWidth(150);
        this.table.getColumn((String)this.titles.get(2)).setPreferredWidth(200);
        this.table.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.floralWhite, AlternateRowHighlighter.quickSilver}));
        this.table.getTable().setSortable(false);
        this.buttonAdd = new JButton(language.getText("add"));
        this.buttonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomColumnsPanel.this.myUIfacade.getUndoManager().undoableEdit("TaskPropertyNewColumn", new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        CustomColumn customColumn = new CustomColumn();
                        GanttDialogCustomColumn d = new GanttDialogCustomColumn(CustomColumnsPanel.access$100(1.access$000(this.this$1)), customColumn);
                        d.setVisible(true);
                        CustomColumnsPanel.access$200(1.access$000(this.this$1)).addNewCustomColumn(customColumn);
                        1.access$400(this.this$1).refreshData(CustomColumnsPanel.access$300(1.access$000(this.this$1)));
                        1.access$000(this.this$1).repaint();
                    }
                });
            }

            static /* synthetic */ CustomColumnsPanel access$000(1 x0) {
                return x0.CustomColumnsPanel.this;
            }

            static /* synthetic */ CustomColumnTableModel access$400(1 x0) {
                return x0.model;
            }
        });
        this.add((Component)this.buttonAdd, "East");
        this.buttonDel = new JButton(language.getText("delete"));
        this.buttonDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] selectedRowsIndexes = CustomColumnsPanel.this.table.getTable().getSelectedRows();
                for (int i = 0; i < selectedRowsIndexes.length; ++i) {
                    String nameToDel = (String)model.getValueAt(selectedRowsIndexes[i], 0);
                    CustomColumnsPanel.this.myColumnManager.deleteCustomColumn(nameToDel);
                }
                model.refreshData(CustomColumnsPanel.this.customColumnStorage);
                CustomColumnsPanel.this.repaint();
            }
        });
        this.add((Component)this.buttonDel, "East");
    }

    class CustomColumnTableModel
    extends DefaultTableModel {
        CustomColumnsStorage customColumnsHandler = null;

        public CustomColumnTableModel(CustomColumnsStorage ccHandler) {
            this.customColumnsHandler = ccHandler;
            this.columnIdentifiers = CustomColumnsPanel.this.titles;
            this.dataVector = new Vector();
            Iterator it = this.customColumnsHandler.getCustomColums().iterator();
            while (it.hasNext()) {
                CustomColumn cc = (CustomColumn)it.next();
                Object[] o = new Object[]{cc.getName(), cc.getType(), cc.getDefaultValue()};
                this.addRow(o);
            }
        }

        public void refreshData(CustomColumnsStorage cch) {
            this.customColumnsHandler = cch;
            this.dataVector = new Vector();
            Iterator it = this.customColumnsHandler.getCustomColums().iterator();
            while (it.hasNext()) {
                CustomColumn cc = (CustomColumn)it.next();
                Object[] o = new Object[]{cc.getName(), cc.getType(), cc.getDefaultValue()};
                this.addRow(o);
            }
        }

        public String getColumnName(int column) {
            return (String)this.columnIdentifiers.get(column);
        }

        public Class getColumnClass(int column) {
            return class$java$lang$String == null ? (class$java$lang$String = CustomColumnsPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int col) {
            return col != 1;
        }

        public Object getValueAt(int row, int col) {
            String colName = (String)((Vector)this.dataVector.get(row)).get(0);
            CustomColumn res = this.customColumnsHandler.getCustomColumn(colName);
            if (res != null) {
                switch (col) {
                    case 0: {
                        return res.getName();
                    }
                    case 1: {
                        Class cl = res.getType();
                        if (cl.equals(class$java$lang$String == null ? (class$java$lang$String = CustomColumnsPanel.class$("java.lang.String")) : class$java$lang$String)) {
                            return language.getText("text");
                        }
                        if ((class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = CustomColumnsPanel.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar).isAssignableFrom(cl)) {
                            return language.getText("date");
                        }
                        if (cl.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = CustomColumnsPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                            return language.getText("boolean");
                        }
                        if (cl.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = CustomColumnsPanel.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                            return language.getText("integer");
                        }
                        if (cl.equals(class$java$lang$Double == null ? (class$java$lang$Double = CustomColumnsPanel.class$("java.lang.Double")) : class$java$lang$Double)) {
                            return language.getText("double");
                        }
                    }
                    case 2: {
                        return res.getDefaultValue();
                    }
                }
            }
            return null;
        }

        public void setValueAt(Object o, int row, int col) {
            Vector v = (Vector)this.dataVector.get(row);
            String oldName = (String)v.get(0);
            if (col == 0 && !((String)o).equals(oldName) && !CustomColumnsPanel.this.customColumnStorage.exists((String)o)) {
                v.setElementAt(o, col);
                CustomColumnsPanel.this.myColumnManager.changeCustomColumnName(oldName, (String)o);
            }
            if (col == 2) {
                try {
                    CustomColumnsPanel.this.myColumnManager.changeCustomColumnDefaultValue(oldName, o);
                    v.setElementAt(o, col);
                }
                catch (CustomColumnsException e) {
                    // empty catch block
                }
            }
        }
    }
}

