/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options.model;

import java.awt.Color;
import net.sourceforge.ganttproject.gui.options.model.ColorOption;
import net.sourceforge.ganttproject.gui.options.model.GPAbstractOption;
import net.sourceforge.ganttproject.util.ColorConvertion;

public class DefaultColorOption
extends GPAbstractOption
implements ColorOption {
    private Color myLockedValue;
    private Color myValue;

    public DefaultColorOption(String id) {
        super(id);
    }

    public Color getValue() {
        return this.myValue;
    }

    public void setValue(Color value) {
        if (!this.isLocked()) {
            throw new IllegalStateException("Lock option before setting value");
        }
        this.myLockedValue = value;
    }

    public void commit() {
        super.commit();
        this.myValue = this.myLockedValue;
    }

    public String getPersistentValue() {
        return this.getValue() == null ? null : ColorConvertion.getColor(this.getValue());
    }

    public void loadPersistentValue(String value) {
        this.myLockedValue = ColorConvertion.determineColor(value);
    }

    public boolean isChanged() {
        if (this.isLocked() && this.myValue != null) {
            return false == this.myValue.equals(this.myLockedValue);
        }
        return false;
    }
}

