/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.gui.options.GeneralOptionPanel;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class LanguageSettingsPanel
extends GeneralOptionPanel
implements ItemListener {
    private JComboBox cbLanguage;
    private GanttProject appli;

    public LanguageSettingsPanel(GanttProject parent) {
        super(GanttLanguage.getInstance().getText("languages"), GanttLanguage.getInstance().getText("settingsLanguages"), parent);
        this.appli = parent;
        this.cbLanguage = new JComboBox();
        this.cbLanguage.addItem("Traditional Chinese");
        this.cbLanguage.addItem("Simplified Chinese");
        this.cbLanguage.addItem("\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438");
        this.cbLanguage.addItem("\u010cesky");
        this.cbLanguage.addItem("Dansk");
        this.cbLanguage.addItem("Deutsch");
        this.cbLanguage.addItem("English");
        this.cbLanguage.addItem("English (United Kingdom)");
        this.cbLanguage.addItem("Espa\u00f1ol");
        this.cbLanguage.addItem("Estonian");
        this.cbLanguage.addItem("Finnish");
        this.cbLanguage.addItem("Fran\u00e7ais");
        this.cbLanguage.addItem("Greek");
        this.cbLanguage.addItem("Hungarian");
        this.cbLanguage.addItem("Korean");
        this.cbLanguage.addItem("\u05e2\u05d1\u05e8\u05d9\u05ea");
        this.cbLanguage.addItem("Italiano");
        this.cbLanguage.addItem("Japanese");
        this.cbLanguage.addItem("Nederlands");
        this.cbLanguage.addItem("Norsk");
        this.cbLanguage.addItem("Polski");
        this.cbLanguage.addItem("Portugues");
        this.cbLanguage.addItem("Portugu\u00eas do Brasil");
        this.cbLanguage.addItem("\u0420\u0443\u0441\u0441\u043a\u0438\u0439");
        this.cbLanguage.addItem("Romanian");
        this.cbLanguage.addItem("Sloven\u0161\u010dina");
        this.cbLanguage.addItem("Slovensky");
        this.cbLanguage.addItem("Svenska");
        this.cbLanguage.addItem("T\u00fcrk\u00e7e");
        this.cbLanguage.addItemListener(this);
        JPanel languagePanel = new JPanel(new BorderLayout());
        languagePanel.add((Component)this.cbLanguage, "North");
        this.vb.add(languagePanel);
        this.applyComponentOrientation(this.language.getComponentOrientation());
    }

    public boolean applyChanges(boolean askForApply) {
        if (this.bHasChange && (!askForApply || askForApply && this.askForApplyChanges())) {
            this.changeLanguage();
        }
        return this.bHasChange;
    }

    public void initialize() {
        this.cbLanguage.setSelectedItem(this.language.getText("longLanguage").trim());
        this.bHasChange = false;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.bHasChange = true;
        }
    }

    public void changeLanguage() {
        String lang = (String)this.cbLanguage.getSelectedItem();
        if (lang.equals("Traditional Chinese")) {
            this.language.setLocale(Locale.TAIWAN);
        } else if (lang.equals("Simplified Chinese")) {
            this.language.setLocale(Locale.CHINA);
        } else if (lang.equals("\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438")) {
            this.language.setLocale(new Locale("bg", "BG"));
        } else if (lang.equals("\u010cesky")) {
            this.language.setLocale(new Locale("cs", "CZ"));
        } else if (lang.equals("Dansk")) {
            this.language.setLocale(new Locale("da", "DK"));
        } else if (lang.equals("Deutsch")) {
            this.language.setLocale(Locale.GERMANY);
        } else if (lang.equals("English")) {
            this.language.setLocale(Locale.US);
        } else if (lang.equals("English (United Kingdom)")) {
            this.language.setLocale(Locale.UK);
        } else if (lang.equals("Espa\u00f1ol")) {
            this.language.setLocale(new Locale("es", "ES"));
        } else if (lang.equals("Estonian")) {
            this.language.setLocale(new Locale("et", "ET"));
        } else if (lang.equals("Greek")) {
            this.language.setLocale(new Locale("el", "GR"));
        } else if (lang.equals("Finnish")) {
            this.language.setLocale(new Locale("fi", "FI"));
        } else if (lang.equals("Fran\u00e7ais")) {
            this.language.setLocale(Locale.FRANCE);
        } else if (lang.equals("Hungarian")) {
            this.language.setLocale(new Locale("hu", "HU"));
        } else if (lang.equals("Korean")) {
            this.language.setLocale(new Locale("ko", "KR"));
        } else if (lang.equals("\u05e2\u05d1\u05e8\u05d9\u05ea")) {
            this.language.setLocale(new Locale("iw", "iW"));
        } else if (lang.equals("Italiano")) {
            this.language.setLocale(Locale.ITALY);
        } else if (lang.equals("Japanese")) {
            this.language.setLocale(new Locale("ja", "JP"));
        } else if (lang.equals("Nederlands")) {
            this.language.setLocale(new Locale("nl", "NL"));
        } else if (lang.equals("Norsk")) {
            this.language.setLocale(new Locale("no", "NO"));
        } else if (lang.equals("Polski")) {
            this.language.setLocale(new Locale("pl", "PL"));
        } else if (lang.equals("Portugues")) {
            this.language.setLocale(new Locale("pt", "PT"));
        } else if (lang.equals("Portugu\u00eas do Brasil")) {
            this.language.setLocale(new Locale("pt", "BR"));
        } else if (lang.equals("Romanian")) {
            this.language.setLocale(new Locale("ro", "RO"));
        } else if (lang.equals("Sloven\u0161\u010dina")) {
            this.language.setLocale(new Locale("si", "SI"));
        } else if (lang.equals("Slovensky")) {
            this.language.setLocale(new Locale("sk", "SK"));
        } else if (lang.equals("Svenska")) {
            this.language.setLocale(new Locale("sv", "SV"));
        } else if (lang.equals("T\u00fcrk\u00e7e")) {
            this.language.setLocale(new Locale("tr", "TR"));
        } else if (lang.equals("\u0420\u0443\u0441\u0441\u043a\u0438\u0439")) {
            this.language.setLocale(new Locale("ru", "RU"));
        }
        this.appli.changeLanguage();
    }
}

