/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.gui.options.OptionsPageBuilder;
import net.sourceforge.ganttproject.gui.options.model.DateOption;
import net.sourceforge.ganttproject.gui.options.model.DefaultDateOption;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class DateIntervalListEditor
extends JPanel {
    private final DateIntervalModel myIntervalsModel;
    private final DateOption myStart;
    private final DateOption myFinish;
    private GPAction myAddAction;
    private GPAction myDeleteAction;
    private MyListModel myListModel = new MyListModel();
    private ListSelectionModel myListSelectionModel;

    public DateIntervalListEditor(final DateIntervalModel intervalsModel) {
        super(new BorderLayout());
        this.myIntervalsModel = intervalsModel;
        this.myStart = new DefaultDateOption("generic.startDate"){

            public void setValue(Date value) {
                super.setValue(value);
                this.commit();
                if (intervalsModel.getMaxIntervalLength() == 1) {
                    DateIntervalListEditor.this.myFinish.setValue(value);
                }
                DateIntervalListEditor.this.updateActions();
                this.lock();
            }
        };
        this.myFinish = new DefaultDateOption("generic.endDate"){

            public void setValue(Date value) {
                super.setValue(value);
                this.commit();
                DateIntervalListEditor.this.updateActions();
                this.lock();
            }
        };
        this.myStart.lock();
        this.myFinish.lock();
        this.init();
    }

    private void updateActions() {
        if (this.myStart.getValue() != null && this.myFinish.getValue() != null && !this.myFinish.getValue().before(this.myStart.getValue())) {
            this.myAddAction.setEnabled(true);
        } else {
            this.myAddAction.setEnabled(false);
        }
        this.myDeleteAction.setEnabled(false == this.myListSelectionModel.isSelectionEmpty());
    }

    private void init() {
        this.myAddAction = new GPAction(){

            protected String getIconFilePrefix() {
                return null;
            }

            protected String getLocalizedName() {
                return this.getI18n("add");
            }

            public void actionPerformed(ActionEvent e) {
                DateIntervalListEditor.this.myIntervalsModel.add(new DateInterval(DateIntervalListEditor.this.myStart.getValue(), DateIntervalListEditor.this.myFinish.getValue()));
                DateIntervalListEditor.this.myListModel.update();
            }
        };
        this.myDeleteAction = new GPAction(){

            protected String getIconFilePrefix() {
                return null;
            }

            protected String getLocalizedName() {
                return this.getI18n("delete");
            }

            public void actionPerformed(ActionEvent e) {
                int selected = DateIntervalListEditor.this.myListSelectionModel.getMinSelectionIndex();
                DateIntervalListEditor.this.myIntervalsModel.remove(DateIntervalListEditor.this.myIntervalsModel.getIntervals()[selected]);
                DateIntervalListEditor.this.myListModel.update();
                DateIntervalListEditor.this.myListSelectionModel.removeIndexInterval(selected, selected);
                DateIntervalListEditor.this.updateActions();
            }
        };
        JPanel topPanel = new JPanel(new BorderLayout());
        OptionsPageBuilder builder = new OptionsPageBuilder();
        builder.setOptionKeyPrefix("");
        GPOptionGroup group = this.myIntervalsModel.getMaxIntervalLength() == 1 ? new GPOptionGroup("", new GPOption[]{this.myStart}) : new GPOptionGroup("", new GPOption[]{this.myStart, this.myFinish});
        group.setTitled(false);
        JComponent datesBox = builder.buildPlanePage(new GPOptionGroup[]{group});
        topPanel.add((Component)datesBox, "Center");
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        buttonBox.add(new JButton(this.myAddAction));
        buttonBox.add(Box.createHorizontalStrut(5));
        buttonBox.add(new JButton(this.myDeleteAction));
        topPanel.add((Component)buttonBox, "South");
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.add((Component)topPanel, "North");
        JList list = new JList(this.myListModel);
        list.setName("list");
        list.setBorder(BorderFactory.createLoweredBevelBorder());
        this.myListSelectionModel = list.getSelectionModel();
        this.myListSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DateIntervalListEditor.this.updateActions();
            }
        });
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        scrollPane.setPreferredSize(new Dimension(120, 200));
        this.add((Component)scrollPane, "Center");
        this.updateActions();
    }

    private class MyListModel
    extends AbstractListModel {
        private MyListModel() {
        }

        public int getSize() {
            return DateIntervalListEditor.this.myIntervalsModel.getIntervals().length;
        }

        public Object getElementAt(int index) {
            DateInterval interval = DateIntervalListEditor.this.myIntervalsModel.getIntervals()[index];
            StringBuffer result = new StringBuffer(GanttLanguage.getInstance().getDateFormat().format(interval.start));
            if (!interval.end.equals(interval.start)) {
                result.append("...");
                result.append(GanttLanguage.getInstance().getDateFormat().format(interval.end));
            }
            return result.toString();
        }

        public void update() {
            this.fireContentsChanged(this, 0, DateIntervalListEditor.this.myIntervalsModel.getIntervals().length);
        }
    }

    public static class DefaultDateIntervalModel
    implements DateIntervalModel {
        List myIntervals = new ArrayList();

        public DateInterval[] getIntervals() {
            return this.myIntervals.toArray(new DateInterval[this.myIntervals.size()]);
        }

        public void remove(DateInterval interval) {
            this.myIntervals.remove(interval);
        }

        public void add(DateInterval interval) {
            this.myIntervals.add(interval);
        }

        public int getMaxIntervalLength() {
            return 1;
        }
    }

    public static interface DateIntervalModel {
        public DateInterval[] getIntervals();

        public void remove(DateInterval var1);

        public void add(DateInterval var1);

        public int getMaxIntervalLength();
    }

    public static class DateInterval {
        public final Date start;
        public final Date end;

        public DateInterval(Date start, Date end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DateInterval)) {
                return false;
            }
            DateInterval rvalue = (DateInterval)obj;
            return this.start.equals(rvalue.start) && this.end.equals(rvalue.end);
        }

        public int hashCode() {
            return this.start.hashCode();
        }
    }
}

