/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.export;

import java.awt.image.RenderedImage;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.sourceforge.ganttproject.GanttExportSettings;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.chart.Chart;
import net.sourceforge.ganttproject.export.ExportFinalizationJob;
import net.sourceforge.ganttproject.export.Exporter;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.model.EnumerationOption;
import net.sourceforge.ganttproject.gui.options.model.GPAbstractOption;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class ExporterToImage
implements Exporter {
    private IGanttProject myProject;
    private UIFacade myUIFacade;
    private FileTypeOption myFileTypeOption = new FileTypeOption();
    private GPOptionGroup myOptions = new GPOptionGroup("impex.image", new GPOption[]{this.myFileTypeOption});
    private Chart myGanttChart;

    public ExporterToImage() {
        this.myOptions.setTitled(false);
    }

    public String getFileTypeDescription() {
        return MessageFormat.format(GanttLanguage.getInstance().getText("impex.image.description"), this.proposeFileExtension());
    }

    public GPOptionGroup getOptions() {
        return this.myOptions;
    }

    public GPOptionGroup[] getSecondaryOptions() {
        return null;
    }

    public String getFileNamePattern() {
        return this.proposeFileExtension();
    }

    public void setContext(IGanttProject project, UIFacade uiFacade) {
        this.myProject = project;
        this.myUIFacade = uiFacade;
        this.myGanttChart = uiFacade.getGanttChart().createCopy();
    }

    public void run(File outputFile, ExportFinalizationJob finalizationJob) throws Exception {
        Chart chart = this.myUIFacade.getActiveChart();
        if (chart == null) {
            chart = this.myUIFacade.getGanttChart();
        }
        RenderedImage renderedImage = chart.getRenderedImage(new GanttExportSettings());
        ImageIO.write(renderedImage, this.myFileTypeOption.proposeFileExtension(), outputFile);
        finalizationJob.run(new File[]{outputFile});
    }

    public String proposeFileExtension() {
        return this.myFileTypeOption.proposeFileExtension();
    }

    public String[] getFileExtensions() {
        return FileTypeOption.FILE_EXTENSION;
    }

    static class FileTypeOption
    extends GPAbstractOption
    implements EnumerationOption {
        static final String[] FILE_FORMAT_ID = new String[]{"impex.image.fileformat.png", "impex.image.fileformat.jpeg"};
        static final String[] FILE_EXTENSION = new String[]{"png", "jpg"};
        private String myValue = FILE_FORMAT_ID[0];

        FileTypeOption() {
            super("impex.image.fileformat");
        }

        public String[] getAvailableValues() {
            return FILE_FORMAT_ID;
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        public String getValue() {
            return this.myValue;
        }

        String proposeFileExtension() {
            for (int i = 0; i < FILE_FORMAT_ID.length; ++i) {
                if (!this.myValue.equals(FILE_FORMAT_ID[i])) continue;
                return FILE_EXTENSION[i];
            }
            throw new IllegalStateException("Selected format=" + this.myValue + " has not been found in known formats:" + Arrays.asList(FILE_FORMAT_ID));
        }

        public String getPersistentValue() {
            return null;
        }

        public void loadPersistentValue(String value) {
        }

        public boolean isChanged() {
            return false;
        }
    }
}

