/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.document;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import net.sourceforge.ganttproject.document.AbstractDocument;

public class FileDocument
extends AbstractDocument {
    private File file;

    public FileDocument(File file) {
        this.file = file;
    }

    public String getDescription() {
        return this.file.getName();
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canWrite() {
        boolean writable = this.file.canWrite();
        if (!writable && !this.file.exists()) {
            try {
                if (this.file.createNewFile()) {
                    this.file.delete();
                    writable = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return writable;
    }

    public boolean isValidForMRU() {
        return this.file.exists();
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.file);
    }

    public String getPath() {
        return this.file.getPath();
    }

    public String getFilePath() {
        return this.getPath();
    }

    public void open() throws IOException {
    }

    public void write() throws IOException {
    }

    public URI getURI() {
        return this.file.toURI();
    }

    public boolean isLocal() {
        return true;
    }
}

