/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.ganttproject.document.Document;

public class DocumentsMRU {
    private int maxSize;
    private List documents;

    public DocumentsMRU(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be larger than zero (" + maxSize + ")");
        }
        this.maxSize = maxSize;
        this.documents = new ArrayList(maxSize);
    }

    public boolean add(Document document) {
        if (!document.isValidForMRU()) {
            return false;
        }
        int i = this.documents.indexOf(document);
        if (0 == i) {
            return false;
        }
        if (0 < i) {
            this.documents.remove(i);
        } else {
            while (this.documents.size() >= this.maxSize) {
                this.documents.remove(this.maxSize - 1);
            }
        }
        this.documents.add(0, document);
        return true;
    }

    public boolean append(Document document) {
        if (!document.isValidForMRU()) {
            return false;
        }
        int i = this.documents.indexOf(document);
        if (i == this.maxSize - 1) {
            return false;
        }
        if (i != -1) {
            this.documents.remove(i);
        }
        if (this.documents.size() < this.maxSize) {
            this.documents.add(document);
            return true;
        }
        return false;
    }

    public void clear() {
        this.documents.clear();
    }

    public Iterator iterator() {
        return this.documents.iterator();
    }
}

