/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.document;

import java.io.File;
import java.io.IOException;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.document.DocumentManager;
import net.sourceforge.ganttproject.document.FileDocument;
import net.sourceforge.ganttproject.document.FtpDocument;
import net.sourceforge.ganttproject.document.HttpDocument;
import net.sourceforge.ganttproject.document.ProxyDocument;
import net.sourceforge.ganttproject.gui.TableHeaderUIFacade;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.model.DefaultStringOption;
import net.sourceforge.ganttproject.gui.options.model.GP1XOptionConverter;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.gui.options.model.StringOption;
import net.sourceforge.ganttproject.parser.ParserFactory;

public class DocumentCreator
implements DocumentManager {
    private IGanttProject myProject;
    private UIFacade myUIFacade;
    private ParserFactory myParserFactory;
    private final StringOption myWorkingDirectory = new StringOptionImpl("working-dir", "working-dir", "dir");
    private final GPOptionGroup myOptionGroup = new GPOptionGroup("", new GPOption[]{this.myWorkingDirectory});
    private final StringOption myFtpUserOption = new StringOptionImpl("user-name", "ftp", "ftpuser");
    private final StringOption myFtpServerNameOption = new StringOptionImpl("server-name", "ftp", "ftpurl");
    private final StringOption myFtpDirectoryNameOption = new StringOptionImpl("directory-name", "ftp", "ftpdir");
    private final StringOption myFtpPasswordOption = new StringOptionImpl("password", "ftp", "ftppwd");
    private final DocumentManager.FTPOptions myFtpOptions = new DocumentManager.FTPOptions("ftp", new GPOption[]{this.myFtpUserOption, this.myFtpServerNameOption, this.myFtpDirectoryNameOption, this.myFtpPasswordOption}){

        public StringOption getDirectoryName() {
            return DocumentCreator.this.myFtpDirectoryNameOption;
        }

        public StringOption getPassword() {
            return DocumentCreator.this.myFtpPasswordOption;
        }

        public StringOption getServerName() {
            return DocumentCreator.this.myFtpServerNameOption;
        }

        public StringOption getUserName() {
            return DocumentCreator.this.myFtpUserOption;
        }
    };
    static final String USERNAME_OPTION_ID = "user-name";
    static final String SERVERNAME_OPTION_ID = "server-name";
    static final String DIRECTORYNAME_OPTION_ID = "directory-name";
    static final String PASSWORD_OPTION_ID = "password";
    static final /* synthetic */ boolean $assertionsDisabled;

    public DocumentCreator(IGanttProject project, UIFacade uiFacade, ParserFactory parserFactory) {
        this.myProject = project;
        this.myUIFacade = uiFacade;
        this.setParserFactory(parserFactory);
    }

    private Document createDocument(String path) {
        return this.createDocument(path, null, null);
    }

    private Document createDocument(String path, String user, String pass) {
        if (!$assertionsDisabled && path == null) {
            throw new AssertionError();
        }
        if ((path = path.trim()).toLowerCase().startsWith("http://") || path.toLowerCase().startsWith("https://")) {
            return new HttpDocument(path, user, pass);
        }
        if (path.toLowerCase().startsWith("ftp:")) {
            return new FtpDocument(path, this.myFtpUserOption, this.myFtpPasswordOption);
        }
        return new FileDocument(new File(path));
    }

    public Document getDocument(String path) {
        Document physicalDocument = this.createDocument(path);
        ProxyDocument proxyDocument = new ProxyDocument(this, physicalDocument, this.myProject, this.myUIFacade, this.getVisibleFields(), this.getParserFactory());
        return proxyDocument;
    }

    public Document getDocument(String path, String userName, String password) {
        Document physicalDocument = this.createDocument(path, userName, password);
        ProxyDocument proxyDocument = new ProxyDocument(this, physicalDocument, this.myProject, this.myUIFacade, this.getVisibleFields(), this.getParserFactory());
        return proxyDocument;
    }

    protected TableHeaderUIFacade getVisibleFields() {
        return null;
    }

    public void addToRecentDocuments(Document document) {
    }

    protected void setParserFactory(ParserFactory myParserFactory) {
        this.myParserFactory = myParserFactory;
    }

    protected ParserFactory getParserFactory() {
        return this.myParserFactory;
    }

    String createTemporaryFile() throws IOException {
        File tempFile = File.createTempFile("project", ".gan", this.getWorkingDirectoryFile());
        return tempFile.getAbsolutePath();
    }

    public void changeWorkingDirectory(File directory) {
        if (!$assertionsDisabled && !directory.isDirectory()) {
            throw new AssertionError();
        }
        this.myWorkingDirectory.lock();
        this.myWorkingDirectory.setValue(directory.getAbsolutePath());
        this.myWorkingDirectory.commit();
    }

    public String getWorkingDirectory() {
        return this.myWorkingDirectory.getValue();
    }

    private File getWorkingDirectoryFile() {
        return new File(this.getWorkingDirectory());
    }

    public GPOptionGroup getOptionGroup() {
        return this.myOptionGroup;
    }

    public DocumentManager.FTPOptions getFTPOptions() {
        return this.myFtpOptions;
    }

    public GPOptionGroup[] getNetworkOptionGroups() {
        return new GPOptionGroup[]{this.myFtpOptions};
    }

    static {
        $assertionsDisabled = !DocumentCreator.class.desiredAssertionStatus();
    }

    private static class StringOptionImpl
    extends DefaultStringOption
    implements GP1XOptionConverter {
        private final String myLegacyTagName;
        private final String myLegacyAttrName;

        private StringOptionImpl(String optionName, String legacyTagName, String legacyAttrName) {
            super(optionName);
            this.myLegacyTagName = legacyTagName;
            this.myLegacyAttrName = legacyAttrName;
        }

        public String getTagName() {
            return this.myLegacyTagName;
        }

        public String getAttributeName() {
            return this.myLegacyAttrName;
        }

        public void loadValue(String legacyValue) {
            this.lock();
            this.loadPersistentValue(legacyValue);
            this.commit();
        }
    }
}

