/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.chart;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttPreviousStateTask;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.chart.ChartModelBase;
import net.sourceforge.ganttproject.chart.ChartModelImpl;
import net.sourceforge.ganttproject.chart.ChartOptionGroup;
import net.sourceforge.ganttproject.chart.ChartRendererBase;
import net.sourceforge.ganttproject.chart.GraphicPrimitiveContainer;
import net.sourceforge.ganttproject.chart.TimeUnitVisitor;
import net.sourceforge.ganttproject.gui.options.model.DefaultEnumerationOption;
import net.sourceforge.ganttproject.gui.options.model.EnumerationOption;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskActivity;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskProperties;
import net.sourceforge.ganttproject.task.algorithm.SortTasksAlgorithm;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import net.sourceforge.ganttproject.time.TimeFrame;
import net.sourceforge.ganttproject.time.TimeUnit;

public class TaskRendererImpl
extends ChartRendererBase
implements TimeUnitVisitor {
    private List myVisibleActivities;
    private static final SortTasksAlgorithm ourAlgorithm;
    private List myCurrentlyProcessed = new ArrayList();
    private Map myActivity2ordinalNumber = new HashMap();
    private Map myTask_WorkingRectanglesLength = new HashMap();
    private int myPosX;
    private TimeFrame myCurrentTimeFrame;
    private TimeUnit myCurrentUnit;
    private Date myUnitStart;
    private boolean myProgressRenderingEnabled = true;
    private boolean myDependenciesRenderingEnabled = true;
    private GanttLanguage lang = GanttLanguage.getInstance();
    private boolean[] isVisible = new boolean[]{false, false, false, false, true, false, true};
    private ChartModelImpl myModel;
    private GPOption[] myDetailsOptions;
    private EnumerationOption[] myLabelOptions;
    private GPOptionGroup[] myOptionGroups;
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private ArrayList myTasks;
    private ArrayList myPreviousStateTasks;
    private List myPreviousStateCurrentlyProcessed = new ArrayList();
    private static List ourInfoList;
    private List myActivitiesOutOfView = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public TaskRendererImpl(ChartModelImpl model) {
        super(model);
        this.myModel = model;
        this.getPrimitiveContainer().newLayer();
        this.getPrimitiveContainer().newLayer();
        DefaultEnumerationOption deo0 = new DefaultEnumerationOption("taskLabelUp", ourInfoList);
        DefaultEnumerationOption deo1 = new DefaultEnumerationOption("taskLabelDown", ourInfoList);
        DefaultEnumerationOption deo2 = new DefaultEnumerationOption("taskLabelLeft", ourInfoList);
        DefaultEnumerationOption deo3 = new DefaultEnumerationOption("taskLabelRight", ourInfoList);
        Mediator.addChangeValueDispatcher(deo0);
        Mediator.addChangeValueDispatcher(deo1);
        Mediator.addChangeValueDispatcher(deo2);
        Mediator.addChangeValueDispatcher(deo3);
        this.myLabelOptions = new EnumerationOption[]{deo0, deo1, deo2, deo3};
        this.myOptionGroups = new GPOptionGroup[1];
        this.updateOptions();
    }

    private void addOption(String name) {
        ourInfoList.add(name);
        this.updateOptions();
    }

    private void removeOption(String name) {
        ourInfoList.remove(name);
        this.updateOptions();
    }

    private void updateOptions() {
        this.myDetailsOptions = new GPOption[this.myLabelOptions.length];
        System.arraycopy(this.myLabelOptions, 0, this.myDetailsOptions, 0, this.myLabelOptions.length);
        this.myOptionGroups[0] = new ChartOptionGroup("ganttChartDetails", this.myDetailsOptions, this.myModel.getOptionEventDispatcher());
    }

    public boolean isTextUp() {
        return this.myLabelOptions[0].getValue() != null && this.myLabelOptions[0].getValue().length() != 0;
    }

    public boolean isTextDown() {
        return this.myLabelOptions[1].getValue() != null && this.myLabelOptions[1].getValue().length() != 0;
    }

    public void beforeProcessingTimeFrames() {
        this.getPrimitiveContainer().clear();
        this.getPrimitiveContainer().getLayer(1).clear();
        this.getPrimitiveContainer().getLayer(2).clear();
        this.myActivity2ordinalNumber.clear();
        this.myTask_WorkingRectanglesLength.clear();
        this.myActivitiesOutOfView.clear();
        this.myVisibleActivities = this.getSortedTaskActivities();
        if (this.myTasks != null) {
            this.myPreviousStateTasks = (ArrayList)this.myTasks.clone();
        }
        this.myCurrentlyProcessed.clear();
        this.myPosX = 0;
    }

    public void afterProcessingTimeFrames() {
        GraphicPrimitiveContainer.Rectangle rectangle;
        GraphicPrimitiveContainer container;
        int topy;
        Integer nextOrdNumber;
        TaskActivity next;
        int i;
        for (i = 0; i < this.myActivitiesOutOfView.size(); ++i) {
            next = (TaskActivity)this.myActivitiesOutOfView.get(i);
            nextOrdNumber = (Integer)this.myActivity2ordinalNumber.get(next);
            topy = nextOrdNumber * this.getRowHeight() + 4;
            container = this.getContainerFor(next.getTask());
            rectangle = container.createRectangle(-10, topy, 1, this.getRowHeight());
            container.bind(rectangle, next);
        }
        for (i = 0; i < this.myVisibleActivities.size(); ++i) {
            next = (TaskActivity)this.myVisibleActivities.get(i);
            nextOrdNumber = (Integer)this.myActivity2ordinalNumber.get(next);
            topy = nextOrdNumber * this.getRowHeight() + 4;
            container = this.getContainerFor(next.getTask());
            rectangle = container.createRectangle(this.getWidth() + 10, topy, 1, this.getRowHeight());
            container.bind(rectangle, next);
        }
        if (this.myDependenciesRenderingEnabled) {
            this.createDependencyLines();
        }
    }

    private boolean isPathExpanded(Task task) {
        boolean result = true;
        TaskContainmentHierarchyFacade taskHierarchy = this.getChartModel().getTaskManager().getTaskHierarchy();
        Task supertask = taskHierarchy.getContainer(task);
        while (supertask != null && supertask != this.getChartModel().getTaskManager().getRootTask()) {
            if (!supertask.getExpand()) {
                result = false;
                break;
            }
            supertask = taskHierarchy.getContainer(supertask);
        }
        return result;
    }

    private List getSortedTaskActivities() {
        List visibleTasks = ((ChartModelImpl)this.getChartModel()).getVisibleTasks();
        ArrayList<TaskActivity> visibleActivities = new ArrayList<TaskActivity>();
        this.myActivity2ordinalNumber.clear();
        for (int i = 0; i < visibleTasks.size(); ++i) {
            if (visibleTasks.get(i).equals("")) continue;
            Task nextTask = (Task)visibleTasks.get(i);
            Integer nextOrdinal = new Integer(i);
            if (nextTask == null) continue;
            TaskActivity[] activities = nextTask.getActivities();
            float totalTaskLength = 0.0f;
            for (int j = 0; j < activities.length; ++j) {
                TaskActivity nextActivity = activities[j];
                this.myActivity2ordinalNumber.put(nextActivity, nextOrdinal);
                visibleActivities.add(nextActivity);
                if (nextActivity.getEnd().before(this.getChartModel().getStartDate()) || !(nextActivity.getIntensity() > 0.0f)) continue;
                totalTaskLength += activities[j].getDuration().getLength(this.getChartModel().getBottomUnit()) * (float)this.getChartModel().getBottomUnitWidth();
            }
            this.myTask_WorkingRectanglesLength.put(nextTask, new Long((long)(totalTaskLength * (float)nextTask.getCompletionPercentage() / 100.0f)));
        }
        HashSet<TaskActivity> hashedVisible = new HashSet<TaskActivity>(visibleActivities);
        Integer maxOrdinal = new Integer(hashedVisible.size() + 1);
        Integer minOrdinal = new Integer(-2);
        for (int i = 0; i < visibleTasks.size(); ++i) {
            int diff;
            TaskDependency nextDependency;
            int j;
            Task next = (Task)visibleTasks.get(i);
            TaskDependency[] dependencies = next.getDependenciesAsDependant().toArray();
            for (j = 0; j < dependencies.length; ++j) {
                nextDependency = dependencies[j];
                TaskActivity dependeeActivity = nextDependency.getActivityBinding().getDependeeActivity();
                if (hashedVisible.contains(dependeeActivity)) continue;
                Task dependeeTask = dependeeActivity.getTask();
                if (!this.getChartModel().getTaskManager().getTaskHierarchy().contains(dependeeTask) || !this.isPathExpanded(dependeeTask)) continue;
                diff = this.getChartModel().getTaskManager().getTaskHierarchy().compareDocumentOrder(next, dependeeTask);
                if (!$assertionsDisabled && diff == 0) {
                    throw new AssertionError();
                }
                Integer dependeePosition = diff < 0 ? maxOrdinal : minOrdinal;
                this.myActivity2ordinalNumber.put(dependeeActivity, dependeePosition);
                visibleActivities.add(dependeeActivity);
                hashedVisible.add(dependeeActivity);
            }
            dependencies = next.getDependenciesAsDependee().toArray();
            for (j = 0; j < dependencies.length; ++j) {
                nextDependency = dependencies[j];
                TaskActivity dependantActivity = nextDependency.getActivityBinding().getDependantActivity();
                if (hashedVisible.contains(dependantActivity)) continue;
                Task dependantTask = dependantActivity.getTask();
                if (!this.getChartModel().getTaskManager().getTaskHierarchy().contains(dependantTask) || !this.isPathExpanded(dependantTask)) continue;
                diff = this.getChartModel().getTaskManager().getTaskHierarchy().compareDocumentOrder(next, dependantTask);
                if (!$assertionsDisabled && diff == 0) {
                    throw new AssertionError();
                }
                Integer dependantPosition = diff < 0 ? maxOrdinal : minOrdinal;
                this.myActivity2ordinalNumber.put(dependantActivity, dependantPosition);
                visibleActivities.add(dependantActivity);
                hashedVisible.add(dependantActivity);
            }
        }
        ourAlgorithm.sortByStartDate(visibleActivities);
        return visibleActivities;
    }

    public void startTimeFrame(TimeFrame timeFrame) {
        this.myCurrentTimeFrame = timeFrame;
    }

    public void endTimeFrame(TimeFrame timeFrame) {
        this.myCurrentTimeFrame = null;
    }

    public void startUnitLine(TimeUnit timeUnit) {
        if (this.myCurrentTimeFrame.getBottomUnit() == timeUnit) {
            this.myCurrentUnit = timeUnit;
        }
    }

    public void endUnitLine(TimeUnit timeUnit) {
        this.myCurrentUnit = null;
    }

    public void nextTimeUnit(int unitIndex) {
        if (this.myCurrentUnit != null) {
            Date unitStart = this.myCurrentTimeFrame.getUnitStart(this.myCurrentUnit, unitIndex);
            Date unitFinish = this.myCurrentTimeFrame.getUnitFinish(this.myCurrentUnit, unitIndex);
            this.myUnitStart = unitStart;
            this.pullQueue(unitStart, unitFinish);
            Iterator startedActivities = this.myCurrentlyProcessed.iterator();
            while (startedActivities.hasNext()) {
                TaskActivity nextStarted = (TaskActivity)startedActivities.next();
                this.processActivity(nextStarted);
                startedActivities.remove();
            }
            if (this.myModel.isPrevious()) {
                for (int i = 0; i < this.myPreviousStateCurrentlyProcessed.size(); ++i) {
                    Object next = this.myPreviousStateCurrentlyProcessed.get(i);
                    if (next == null) continue;
                    GanttPreviousStateTask previousTask = (GanttPreviousStateTask)next;
                    this.drawPreviousStateTask(previousTask, i);
                }
                this.myPreviousStateCurrentlyProcessed = new ArrayList();
            }
            this.myPosX += this.getChartModel().getBottomUnitWidth();
        }
    }

    private void processActivity(TaskActivity nextStarted) {
        if (nextStarted.isLast()) {
            this.processLastActivity(nextStarted);
        } else if (nextStarted.isFirst()) {
            this.processFirstActivity(nextStarted);
        } else {
            this.processRegularActivity(nextStarted);
        }
    }

    private GraphicPrimitiveContainer.Rectangle processRegularActivity(TaskActivity nextStarted) {
        Task nextTask = nextStarted.getTask();
        if (nextTask.isMilestone() && !nextStarted.isFirst()) {
            return null;
        }
        Rectangle nextBounds = this.getBoundingRectangle(nextStarted);
        int nextLength = nextBounds.width;
        int topy = nextBounds.y;
        topy += (this.getRowHeight() - 20) / 2;
        if (this.myModel.isOnlyDown()) {
            topy -= 6;
        } else if (this.myModel.isOnlyUp()) {
            topy += 6;
        }
        if (this.myModel.isPrevious()) {
            topy -= 5;
        }
        boolean nextHasNested = ((ChartModelImpl)this.getChartModel()).getTaskContainment().hasNestedTasks(nextTask);
        GraphicPrimitiveContainer container = this.getContainerFor(nextTask);
        GraphicPrimitiveContainer.Rectangle nextRectangle = container.createRectangle(nextBounds.x, topy, nextLength, 12);
        if (nextStarted.getTask().isMilestone()) {
            nextRectangle.setStyle("task.milestone");
        } else if (nextTask.isProjectTask()) {
            nextRectangle.setStyle("task.projectTask");
            if (nextStarted.isFirst()) {
                GraphicPrimitiveContainer.Rectangle supertaskStart = container.createRectangle(nextRectangle.myLeftX, topy, nextLength, 12);
                supertaskStart.setStyle("task.projectTask.start");
            }
            if (nextStarted.isLast()) {
                GraphicPrimitiveContainer.Rectangle supertaskEnd = container.createRectangle(this.myPosX - 1, topy, nextLength, 12);
                supertaskEnd.setStyle("task.projectTask.end");
            }
        } else if (nextHasNested) {
            nextRectangle.setStyle("task.supertask");
            if (nextStarted.isFirst()) {
                GraphicPrimitiveContainer.Rectangle supertaskStart = container.createRectangle(nextRectangle.myLeftX, topy, nextLength, 12);
                supertaskStart.setStyle("task.supertask.start");
            }
            if (nextStarted.isLast()) {
                GraphicPrimitiveContainer.Rectangle supertaskEnd = container.createRectangle(nextRectangle.myLeftX, topy, nextLength, 12);
                supertaskEnd.setStyle("task.supertask.end");
            }
        } else if (nextStarted.getIntensity() == 0.0f) {
            nextRectangle.setStyle("task.holiday");
        } else if (nextStarted.isFirst() && nextStarted.isLast()) {
            nextRectangle.setStyle("task.startend");
        } else if (false == nextStarted.isFirst() ^ nextStarted.isLast()) {
            nextRectangle.setStyle("task");
        } else if (nextStarted.isFirst()) {
            nextRectangle.setStyle("task.start");
        } else if (nextStarted.isLast()) {
            nextRectangle.setStyle("task.end");
        }
        if (this.myProgressRenderingEnabled && !nextTask.isMilestone() && !nextHasNested) {
            this.renderProgressBar(nextStarted, nextRectangle);
        }
        if (!"task.holiday".equals(nextRectangle.getStyle()) && !"task.supertask".equals(nextRectangle.getStyle())) {
            nextRectangle.setBackgroundColor(nextStarted.getTask().getColor());
        }
        container.bind(nextRectangle, nextStarted);
        return nextRectangle;
    }

    private void renderProgressBar(TaskActivity nextStarted, GraphicPrimitiveContainer.Rectangle nextActivityRectangle) {
        if (nextStarted.getIntensity() == 0.0f) {
            return;
        }
        Task nextTask = nextStarted.getTask();
        int nextLength = nextActivityRectangle.myWidth;
        Long workingRectanglesLength = (Long)this.myTask_WorkingRectanglesLength.get(nextTask);
        if (workingRectanglesLength != null) {
            String style;
            long nextProgressLength = nextLength;
            if (workingRectanglesLength > (long)nextLength) {
                this.myTask_WorkingRectanglesLength.put(nextTask, new Long(workingRectanglesLength - (long)nextLength));
                style = "task.progress";
            } else {
                nextProgressLength = workingRectanglesLength;
                this.myTask_WorkingRectanglesLength.remove(nextTask);
                style = "task.progress.end";
            }
            int nextMidY = nextActivityRectangle.getMiddleY();
            GraphicPrimitiveContainer.Rectangle nextProgressRect = this.getPrimitiveContainer().getLayer(1).createRectangle(nextActivityRectangle.myLeftX, nextMidY - 1, (int)nextProgressLength, 3);
            nextProgressRect.setStyle(style);
            this.getPrimitiveContainer().getLayer(1).bind(nextProgressRect, nextTask);
        }
    }

    private void processFirstActivity(TaskActivity taskActivity) {
        boolean stop;
        boolean bl = stop = taskActivity.getIntensity() == 0.0f;
        if (!stop) {
            this.processRegularActivity(taskActivity);
        }
    }

    private void createRightSideText(TaskActivity taskActivity) {
        Rectangle bounds = this.getBoundingRectangle(taskActivity);
        String text = "";
        text = this.getTaskLabel(taskActivity.getTask(), 3);
        int xText = (int)bounds.getMaxX() + 9;
        int yText = (int)this.myModel.getBoundingRectangle(taskActivity.getTask()).getMaxY() - 3;
        GraphicPrimitiveContainer.Text textPrimitive = this.processText(xText, yText, text);
    }

    private void createDownSideText(TaskActivity taskActivity) {
        String text = this.getTaskLabel(taskActivity.getTask(), 1);
        if (text.length() > 0) {
            Rectangle taskRectangle = this.myModel.getBoundingRectangle(taskActivity.getTask());
            int xOrigin = (int)taskRectangle.getMinX() + (int)taskRectangle.getWidth() / 2;
            int yOrigin = (int)taskRectangle.getMaxY() + 2;
            GraphicPrimitiveContainer.Text textPrimitive = this.processText(xOrigin, yOrigin, text);
            textPrimitive.setAlignment(GraphicPrimitiveContainer.HAlignment.CENTER, GraphicPrimitiveContainer.VAlignment.TOP);
        }
    }

    private void createUpSideText(TaskActivity taskActivity) {
        String text = this.getTaskLabel(taskActivity.getTask(), 0);
        if (text.length() > 0) {
            Rectangle taskRectangle = this.myModel.getBoundingRectangle(taskActivity.getTask());
            int xOrigin = (int)taskRectangle.getMinX() + (int)taskRectangle.getWidth() / 2;
            int yOrigin = (int)taskRectangle.getMinY() - 3;
            GraphicPrimitiveContainer.Text textPrimitive = this.processText(xOrigin, yOrigin, text);
            textPrimitive.setAlignment(GraphicPrimitiveContainer.HAlignment.CENTER, GraphicPrimitiveContainer.VAlignment.BOTTOM);
        }
    }

    private void createLeftSideText(TaskActivity taskActivity) {
        String text = this.getTaskLabel(taskActivity.getTask(), 2);
        if (text.length() > 0) {
            Rectangle taskRectangle = this.myModel.getBoundingRectangle(taskActivity.getTask());
            int xOrigin = (int)taskRectangle.getMinX() - 9;
            int yOrigin = (int)(taskRectangle.getMaxY() - 3.0);
            GraphicPrimitiveContainer.Text textPrimitive = this.processText(xOrigin, yOrigin, text);
            textPrimitive.setAlignment(GraphicPrimitiveContainer.HAlignment.RIGHT, GraphicPrimitiveContainer.VAlignment.BOTTOM);
        }
    }

    private void processLastActivity(TaskActivity taskActivity) {
        if (taskActivity.getIntensity() != 0.0f) {
            this.processRegularActivity(taskActivity);
        }
        if (taskActivity.getTask().isMilestone()) {
            return;
        }
        this.createRightSideText(taskActivity);
        this.createDownSideText(taskActivity);
        this.createUpSideText(taskActivity);
        this.createLeftSideText(taskActivity);
    }

    private GraphicPrimitiveContainer.Text processText(int xorigin, int yorigin, String text) {
        GraphicPrimitiveContainer.Text res = this.getPrimitiveContainer().getLayer(2).createText(xorigin, yorigin, text);
        res.setStyle("text.ganttinfo");
        return res;
    }

    private void drawPreviousStateTask(GanttPreviousStateTask task, int row) {
        int topy = row * this.getRowHeight() + this.getRowHeight() - 8;
        int posX = this.myPosX;
        if (task.getStart().getTime().compareTo(this.myUnitStart) >= 0) {
            TaskLength deltaLength = this.myModel.getTaskManager().createLength(this.getChartModel().getTimeUnitStack().getDefaultTimeUnit(), this.myUnitStart, task.getStart().getTime());
            int deltaX = (int)(deltaLength.getLength(this.myCurrentUnit) * (float)this.getChartModel().getBottomUnitWidth());
            posX += deltaX;
        }
        int duration = task.getEnd(this.myModel.getTaskManager().getCalendar()).diff(task.getStart());
        TaskLength tl = this.myModel.getTaskManager().createLength(duration);
        int length = (int)(tl.getLength(this.myCurrentUnit) * (float)this.getChartModel().getBottomUnitWidth());
        Integer nextOrdNumber = (Integer)this.myActivity2ordinalNumber.get(task);
        GraphicPrimitiveContainer container = this.getPrimitiveContainer();
        GraphicPrimitiveContainer.Rectangle rect = container.createRectangle(posX, topy, length, 6);
        String style = "";
        if (task.isMilestone()) {
            style = "previousStateTask.milestone";
        } else if (task.hasNested()) {
            style = "previousStateTask.super";
            if (task.isAPart()) {
                style = "previousStateTask.super.apart";
            }
        } else {
            style = "previousStateTask";
        }
        if (task.getState() == 2) {
            style = style + ".earlier";
        } else if (task.getState() == 1) {
            style = style + ".later";
        }
        rect.setStyle(style);
    }

    private String getTaskLabel(Task task, int position) {
        StringBuffer result = new StringBuffer();
        Object property = TaskProperties.getProperty(task, this.myLabelOptions[position].getValue());
        if (property != null) {
            if (property instanceof Boolean) {
                if (((Boolean)property).booleanValue()) {
                    result.append(this.lang.getText("yes"));
                } else {
                    result.append(this.lang.getText("no"));
                }
            } else {
                result.append(property);
            }
        }
        return result.toString();
    }

    private long getNegativeOffset(Date offsetDate, Date anchorDate) {
        ChartModelBase.Offset[] offsets;
        if (this.getChartModel().getTimeUnitStack().getDefaultTimeUnit().equals(this.myCurrentUnit)) {
            TaskLength length = this.getChartModel().getTaskManager().createLength(this.myCurrentUnit, offsetDate, anchorDate);
            return -length.getLength() * (long)this.getChartModel().getBottomUnitWidth();
        }
        int length = 0;
        while (true) {
            offsets = this.getChartModel().calculateOffsets(this.myCurrentTimeFrame, this.myCurrentUnit, offsetDate, this.getChartModel().getTimeUnitStack().getDefaultTimeUnit(), this.getChartModel().getBottomUnitWidth());
            if (!$assertionsDisabled && offsets.length <= 0) {
                throw new AssertionError();
            }
            Date lastOffsetEnd = offsets[offsets.length - 1].getOffsetEnd();
            if (!lastOffsetEnd.before(anchorDate)) break;
            offsetDate = lastOffsetEnd;
            length += offsets[offsets.length - 1].getOffsetPixels();
        }
        for (int i = offsets.length - 1; i >= 0; --i) {
            ChartModelBase.Offset offset = offsets[i];
            if (offset.getOffsetEnd().after(anchorDate)) continue;
            length += offset.getOffsetPixels();
            break;
        }
        return -length;
    }

    private long getPositiveOffset(Date offsetDate, Date anchorDate) {
        ChartModelBase.Offset[] offsets;
        if (this.getChartModel().getTimeUnitStack().getDefaultTimeUnit().equals(this.myCurrentUnit)) {
            TaskLength length = this.getChartModel().getTaskManager().createLength(this.myCurrentUnit, anchorDate, offsetDate);
            return length.getLength() * (long)this.getChartModel().getBottomUnitWidth();
        }
        int length = 0;
        while (true) {
            if ((offsets = this.getChartModel().calculateOffsets(this.myCurrentTimeFrame, this.myCurrentUnit, anchorDate, this.getChartModel().getTimeUnitStack().getDefaultTimeUnit(), this.getChartModel().getBottomUnitWidth())).length == 0) {
                throw new IllegalStateException("Failed to calculate offsets for anchorDate=" + anchorDate);
            }
            Date lastOffsetEnd = offsets[offsets.length - 1].getOffsetEnd();
            if (!lastOffsetEnd.before(offsetDate)) break;
            anchorDate = lastOffsetEnd;
            length += offsets[offsets.length - 1].getOffsetPixels();
        }
        for (int i = 0; i < offsets.length; ++i) {
            ChartModelBase.Offset offset = offsets[i];
            if (offset.getOffsetEnd().before(offsetDate)) continue;
            length += offset.getOffsetPixels();
            break;
        }
        return length;
    }

    private Rectangle getBoundingRectangle(TaskActivity activity) {
        int length;
        int posX = this.myPosX;
        if (!activity.getStart().equals(this.myUnitStart)) {
            int deltaX = 0;
            if (activity.getStart().before(this.myUnitStart)) {
                deltaX = (int)this.getNegativeOffset(activity.getStart(), this.myUnitStart);
            } else if (activity.getStart().after(this.myUnitStart)) {
                deltaX = (int)this.getPositiveOffset(activity.getStart(), this.myUnitStart);
            }
            posX += deltaX;
            length = (int)this.getPositiveOffset(activity.getEnd(), this.myUnitStart) - deltaX;
        } else {
            length = (int)(activity.getDuration().getLength(this.myCurrentUnit) * (float)this.getChartModel().getBottomUnitWidth());
        }
        Integer nextOrdNumber = (Integer)this.myActivity2ordinalNumber.get(activity);
        int topy = nextOrdNumber * this.getRowHeight() + 4;
        return new Rectangle(posX, topy, length, this.getRowHeight());
    }

    private void createDependencyLines() {
        List dependencyDrawData = this.prepareDependencyDrawData();
        this.drawDependencies(dependencyDrawData);
    }

    private void drawDependencies(List dependencyDrawData) {
        GraphicPrimitiveContainer primitiveContainer = this.getPrimitiveContainer().getLayer(2);
        int arrowLength = 7;
        for (int i = 0; i < dependencyDrawData.size(); ++i) {
            Point third;
            Point second;
            DependencyDrawData next = (DependencyDrawData)dependencyDrawData.get(i);
            if (next.myDependeeVector.reaches(next.myDependantVector.getPoint())) {
                String style;
                int ysign = this.signum(next.myDependantVector.getPoint().y - next.myDependeeVector.getPoint().y);
                Point first = new Point(next.myDependeeVector.getPoint().x, next.myDependeeVector.getPoint().y);
                second = new Point(next.myDependantVector.getPoint((int)-3).x, next.myDependeeVector.getPoint().y);
                third = new Point(next.myDependantVector.getPoint((int)-3).x, next.myDependantVector.getPoint().y);
                Rectangle arrowBoundary = null;
                if (next.myDependantVector.reaches(third)) {
                    second.x += arrowLength;
                    third.x += arrowLength;
                    Point forth = next.myDependantVector.getPoint();
                    primitiveContainer.createLine(third.x, third.y, forth.x, forth.y);
                    arrowBoundary = new Rectangle(forth.x, forth.y - 3, arrowLength, 6);
                    style = "dependency.arrow.left";
                } else {
                    third.y -= ysign * next.myDependantRectangle.myHeight / 2;
                    arrowBoundary = new Rectangle(third.x - 3, third.y - (ysign > 0 ? ysign * arrowLength : 0), 6, arrowLength);
                    style = ysign > 0 ? "dependency.arrow.down" : "dependency.arrow.up";
                }
                primitiveContainer.createLine(first.x, first.y, second.x, second.y);
                primitiveContainer.createLine(second.x, second.y, third.x, third.y);
                if (arrowBoundary == null) continue;
                GraphicPrimitiveContainer.Rectangle arrow = this.getPrimitiveContainer().createRectangle(arrowBoundary.x, arrowBoundary.y, arrowBoundary.width, arrowBoundary.height);
                arrow.setStyle(style);
                continue;
            }
            Point first = next.myDependeeVector.getPoint(3);
            if (next.myDependantVector.reaches(first)) {
                Point second2 = new Point(first.x, next.myDependantVector.getPoint().y);
                primitiveContainer.createLine(next.myDependeeVector.getPoint().x, next.myDependeeVector.getPoint().y, first.x, first.y);
                primitiveContainer.createLine(first.x, first.y, second2.x, second2.y);
                primitiveContainer.createLine(second2.x, second2.y, next.myDependantVector.getPoint().x, next.myDependantVector.getPoint().y);
                int xsign = this.signum(next.myDependantVector.getPoint().x - second2.x);
                Rectangle arrowBoundary = new Rectangle(next.myDependantVector.getPoint((int)7).x, next.myDependantVector.getPoint().y - 3, xsign * 7, 6);
                GraphicPrimitiveContainer.Rectangle arrow = primitiveContainer.createRectangle(arrowBoundary.x, arrowBoundary.y, arrowBoundary.width, arrowBoundary.height);
                arrow.setStyle(xsign < 0 ? "dependency.arrow.left" : "dependency.arrow.right");
                continue;
            }
            Point forth = next.myDependantVector.getPoint(3);
            second = new Point(first.x, (first.y + forth.y) / 2);
            third = new Point(forth.x, (first.y + forth.y) / 2);
            primitiveContainer.createLine(next.myDependeeVector.getPoint().x, next.myDependeeVector.getPoint().y, first.x, first.y);
            primitiveContainer.createLine(first.x, first.y, second.x, second.y);
            primitiveContainer.createLine(second.x, second.y, third.x, third.y);
            primitiveContainer.createLine(third.x, third.y, forth.x, forth.y);
            primitiveContainer.createLine(forth.x, forth.y, next.myDependantVector.getPoint().x, next.myDependantVector.getPoint().y);
        }
    }

    private final int signum(int value) {
        if (value == 0) {
            return 0;
        }
        return value < 0 ? -1 : 1;
    }

    private List prepareDependencyDrawData() {
        ArrayList result = new ArrayList();
        List visibleTasks = ((ChartModelImpl)this.getChartModel()).getVisibleTasks();
        for (int i = 0; i < visibleTasks.size(); ++i) {
            Task nextTask;
            if (visibleTasks.get(i).equals("") || (nextTask = (Task)visibleTasks.get(i)) == null) continue;
            this.prepareDependencyDrawData(nextTask, result);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void prepareDependencyDrawData(Task task, List result) {
        TaskDependency[] deps = task.getDependencies().toArray();
        for (int i = 0; i < deps.length; ++i) {
            void var15_15;
            void var14_14;
            PointVector dependeeVector;
            PointVector dependantVector;
            TaskActivity dependee;
            GraphicPrimitiveContainer dependeeContainer;
            GraphicPrimitiveContainer.Rectangle dependeeRectangle;
            TaskDependency next = deps[i];
            TaskDependency.ActivityBinding activityBinding = next.getActivityBinding();
            TaskActivity dependant = activityBinding.getDependantActivity();
            GraphicPrimitiveContainer dependantContainer = this.getContainerFor(dependant.getTask());
            GraphicPrimitiveContainer.Rectangle dependantRectangle = (GraphicPrimitiveContainer.Rectangle)dependantContainer.getPrimitive(dependant);
            if (dependantRectangle == null || (dependeeRectangle = (GraphicPrimitiveContainer.Rectangle)(dependeeContainer = this.getContainerFor((dependee = activityBinding.getDependeeActivity()).getTask())).getPrimitive(dependee)) == null) continue;
            Date[] bounds = activityBinding.getAlignedBounds();
            if (bounds[0].equals(dependant.getStart())) {
                dependantVector = new WestPointVector(new Point(dependantRectangle.myLeftX, dependantRectangle.getMiddleY()));
            } else if (bounds[0].equals(dependant.getEnd())) {
                dependantVector = new EastPointVector(new Point(dependantRectangle.getRightX(), dependantRectangle.getMiddleY()));
            } else {
                throw new RuntimeException();
            }
            if (bounds[1].equals(dependee.getStart())) {
                dependeeVector = new WestPointVector(new Point(dependeeRectangle.myLeftX, dependeeRectangle.getMiddleY()));
            } else if (bounds[1].equals(dependee.getEnd())) {
                dependeeVector = new EastPointVector(new Point(dependeeRectangle.getRightX(), dependeeRectangle.getMiddleY()));
            } else {
                throw new RuntimeException();
            }
            DependencyDrawData data = new DependencyDrawData(next, dependantRectangle, dependeeRectangle, (PointVector)var14_14, (PointVector)var15_15);
            result.add(data);
        }
    }

    private int getRowHeight() {
        return this.myModel.getRowHeight();
    }

    private void pullQueue(Date unitStart, Date unitFinish) {
        Iterator activities = this.myVisibleActivities.iterator();
        while (activities.hasNext()) {
            TaskActivity next = (TaskActivity)activities.next();
            if (next.getEnd().before(this.getChartModel().getStartDate())) {
                this.myActivitiesOutOfView.add(next);
                activities.remove();
                continue;
            }
            if (next.getStart().before(this.getChartModel().getStartDate()) && next.getEnd().after(this.getChartModel().getEndDate())) {
                this.myCurrentlyProcessed.add(next);
                activities.remove();
                continue;
            }
            if (next.getStart().after(unitFinish)) break;
            if ((next.getStart().compareTo(unitStart) < 0 || next.getStart().compareTo(unitFinish) >= 0) && (next.getEnd().compareTo(unitStart) < 0 || next.getEnd().compareTo(unitFinish) >= 0)) continue;
            this.myCurrentlyProcessed.add(next);
            activities.remove();
        }
        if (this.myModel.isPrevious()) {
            List visibleTasks = ((ChartModelImpl)this.getChartModel()).getVisibleTasks();
            for (int i = 0; i < visibleTasks.size(); ++i) {
                Task task = (Task)visibleTasks.get(i);
                int index = this.getPreviousStateTaskIndex(task);
                GPCalendar calendar = this.myModel.getTaskManager().getCalendar();
                if (index != -1) {
                    GanttPreviousStateTask previousStateTask = (GanttPreviousStateTask)this.myPreviousStateTasks.get(index);
                    previousStateTask.setState(task, calendar);
                    if (previousStateTask.getStart().after(unitFinish)) {
                        this.myPreviousStateCurrentlyProcessed.add(null);
                        continue;
                    }
                    if (previousStateTask.getStart().getTime().compareTo(unitStart) >= 0 && previousStateTask.getStart().getTime().compareTo(unitFinish) < 0) {
                        this.myPreviousStateCurrentlyProcessed.add(previousStateTask);
                        this.myPreviousStateTasks.remove(index);
                        continue;
                    }
                    if (previousStateTask.getStart().getTime().compareTo(unitStart) < 0 && previousStateTask.getEnd(calendar).getTime().compareTo(unitStart) > 0) {
                        GanttCalendar newStart = new GanttCalendar(unitStart);
                        int id = previousStateTask.getId();
                        int duration = previousStateTask.getDuration() - newStart.diff(previousStateTask.getStart());
                        int diff = newStart.diff(previousStateTask.getStart());
                        for (int j = 0; j < diff; ++j) {
                            if (!calendar.isNonWorkingDay(previousStateTask.getStart().newAdd(j).getTime())) continue;
                            ++duration;
                        }
                        boolean isMilestone = previousStateTask.isMilestone();
                        boolean hasNested = previousStateTask.hasNested();
                        GanttPreviousStateTask partOfPreviousTask = new GanttPreviousStateTask(id, newStart, duration, isMilestone, hasNested);
                        partOfPreviousTask.setState(task, calendar);
                        partOfPreviousTask.setIsAPart(true);
                        this.myPreviousStateCurrentlyProcessed.add(partOfPreviousTask);
                        this.myPreviousStateTasks.remove(index);
                        continue;
                    }
                    this.myPreviousStateCurrentlyProcessed.add(null);
                    continue;
                }
                this.myPreviousStateCurrentlyProcessed.add(null);
            }
        }
    }

    private int getPreviousStateTaskIndex(Task task) {
        if (this.myPreviousStateTasks == null) {
            return -1;
        }
        for (int i = 0; i < this.myPreviousStateTasks.size(); ++i) {
            if (task.getTaskID() != ((GanttPreviousStateTask)this.myPreviousStateTasks.get(i)).getId()) continue;
            return i;
        }
        return -1;
    }

    public void setProgressRenderingEnabled(boolean renderProgress) {
        this.myProgressRenderingEnabled = renderProgress;
    }

    public void setDependenciesRenderingEnabled(boolean renderDependencies) {
        this.myDependenciesRenderingEnabled = renderDependencies;
    }

    public boolean isVisible(int index) {
        return this.isVisible[index];
    }

    public GPOptionGroup[] getOptionGroups() {
        return this.myOptionGroups;
    }

    public void setPreviousStateTasks(ArrayList tasks) {
        this.myTasks = tasks;
    }

    public GraphicPrimitiveContainer.Rectangle getPrimitive(TaskActivity activity) {
        return (GraphicPrimitiveContainer.Rectangle)this.getContainerFor(activity.getTask()).getPrimitive(activity);
    }

    private GraphicPrimitiveContainer getContainerFor(Task task) {
        boolean hasNested = ((ChartModelImpl)this.getChartModel()).getTaskContainment().hasNestedTasks(task);
        return hasNested ? this.getPrimitiveContainer().getLayer(2) : this.getPrimitiveContainer();
    }

    static {
        $assertionsDisabled = !TaskRendererImpl.class.desiredAssertionStatus();
        ourAlgorithm = new SortTasksAlgorithm();
        ourInfoList = new ArrayList();
        ourInfoList.add("");
        ourInfoList.add("id");
        ourInfoList.add("taskDates");
        ourInfoList.add("name");
        ourInfoList.add("length");
        ourInfoList.add("advancement");
        ourInfoList.add("coordinator");
        ourInfoList.add("resources");
        ourInfoList.add("predecessors");
    }

    private static class EastPointVector
    extends PointVector {
        protected EastPointVector(Point point) {
            super(point);
        }

        boolean reaches(Point targetPoint) {
            return targetPoint.x >= this.getPoint().x;
        }

        Point getPoint(int diff) {
            return new Point(this.getPoint().x + diff, this.getPoint().y);
        }

        public String toString() {
            return ">=" + this.getPoint().toString();
        }
    }

    private static class WestPointVector
    extends PointVector {
        protected WestPointVector(Point point) {
            super(point);
        }

        boolean reaches(Point targetPoint) {
            return targetPoint.x <= this.getPoint().x;
        }

        Point getPoint(int diff) {
            return new Point(this.getPoint().x - diff, this.getPoint().y);
        }

        public String toString() {
            return "<=" + this.getPoint().toString();
        }
    }

    private static abstract class PointVector {
        private final Point myPoint;

        protected PointVector(Point point) {
            this.myPoint = point;
        }

        Point getPoint() {
            return this.myPoint;
        }

        abstract boolean reaches(Point var1);

        abstract Point getPoint(int var1);
    }

    private static class DependencyDrawData {
        final GraphicPrimitiveContainer.Rectangle myDependantRectangle;
        final GraphicPrimitiveContainer.Rectangle myDependeeRectangle;
        final TaskDependency myDependency;
        final PointVector myDependantVector;
        final PointVector myDependeeVector;

        public DependencyDrawData(TaskDependency dependency, GraphicPrimitiveContainer.GraphicPrimitive dependantPrimitive, GraphicPrimitiveContainer.GraphicPrimitive dependeePrimitive, PointVector dependantVector, PointVector dependeeVector) {
            this.myDependency = dependency;
            this.myDependantRectangle = (GraphicPrimitiveContainer.Rectangle)dependantPrimitive;
            this.myDependeeRectangle = (GraphicPrimitiveContainer.Rectangle)dependeePrimitive;
            this.myDependantVector = dependantVector;
            this.myDependeeVector = dependeeVector;
        }

        public String toString() {
            return "From activity=" + this.myDependency.getActivityBinding().getDependantActivity() + " (vector=" + this.myDependantVector + ")\n to activity=" + this.myDependency.getActivityBinding().getDependeeActivity() + " (vector=" + this.myDependeeVector;
        }
    }
}

