/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.calendar;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.ganttproject.parser.FileFormatException;
import net.sourceforge.ganttproject.parser.ParsingListener;
import net.sourceforge.ganttproject.parser.TagHandler;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLCalendarOpen {
    private List myCalendarResources = new ArrayList();
    private String[] myCalendarLabels;
    private ArrayList myTagHandlers = new ArrayList();
    private ArrayList myListeners = new ArrayList();

    boolean load(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        GanttXMLParser handler = new GanttXMLParser();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(inputStream, (DefaultHandler)handler);
        return true;
    }

    void addTagHandler(TagHandler handler) {
        this.myTagHandlers.add(handler);
    }

    void addParsingListener(ParsingListener listener) {
        this.myListeners.add(listener);
    }

    private TagHandler getDefaultTagHandler() {
        return new DefaultTagHandler();
    }

    public void setCalendars() throws Exception {
        this.myCalendarResources.clear();
        DefaultTagHandler th = (DefaultTagHandler)this.getDefaultTagHandler();
        this.addTagHandler(th);
        IConfigurationElement[] calendarExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor("net.sourceforge.ganttproject.calendar");
        this.myCalendarLabels = new String[calendarExtensions.length];
        for (int i = 0; i < calendarExtensions.length; ++i) {
            Bundle nextBundle = Platform.getBundle((String)calendarExtensions[i].getDeclaringExtension().getNamespace());
            URL calendarUrl = nextBundle.getResource(calendarExtensions[i].getAttribute("resource-url"));
            if (calendarUrl == null) continue;
            this.load(calendarUrl.openStream());
            this.myCalendarLabels[i] = th.getName();
            this.myCalendarResources.add(calendarUrl);
        }
    }

    public URL[] getCalendarResources() {
        return this.myCalendarResources.toArray(new URL[0]);
    }

    public String[] getLabels() {
        return this.myCalendarLabels;
    }

    private static class Filter
    extends FileFilter
    implements FilenameFilter {
        private String extension;

        public Filter(String extension) {
            if (extension == null) {
                throw new NullPointerException("La description (ou extension) ne peut \u00eatre null.");
            }
            this.extension = extension;
        }

        public String getDescription() {
            return null;
        }

        public boolean accept(File file, String arg1) {
            return arg1.endsWith(this.extension);
        }

        public boolean accept(File arg0) {
            return false;
        }
    }

    private class GanttXMLParser
    extends DefaultHandler {
        private GanttXMLParser() {
        }

        public void endDocument() throws SAXException {
            for (int i = 0; i < XMLCalendarOpen.this.myListeners.size(); ++i) {
                ParsingListener l = (ParsingListener)XMLCalendarOpen.this.myListeners.get(i);
                l.parsingFinished();
            }
        }

        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            Iterator handlers = XMLCalendarOpen.this.myTagHandlers.iterator();
            while (handlers.hasNext()) {
                TagHandler next = (TagHandler)handlers.next();
                try {
                    next.startElement(namespaceURI, sName, qName, attrs);
                }
                catch (FileFormatException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            Iterator handlers = XMLCalendarOpen.this.myTagHandlers.iterator();
            while (handlers.hasNext()) {
                TagHandler next = (TagHandler)handlers.next();
                next.endElement(namespaceURI, sName, qName);
            }
        }
    }

    private class DefaultTagHandler
    implements TagHandler {
        private String name;

        private DefaultTagHandler() {
        }

        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
            String eName = qName;
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if ("".equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if (!eName.equals("calendar")) continue;
                    if (aName.equals("name")) {
                        this.name = attrs.getValue(i);
                        continue;
                    }
                    if (!aName.equals("type")) continue;
                }
            }
        }

        public void endElement(String namespaceURI, String sName, String qName) {
        }

        public String getName() {
            return this.name;
        }
    }
}

