/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import net.sourceforge.ganttproject.ErrorNotifier;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.action.CancelAction;
import net.sourceforge.ganttproject.action.OkAction;
import net.sourceforge.ganttproject.chart.Chart;
import net.sourceforge.ganttproject.chart.GanttChart;
import net.sourceforge.ganttproject.gui.DialogAligner;
import net.sourceforge.ganttproject.gui.GanttDialogInfo;
import net.sourceforge.ganttproject.gui.GanttStatusBar;
import net.sourceforge.ganttproject.gui.ResourceTreeUIFacade;
import net.sourceforge.ganttproject.gui.TaskTreeUIFacade;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.scrolling.ScrollingManager;
import net.sourceforge.ganttproject.gui.scrolling.ScrollingManagerImpl;
import net.sourceforge.ganttproject.gui.zoom.ZoomManager;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.undo.GPUndoManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;

class UIFacadeImpl
extends ProgressProvider
implements UIFacade {
    private final JFrame myMainFrame;
    private final ScrollingManager myScrollingManager;
    private final ZoomManager myZoomManager;
    private final GanttStatusBar myStatusBar;
    private final UIFacade myFallbackDelegate;
    private final GanttLanguage i18n = GanttLanguage.getInstance();
    private final ErrorNotifier myErrorNotifier;

    UIFacadeImpl(JFrame mainFrame, GanttStatusBar statusBar, IGanttProject project, UIFacade fallbackDelegate) {
        this.myMainFrame = mainFrame;
        this.myScrollingManager = new ScrollingManagerImpl();
        this.myZoomManager = new ZoomManager(project.getTimeUnitStack());
        this.myStatusBar = statusBar;
        this.myFallbackDelegate = fallbackDelegate;
        Platform.getJobManager().setProgressProvider((ProgressProvider)this);
        this.myErrorNotifier = new ErrorNotifier(this);
    }

    public ScrollingManager getScrollingManager() {
        return this.myScrollingManager;
    }

    public ZoomManager getZoomManager() {
        return this.myZoomManager;
    }

    public GPUndoManager getUndoManager() {
        return this.myFallbackDelegate.getUndoManager();
    }

    public UIFacade.Choice showConfirmationDialog(String message, String title) {
        String yes = GanttLanguage.getInstance().getText("yes");
        String no = GanttLanguage.getInstance().getText("no");
        String cancel = GanttLanguage.getInstance().getText("cancel");
        int result = JOptionPane.showOptionDialog(this.myMainFrame, message, title, 1, 3, null, new String[]{yes, no, cancel}, yes);
        switch (result) {
            case 0: {
                return UIFacade.Choice.YES;
            }
            case 1: {
                return UIFacade.Choice.NO;
            }
            case 2: {
                return UIFacade.Choice.CANCEL;
            }
            case -1: {
                return UIFacade.Choice.CANCEL;
            }
        }
        return UIFacade.Choice.CANCEL;
    }

    public void showPopupMenu(Component invoker, Action[] actions, int x, int y) {
        JPopupMenu menu = new JPopupMenu();
        for (int i = 0; i < actions.length; ++i) {
            Action next = actions[i];
            if (next == null) {
                menu.addSeparator();
                continue;
            }
            menu.add(next);
        }
        menu.applyComponentOrientation(UIFacadeImpl.getLanguage().getComponentOrientation());
        menu.show(invoker, x, y);
    }

    public void showDialog(Component content, Action[] buttonActions) {
        this.showDialog(content, buttonActions, "");
    }

    public void showDialog(Component content, Action[] buttonActions, String title) {
        JDialog result = new JDialog((Frame)this.myMainFrame, true);
        result.setTitle(title);
        final Commiter commiter = new Commiter();
        Action okAction = null;
        Action cancelAction = null;
        Box buttonBox = Box.createHorizontalBox();
        for (int i = 0; i < buttonActions.length; ++i) {
            Action nextAction = buttonActions[i];
            JButton nextButton = null;
            if (nextAction instanceof OkAction) {
                okAction = nextAction = this.createOkAction(nextAction, result, commiter);
                nextButton = new JButton(nextAction);
                result.getRootPane().setDefaultButton(nextButton);
            }
            if (nextAction instanceof CancelAction) {
                cancelAction = nextAction = this.createCancelAction(nextAction, result, commiter);
                result.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), nextAction.getValue("Name"));
                result.getRootPane().getActionMap().put(nextAction.getValue("Name"), nextAction);
            }
            if (nextButton == null) {
                nextButton = new JButton(nextAction);
            }
            buttonBox.add(nextButton);
            if (i >= buttonActions.length - 1) continue;
            buttonBox.add(Box.createHorizontalStrut(5));
        }
        result.getContentPane().setLayout(new BorderLayout());
        result.getContentPane().add(content, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        buttonPanel.add((Component)buttonBox, "East");
        result.getContentPane().add((Component)buttonPanel, "South");
        result.setDefaultCloseOperation(2);
        Action localOkAction = okAction;
        final Action localCancelAction = cancelAction;
        result.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                if (localCancelAction != null && !commiter.isCommited()) {
                    localCancelAction.actionPerformed(null);
                }
            }
        });
        result.pack();
        DialogAligner.center(result, this.myMainFrame);
        result.setVisible(true);
    }

    public void setStatusText(String text) {
        this.myStatusBar.setFirstText(text, 2000);
    }

    public void showErrorDialog(String errorMessage) {
        if (this.myMainFrame.isVisible()) {
            GanttDialogInfo gdi = new GanttDialogInfo(this.myMainFrame, 0, GanttDialogInfo.YES_OPTION, errorMessage, UIFacadeImpl.getLanguage().getText("error"));
            gdi.show();
        } else {
            System.err.println("[GanttProjectBase] showErrorDialog:\n message");
        }
    }

    public void showErrorDialog(Throwable e) {
        this.showErrorDialog(UIFacadeImpl.getExceptionReport(e));
    }

    public void logErrorMessage(Exception e) {
        this.myErrorNotifier.add(e);
        this.myStatusBar.setErrorNotifier(this.myErrorNotifier);
    }

    void resetErrorLog() {
        this.myStatusBar.setErrorNotifier(null);
    }

    /*
     * WARNING - void declaration
     */
    private Component createDialogContentComponent(int dialogType, String message) {
        void var3_3;
        switch (dialogType) {
            case 0: {
                JLabel label = new JLabel(new ImageIcon(this.getClass().getResource("/icons/error.png")));
                break;
            }
            case 1: {
                JLabel label = new JLabel(new ImageIcon(this.getClass().getResource("/icons/warning.png")));
                break;
            }
            case 2: {
                JLabel label = new JLabel(new ImageIcon(this.getClass().getResource("/icons/info.png")));
                break;
            }
            case 3: {
                JLabel label = new JLabel(new ImageIcon(this.getClass().getResource("/icons/question.png")));
                break;
            }
            default: {
                throw new IllegalStateException("We should not be here");
            }
        }
        JPanel imagePanel = new JPanel(new BorderLayout());
        imagePanel.add((Component)var3_3, "North");
        JTextArea textArea = new JTextArea(message);
        textArea.setEditable(false);
        textArea.setBackground(new JLabel().getBackground());
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)imagePanel, "West");
        result.add((Component)textArea, "Center");
        return result;
    }

    public GanttChart getGanttChart() {
        return this.myFallbackDelegate.getGanttChart();
    }

    public Chart getResourceChart() {
        return this.myFallbackDelegate.getResourceChart();
    }

    public Chart getActiveChart() {
        return this.myFallbackDelegate.getActiveChart();
    }

    public int getViewIndex() {
        return this.myFallbackDelegate.getViewIndex();
    }

    public void setViewIndex(int viewIndex) {
        this.myFallbackDelegate.setViewIndex(viewIndex);
    }

    public int getGanttDividerLocation() {
        return this.myFallbackDelegate.getGanttDividerLocation();
    }

    public void setGanttDividerLocation(int location) {
        this.myFallbackDelegate.setGanttDividerLocation(location);
    }

    public int getResourceDividerLocation() {
        return this.myFallbackDelegate.getResourceDividerLocation();
    }

    public void setResourceDividerLocation(int location) {
        this.myFallbackDelegate.setResourceDividerLocation(location);
    }

    public void refresh() {
        this.myFallbackDelegate.refresh();
    }

    public Frame getMainFrame() {
        return this.myMainFrame;
    }

    private Action createOkAction(Action realAction, JDialog dialog, Commiter commiter) {
        return new ProxyOkAction(realAction, dialog, commiter);
    }

    private Action createCancelAction(final Action realAction, final JDialog result, final Commiter commiter) {
        return new CancelAction(){

            public void actionPerformed(ActionEvent e) {
                realAction.actionPerformed(e);
                commiter.commit();
                result.setVisible(false);
                result.dispose();
            }
        };
    }

    private static GanttLanguage getLanguage() {
        return GanttLanguage.getInstance();
    }

    static String getExceptionReport(Throwable e) {
        StringBuffer result = new StringBuffer();
        result.append(e.getMessage() + "\n\n");
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        writer.close();
        result.append(stringWriter.getBuffer().toString());
        return result.toString();
    }

    public void setWorkbenchTitle(String title) {
        this.myMainFrame.setTitle(title);
    }

    public IProgressMonitor createMonitor(Job job) {
        return this.myStatusBar.createProgressMonitor();
    }

    public IProgressMonitor createProgressGroup() {
        return this.myStatusBar.createProgressMonitor();
    }

    public IProgressMonitor createMonitor(Job job, IProgressMonitor group, int ticks) {
        return group;
    }

    public IProgressMonitor getDefaultMonitor() {
        return null;
    }

    public TaskTreeUIFacade getTaskTree() {
        return this.myFallbackDelegate.getTaskTree();
    }

    public ResourceTreeUIFacade getResourceTree() {
        return this.myFallbackDelegate.getResourceTree();
    }

    private class ProxyOkAction
    extends OkAction
    implements PropertyChangeListener {
        private Action myRealAction;
        private JDialog myDialog;
        private Commiter myCommiter;

        private ProxyOkAction(Action realAction, JDialog dialog, Commiter commiter) {
            realAction.addPropertyChangeListener(this);
            this.myRealAction = realAction;
            this.myDialog = dialog;
            this.myCommiter = commiter;
            this.setEnabled(realAction.isEnabled());
        }

        public void actionPerformed(ActionEvent e) {
            this.myRealAction.removePropertyChangeListener(this);
            this.myRealAction.actionPerformed(e);
            this.myCommiter.commit();
            if (this.myDialog.isVisible()) {
                this.myDialog.setVisible(false);
                this.myDialog.dispose();
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.setEnabled(this.myRealAction.isEnabled());
        }
    }

    private static class Commiter {
        private boolean isCommited;

        private Commiter() {
        }

        void commit() {
            this.isCommited = true;
        }

        boolean isCommited() {
            return this.isCommited;
        }
    }

    class MyDialog {
        boolean result;
        final Component contentComponent;
        final OkAction okAction = new OkAction(){

            public void actionPerformed(ActionEvent e) {
                result = true;
            }
        };
        final CancelAction cancelAction = new CancelAction(this){
            private final /* synthetic */ MyDialog this$1;
            {
                this.this$1 = this$1;
            }

            public void actionPerformed(ActionEvent e) {
            }
        };

        MyDialog(int dialogType, String message) {
            this.contentComponent = UIFacadeImpl.this.createDialogContentComponent(dialogType, message);
        }

        void show() {
            UIFacadeImpl.this.showDialog(this.contentComponent, new Action[]{this.okAction, this.cancelAction});
        }
    }
}

