/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.resource.AssignmentNode;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.resource.ResourceColumn;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.resource.ResourceNode;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import org.jdesktop.swing.treetable.DefaultTreeTableModel;

public class ResourceTreeTableModel
extends DefaultTreeTableModel {
    private static GanttLanguage language;
    public static String strResourceName;
    public static String strResourceRole;
    public static String strResourceEMail;
    public static String strResourcePhone;
    public static String strResourceRoleForTask;
    public static final int INDEX_RESOURCE_NAME = 0;
    public static final int INDEX_RESOURCE_ROLE = 1;
    public static final int INDEX_RESOURCE_EMAIL = 2;
    public static final int INDEX_RESOURCE_PHONE = 3;
    public static final int INDEX_RESOURCE_ROLE_TASK = 4;
    private final Hashtable columns = new Hashtable();
    private static int index;
    private DefaultMutableTreeNode root = null;
    private final HumanResourceManager myResourceManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ResourceTreeTableModel(ResourceManager resMgr) {
        this.myResourceManager = (HumanResourceManager)resMgr;
        this.changeLanguage(language);
        this.root = this.buildTree();
        this.setRoot(this.root);
    }

    public int useNextIndex() {
        return ++index;
    }

    public ResourceNode getNodeForResource(ProjectResource resource) {
        ResourceNode res = null;
        Enumeration<TreeNode> childs = this.root.children();
        while (childs.hasMoreElements() && res == null) {
            ResourceNode rn = (ResourceNode)childs.nextElement();
            if (!resource.equals(rn.getUserObject())) continue;
            res = rn;
        }
        return res;
    }

    public AssignmentNode getNodeForAssigment(ResourceAssignment assignement) {
        AssignmentNode res = null;
        Enumeration<TreeNode> childs = this.getNodeForResource(assignement.getResource()).children();
        while (childs.hasMoreElements() && res == null) {
            AssignmentNode an = (AssignmentNode)childs.nextElement();
            if (!assignement.equals(an.getUserObject())) continue;
            res = an;
        }
        return res;
    }

    private ResourceNode buildTree() {
        ResourceNode root = new ResourceNode(null);
        List listResources = this.myResourceManager.getResources();
        Iterator itRes = listResources.iterator();
        while (itRes.hasNext()) {
            ProjectResource pr = (ProjectResource)itRes.next();
            ResourceAssignment[] tra = pr.getAssignments();
            ResourceNode rnRes = new ResourceNode(pr);
            root.add(rnRes);
        }
        return root;
    }

    public void updateResources() {
        ProjectResource[] listResources = this.myResourceManager.getResourcesArray();
        for (int idxResource = 0; idxResource < listResources.length; ++idxResource) {
            ProjectResource pr = listResources[idxResource];
            ResourceNode rnRes = this.exists(pr);
            if (rnRes == null) {
                rnRes = new ResourceNode(pr);
            }
            this.buildAssignmentsSubtree(rnRes);
            if (this.exists(pr) == null) {
                this.root.add(rnRes);
            }
            this.nodeStructureChanged(rnRes);
        }
    }

    ResourceNode exists(ProjectResource pr) {
        ResourceNode res = null;
        Enumeration<TreeNode> en = this.root.children();
        while (res == null && en.hasMoreElements()) {
            ResourceNode rn = (ResourceNode)en.nextElement();
            if (!rn.getUserObject().equals(pr)) continue;
            res = rn;
        }
        return res;
    }

    private AssignmentNode exists(ResourceNode rn, ResourceAssignment ra) {
        AssignmentNode res = null;
        Enumeration<TreeNode> en = rn.children();
        while (res == null && en.hasMoreElements()) {
            AssignmentNode an = (AssignmentNode)en.nextElement();
            if (!an.getUserObject().equals(ra)) continue;
            res = an;
        }
        return res;
    }

    public void changeLanguage(GanttLanguage ganttLanguage) {
        strResourceName = language.getText("tableColResourceName");
        strResourceRole = language.getText("tableColResourceRole");
        strResourceEMail = language.getText("tableColResourceEMail");
        strResourcePhone = language.getText("tableColResourcePhone");
        strResourceRoleForTask = language.getText("tableColResourceRoleForTask");
        String[] cols = new String[5];
        cols[2] = strResourceEMail;
        cols[0] = strResourceName;
        cols[3] = strResourcePhone;
        cols[1] = strResourceRole;
        cols[4] = strResourceRoleForTask;
        for (int i = 0; i < cols.length; ++i) {
            ResourceColumn col = (ResourceColumn)this.columns.get(new Integer(i));
            if (col == null) continue;
            col.setTitle(cols[i]);
        }
    }

    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        parent.insert(newChild, index);
        int[] newIndexs = new int[]{index};
        this.nodesWereInserted(parent, newIndexs);
    }

    public void removeNodeFromParent(MutableTreeNode node) {
        if (node != null) {
            MutableTreeNode parent = (MutableTreeNode)node.getParent();
            if (parent == null) {
                throw new IllegalArgumentException("node does not have a parent.");
            }
            int[] childIndex = new int[1];
            Object[] removedArray = new Object[1];
            childIndex[0] = parent.getIndex(node);
            parent.remove(childIndex[0]);
            removedArray[0] = node;
            this.nodesWereRemoved(parent, childIndex, removedArray);
        }
    }

    public void changePeople(List peoples) {
        Iterator it = peoples.iterator();
        while (it.hasNext()) {
            this.addResource((ProjectResource)it.next());
        }
    }

    public DefaultMutableTreeNode addResource(ProjectResource people) {
        ResourceNode result = new ResourceNode(people);
        this.insertNodeInto(result, this.root, this.root.getChildCount());
        this.myResourceManager.toString();
        return result;
    }

    public void deleteResources(ProjectResource[] peoples) {
        for (int i = 0; i < peoples.length; ++i) {
            this.deleteResource(peoples[i]);
        }
    }

    public void deleteResource(ProjectResource people) {
        this.removeNodeFromParent(this.getNodeForResource(people));
    }

    public boolean moveUp(HumanResource resource) {
        this.myResourceManager.up(resource);
        ResourceNode rn = this.getNodeForResource(resource);
        int index = this.root.getIndex(this.root.getChildBefore(rn));
        this.removeNodeFromParent(rn);
        this.insertNodeInto(rn, this.root, index);
        return true;
    }

    public boolean moveDown(HumanResource resource) {
        this.myResourceManager.down(resource);
        ResourceNode rn = this.getNodeForResource(resource);
        int index = this.root.getIndex(this.root.getChildAfter(rn));
        this.removeNodeFromParent(rn);
        this.insertNodeInto(rn, this.root, index);
        return true;
    }

    public void reset() {
        this.myResourceManager.clear();
    }

    public List getAllResouces() {
        return this.myResourceManager.getResources();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public ArrayList getColumns() {
        ArrayList res = new ArrayList();
        Enumeration e = this.columns.elements();
        while (e.hasMoreElements()) {
            res.add(0, e.nextElement());
        }
        return res;
    }

    public ResourceColumn getColumn(int index) {
        return (ResourceColumn)this.columns.get(new Integer(index));
    }

    public Class getColumnClass(int colIndex) {
        if (colIndex == 0) {
            return hierarchicalColumnClass;
        }
        ResourceColumn column = (ResourceColumn)this.columns.get(new Integer(colIndex));
        Class clazz = column == null ? String.class : column.getType();
        return clazz;
    }

    public String getColumnName(int column) {
        return ((ResourceColumn)this.columns.get(new Integer(column))).getTitle();
    }

    public boolean isCellEditable(Object node, int column) {
        return node instanceof ResourceNode && (column == 2 || column == 0 || column == 3 || column == 1) || node instanceof AssignmentNode && column == 4 || column > 4;
    }

    public Object getValueAt(Object node, int column) {
        Object res = null;
        ResourceNode rn = null;
        AssignmentNode an = null;
        if (node instanceof ResourceNode) {
            rn = (ResourceNode)node;
        } else if (node instanceof AssignmentNode) {
            an = (AssignmentNode)node;
        }
        boolean hasChild = rn != null;
        switch (column) {
            case 0: {
                if (hasChild) {
                    res = rn.getName();
                    break;
                }
                res = an.getTask().getName();
                break;
            }
            case 1: {
                if (hasChild) {
                    res = rn.getDefaultRole();
                    break;
                }
                res = "";
                break;
            }
            case 2: {
                if (hasChild) {
                    res = rn.getEMail();
                    break;
                }
                res = "";
                break;
            }
            case 3: {
                if (hasChild) {
                    res = rn.getPhone();
                    break;
                }
                res = "";
                break;
            }
            case 4: {
                if (hasChild) {
                    res = "";
                    break;
                }
                res = an.getRoleForAssigment();
                break;
            }
            default: {
                res = hasChild ? rn.getCustomField(this.getColumnName(column)) : "";
            }
        }
        return res;
    }

    public void setValueAt(Object value, Object node, int column) {
        if (this.isCellEditable(node, column)) {
            switch (column) {
                case 0: {
                    ((ResourceNode)node).setName(value.toString());
                    break;
                }
                case 2: {
                    ((ResourceNode)node).setEMail(value.toString());
                    break;
                }
                case 3: {
                    ((ResourceNode)node).setPhone(value.toString());
                    break;
                }
                case 1: {
                    ((ResourceNode)node).setDefaultRole((Role)value);
                    break;
                }
                case 4: {
                    ((AssignmentNode)node).setRoleForAssigment((Role)value);
                    break;
                }
                default: {
                    ((ResourceNode)node).setCustomField(this.getColumnName(column), value);
                }
            }
        }
        Mediator.getGanttProjectSingleton().setAskForSave(true);
    }

    public void addMandatoryColumn(ResourceColumn col) {
        this.columns.put(new Integer(col.getIndex()), col);
    }

    public void addCustomColumn(String title, ResourceColumn col) throws Exception {
        if (this.myResourceManager.checkCustomField(title)) {
            throw new Exception("Column exists");
        }
        this.myResourceManager.addCustomField(col);
        this.columns.put(new Integer(index), col);
    }

    public ResourceColumn deleteCustomColumn(String name) {
        ResourceColumn toDel = null;
        Collection vals = this.columns.values();
        Iterator i = vals.iterator();
        while (i.hasNext()) {
            toDel = (ResourceColumn)i.next();
            if (!name.equals(toDel.getTitle())) continue;
            this.myResourceManager.removeCustomField(toDel.getTitle());
            vals.remove(toDel);
            return toDel;
        }
        return null;
    }

    public boolean checkRemovableCol(String name) {
        return this.myResourceManager.checkCustomField(name);
    }

    public void resourceChanged(ProjectResource resource) {
        ResourceNode node = this.getNodeForResource(resource);
        if (node == null) {
            return;
        }
        TreeNode parent = node.getParent();
        int index = parent.getIndex(node);
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError();
        }
        this.nodesChanged(parent, new int[]{index});
    }

    public void resourceAssignmentsChanged(ProjectResource[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            ResourceNode nextNode = this.exists(resources[i]);
            this.buildAssignmentsSubtree(nextNode);
        }
    }

    private void buildAssignmentsSubtree(ResourceNode resourceNode) {
        ProjectResource resource = resourceNode.getResource();
        resourceNode.removeAllChildren();
        ResourceAssignment[] assignments = resource.getAssignments();
        int[] indices = new int[assignments.length];
        Object[] children = new TreeNode[assignments.length];
        if (assignments.length > 0) {
            for (int i = 0; i < assignments.length; ++i) {
                indices[i] = i;
                AssignmentNode an = new AssignmentNode(assignments[i]);
                children[i] = an;
                resourceNode.add(an);
            }
        }
        this.fireTreeStructureChanged((Object)this, resourceNode.getPath(), indices, children);
    }

    void decreaseCustomPropertyIndex(int i) {
        index -= i;
    }

    static {
        $assertionsDisabled = !ResourceTreeTableModel.class.desiredAssertionStatus();
        language = GanttLanguage.getInstance();
        strResourceName = null;
        strResourceRole = null;
        strResourceEMail = null;
        strResourcePhone = null;
        strResourceRoleForTask = null;
        index = -1;
    }
}

