/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Action;
import javax.swing.Icon;
import net.sourceforge.ganttproject.ChartComponentBase;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttExportSettings;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.ResourceTreeImageGenerator;
import net.sourceforge.ganttproject.chart.ChartModelBase;
import net.sourceforge.ganttproject.chart.ChartModelResource;
import net.sourceforge.ganttproject.chart.ChartSelection;
import net.sourceforge.ganttproject.chart.RenderedChartImage;
import net.sourceforge.ganttproject.chart.RenderedResourceChartImage;
import net.sourceforge.ganttproject.chart.ResourceChart;
import net.sourceforge.ganttproject.font.Fonts;
import net.sourceforge.ganttproject.gui.zoom.ZoomManager;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.resource.AssignmentNode;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.time.gregorian.GregorianCalendar;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ResourceLoadGraphicArea
extends ChartComponentBase
implements ResourceChart {
    private int margY;
    private boolean drawVersion = false;
    private GanttProject appli;
    private ChartModelResource myChartModel;
    private MouseMotionListener myMouseMotionListener;
    private MouseListener myMouseListener;
    private ChartComponentBase.AbstractChartImplementation myChartImplementation = new ChartComponentBase.AbstractChartImplementation(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            Object object = ChartModelBase.STATIC_MUTEX;
            synchronized (object) {
                super.paintComponent(g);
                ResourceLoadGraphicArea.super.paintComponent(g);
                ResourceLoadGraphicArea.this.myChartModel.setHeaderHeight(ResourceLoadGraphicArea.this.getHeaderHeight());
                ResourceLoadGraphicArea.this.myChartModel.setBottomUnitWidth(ResourceLoadGraphicArea.this.getViewState().getBottomUnitWidth());
                ResourceLoadGraphicArea.this.myChartModel.setRowHeight(ResourceLoadGraphicArea.this.getRowHeight());
                ResourceLoadGraphicArea.this.myChartModel.setTopTimeUnit(ResourceLoadGraphicArea.this.getViewState().getTopTimeUnit());
                ResourceLoadGraphicArea.this.myChartModel.setBottomTimeUnit(ResourceLoadGraphicArea.this.getViewState().getBottomTimeUnit());
                ResourceLoadGraphicArea.this.myChartModel.paint(g);
                if (ResourceLoadGraphicArea.this.drawVersion) {
                    ResourceLoadGraphicArea.this.drawGPVersion(g);
                }
            }
        }

        public ChartSelection getSelection() {
            ChartComponentBase.ChartSelectionImpl result = new ChartComponentBase.ChartSelectionImpl(this){
                private final /* synthetic */ 3 this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isEmpty() {
                    return false;
                }

                public void startCopyClipboardTransaction() {
                    super.startCopyClipboardTransaction();
                    ResourceLoadGraphicArea.access$000(3.access$400(this.this$1)).getResourcePanel().copySelection();
                }

                public void startMoveClipboardTransaction() {
                    super.startMoveClipboardTransaction();
                    ResourceLoadGraphicArea.access$000(3.access$400(this.this$1)).getResourcePanel().cutSelection();
                }
            };
            return result;
        }

        public IStatus canPaste(ChartSelection selection) {
            return Status.OK_STATUS;
        }

        public void paste(ChartSelection selection) {
            ResourceLoadGraphicArea.this.appli.getResourcePanel().pasteSelection();
        }

        static /* synthetic */ ResourceLoadGraphicArea access$400(3 x0) {
            return x0.ResourceLoadGraphicArea.this;
        }
    };

    public ResourceLoadGraphicArea(GanttProject app, ZoomManager zoomManager) {
        super(app, app, zoomManager);
        this.setBackground(Color.WHITE);
        this.myChartModel = new ChartModelResource(this.getTaskManager(), (HumanResourceManager)app.getHumanResourceManager(), this.getTimeUnitStack(), this.getUIConfiguration(), this);
        this.getViewState().addStateListener(this.myChartModel);
        this.getViewState().setStartDate(GregorianCalendar.getInstance().getTime());
        this.margY = 0;
        this.appli = app;
    }

    public Dimension getPreferredSize() {
        return new Dimension(465, 600);
    }

    public void paintComponent(Graphics g) {
        this.myChartModel.setBounds(this.getSize());
        this.myChartImplementation.paintComponent(g);
    }

    protected int getHeaderHeight() {
        return 0;
    }

    protected int getRowHeight() {
        return 20;
    }

    public void drawGPVersion(Graphics g) {
        g.setColor(Color.black);
        g.setFont(Fonts.GP_VERSION_FONT);
        g.drawString("GanttProject (2.0.5)", 3, this.getHeight() - 8);
    }

    public int indexOf(ArrayList listOfParam, String coef) {
        for (int i = 0; i < listOfParam.size(); ++i) {
            if (coef != listOfParam.get(i).toString()) continue;
            return i;
        }
        return -1;
    }

    public void setScrollBar(int v) {
        this.margY = v;
        this.getChartModel().getChartUIConfiguration().setYOffSet(v);
    }

    public BufferedImage getChart(GanttExportSettings settings) {
        RenderedChartImage renderedImage = (RenderedChartImage)this.getRenderedImage(settings);
        BufferedImage result = renderedImage.getWholeImage();
        this.repaint();
        return result;
    }

    public RenderedImage getRenderedImage(GanttExportSettings settings) {
        TaskLength printedLength;
        int chartWidth;
        Date dateEnd;
        Date dateStart = settings.getStartDate() == null ? this.getStartDate() : settings.getStartDate();
        Date date = dateEnd = settings.getEndDate() == null ? this.getEndDate() : settings.getEndDate();
        if (dateStart.after(dateEnd)) {
            Date tmp = (Date)dateStart.clone();
            dateStart = (Date)dateEnd.clone();
            dateEnd = tmp;
        }
        if ((chartWidth = (int)(((printedLength = this.getTaskManager().createLength(this.getViewState().getBottomTimeUnit(), dateStart, dateEnd)).getLength(this.getViewState().getBottomTimeUnit()) + 1.0f) * (float)this.getViewState().getBottomUnitWidth())) < this.getWidth()) {
            chartWidth = this.getWidth();
        }
        ResourceTreeImageGenerator resourceTreeGenerator = new ResourceTreeImageGenerator(this.getHumanResourceManager()){

            protected boolean isAssignmentVisible(ResourceAssignment assignment) {
                AssignmentNode an = ResourceLoadGraphicArea.this.appli.getResourcePanel().getResourceTreeTableModel().getNodeForAssigment(assignment);
                return ResourceLoadGraphicArea.this.appli.getResourcePanel().getResourceTreeTable().isVisible(an);
            }

            protected int getRowHeight() {
                return ResourceLoadGraphicArea.this.getRowHeight();
            }
        };
        BufferedImage resourceTreeImage = resourceTreeGenerator.createImage();
        int chartHeight = resourceTreeImage.getHeight();
        RenderedResourceChartImage renderedImage = new RenderedResourceChartImage(this.myChartModel, this.myChartImplementation, resourceTreeImage, chartWidth, chartHeight);
        return renderedImage;
    }

    private HumanResourceManager getHumanResourceManager() {
        return (HumanResourceManager)this.appli.getHumanResourceManager();
    }

    public String getName() {
        return GanttLanguage.getInstance().getText("resourcesChart");
    }

    public Date getStartDate() {
        return this.getTaskManager().getProjectStart();
    }

    public Date getEndDate() {
        TaskLength projectLength = this.getTaskManager().getProjectLength();
        GanttCalendar pstart = new GanttCalendar(this.getTaskManager().getProjectStart());
        pstart.add((int)projectLength.getLength());
        GanttCalendar end = pstart.Clone();
        return end.getTime();
    }

    protected ChartModelBase getChartModel() {
        return this.myChartModel;
    }

    protected MouseListener getMouseListener() {
        if (this.myMouseListener == null) {
            this.myMouseListener = new ChartComponentBase.MouseListenerBase(){

                protected Action[] getPopupMenuActions() {
                    return new Action[]{ResourceLoadGraphicArea.this.getOptionsDialogAction()};
                }
            };
        }
        return this.myMouseListener;
    }

    protected MouseMotionListener getMouseMotionListener() {
        if (this.myMouseMotionListener == null) {
            this.myMouseMotionListener = new ChartComponentBase.MouseMotionListenerBase();
        }
        return this.myMouseMotionListener;
    }

    protected ChartComponentBase.AbstractChartImplementation getImplementation() {
        return this.myChartImplementation;
    }

    public boolean isExpanded(ProjectResource resource) {
        return true;
    }

    public void setTaskManager(TaskManager taskManager) {
    }

    public void reset() {
    }

    public Icon getIcon() {
        return null;
    }
}

