/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import net.sourceforge.ganttproject.GPTreeTableBase;
import net.sourceforge.ganttproject.GanttTreeTableModel;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.delay.Delay;
import net.sourceforge.ganttproject.gui.GanttDialogCustomColumn;
import net.sourceforge.ganttproject.gui.TableHeaderUIFacade;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.CustomColumEvent;
import net.sourceforge.ganttproject.task.CustomColumn;
import net.sourceforge.ganttproject.task.CustomColumnsException;
import net.sourceforge.ganttproject.task.CustomColumsListener;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskNode;
import org.jdesktop.swing.decorator.AlternateRowHighlighter;
import org.jdesktop.swing.decorator.HierarchicalColumnHighlighter;
import org.jdesktop.swing.decorator.Highlighter;
import org.jdesktop.swing.decorator.HighlighterPipeline;
import org.jdesktop.swing.table.TableColumnExt;
import org.jdesktop.swing.treetable.TreeTableModel;

public class GanttTreeTable
extends GPTreeTableBase
implements GanttLanguage.Listener,
CustomColumsListener {
    private static GanttLanguage language;
    private JPopupMenu popupMenu;
    private Map mapColNameMenuItem;
    private Point clickPoint = null;
    private final GanttTreeTableModel ttModel;
    private final Map mapTableColumnColumnKeeper = new LinkedHashMap();
    private JMenuItem jmiDeleteColumn;
    DisplayedColumnsList listDisplayedColumns = null;
    private GanttLanguage.Listener myLanguageListener;
    private final UIFacade myUIfacade;
    private final TableHeaderUIFacade myVisibleFields = new VisibleFieldsImpl();
    static final /* synthetic */ boolean $assertionsDisabled;

    public GanttTreeTable(IGanttProject project, UIFacade uifacade, GanttTreeTableModel model) {
        super(project, (TreeTableModel)model);
        GanttLanguage.getInstance().addListener(this);
        this.initTreeTable();
        this.ttModel = model;
        this.myUIfacade = uifacade;
    }

    void setAction(Action action) {
        this.addAction(action, (KeyStroke)action.getValue("AcceleratorKey"));
    }

    void addAction(Action action, KeyStroke keyStroke) {
        InputMap inputMap = this.getInputMap();
        inputMap.put(keyStroke, action.getValue("Name"));
        this.getActionMap().put(action.getValue("Name"), action);
    }

    private void updateDisplayedColumnsOrder() {
        Iterator it = this.listDisplayedColumns.iterator();
        while (it.hasNext()) {
            DisplayedColumn dc = (DisplayedColumn)it.next();
            if (!dc.isDisplayed()) continue;
            String id = dc.getID();
            String name = this.getNameForId(id);
            int viewIndex = this.getTable().convertColumnIndexToView(this.getColumn(name).getModelIndex());
            dc.setOrder(viewIndex);
            dc.setWidth(this.getColumn(name).getPreferredWidth());
        }
    }

    public DisplayedColumnsList getDisplayColumns() {
        this.updateDisplayedColumnsOrder();
        return this.listDisplayedColumns;
    }

    public void setDisplayedColumns(DisplayedColumnsList displayedColumns) {
        DisplayedColumnsList l = (DisplayedColumnsList)displayedColumns.clone();
        this.displayAllColumns();
        this.hideAllColumns();
        this.listDisplayedColumns = l;
        Collections.sort(this.listDisplayedColumns);
        Iterator it = this.listDisplayedColumns.iterator();
        while (it.hasNext()) {
            DisplayedColumn dc = (DisplayedColumn)it.next();
            String id = dc.getID();
            String name = this.getNameForId(id);
            if (dc.displayed) {
                this.displayColumn(name);
                continue;
            }
            this.hideColumn(name);
        }
    }

    void reloadColumns() {
        ArrayList<TableColumn> columns = Collections.list(this.getTable().getColumnModel().getColumns());
        for (int i = 0; i < columns.size(); ++i) {
            this.getTable().removeColumn((TableColumn)columns.get(i));
        }
        if (this.myLanguageListener != null) {
            GanttLanguage.getInstance().removeListener(this.myLanguageListener);
        }
        final TableColumnExt tce1 = this.newTableColumnExt(0);
        final TableColumnExt tce2 = this.newTableColumnExt(1);
        final TableColumnExt tce3 = this.newTableColumnExt(2);
        final TableColumnExt tce4 = this.newTableColumnExt(3);
        final TableColumnExt tce5 = this.newTableColumnExt(4);
        final TableColumnExt tce6 = this.newTableColumnExt(5);
        final TableColumnExt tce7 = this.newTableColumnExt(6);
        final TableColumnExt tce8 = this.newTableColumnExt(7);
        final TableColumnExt tce9 = this.newTableColumnExt(8);
        final TableColumnExt tce10 = this.newTableColumnExt(9);
        final TableColumnExt tce11 = this.newTableColumnExt(10);
        this.myLanguageListener = new GanttLanguage.Listener(){

            public void languageChanged(GanttLanguage.Event event) {
                GanttTreeTable.this.ttModel.languageChanged(event);
                tce1.setTitle(GanttTreeTableModel.strColType);
                tce2.setTitle(GanttTreeTableModel.strColPriority);
                tce3.setTitle(GanttTreeTableModel.strColInfo);
                tce4.setTitle(GanttTreeTableModel.strColName);
                tce5.setTitle(GanttTreeTableModel.strColBegDate);
                tce6.setTitle(GanttTreeTableModel.strColEndDate);
                tce7.setTitle(GanttTreeTableModel.strColDuration);
                tce8.setTitle(GanttTreeTableModel.strColCompletion);
                tce9.setTitle(GanttTreeTableModel.strColCoordinator);
                tce10.setTitle(GanttTreeTableModel.strColPredecessors);
                tce11.setTitle(GanttTreeTableModel.strColID);
            }
        };
        GanttLanguage.getInstance().addListener(this.myLanguageListener);
        this.addColumn(tce1);
        this.addColumn(tce2);
        this.addColumn(tce3);
        this.addColumn(tce4);
        this.addColumn(tce5);
        this.addColumn(tce6);
        this.addColumn(tce7);
        this.addColumn(tce8);
        this.addColumn(tce9);
        this.addColumn(tce10);
        this.addColumn(tce11);
        this.listDisplayedColumns = new DisplayedColumnsList();
        DisplayedColumn dc1 = new DisplayedColumn(this.getIdForName(tce1.getTitle()));
        dc1.setDisplayed(false);
        dc1.setOrder(this.getTable().convertColumnIndexToView(tce1.getModelIndex()));
        dc1.setWidth(tce1.getPreferredWidth());
        this.listDisplayedColumns.add(dc1);
        DisplayedColumn dc2 = new DisplayedColumn(this.getIdForName(tce2.getTitle()));
        dc2.setDisplayed(false);
        dc2.setOrder(this.getTable().convertColumnIndexToView(tce2.getModelIndex()));
        dc2.setWidth(tce2.getPreferredWidth());
        this.listDisplayedColumns.add(dc2);
        DisplayedColumn dc3 = new DisplayedColumn(this.getIdForName(tce3.getTitle()));
        dc3.setDisplayed(false);
        dc3.setOrder(this.getTable().convertColumnIndexToView(tce3.getModelIndex()));
        dc3.setWidth(tce3.getPreferredWidth());
        this.listDisplayedColumns.add(dc3);
        DisplayedColumn dc4 = new DisplayedColumn(this.getIdForName(tce4.getTitle()));
        dc4.setDisplayed(true);
        dc4.setOrder(this.getTable().convertColumnIndexToView(tce4.getModelIndex()));
        dc4.setWidth(tce4.getPreferredWidth());
        this.listDisplayedColumns.add(dc4);
        DisplayedColumn dc5 = new DisplayedColumn(this.getIdForName(tce5.getTitle()));
        dc5.setDisplayed(true);
        dc5.setOrder(this.getTable().convertColumnIndexToView(tce5.getModelIndex()));
        dc5.setWidth(tce5.getPreferredWidth());
        this.listDisplayedColumns.add(dc5);
        DisplayedColumn dc6 = new DisplayedColumn(this.getIdForName(tce6.getTitle()));
        dc6.setDisplayed(true);
        dc6.setOrder(this.getTable().convertColumnIndexToView(tce6.getModelIndex()));
        dc6.setWidth(tce6.getPreferredWidth());
        this.listDisplayedColumns.add(dc6);
        DisplayedColumn dc7 = new DisplayedColumn(this.getIdForName(tce7.getTitle()));
        dc7.setDisplayed(false);
        dc7.setOrder(this.getTable().convertColumnIndexToView(tce7.getModelIndex()));
        dc7.setWidth(tce7.getPreferredWidth());
        this.listDisplayedColumns.add(dc7);
        DisplayedColumn dc8 = new DisplayedColumn(this.getIdForName(tce8.getTitle()));
        dc8.setDisplayed(false);
        dc8.setOrder(this.getTable().convertColumnIndexToView(tce8.getModelIndex()));
        dc8.setWidth(tce8.getPreferredWidth());
        this.listDisplayedColumns.add(dc8);
        DisplayedColumn dc9 = new DisplayedColumn(this.getIdForName(tce9.getTitle()));
        dc9.setDisplayed(false);
        dc9.setOrder(this.getTable().convertColumnIndexToView(tce9.getModelIndex()));
        dc9.setWidth(tce9.getPreferredWidth());
        this.listDisplayedColumns.add(dc9);
        DisplayedColumn dc10 = new DisplayedColumn(this.getIdForName(tce10.getTitle()));
        dc10.setDisplayed(false);
        dc10.setOrder(this.getTable().convertColumnIndexToView(tce10.getModelIndex()));
        dc10.setWidth(tce10.getPreferredWidth());
        this.listDisplayedColumns.add(dc10);
        DisplayedColumn dc11 = new DisplayedColumn(this.getIdForName(tce11.getTitle()));
        dc11.setDisplayed(false);
        dc11.setOrder(this.getTable().convertColumnIndexToView(tce11.getModelIndex()));
        dc11.setWidth(tce11.getPreferredWidth());
        this.listDisplayedColumns.add(dc11);
        this.mapTableColumnColumnKeeper.clear();
        this.mapTableColumnColumnKeeper.put(tce1, new ColumnKeeper((TableColumn)tce1));
        this.mapTableColumnColumnKeeper.put(tce2, new ColumnKeeper((TableColumn)tce2));
        this.mapTableColumnColumnKeeper.put(tce3, new ColumnKeeper((TableColumn)tce3));
        this.mapTableColumnColumnKeeper.put(tce4, new ColumnKeeper((TableColumn)tce4));
        this.mapTableColumnColumnKeeper.put(tce5, new ColumnKeeper((TableColumn)tce5));
        this.mapTableColumnColumnKeeper.put(tce6, new ColumnKeeper((TableColumn)tce6));
        this.mapTableColumnColumnKeeper.put(tce7, new ColumnKeeper((TableColumn)tce7));
        this.mapTableColumnColumnKeeper.put(tce8, new ColumnKeeper((TableColumn)tce8));
        this.mapTableColumnColumnKeeper.put(tce9, new ColumnKeeper((TableColumn)tce9));
        this.mapTableColumnColumnKeeper.put(tce10, new ColumnKeeper((TableColumn)tce10));
        this.mapTableColumnColumnKeeper.put(tce11, new ColumnKeeper((TableColumn)tce11));
        this.initColumnsAlignements();
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColBegDate).setCellEditor(this.newDateCellEditor());
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColEndDate).setCellEditor(this.newDateCellEditor());
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColName).setCellEditor((TableCellEditor)new NameCellEditor());
        if (this.listDisplayedColumns != null) {
            this.setDisplayedColumns(this.listDisplayedColumns);
        } else {
            this.displayAllColumns();
        }
        Runnable t = new Runnable(){

            public void run() {
                GanttTreeTable.this.calculateWidth();
                GanttTreeTable.this.revalidate();
            }
        };
        SwingUtilities.invokeLater(t);
    }

    void initTreeTable() {
        this.clickPoint = null;
        this.getProject().getTaskCustomColumnManager().addCustomColumnsListener(this);
        this.mapColNameMenuItem = new HashMap();
        this.getTreeTableModel().addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent arg0) {
            }

            public void treeNodesInserted(TreeModelEvent arg0) {
            }

            public void treeNodesRemoved(TreeModelEvent arg0) {
            }

            public void treeStructureChanged(TreeModelEvent arg0) {
            }
        });
        this.getTable().setAutoCreateColumnsFromModel(false);
        this.getTable().setAutoResizeMode(2);
        this.setShowHorizontalLines(true);
        this.setOpenIcon(null);
        this.setClosedIcon(null);
        this.setCollapsedIcon(new ImageIcon(this.getClass().getResource("/icons/plus.gif")));
        this.setExpandedIcon(new ImageIcon(this.getClass().getResource("/icons/minus.gif")));
        this.setLeafIcon(null);
        this.setHasColumnControl(false);
        this.getTreeTable().getParent().setBackground(Color.WHITE);
        this.getTreeTable().getParent().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                e.consume();
                if (e.getClickCount() == 1) {
                    Mediator.getGanttProjectSingleton().getTree().selectTreeRow(-1);
                } else if (e.getClickCount() == 2 && e.getButton() == 1) {
                    Mediator.getGanttProjectSingleton().getUndoManager().undoableEdit("New Task by click", new Runnable(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            Mediator.getGanttProjectSingleton().newTask();
                        }
                    });
                }
            }
        });
        InputMap inputMap = this.getInputMap();
        inputMap.setParent(this.getTreeTable().getInputMap(0));
        this.getTreeTable().setInputMap(0, inputMap);
        ActionMap actionMap = this.getActionMap();
        actionMap.setParent(this.getTreeTable().getActionMap());
        this.getTreeTable().setActionMap(actionMap);
        this.getTable().getColumnModel().addColumnModelListener((TableColumnModelListener)this.getTreeTableModel());
        this.getTable().getModel().addTableModelListener(new ModelListener());
        this.getTable().getTableHeader().addMouseListener(new HeaderMouseListener());
        this.getTable().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
                DefaultTableColumnModel o = (DefaultTableColumnModel)e.getSource();
                TableColumn tc = o.getColumn(e.getFromIndex());
                ColumnKeeper ck = (ColumnKeeper)GanttTreeTable.this.mapTableColumnColumnKeeper.get(tc);
                if (ck != null) {
                    ck.setInitIndex(e.getToIndex());
                }
                if (Mediator.getGanttProjectSingleton() != null) {
                    Mediator.getGanttProjectSingleton().setAskForSave(true);
                }
                GanttTreeTable.this.updateDisplayedColumnsOrder();
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.quickSilver, new HierarchicalColumnHighlighter()}));
        this.reloadColumns();
    }

    void addScrollPaneMouseListener(MouseListener ml) {
        this.getTreeTable().getParent().addMouseListener(ml);
    }

    private void initColumnsAlignements() {
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColType, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColPriority, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColInfo, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColBegDate, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColEndDate, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColDuration, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColCompletion, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColCoordinator, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColPredecessors, 4);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColID, 0);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColID).setPreferredWidth(32);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColType).setPreferredWidth(32);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColPriority).setPreferredWidth(42);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColInfo).setPreferredWidth(32);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColName).setPreferredWidth(120);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColDuration).setPreferredWidth(50);
    }

    void calculateWidth() {
        int width = 0;
        int nbCol = this.getTable().getColumnCount();
        for (int i = 0; i < nbCol; ++i) {
            TableColumnExt tce = this.getTable().getColumnExt(i);
            if (!tce.isVisible()) continue;
            width += tce.getPreferredWidth();
        }
        this.getTable().setPreferredScrollableViewportSize(new Dimension(width, 0));
    }

    private void createPopupMenu() {
        this.mapColNameMenuItem.clear();
        this.popupMenu = new JPopupMenu();
        TableColumnModel tcModel = this.getTable().getColumnModel();
        Iterator entries = this.mapTableColumnColumnKeeper.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry nextEntry = entries.next();
            TableColumn column = (TableColumn)nextEntry.getKey();
            JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem(column.getHeaderValue().toString());
            ColumnKeeper ck = (ColumnKeeper)nextEntry.getValue();
            if (!$assertionsDisabled && ck == null) {
                throw new AssertionError();
            }
            jcbmi.setSelected(ck.isShown);
            jcbmi.addActionListener(ck);
            this.mapColNameMenuItem.put(column.getHeaderValue().toString(), jcbmi);
            this.popupMenu.add(jcbmi);
        }
        this.popupMenu.addSeparator();
        JMenuItem jmiAddColumn = new JMenuItem(language.getText("addCustomColumn"));
        jmiAddColumn.setIcon(new ImageIcon(this.getClass().getResource("/icons/addCol_16.gif")));
        jmiAddColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GanttTreeTable.this.myUIfacade.getUndoManager().undoableEdit("PopUpNewColumn", new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        CustomColumn customColumn = new CustomColumn();
                        GanttDialogCustomColumn d = new GanttDialogCustomColumn(GanttTreeTable.access$600(7.access$500(this.this$1)), customColumn);
                        d.setVisible(true);
                        7.access$500(this.this$1).getProject().getTaskCustomColumnManager().addNewCustomColumn(customColumn);
                    }
                });
            }

            static /* synthetic */ GanttTreeTable access$500(7 x0) {
                return x0.GanttTreeTable.this;
            }
        });
        JMenuItem jmiDisplayAll = new JMenuItem(language.getText("displayAll"));
        jmiDisplayAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Mediator.getGanttProjectSingleton().getUndoManager().undoableEdit("displayAllColumns", new Runnable(this){
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        GanttTreeTable.access$800(9.access$700(this.this$1));
                    }
                });
            }

            static /* synthetic */ GanttTreeTable access$700(9 x0) {
                return x0.GanttTreeTable.this;
            }
        });
        this.jmiDeleteColumn = new JMenuItem(language.getText("deleteCustomColumn"));
        this.jmiDeleteColumn.setIcon(new ImageIcon(this.getClass().getResource("/icons/removeCol_16.gif")));
        this.jmiDeleteColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GanttTreeTable.this.myUIfacade.getUndoManager().undoableEdit("deleteCustomColumn", new Runnable(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        int ind = 11.access$900(this.this$1).getTable().columnAtPoint(GanttTreeTable.access$1000(11.access$900(this.this$1)));
                        if (ind >= 0) {
                            11.access$900(this.this$1).getProject().getTaskCustomColumnManager().deleteCustomColumn(11.access$900(this.this$1).getTable().getColumnName(ind));
                            GanttTreeTable.access$1100(11.access$900(this.this$1)).setEnabled(false);
                        }
                    }
                });
            }

            static /* synthetic */ GanttTreeTable access$900(11 x0) {
                return x0.GanttTreeTable.this;
            }
        });
        this.jmiDeleteColumn.setEnabled(false);
        this.popupMenu.add(jmiDisplayAll);
        this.popupMenu.addSeparator();
        this.popupMenu.add(jmiAddColumn);
        this.popupMenu.add(this.jmiDeleteColumn);
    }

    private void renameMenuItem(String oldName, String newName) {
        Component[] t = this.popupMenu.getComponents();
        JCheckBoxMenuItem jcbmi = null;
        for (int i = 0; i < t.length; ++i) {
            if (!(t[i] instanceof JCheckBoxMenuItem) || !(jcbmi = (JCheckBoxMenuItem)t[i]).getText().equals(oldName)) continue;
            jcbmi.setText(newName);
            break;
        }
        if (jcbmi != null) {
            this.mapColNameMenuItem.remove(oldName);
            this.mapColNameMenuItem.put(newName, jcbmi);
        }
    }

    private void displayAllColumns() {
        Iterator it = this.mapTableColumnColumnKeeper.values().iterator();
        while (it.hasNext()) {
            ColumnKeeper ck = (ColumnKeeper)it.next();
            if (ck.isShown) continue;
            ck.show();
        }
    }

    private void hideAllColumns() {
        Iterator it = this.mapTableColumnColumnKeeper.values().iterator();
        while (it.hasNext()) {
            ColumnKeeper ck = (ColumnKeeper)it.next();
            if (!ck.isShown) continue;
            ck.hide();
        }
    }

    private void displayColumn(String name) {
        int indexView = -1;
        int width = -1;
        Iterator itDc = this.listDisplayedColumns.iterator();
        while (itDc.hasNext()) {
            DisplayedColumn dc = (DisplayedColumn)itDc.next();
            if (!this.getNameForId(dc.getID()).equals(name)) continue;
            indexView = dc.getOrder();
            width = dc.getWidth();
        }
        Iterator it = this.mapTableColumnColumnKeeper.keySet().iterator();
        while (it.hasNext()) {
            TableColumn c = (TableColumn)it.next();
            String n = (String)c.getHeaderValue();
            if (!n.equals(name)) continue;
            ColumnKeeper ck = (ColumnKeeper)this.mapTableColumnColumnKeeper.get(c);
            if (indexView != -1) {
                ck.index = indexView;
            }
            if (ck.isShown) break;
            ck.show();
            break;
        }
        this.getTable().getColumnExt((Object)name).setPreferredWidth(width);
    }

    private void hideColumn(String name) {
        Iterator it = this.mapTableColumnColumnKeeper.keySet().iterator();
        while (it.hasNext()) {
            TableColumn c = (TableColumn)it.next();
            String n = (String)c.getHeaderValue();
            if (!n.equals(name)) continue;
            ColumnKeeper ck = (ColumnKeeper)this.mapTableColumnColumnKeeper.get(c);
            if (!ck.isShown) break;
            ck.hide();
            break;
        }
    }

    public void addNewCustomColumn(CustomColumn customColumn) {
        if (customColumn == null) {
            customColumn = new CustomColumn();
            GanttDialogCustomColumn d = new GanttDialogCustomColumn(this.myUIfacade, customColumn);
            d.setVisible(true);
        }
        if (customColumn.getName() != null) {
            GanttTreeTableModel treeTableModel = (GanttTreeTableModel)this.getTreeTableModel();
            int nbCol = treeTableModel.getColumnCountTotal();
            String newName = customColumn.getName();
            this.ttModel.addCustomColumn(newName);
            TaskContainmentHierarchyFacade tchf = this.getProject().getTaskManager().getTaskHierarchy();
            this.setCustomColumnValueToAllNestedTask(tchf, tchf.getRootTask(), customColumn.getName(), customColumn.getDefaultValue());
            TableColumnExt t = this.newTableColumnExt(nbCol);
            t.setMaxWidth(500);
            t.setHeaderValue((Object)newName);
            this.getTable().getColumnModel().addColumn((TableColumn)t);
            try {
                if (this.clickPoint != null) {
                    this.getTable().getColumnModel().moveColumn(this.getTable().getColumnCount() - 1, this.getTable().columnAtPoint(this.clickPoint));
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            int align = 0;
            if (customColumn.getType().equals(GregorianCalendar.class)) {
                align = 4;
            }
            this.setColumnHorizontalAlignment(newName, align);
            DisplayedColumn dc = new DisplayedColumn(this.getProject().getCustomColumnsStorage().getIdFromName(newName));
            dc.setDisplayed(true);
            dc.setOrder(this.getTable().convertColumnIndexToView(this.getColumn(newName).getModelIndex()));
            dc.setWidth(this.getColumn(newName).getPreferredWidth());
            this.listDisplayedColumns.add(dc);
            if (GregorianCalendar.class.isAssignableFrom(customColumn.getType())) {
                this.getTable().getColumnExt((Object)newName).setCellEditor(this.newDateCellEditor());
            }
            JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem(newName);
            jcbmi.setSelected(true);
            ColumnKeeper ck = new ColumnKeeper((TableColumn)t);
            jcbmi.addActionListener(ck);
            this.mapColNameMenuItem.put(newName, jcbmi);
            this.mapTableColumnColumnKeeper.put(t, ck);
            this.getProject().setModified();
        }
        Runnable t = new Runnable(){

            public void run() {
                GanttTreeTable.this.calculateWidth();
                GanttTreeTable.this.revalidate();
            }
        };
        SwingUtilities.invokeLater(t);
    }

    public void deleteCustomColumn(CustomColumn column) {
        String name = column.getName();
        this.displayColumn(name);
        this.deleteColumnFromUI(name);
        TaskContainmentHierarchyFacade tchf = Mediator.getGanttProjectSingleton().getTaskManager().getTaskHierarchy();
        tchf.getRootTask().getCustomValues().removeCustomColumn(name);
        this.removeCustomColumnToAllNestedTask(tchf, tchf.getRootTask(), name);
        Mediator.getGanttProjectSingleton().setAskForSave(true);
    }

    private void deleteColumnFromUI(String name) {
        Iterator it = this.listDisplayedColumns.iterator();
        while (it.hasNext()) {
            DisplayedColumn dc = (DisplayedColumn)it.next();
            if (!this.getNameForId(dc.getID()).equals(name)) continue;
            it.remove();
            break;
        }
        int index = this.getTable().getColumnModel().getColumnIndex(name);
        int modelIndex = this.getTable().convertColumnIndexToModel(index);
        TableColumnModelEvent tcme = new TableColumnModelEvent(this.getTable().getColumnModel(), modelIndex, modelIndex);
        this.getTable().removeColumn((TableColumn)this.getTable().getColumnExt((Object)name));
        this.getTable().columnRemoved(tcme);
        this.ttModel.deleteCustomColumn(name);
        this.popupMenu.remove(this.popupMenu.getComponentIndex((Component)this.mapColNameMenuItem.get(name)));
        this.mapColNameMenuItem.remove(name);
        Iterator it2 = this.mapTableColumnColumnKeeper.keySet().iterator();
        while (it2.hasNext()) {
            TableColumn c = (TableColumn)it2.next();
            String n = (String)c.getHeaderValue();
            if (!n.equals(name)) continue;
            this.mapTableColumnColumnKeeper.remove(c);
            break;
        }
    }

    public void renameCustomcolumn(String name, String newName) {
        Mediator.getGanttProjectSingleton().setAskForSave(true);
        this.displayColumn(name);
        TableColumnExt tc = (TableColumnExt)this.getTable().getColumn((Object)name);
        tc.setTitle(newName);
        Mediator.getGanttProjectSingleton().repaint();
        this.renameMenuItem(name, newName);
        TaskContainmentHierarchyFacade tchf = Mediator.getGanttProjectSingleton().getTaskManager().getTaskHierarchy();
        tchf.getRootTask().getCustomValues().renameCustomColumn(name, newName);
        this.renameCustomColumnForAllNestedTask(tchf, tchf.getRootTask(), name, newName);
        this.ttModel.renameCustomColumn(name, newName);
        Iterator it = this.mapTableColumnColumnKeeper.keySet().iterator();
        while (it.hasNext()) {
            TableColumn c = (TableColumn)it.next();
            String n = (String)c.getHeaderValue();
            if (!n.equals(name)) continue;
            ColumnKeeper ck = (ColumnKeeper)this.mapTableColumnColumnKeeper.get(c);
            ((TableColumnExt)c).setTitle(newName);
            break;
        }
    }

    private void setCustomColumnValueToAllNestedTask(TaskContainmentHierarchyFacade facade, Task root, String colName, Object value) {
        try {
            root.getCustomValues().setValue(colName, value);
        }
        catch (CustomColumnsException e) {
            e.printStackTrace();
        }
        Task[] tt = facade.getNestedTasks(root);
        for (int i = 0; i < tt.length; ++i) {
            try {
                tt[i].getCustomValues().setValue(colName, value);
            }
            catch (CustomColumnsException e1) {
                e1.printStackTrace();
            }
            this.setCustomColumnValueToAllNestedTask(facade, tt[i], colName, value);
        }
    }

    private void removeCustomColumnToAllNestedTask(TaskContainmentHierarchyFacade facade, Task root, String colName) {
        Task[] tt = facade.getNestedTasks(root);
        for (int i = 0; i < tt.length; ++i) {
            tt[i].getCustomValues().removeCustomColumn(colName);
            this.removeCustomColumnToAllNestedTask(facade, tt[i], colName);
        }
    }

    private void renameCustomColumnForAllNestedTask(TaskContainmentHierarchyFacade facade, Task root, String oldName, String newName) {
        Task[] tt = facade.getNestedTasks(root);
        for (int i = 0; i < tt.length; ++i) {
            tt[i].getCustomValues().renameCustomColumn(oldName, newName);
            this.renameCustomColumnForAllNestedTask(facade, tt[i], oldName, newName);
        }
    }

    public void languageChanged(GanttLanguage.Event changeEvent) {
        TableColumnModel tcm = this.getTable().getColumnModel();
        this.reloadColumns();
    }

    String getIdForName(String colName) {
        String id = null;
        id = colName.equals(GanttTreeTableModel.strColType) ? "tpd0" : (colName.equals(GanttTreeTableModel.strColPriority) ? "tpd1" : (colName.equals(GanttTreeTableModel.strColInfo) ? "tpd2" : (colName.equals(GanttTreeTableModel.strColName) ? "tpd3" : (colName.equals(GanttTreeTableModel.strColBegDate) ? "tpd4" : (colName.equals(GanttTreeTableModel.strColEndDate) ? "tpd5" : (colName.equals(GanttTreeTableModel.strColDuration) ? "tpd6" : (colName.equals(GanttTreeTableModel.strColCompletion) ? "tpd7" : (colName.equals(GanttTreeTableModel.strColCoordinator) ? "tpd8" : (colName.equals(GanttTreeTableModel.strColPredecessors) ? "tpd9" : (colName.equals(GanttTreeTableModel.strColID) ? "tpd10" : this.getProject().getCustomColumnsStorage().getIdFromName(colName)))))))))));
        return id;
    }

    private String getNameForId(String id) {
        String name = null;
        name = id.equals("tpd0") ? GanttTreeTableModel.strColType : (id.equals("tpd1") ? GanttTreeTableModel.strColPriority : (id.equals("tpd2") ? GanttTreeTableModel.strColInfo : (id.equals("tpd3") ? GanttTreeTableModel.strColName : (id.equals("tpd4") ? GanttTreeTableModel.strColBegDate : (id.equals("tpd5") ? GanttTreeTableModel.strColEndDate : (id.equals("tpd6") ? GanttTreeTableModel.strColDuration : (id.equals("tpd7") ? GanttTreeTableModel.strColCompletion : (id.equals("tpd8") ? GanttTreeTableModel.strColCoordinator : (id.equals("tpd9") ? GanttTreeTableModel.strColPredecessors : (id.equals("tpd10") ? GanttTreeTableModel.strColID : this.getProject().getCustomColumnsStorage().getNameFromId(id)))))))))));
        return name;
    }

    public JTree getTree() {
        return this.getTreeTable().getTree();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.scrollPane.getVerticalScrollBar();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void centerViewOnSelectedCell() {
        int row = this.getTable().getSelectedRow();
        int col = this.getTable().getEditingColumn();
        if (col == -1) {
            col = this.getTable().getSelectedColumn();
        }
        Rectangle rect = this.getTable().getCellRect(row, col, true);
        this.scrollPane.getHorizontalScrollBar().scrollRectToVisible(rect);
        this.scrollPane.getViewport().scrollRectToVisible(rect);
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.getTable().addMouseListener(mouseListener);
        this.getTree().addMouseListener(mouseListener);
        this.getTreeTable().getParent().addMouseListener(mouseListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        super.addKeyListener(keyListener);
        this.getTable().addKeyListener(keyListener);
        this.getTree().addKeyListener(keyListener);
    }

    void setDelay(TaskNode taskNode, Delay delay) {
        try {
            int indexInfo = this.getTable().getColumnModel().getColumnIndex(GanttTreeTableModel.strColInfo);
            indexInfo = this.getTable().convertColumnIndexToModel(indexInfo);
            this.ttModel.setValueAt(delay, taskNode, indexInfo);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void editNewTask(Task t) {
        TreePath selectedPath = this.getTree().getSelectionPath();
        int c = this.getTable().convertColumnIndexToView(this.getTable().getColumn((Object)GanttTreeTableModel.strColName).getModelIndex());
        NameCellEditor nameCellEditor = (NameCellEditor)this.getTable().getCellEditor(-1, c);
        this.getTreeTable().editCellAt(this.getTree().getRowForPath(selectedPath), c);
        nameCellEditor.requestFocus();
    }

    public void customColumsChange(CustomColumEvent event) {
        switch (event.getType()) {
            case 0: {
                this.addNewCustomColumn(event.getColumn());
                break;
            }
            case 1: {
                this.deleteCustomColumn(event.getColumn());
            }
        }
    }

    public TableHeaderUIFacade getVisibleFields() {
        return this.myVisibleFields;
    }

    static /* synthetic */ void access$800(GanttTreeTable x0) {
        x0.displayAllColumns();
    }

    static /* synthetic */ Point access$1000(GanttTreeTable x0) {
        return x0.clickPoint;
    }

    static {
        $assertionsDisabled = !GanttTreeTable.class.desiredAssertionStatus();
        language = GanttLanguage.getInstance();
    }

    class VisibleFieldsImpl
    implements TableHeaderUIFacade {
        VisibleFieldsImpl() {
        }

        public void add(String name, int order, int width) {
            DisplayedColumn newColumn = new DisplayedColumn(name);
            newColumn.setOrder(order);
            if (width >= 0) {
                newColumn.setWidth(width);
            }
            newColumn.setDisplayed(true);
            DisplayedColumnsList clone = (DisplayedColumnsList)GanttTreeTable.this.getDisplayColumns().clone();
            clone.add(newColumn);
            GanttTreeTable.this.setDisplayedColumns(clone);
        }

        public void clear() {
            GanttTreeTable.this.setDisplayedColumns(new DisplayedColumnsList());
        }

        public TableHeaderUIFacade.Column getField(int index) {
            return (TableHeaderUIFacade.Column)GanttTreeTable.this.getDisplayColumns().get(index);
        }

        public int getSize() {
            return GanttTreeTable.this.getDisplayColumns().size();
        }

        public void importData(TableHeaderUIFacade source) {
            this.clear();
            DisplayedColumnsList clone = (DisplayedColumnsList)GanttTreeTable.this.getDisplayColumns().clone();
            clone.clear();
            for (int i = 0; i < source.getSize(); ++i) {
                TableHeaderUIFacade.Column nextField = source.getField(i);
                DisplayedColumn newColumn = new DisplayedColumn(nextField.getName());
                newColumn.setID(nextField.getID());
                newColumn.setOrder(nextField.getOrder());
                if (nextField.getWidth() >= 0) {
                    newColumn.setWidth(nextField.getWidth());
                }
                newColumn.setDisplayed(true);
                clone.add(newColumn);
            }
            GanttTreeTable.this.setDisplayedColumns(clone);
        }
    }

    class ModelListener
    implements TableModelListener {
        ModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            Mediator.getGanttProjectSingleton().repaint();
        }
    }

    class NameCellEditor
    extends DefaultCellEditor {
        private JTextField field;

        public NameCellEditor() {
            super(new JTextField());
            this.field = null;
            this.field = (JTextField)this.editorComponent;
        }

        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            JTextField result = (JTextField)super.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
            result.selectAll();
            return result;
        }

        public void requestFocus() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ NameCellEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    NameCellEditor.access$1700(this.this$1).requestFocus();
                    NameCellEditor.access$1700(this.this$1).selectAll();
                }
            });
        }

        static /* synthetic */ JTextField access$1700(NameCellEditor x0) {
            return x0.field;
        }
    }

    class HeaderMouseListener
    extends MouseAdapter {
        boolean first = false;

        public void mousePressed(MouseEvent e) {
            this.handlePopupTrigger(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.handlePopupTrigger(e);
        }

        private void handlePopupTrigger(MouseEvent e) {
            if (e.isPopupTrigger()) {
                GanttTreeTable.this.createPopupMenu();
                Component c = (Component)e.getSource();
                GanttTreeTable.this.popupMenu.show(c, e.getX(), e.getY());
                GanttTreeTable.this.clickPoint = e.getPoint();
                CustomColumn cc = GanttTreeTable.this.getProject().getCustomColumnsStorage().getCustomColumn(GanttTreeTable.this.getTable().getColumnName(GanttTreeTable.this.getTable().columnAtPoint(e.getPoint())));
                if (cc != null) {
                    GanttTreeTable.this.jmiDeleteColumn.setEnabled(true);
                } else {
                    GanttTreeTable.this.jmiDeleteColumn.setEnabled(false);
                }
            }
        }
    }

    class ColumnKeeper
    implements ActionListener {
        private int index;
        private boolean isShown = true;
        protected TableColumn column;

        public ColumnKeeper(TableColumn tc) {
            this.column = tc;
            this.index = this.column.getModelIndex();
        }

        public void setInitIndex(int initIndex) {
            this.index = initIndex;
        }

        public int getInitIndex() {
            return this.index;
        }

        void hide() {
            GanttTreeTable.this.getTable().getColumnModel().removeColumn(this.column);
            this.isShown = false;
            String name = (String)this.column.getHeaderValue();
            String id = GanttTreeTable.this.getIdForName(name);
            Iterator it = GanttTreeTable.this.listDisplayedColumns.iterator();
            while (it.hasNext()) {
                DisplayedColumn dc = (DisplayedColumn)it.next();
                if (!dc.getID().equals(id)) continue;
                dc.setDisplayed(false);
            }
            GanttTreeTable.this.calculateWidth();
            GanttTreeTable.this.revalidate();
        }

        void show() {
            DisplayedColumn dc;
            boolean reloadInfo = false;
            GanttTreeTable.this.getTable().getColumnModel().addColumn(this.column);
            try {
                int columnViewIndexOld = this.index;
                int columnModelIndexActual = this.column.getModelIndex();
                if (this.column.getIdentifier().equals(GanttTreeTableModel.strColInfo)) {
                    reloadInfo = true;
                }
                int columnViewIndexActual = GanttTreeTable.this.getTable().convertColumnIndexToView(columnModelIndexActual);
                GanttTreeTable.this.getTable().moveColumn(columnViewIndexActual, columnViewIndexOld);
            }
            catch (IllegalArgumentException e) {
                this.index = GanttTreeTable.this.getTable().getModel().getColumnCount() - 1;
            }
            this.isShown = true;
            String name = (String)this.column.getHeaderValue();
            String id = GanttTreeTable.this.getIdForName(name);
            boolean found = false;
            Iterator it = GanttTreeTable.this.listDisplayedColumns.iterator();
            while (it.hasNext()) {
                dc = (DisplayedColumn)it.next();
                if (!dc.getID().equals(id)) continue;
                dc.setDisplayed(true);
                found = true;
            }
            if (!found && id != null) {
                dc = new DisplayedColumn(id);
                dc.setDisplayed(true);
                GanttTreeTable.this.listDisplayedColumns.add(dc);
            }
            if (reloadInfo && Mediator.getDelayManager() != null) {
                Mediator.getDelayManager().fireDelayObservation();
            }
            GanttTreeTable.this.calculateWidth();
            GanttTreeTable.this.revalidate();
        }

        public void actionPerformed(ActionEvent e) {
            Mediator.getGanttProjectSingleton().getUndoManager().undoableEdit("HIDE OR SHOW A COLUMN", new Runnable(this){
                private final /* synthetic */ ColumnKeeper this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (!ColumnKeeper.access$400(this.this$1)) {
                        this.this$1.show();
                    } else {
                        this.this$1.hide();
                    }
                    ColumnKeeper.access$1400(this.this$1).getTable().repaint();
                }
            });
        }

        static /* synthetic */ GanttTreeTable access$1400(ColumnKeeper x0) {
            return x0.GanttTreeTable.this;
        }
    }

    public class DisplayedColumn
    implements Comparable,
    TableHeaderUIFacade.Column {
        private String id = null;
        private boolean displayed = false;
        private int order = -1;
        private int width = 0;

        public DisplayedColumn(String id) {
            this.id = id;
        }

        public void setID(String id) {
            this.id = id;
        }

        public void setDisplayed(boolean disp) {
            this.displayed = disp;
        }

        public boolean isDisplayed() {
            return this.displayed;
        }

        public boolean isVisible() {
            return this.isDisplayed();
        }

        public String getName() {
            return GanttTreeTable.this.getNameForId(this.getID());
        }

        public String getID() {
            return this.id;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public Object clone() {
            DisplayedColumn dc = new DisplayedColumn(this.id);
            dc.setDisplayed(this.isDisplayed());
            dc.setOrder(this.getOrder());
            dc.setWidth(this.getWidth());
            return dc;
        }

        public String toString() {
            return "[ID = " + this.id + ", displayed = " + this.displayed + ", order = " + this.order + "]";
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 0;
            }
            if (o instanceof DisplayedColumn) {
                DisplayedColumn dc = (DisplayedColumn)o;
                if (this.order != dc.order) {
                    return this.order - dc.order;
                }
                return this.id.compareTo(dc.id);
            }
            return 0;
        }
    }

    public class DisplayedColumnsList
    extends ArrayList {
        public boolean isDisplayed(String name) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                DisplayedColumn dc = (DisplayedColumn)it.next();
                if (!GanttTreeTable.this.getNameForId(dc.getID()).equals(name)) continue;
                return dc.isDisplayed();
            }
            return false;
        }

        public int getOrderForName(String name) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                DisplayedColumn dc = (DisplayedColumn)it.next();
                if (!GanttTreeTable.this.getNameForId(dc.getID()).equals(name)) continue;
                return dc.getOrder();
            }
            return -1;
        }

        public String getNameForOrder(int order) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                DisplayedColumn dc = (DisplayedColumn)it.next();
                if (dc.getOrder() != order) continue;
                return GanttTreeTable.this.getNameForId(dc.getID());
            }
            return null;
        }

        public boolean add(Object o) {
            if (o instanceof DisplayedColumn) {
                DisplayedColumn dc1 = (DisplayedColumn)o;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    DisplayedColumn dc = (DisplayedColumn)it.next();
                    if (!dc.getID().equals(dc1.getID())) continue;
                    this.remove(dc);
                    return super.add(dc1);
                }
                return super.add(dc1);
            }
            return false;
        }

        public Object clone() {
            DisplayedColumnsList l = new DisplayedColumnsList();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                l.add(((DisplayedColumn)it.next()).clone());
            }
            return l;
        }
    }
}

