/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.ganttproject.GanttGraphicArea;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.GanttTask;
import net.sourceforge.ganttproject.GanttTreeTable;
import net.sourceforge.ganttproject.GanttTreeTableModel;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.ProjectEventListener;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.action.NewTaskAction;
import net.sourceforge.ganttproject.delay.Delay;
import net.sourceforge.ganttproject.delay.DelayObserver;
import net.sourceforge.ganttproject.font.Fonts;
import net.sourceforge.ganttproject.gui.TableHeaderUIFacade;
import net.sourceforge.ganttproject.gui.TaskTreeUIFacade;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.BlankLineNode;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskManagerImpl;
import net.sourceforge.ganttproject.task.TaskNode;
import net.sourceforge.ganttproject.task.algorithm.AdjustTaskBoundsAlgorithm;
import net.sourceforge.ganttproject.task.algorithm.RecalculateTaskScheduleAlgorithm;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyException;
import net.sourceforge.ganttproject.undo.GPUndoManager;

public class GanttTree2
extends JPanel
implements DragSourceListener,
DragGestureListener,
DelayObserver,
ProjectEventListener,
TaskTreeUIFacade {
    private TaskNode rootNode;
    private GanttTreeTableModel treeModel;
    private UIFacade myUIFacade;
    private GanttTreeTable treetable;
    private GanttGraphicArea area = null;
    private GanttProject appli;
    private static final int AUTOSCROLL_MARGIN = 12;
    private JScrollBar vbar;
    private JScrollBar hbar;
    private GanttLanguage language = GanttLanguage.getInstance();
    private int nbTasks = 0;
    private TreePath dragPath = null;
    private BufferedImage ghostImage = null;
    private Point offsetPoint = new Point();
    private final TaskManager myTaskManager;
    private final GPAction myIndentAction = new GPAction(){

        protected String getIconFilePrefix() {
            return "indent_";
        }

        public void actionPerformed(ActionEvent e) {
            GanttTree2.this.indentCurrentNodes();
        }

        protected String getLocalizedName() {
            return this.getI18n("indentTask");
        }
    };
    private final GPAction myDedentAction = new GPAction(){

        protected String getIconFilePrefix() {
            return "unindent_";
        }

        public void actionPerformed(ActionEvent e) {
            GanttTree2.this.dedentCurrentNodes();
        }

        protected String getLocalizedName() {
            return this.getI18n("dedentTask");
        }
    };
    private final GPAction myMoveUpAction = new GPAction(){

        protected String getIconFilePrefix() {
            return "up_";
        }

        public void actionPerformed(ActionEvent e) {
            GanttTree2.this.upCurrentNodes();
        }

        protected String getLocalizedName() {
            return this.getI18n("upTask");
        }
    };
    private final GPAction myMoveDownAction = new GPAction(){

        protected String getIconFilePrefix() {
            return "down_";
        }

        public void actionPerformed(ActionEvent e) {
            GanttTree2.this.downCurrentNodes();
        }

        protected String getLocalizedName() {
            return this.getI18n("downTask");
        }
    };
    private Action myLinkTasksAction;
    private Action myUnlinkTasksAction;
    private List hiddenTask = new ArrayList();
    private DefaultMutableTreeNode cpNode;
    private ArrayList cpNodesArrayList;
    private ArrayList allNodes;
    private ArrayList cpDependencies;
    private Map mapOriginalIDCopyID;
    int where = -1;
    private Action myTaskPropertiesAction;

    public GanttTree2(final GanttProject app, TaskManager taskManager, UIFacade uiFacade) {
        app.getProject().addProjectEventListener(this);
        this.myUIFacade = uiFacade;
        this.myTaskManager = taskManager;
        this.appli = app;
        this.initRootNode();
        this.treeModel = new GanttTreeTableModel(this.rootNode);
        this.treeModel.addTreeModelListener(new GanttTreeModelListener());
        this.treetable = new GanttTreeTable(app.getProject(), uiFacade, this.treeModel);
        this.treetable.getActionMap().put(this.myIndentAction.getValue("Name"), this.myIndentAction);
        this.treetable.getActionMap().put(this.myDedentAction.getValue("Name"), this.myDedentAction);
        this.treetable.getInputMap().put(KeyStroke.getKeyStroke(9, 0), this.myIndentAction.getValue("Name"));
        this.treetable.getInputMap().put(KeyStroke.getKeyStroke(9, 64), this.myDedentAction.getValue("Name"));
        this.treetable.getActionMap().put("newTask", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (GanttTree2.this.getSelectedTask() != null) {
                    GanttTree2.this.setEditingTask(GanttTree2.this.getSelectedTask());
                }
                Mediator.getGanttProjectSingleton().getUndoManager().undoableEdit("New Task", new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Task t = Mediator.getGanttProjectSingleton().newTask();
                        5.access$200(this.this$1).setEditingTask(t);
                    }
                });
            }

            static /* synthetic */ GanttTree2 access$200(5 x0) {
                return x0.GanttTree2.this;
            }
        });
        this.treetable.getInputMap(2).put(GPAction.getKeyStroke("newArtifact.shortcut"), "newTask");
        this.treetable.getInputMap(2).put(KeyStroke.getKeyStroke(88, 512), "cutTask");
        this.treetable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!GanttTree2.this.treetable.getTable().isEditing()) {
                    app.keyPressed(e);
                }
            }
        });
        this.treetable.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                Mediator.getTaskSelectionManager().clear();
                TaskNode[] tn = GanttTree2.this.getSelectedTaskNodes();
                if (tn != null) {
                    for (int i = 0; i < tn.length; ++i) {
                        Mediator.getTaskSelectionManager().addTask((Task)tn[i].getUserObject());
                    }
                }
            }
        });
        this.treetable.setBackground(new Color(1.0f, 1.0f, 1.0f));
        this.treetable.getTree().addTreeExpansionListener(new GanttTreeExpansionListener());
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.treetable));
        JScrollPane scrollpane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.add((Component)scrollpane, "Center");
        scrollpane.getViewport().add((Component)((Object)this.treetable));
        scrollpane.setVerticalScrollBarPolicy(21);
        this.vbar = this.treetable.getVerticalScrollBar();
        final JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)this.vbar, "Center");
        jp.setBorder(BorderFactory.createEtchedBorder(1));
        jp.setVisible(false);
        this.vbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (GanttTree2.this.treetable.getSize().getHeight() - 20.0 < (double)e.getAdjustable().getMaximum()) {
                    jp.setVisible(true);
                } else {
                    jp.setVisible(false);
                }
                GanttTree2.this.repaint();
            }
        });
        this.add((Component)jp, "West");
        this.hbar = scrollpane.getHorizontalScrollBar();
        this.vbar.addAdjustmentListener(new GanttAdjustmentListener());
        MouseAdapter ml = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                this.handlePopupTrigger(e);
            }

            public void mousePressed(MouseEvent e) {
                this.handlePopupTrigger(e);
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    TreePath selPath = GanttTree2.this.treetable.getTreeTable().getPathForLocation(e.getX(), e.getY());
                    if (selPath != null) {
                        e.consume();
                        GanttTree2.this.appli.propertiesTask();
                    }
                } else {
                    this.handlePopupTrigger(e);
                }
            }

            private void handlePopupTrigger(MouseEvent e) {
                if (e.isPopupTrigger() || e.getButton() == 3) {
                    TreePath selPath = GanttTree2.this.treetable.getTreeTable().getPathForLocation(e.getX(), e.getY());
                    if (selPath != null) {
                        TreePath[] currentSelection = GanttTree2.this.treetable.getTree().getSelectionPaths();
                        if (currentSelection == null || currentSelection.length == 0) {
                            GanttTree2.this.treetable.getTree().setSelectionPath(selPath);
                        } else {
                            boolean contains = false;
                            for (int i = 0; i < currentSelection.length && !contains; ++i) {
                                if (currentSelection[i] != selPath) continue;
                                contains = true;
                            }
                            if (!contains) {
                                GanttTree2.this.treetable.getTree().setSelectionPath(selPath);
                            }
                        }
                        GanttTree2.this.createPopupMenu(e.getX(), e.getY(), true);
                    } else {
                        GanttTree2.this.treetable.getTree().setSelectionPath(null);
                        GanttTree2.this.createPopupMenu(e.getX(), e.getY(), false);
                    }
                    e.consume();
                }
            }
        };
        if (!app.isOnlyViewer) {
            this.treetable.addMouseListener(ml);
        }
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer((Component)((Object)this.treetable), 3, this);
        dragSource.addDragSourceListener(this);
        DropTarget dropTarget = new DropTarget((Component)((Object)this.treetable), new GanttTreeDropListener());
        dropTarget.setDefaultActions(3);
        this.getTreeTable().setToolTipText("aze");
        this.getTreeTable().getTreeTable().setToolTipText("rty");
    }

    public void setActions() {
        this.treetable.setAction(this.appli.getCopyAction());
        this.treetable.setAction(this.appli.getPasteAction());
        this.treetable.setAction(this.appli.getCutAction());
        this.treetable.addAction(this.myIndentAction, KeyStroke.getKeyStroke(9, 0));
        this.treetable.addAction(this.myDedentAction, KeyStroke.getKeyStroke(9, 64));
    }

    public void setEditingTask(Task t) {
        this.selectTask(t, false);
        TreePath tp = new TreePath(this.getSelectedTaskNode().getPath());
        int c = this.getTable().convertColumnIndexToView(this.getTable().getColumn(GanttTreeTableModel.strColName).getModelIndex());
        this.treetable.getTreeTable().editingStopped(new ChangeEvent(this.treetable.getTreeTable()));
        this.treetable.editNewTask(t);
        this.treetable.centerViewOnSelectedCell();
    }

    public void stopEditing() {
        this.treetable.getTable().editingCanceled(new ChangeEvent(this.treetable.getTreeTable()));
        this.treetable.getTreeTable().editingCanceled(new ChangeEvent(this.treetable.getTreeTable()));
    }

    public void changeLanguage(GanttLanguage ganttLanguage) {
        this.language = ganttLanguage;
    }

    private void initRootNode() {
        this.getTaskManager().getRootTask().setName("root");
        this.rootNode = new TaskNode(this.getTaskManager().getRootTask());
    }

    public Action[] getPopupMenuActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new NewTaskAction(this.appli));
        if (!Mediator.getTaskSelectionManager().getSelectedTasks().isEmpty()) {
            actions.add(this.getTaskPropertiesAction());
            actions.add(this.createMenuAction(GanttProject.correctLabel(this.language.getText("deleteTask")), "/icons/delete_16.gif"));
            actions.add(null);
            actions.add(this.myIndentAction);
            actions.add(this.myDedentAction);
            actions.add(this.getMoveUpAction());
            actions.add(this.getMoveDownAction());
            actions.add(null);
            actions.add(this.getUnlinkTasksAction());
            actions.add(this.getLinkTasksAction());
            actions.add(null);
            actions.add(this.appli.getCutAction());
            actions.add(this.appli.getCopyAction());
            actions.add(this.appli.getPasteAction());
        }
        return actions.toArray(new Action[0]);
    }

    private Action createMenuAction(String label, String iconPath) {
        AbstractAction result = new AbstractAction(label, new ImageIcon(this.getClass().getResource(iconPath))){

            public void actionPerformed(ActionEvent e) {
                GanttTree2.this.appli.actionPerformed(e);
            }
        };
        return result;
    }

    private void createPopupMenu(int x, int y, boolean all) {
        JPopupMenu menu = new JPopupMenu();
        Action[] popupMenuActions = this.getPopupMenuActions();
        this.myUIFacade.showPopupMenu(this, popupMenuActions, x - this.hbar.getValue() + (this.vbar.isVisible() ? this.vbar.getWidth() : 0), y - this.vbar.getValue() + 20);
    }

    public void setGraphicArea(GanttGraphicArea area) {
        this.area = area;
    }

    public DefaultMutableTreeNode addObjectWithExpand(Object child, DefaultMutableTreeNode parent) {
        TaskNode childNode = new TaskNode((Task)child);
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        Task task = (Task)((DefaultMutableTreeNode)childNode).getUserObject();
        boolean res = true;
        if (parent == null) {
            res = false;
        }
        while (parent != null) {
            Task taskFather = (Task)parent.getUserObject();
            if (!taskFather.getExpand()) {
                res = false;
                break;
            }
            parent = (DefaultMutableTreeNode)parent.getParent();
        }
        this.treetable.getTree().scrollPathToVisible(new TreePath(childNode.getPath()));
        if (!res && parent != null) {
            this.treetable.getTree().collapsePath(new TreePath(parent.getPath()));
        }
        ++this.nbTasks;
        this.appli.refreshProjectInfos();
        return childNode;
    }

    public void addBlankLine(DefaultMutableTreeNode select, int index) {
        this.treeModel.insertNodeInto(new BlankLineNode(), select == null ? this.getRoot() : (DefaultMutableTreeNode)select.getParent(), index == -1 ? this.getRoot().getChildCount() : index);
        this.appli.setAskForSave(true);
    }

    public TaskNode addObject(Object child, MutableTreeNode parent, int index) {
        TaskNode childNode = new TaskNode((Task)child);
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, index == -1 ? parent.getChildCount() : index);
        this.treetable.getTree().scrollPathToVisible(new TreePath(childNode.getPath()));
        ++this.nbTasks;
        this.appli.refreshProjectInfos();
        return childNode;
    }

    private GanttTask getSelectedTask() {
        DefaultMutableTreeNode node = this.getSelectedTaskNode();
        if (node == null) {
            return null;
        }
        return (GanttTask)node.getUserObject();
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath currentSelection = this.treetable.getTree().getSelectionPath();
        if (currentSelection == null) {
            return null;
        }
        DefaultMutableTreeNode dmtnselected = (DefaultMutableTreeNode)currentSelection.getLastPathComponent();
        return dmtnselected;
    }

    private DefaultMutableTreeNode getSelectedTaskNode() {
        TreePath currentSelection = this.treetable.getTree().getSelectionPath();
        if (currentSelection == null || !(currentSelection.getLastPathComponent() instanceof TaskNode)) {
            return null;
        }
        DefaultMutableTreeNode dmtnselected = (DefaultMutableTreeNode)currentSelection.getLastPathComponent();
        return dmtnselected;
    }

    public TaskNode[] getSelectedTaskNodes() {
        TreePath[] currentSelection = this.treetable.getTree().getSelectionPaths();
        if (currentSelection == null || currentSelection.length == 0) {
            return null;
        }
        DefaultMutableTreeNode[] dmtnselected = new DefaultMutableTreeNode[currentSelection.length];
        for (int i = 0; i < currentSelection.length; ++i) {
            dmtnselected[i] = (DefaultMutableTreeNode)currentSelection[i].getLastPathComponent();
        }
        TaskNode[] res = this.getOnlyTaskNodes(dmtnselected);
        return res;
    }

    public DefaultMutableTreeNode[] getSelectedNodes() {
        TreePath[] currentSelection = this.treetable.getTree().getSelectionPaths();
        if (currentSelection == null || currentSelection.length == 0) {
            return null;
        }
        DefaultMutableTreeNode[] dmtnselected = new DefaultMutableTreeNode[currentSelection.length];
        for (int i = 0; i < currentSelection.length; ++i) {
            dmtnselected[i] = (DefaultMutableTreeNode)currentSelection[i].getLastPathComponent();
        }
        DefaultMutableTreeNode[] res = dmtnselected;
        return res;
    }

    private TaskNode[] getOnlyTaskNodes(DefaultMutableTreeNode[] array) {
        ArrayList<DefaultMutableTreeNode> resAsList = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < array.length; ++i) {
            DefaultMutableTreeNode next = array[i];
            if (!(next instanceof TaskNode)) continue;
            resAsList.add(next);
        }
        return resAsList.toArray(new TaskNode[0]);
    }

    public DefaultMutableTreeNode getNode(int id) {
        DefaultMutableTreeNode base = (DefaultMutableTreeNode)this.treetable.getTreeTableModel().getRoot();
        Enumeration<TreeNode> e = base.preorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode res = (DefaultMutableTreeNode)e.nextElement();
            if (!(res instanceof TaskNode) || ((Task)res.getUserObject()).getTaskID() != id) continue;
            return res;
        }
        return null;
    }

    public static List convertNodesListToItemList(List nodesList) {
        ArrayList<Object> res = new ArrayList<Object>(nodesList.size());
        Iterator itNodes = nodesList.iterator();
        while (itNodes.hasNext()) {
            res.add(((DefaultMutableTreeNode)itNodes.next()).getUserObject());
        }
        return res;
    }

    public boolean hasTasks() {
        Enumeration<TreeNode> e = this.rootNode.preorderEnumeration();
        while (e.hasMoreElements()) {
            TreeNode next = e.nextElement();
            if (this.rootNode == (DefaultMutableTreeNode)next || !(next instanceof TaskNode)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getAllTasks() {
        ArrayList<TreeNode> res = new ArrayList<TreeNode>();
        Enumeration<TreeNode> enumeration = this.rootNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode o = enumeration.nextElement();
            if (!(o instanceof TaskNode)) continue;
            res.add(o);
        }
        return res;
    }

    public List getAllVisibleNodes() {
        ArrayList<DefaultMutableTreeNode> res = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = this.rootNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode o = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!this.getTreeTable().getTree().isVisible(new TreePath(o.getPath()))) continue;
            res.add(o);
        }
        return res;
    }

    public ArrayList getAllChildTask(Task task) {
        ArrayList<TreeNode> res = new ArrayList<TreeNode>();
        if (task == null) {
            return null;
        }
        DefaultMutableTreeNode base = this.getNode(task.getTaskID());
        if (base == null) {
            return res;
        }
        Enumeration<TreeNode> e = base.children();
        while (e.hasMoreElements()) {
            res.add(e.nextElement());
        }
        return res;
    }

    public ArrayList getAllChildTask(DefaultMutableTreeNode base) {
        ArrayList<TreeNode> res = new ArrayList<TreeNode>();
        if (base == null || !(base instanceof TaskNode)) {
            return res;
        }
        Enumeration<TreeNode> e = base.children();
        while (e.hasMoreElements()) {
            TreeNode next = e.nextElement();
            if (!(next instanceof TaskNode)) continue;
            res.add(next);
        }
        return res;
    }

    public DefaultMutableTreeNode getLastNode() {
        return this.rootNode.getLastLeaf();
    }

    void removeCurrentNode(DefaultMutableTreeNode currentNode) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)currentNode.getParent();
        this.getTaskManager().deleteTask((Task)currentNode.getUserObject());
        if (parent != null) {
            this.treeModel.removeNodeFromParent(currentNode);
            this.forwardScheduling();
            --this.nbTasks;
            this.appli.refreshProjectInfos();
            return;
        }
    }

    public void clearTree() {
        this.rootNode.removeAllChildren();
        this.initRootNode();
        this.treeModel.setRoot(this.rootNode);
        this.treeModel.reload();
        this.nbTasks = 0;
        this.hiddenTask.clear();
    }

    public void selectTreeRow(int row) {
        this.treetable.getTree().setSelectionRow(row);
    }

    public void selectTasks(List tasksList) {
        boolean multi = false;
        Iterator it = tasksList.iterator();
        if (it.hasNext()) {
            this.selectTask((Task)it.next(), false);
        }
        while (it.hasNext()) {
            this.selectTask((Task)it.next(), true);
        }
    }

    public void selectTask(Task task, boolean multipleSelection) {
        DefaultMutableTreeNode taskNode = null;
        Enumeration<TreeNode> nodes = this.rootNode.preorderEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)nodes.nextElement();
            if (!(nextNode instanceof TaskNode) || !nextNode.getUserObject().equals(task)) continue;
            taskNode = nextNode;
            break;
        }
        if (taskNode != null) {
            TreePath taskPath = new TreePath(taskNode.getPath());
            if (multipleSelection) {
                if (this.treetable.getTree().getSelectionModel().isPathSelected(taskPath)) {
                    this.treetable.getTree().getSelectionModel().removeSelectionPath(taskPath);
                } else {
                    this.treetable.getTree().getSelectionModel().addSelectionPath(taskPath);
                }
            } else {
                this.treetable.getTree().getSelectionModel().setSelectionPath(taskPath);
            }
        }
        TreePath[] paths = this.treetable.getTree().getSelectionModel().getSelectionPaths();
        Mediator.getTaskSelectionManager().clear();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                TaskNode tn = (TaskNode)paths[i].getLastPathComponent();
                if (tn.isRoot()) continue;
                Mediator.getTaskSelectionManager().addTask((Task)tn.getUserObject());
            }
        }
    }

    public DefaultMutableTreeNode getFatherNode(Task node) {
        if (node == null) {
            return null;
        }
        DefaultMutableTreeNode tmp = this.getNode(node.getTaskID());
        if (tmp == null) {
            return null;
        }
        return (DefaultMutableTreeNode)tmp.getParent();
    }

    public DefaultMutableTreeNode getFatherNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        return (DefaultMutableTreeNode)node.getParent();
    }

    public JTree getJTree() {
        return this.treetable.getTree();
    }

    public JTable getTable() {
        return this.treetable.getTable();
    }

    public GanttTreeTable getTreeTable() {
        return this.treetable;
    }

    public Set getHiddenTasks() {
        HashSet<Object> result = new HashSet<Object>();
        for (int i = 0; i < this.hiddenTask.size(); ++i) {
            HiddenTask next = (HiddenTask)this.hiddenTask.get(i);
            result.add(next.getNode().getUserObject());
        }
        return result;
    }

    public void hideSelectedNodes() {
        int i;
        DefaultMutableTreeNode[] t = this.getSelectedNodes();
        for (i = 0; i < t.length; ++i) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)t[i].getParent();
            this.hiddenTask.add(new HiddenTask(t[i], parent, parent.getIndex(t[i])));
        }
        for (i = 0; i < this.hiddenTask.size(); ++i) {
            HiddenTask ht = (HiddenTask)this.hiddenTask.get(i);
            TreeNode parent = ht.node.getParent();
            if (parent == null) continue;
            ((GanttTreeTableModel)this.getTreeTable().getTreeTableModel()).removeNodeFromParent(((HiddenTask)this.hiddenTask.get(i)).getNode());
        }
    }

    public void displayHiddenTasks() {
        DefaultMutableTreeNode parent;
        DefaultMutableTreeNode node;
        HiddenTask ht;
        int i;
        for (i = 0; i < this.hiddenTask.size(); ++i) {
            ht = (HiddenTask)this.hiddenTask.get(i);
            node = ht.getNode();
            parent = ht.getParent();
            node.setParent(parent);
        }
        Collections.sort(this.hiddenTask);
        for (i = 0; i < this.hiddenTask.size(); ++i) {
            ht = (HiddenTask)this.hiddenTask.get(i);
            node = ht.getNode();
            parent = ht.getParent();
            int index = ht.getIndex();
            node.setParent(null);
            ((GanttTreeTableModel)this.getTreeTable().getTreeTableModel()).insertNodeInto(node, parent, index);
            if (!(node instanceof TaskNode)) continue;
            this.restoreExpand((TaskNode)node);
        }
        this.hiddenTask.clear();
    }

    private void restoreExpand(TaskNode node) {
        Task task = (Task)node.getUserObject();
        boolean expand = task.getExpand();
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            this.restoreExpand((TaskNode)enumeration.nextElement());
        }
        if (expand) {
            this.getTreeTable().getTree().expandPath(new TreePath(node.getPath()));
        } else {
            this.getTreeTable().getTree().collapsePath(new TreePath(node.getPath()));
        }
        task.setExpand(expand);
    }

    public DefaultMutableTreeNode getRoot() {
        return this.rootNode;
    }

    public void upCurrentNodes() {
        final DefaultMutableTreeNode[] cdmtn = this.getSelectedNodes();
        if (cdmtn == null) {
            this.myUIFacade.setStatusText(this.language.getText("msg21"));
            return;
        }
        TreePath[] selectedPaths = new TreePath[cdmtn.length];
        final GanttTree2 gt2 = this;
        this.appli.getUndoManager().undoableEdit("Up", new Runnable(){

            public void run() {
                for (int i = 0; i < cdmtn.length; ++i) {
                    int j;
                    DefaultMutableTreeNode father = gt2.getFatherNode(cdmtn[i]);
                    int index = father.getIndex(cdmtn[i]);
                    Task task = (Task)cdmtn[i].getUserObject();
                    if (--index < 0) continue;
                    DefaultMutableTreeNode[] child = new DefaultMutableTreeNode[cdmtn[i].getChildCount()];
                    if (task.getExpand()) {
                        for (j = 0; j < cdmtn[i].getChildCount(); ++j) {
                            child[j] = (DefaultMutableTreeNode)cdmtn[i].getChildAt(j);
                        }
                        for (j = 0; j < child.length; ++j) {
                            child[j].removeFromParent();
                            GanttTree2.this.treeModel.nodesWereRemoved(cdmtn[i], new int[]{0}, new Object[]{child});
                        }
                    }
                    cdmtn[i].removeFromParent();
                    GanttTree2.this.treeModel.nodesWereRemoved(father, new int[]{index + 1}, new Object[]{cdmtn});
                    father.insert(cdmtn[i], index);
                    GanttTree2.this.treeModel.nodesWereInserted(father, new int[]{index});
                    if (task.getExpand()) {
                        j = 0;
                        while (j < child.length) {
                            cdmtn[i].insert(child[j], j);
                            GanttTree2.this.treeModel.nodesWereInserted(cdmtn[i], new int[]{j++});
                        }
                    }
                    GanttTree2.this.forwardScheduling();
                }
            }
        });
        this.area.repaint();
    }

    public void downCurrentNodes() {
        final DefaultMutableTreeNode[] cdmtn = this.getSelectedNodes();
        if (cdmtn == null) {
            this.myUIFacade.setStatusText(this.language.getText("msg21"));
            return;
        }
        final GanttTree2 gt2 = this;
        this.appli.getUndoManager().undoableEdit("Down", new Runnable(){

            public void run() {
                for (int i = cdmtn.length - 1; i >= 0; --i) {
                    int j;
                    DefaultMutableTreeNode father = gt2.getFatherNode(cdmtn[i]);
                    int index = father.getIndex(cdmtn[i]);
                    Task task = (Task)cdmtn[i].getUserObject();
                    if (++index >= father.getChildCount()) continue;
                    DefaultMutableTreeNode[] child = new DefaultMutableTreeNode[cdmtn[i].getChildCount()];
                    if (task.getExpand()) {
                        for (j = 0; j < cdmtn[i].getChildCount(); ++j) {
                            child[j] = (DefaultMutableTreeNode)cdmtn[i].getChildAt(j);
                        }
                        for (j = 0; j < child.length; ++j) {
                            child[j].removeFromParent();
                            GanttTree2.this.treeModel.nodesWereRemoved(cdmtn[i], new int[]{0}, new Object[]{child});
                        }
                    }
                    cdmtn[i].removeFromParent();
                    GanttTree2.this.treeModel.nodesWereRemoved(father, new int[]{index - 1}, new Object[]{cdmtn});
                    father.insert(cdmtn[i], index);
                    GanttTree2.this.treeModel.nodesWereInserted(father, new int[]{index});
                    if (task.getExpand()) {
                        j = 0;
                        while (j < child.length) {
                            cdmtn[i].insert(child[j], j);
                            GanttTree2.this.treeModel.nodesWereInserted(cdmtn[i], new int[]{j++});
                        }
                    }
                    GanttTree2.this.forwardScheduling();
                }
            }
        });
        this.area.repaint();
    }

    public DefaultMutableTreeNode removeChild(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode nodeCopy = new DefaultMutableTreeNode(node.getUserObject());
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            DefaultMutableTreeNode childCopy = this.removeChild(child);
            nodeCopy.add(childCopy);
            child.removeFromParent();
            this.treeModel.nodesWereRemoved(node, new int[]{0}, new Object[]{child});
        }
        return nodeCopy;
    }

    public void insertChild(DefaultMutableTreeNode node, DefaultMutableTreeNode copy) {
        Enumeration<TreeNode> children = copy.children();
        int index = 0;
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode childCopy = (DefaultMutableTreeNode)children.nextElement();
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(childCopy.getUserObject());
            node.insert(child, index);
            this.treeModel.nodesWereInserted(node, new int[]{index++});
            this.insertChild(child, childCopy);
        }
    }

    private void indentCurrentNodes() {
        final DefaultMutableTreeNode[] cdmtn = this.getSelectedTaskNodes();
        if (cdmtn == null) {
            this.myUIFacade.setStatusText(this.language.getText("msg21"));
            return;
        }
        final GanttTree2 gt2 = this;
        this.getUndoManager().undoableEdit("Indent", new Runnable(){

            public void run() {
                TreePath[] selectedPaths = new TreePath[cdmtn.length];
                for (int i = 0; i < cdmtn.length; ++i) {
                    DefaultMutableTreeNode father = gt2.getFatherNode(cdmtn[i]);
                    DefaultMutableTreeNode newFather = cdmtn[i].getPreviousSibling();
                    if (newFather == null || !(newFather instanceof TaskNode) || !(cdmtn[i] instanceof TaskNode) || !(newFather instanceof TaskNode)) continue;
                    Task nextTask = (Task)cdmtn[i].getUserObject();
                    Task container = (Task)newFather.getUserObject();
                    GanttTree2.this.getTaskManager().getTaskHierarchy().move(nextTask, container);
                }
                GanttTree2.this.area.repaint();
                GanttTree2.this.appli.repaint2();
            }
        });
    }

    public void dedentCurrentNodes() {
        final DefaultMutableTreeNode[] cdmtn = this.getSelectedTaskNodes();
        if (cdmtn == null) {
            this.myUIFacade.setStatusText(this.language.getText("msg21"));
            return;
        }
        final GanttTree2 gt2 = this;
        this.getUndoManager().undoableEdit("Dedent", new Runnable(){

            public void run() {
                TreePath[] selectedPaths = new TreePath[cdmtn.length];
                for (int i = 0; i < cdmtn.length; ++i) {
                    TreePath path;
                    DefaultMutableTreeNode father = gt2.getFatherNode(cdmtn[i]);
                    DefaultMutableTreeNode newFather = gt2.getFatherNode(father);
                    if (newFather == null) {
                        return;
                    }
                    int oldIndex = father.getIndex(cdmtn[i]);
                    cdmtn[i].removeFromParent();
                    GanttTree2.this.treeModel.nodesWereRemoved(father, new int[]{oldIndex}, new Object[]{cdmtn});
                    GanttTree2.this.treeModel.insertNodeInto(cdmtn[i], newFather, newFather.getIndex(father) + 1);
                    Object[] treepath = cdmtn[i].getPath();
                    selectedPaths[i] = path = new TreePath(treepath);
                    GanttTree2.this.expandRefresh(cdmtn[i]);
                    GanttTree2.this.forwardScheduling();
                    if (father.getChildCount() != 0) continue;
                    ((Task)father.getUserObject()).setProjectTask(false);
                }
                GanttTree2.this.treetable.getTree().setSelectionPaths(selectedPaths);
                GanttTree2.this.area.repaint();
            }
        });
    }

    public void expandRefresh(DefaultMutableTreeNode moved) {
        if (moved instanceof TaskNode) {
            Task movedTask = (Task)moved.getUserObject();
            if (movedTask.getExpand()) {
                this.treetable.getTree().expandPath(new TreePath(moved.getPath()));
            }
            Enumeration<TreeNode> children = moved.children();
            while (children.hasMoreElements()) {
                this.expandRefresh((DefaultMutableTreeNode)children.nextElement());
            }
        }
    }

    public void refreshAllChild(String taskToMove) {
        this.forwardScheduling();
    }

    public void cutSelectedNode() {
        TreePath currentSelection = this.treetable.getTree().getSelectionPath();
        final DefaultMutableTreeNode[] cdmtn = this.getSelectedNodes();
        if (currentSelection != null) {
            this.getUndoManager().undoableEdit("Cut", new Runnable(){

                public void run() {
                    GanttTree2.this.cpNodesArrayList = new ArrayList();
                    GanttTree2.this.cpAllDependencies(cdmtn);
                    GanttTask taskFather = null;
                    DefaultMutableTreeNode father = null;
                    DefaultMutableTreeNode current = null;
                    for (int i = 0; i < cdmtn.length; ++i) {
                        current = GanttTree2.this.getSelectedTaskNode();
                        if (current == null) continue;
                        GanttTree2.this.cpNodesArrayList.add(cdmtn[i]);
                        father = GanttTree2.this.getFatherNode(current);
                        GanttTree2.this.where = father.getIndex(current);
                        GanttTree2.this.removeCurrentNode(current);
                        current.setParent(father);
                        taskFather = (GanttTask)father.getUserObject();
                        AdjustTaskBoundsAlgorithm alg = GanttTree2.this.getTaskManager().getAlgorithmCollection().getAdjustTaskBoundsAlgorithm();
                        alg.run(taskFather);
                        father.setUserObject(taskFather);
                    }
                    if (father.getChildCount() == 0) {
                        ((Task)father.getUserObject()).setProjectTask(false);
                    }
                    if (taskFather != null) {
                        GanttTree2.this.selectTask(taskFather, false);
                    }
                    GanttTree2.this.area.repaint();
                }
            });
            this.appli.repaint();
        }
    }

    public void copySelectedNode() {
        TreePath currentSelection = this.treetable.getTree().getSelectionPath();
        this.cpNodesArrayList = new ArrayList();
        if (currentSelection != null) {
            DefaultMutableTreeNode[] cdmtn = this.getSelectedNodes();
            this.cpAllDependencies(cdmtn);
            for (int i = 0; i < cdmtn.length; ++i) {
                boolean isNodeDescendant = false;
                for (int j = 0; j < this.cpNodesArrayList.size(); ++j) {
                    if (!cdmtn[i].isNodeDescendant((DefaultMutableTreeNode)this.cpNodesArrayList.get(j))) continue;
                    isNodeDescendant = true;
                }
                if (isNodeDescendant) continue;
                this.cpNodesArrayList.add(cdmtn[i]);
            }
        }
    }

    public void pasteNode() {
        if (this.cpNodesArrayList != null) {
            GanttTree2 gt2 = this;
            this.getUndoManager().undoableEdit("Paste", new Runnable(){

                public void run() {
                    int i;
                    TaskNode current = (TaskNode)GanttTree2.this.treetable.getTree().getLastSelectedPathComponent();
                    ArrayList<Task> tasksList = new ArrayList<Task>();
                    if (current == null) {
                        current = GanttTree2.this.rootNode;
                    }
                    boolean isAProjectTaskChild = false;
                    for (DefaultMutableTreeNode father = (DefaultMutableTreeNode)current.getParent(); father != null; father = (DefaultMutableTreeNode)father.getParent()) {
                        if (!((Task)father.getUserObject()).isProjectTask()) continue;
                        isAProjectTaskChild = true;
                    }
                    GanttTree2.this.mapOriginalIDCopyID = new HashMap();
                    TaskManagerImpl tmi = (TaskManagerImpl)GanttTree2.this.getTaskManager();
                    int MaxID = tmi.getMaxID();
                    for (i = GanttTree2.this.cpNodesArrayList.size() - 1; i >= 0; --i) {
                        if (isAProjectTaskChild) {
                            ((Task)((TaskNode)GanttTree2.this.cpNodesArrayList.get(i)).getUserObject()).setProjectTask(false);
                        }
                        DefaultMutableTreeNode sel = GanttTree2.this.getSelectedTaskNode();
                        TreeNode parent = null;
                        if (sel != null && (parent = sel.getParent()) != null) {
                            GanttTree2.this.where = parent.getIndex(sel);
                        }
                        tasksList.add((Task)GanttTree2.this.insertClonedNode(current == GanttTree2.this.rootNode ? current : (DefaultMutableTreeNode)current.getParent(), (DefaultMutableTreeNode)GanttTree2.this.cpNodesArrayList.get(i), GanttTree2.this.where + 1, true).getUserObject());
                        GanttTree2.this.nbTasks++;
                    }
                    if (GanttTree2.this.cpDependencies != null) {
                        for (i = 0; i < GanttTree2.this.cpDependencies.size(); ++i) {
                            TaskDependency td = (TaskDependency)GanttTree2.this.cpDependencies.get(i);
                            Task dependee = td.getDependee();
                            Task dependant = td.getDependant();
                            TaskDependencyConstraint constraint = td.getConstraint();
                            for (int j = 0; j < GanttTree2.this.allNodes.size(); ++j) {
                                for (int k = 0; k < GanttTree2.this.allNodes.size(); ++k) {
                                    if (!dependant.equals((Task)((DefaultMutableTreeNode)GanttTree2.this.allNodes.get(j)).getUserObject()) || !dependee.equals((Task)((DefaultMutableTreeNode)GanttTree2.this.allNodes.get(k)).getUserObject())) continue;
                                    try {
                                        TaskDependency newDependency = GanttTree2.this.getTaskManager().getDependencyCollection().createDependency(GanttTree2.this.getTaskManager().getTask((Integer)GanttTree2.this.mapOriginalIDCopyID.get(new Integer(dependant.getTaskID()))), GanttTree2.this.getTaskManager().getTask((Integer)GanttTree2.this.mapOriginalIDCopyID.get(new Integer(dependee.getTaskID()))), GanttTree2.this.getTaskManager().createConstraint(constraint.getID()));
                                        newDependency.setDifference(td.getDifference());
                                        newDependency.setHardness(td.getHardness());
                                        continue;
                                    }
                                    catch (TaskDependencyException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                    GanttTree2.this.selectTasks(tasksList);
                }
            });
            this.appli.refreshProjectInfos();
        }
    }

    private TaskNode insertClonedNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode child, int location, boolean first) {
        GanttTask _t;
        if (parent == null) {
            return null;
        }
        if (first && (_t = (GanttTask)parent.getUserObject()).isMilestone()) {
            _t.setMilestone(false);
            GanttTask _c = (GanttTask)child.getUserObject();
            _t.setLength(_c.getLength());
            _t.setStart(_c.getStart());
        }
        GanttTask originalTask = (GanttTask)child.getUserObject();
        GanttTask newTask = originalTask.Clone();
        newTask.setName((first ? this.language.getText("copy2") + "_" : "") + newTask.toString());
        TaskManagerImpl tmi = (TaskManagerImpl)this.getTaskManager();
        newTask.setTaskID(tmi.getMaxID() + 1);
        this.mapOriginalIDCopyID.put(new Integer(originalTask.getTaskID()), new Integer(newTask.getTaskID()));
        ResourceAssignment[] assignment = newTask.getAssignments();
        for (int i = 0; i < assignment.length; ++i) {
            assignment[i].delete();
        }
        this.getTaskManager().registerTask(newTask);
        TaskNode cloneChildNode = new TaskNode(newTask);
        for (int i = 0; i < child.getChildCount(); ++i) {
            this.insertClonedNode(cloneChildNode, (DefaultMutableTreeNode)child.getChildAt(i), i, false);
        }
        if (parent == null) {
            location = 0;
        }
        if (parent.getChildCount() < location) {
            location = parent.getChildCount();
        }
        this.treeModel.insertNodeInto(cloneChildNode, parent, location);
        this.treetable.getTree().scrollPathToVisible(new TreePath(cloneChildNode.getPath()));
        newTask.setExpand(false);
        return cloneChildNode;
    }

    public void forwardScheduling() {
        RecalculateTaskScheduleAlgorithm alg = this.getTaskManager().getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm();
        try {
            alg.run();
        }
        catch (TaskDependencyException e) {
            e.printStackTrace();
        }
    }

    private TaskManager getTaskManager() {
        return this.myTaskManager;
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Point ptDragOrigin = dge.getDragOrigin();
        TreePath path = this.treetable.getTree().getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
        if (path == null) {
            return;
        }
        Rectangle raPath = this.treetable.getTree().getPathBounds(path);
        this.offsetPoint.setLocation(ptDragOrigin.x - raPath.x, ptDragOrigin.y - raPath.y);
        Component lbl = null;
        lbl.setSize((int)raPath.getWidth(), (int)raPath.getHeight());
        this.ghostImage = new BufferedImage((int)raPath.getWidth(), (int)raPath.getHeight(), 3);
        Graphics2D g2 = this.ghostImage.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
        ((JComponent)lbl).paint(g2);
        Icon icon = ((JLabel)lbl).getIcon();
        int nStartOfText = icon == null ? 0 : icon.getIconWidth() + ((JLabel)lbl).getIconTextGap();
        g2.setComposite(AlphaComposite.getInstance(4, 0.5f));
        g2.setPaint(new GradientPaint(nStartOfText, 0.0f, SystemColor.controlShadow, this.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
        g2.fillRect(nStartOfText, 0, this.getWidth(), this.ghostImage.getHeight());
        g2.dispose();
        this.treetable.getTree().setSelectionPath(path);
        GanttTransferableTreePath transferable = new GanttTransferableTreePath(path);
        this.dragPath = path;
        dge.startDrag(null, this.ghostImage, new Point(5, 5), transferable, this);
    }

    public void cpAllDependencies(DefaultMutableTreeNode[] cdmtn) {
        this.cpDependencies = new ArrayList();
        this.allNodes = new ArrayList();
        for (int i = 0; i < cdmtn.length; ++i) {
            this.getAllNodes(cdmtn[i]);
        }
        TaskDependency[] dependencies = this.getTaskManager().getDependencyCollection().getDependencies();
        for (int i = 0; i < dependencies.length; ++i) {
            Task dependant = dependencies[i].getDependant();
            Task dependee = dependencies[i].getDependee();
            for (int j = 0; j < this.allNodes.size(); ++j) {
                for (int k = 0; k < this.allNodes.size(); ++k) {
                    if (!((Task)((DefaultMutableTreeNode)this.allNodes.get(j)).getUserObject()).equals(dependant) || !((Task)((DefaultMutableTreeNode)this.allNodes.get(k)).getUserObject()).equals(dependee)) continue;
                    this.cpDependencies.add(dependencies[i]);
                }
            }
        }
    }

    public void getAllNodes(DefaultMutableTreeNode dmt) {
        if (!this.allNodes.contains(dmt)) {
            this.allNodes.add(dmt);
        }
        for (int i = 0; i < dmt.getChildCount(); ++i) {
            this.getAllNodes((DefaultMutableTreeNode)dmt.getChildAt(i));
        }
    }

    public boolean hasAProjectTaskDescendant(DefaultMutableTreeNode node) {
        ArrayList child = this.getAllChildTask(node);
        for (int i = 0; i < child.size(); ++i) {
            if (((Task)((DefaultMutableTreeNode)child.get(i)).getUserObject()).isProjectTask()) {
                return true;
            }
            if (!this.hasAProjectTaskDescendant((DefaultMutableTreeNode)child.get(i))) continue;
            return true;
        }
        return false;
    }

    public ArrayList getProjectTasks() {
        ArrayList projectTasks = new ArrayList();
        this.getProjectTasks(this.rootNode, projectTasks);
        return projectTasks;
    }

    public void getProjectTasks(DefaultMutableTreeNode node, ArrayList list) {
        ArrayList child = this.getAllChildTask(node);
        for (int i = 0; i < child.size(); ++i) {
            DefaultMutableTreeNode taskNode = (DefaultMutableTreeNode)child.get(i);
            if (((Task)taskNode.getUserObject()).isProjectTask()) {
                list.add(taskNode);
                continue;
            }
            this.getProjectTasks(taskNode, list);
        }
    }

    public void setDelay(final Task task, final Delay delay) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TaskNode taskNode = (TaskNode)GanttTree2.this.getNode(task.getTaskID());
                if (taskNode != null) {
                    GanttTree2.this.treetable.setDelay(taskNode, delay);
                }
            }
        });
    }

    public GanttTreeTableModel getModel() {
        return this.treeModel;
    }

    private GPUndoManager getUndoManager() {
        return this.myUIFacade.getUndoManager();
    }

    public void projectModified() {
    }

    public void projectSaved() {
    }

    public void projectClosed() {
        this.clearTree();
        this.getTreeTable().reloadColumns();
    }

    public Component getTreeComponent() {
        return this;
    }

    public Action getIndentAction() {
        return this.myIndentAction;
    }

    public Action getUnindentAction() {
        return this.myDedentAction;
    }

    public Action getMoveDownAction() {
        return this.myMoveUpAction;
    }

    public Action getMoveUpAction() {
        return this.myMoveDownAction;
    }

    public void setLinkTasksAction(Action action) {
        this.myLinkTasksAction = action;
    }

    private Action getLinkTasksAction() {
        return this.myLinkTasksAction;
    }

    public void setUnlinkTasksAction(Action action) {
        this.myUnlinkTasksAction = action;
    }

    private Action getUnlinkTasksAction() {
        return this.myUnlinkTasksAction;
    }

    void setTaskPropertiesAction(Action action) {
        this.myTaskPropertiesAction = action;
        this.treetable.getInputMap(2).put(KeyStroke.getKeyStroke(10, 512), action.getValue("Name"));
        this.treetable.getActionMap().put(action.getValue("Name"), action);
    }

    private Action getTaskPropertiesAction() {
        return this.myTaskPropertiesAction;
    }

    public TableHeaderUIFacade getVisibleFields() {
        return this.treetable.getVisibleFields();
    }

    public class GanttTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        public GanttTreeCellRenderer() {
            this.setOpaque(true);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Task task = (Task)((DefaultMutableTreeNode)value).getUserObject();
            if (task == null) {
                return this;
            }
            int type = 0;
            this.setFont(Fonts.GANTT_TREE_FONT);
            if (task.isMilestone()) {
                this.setIcon(new ImageIcon(this.getClass().getResource("/icons/meeting.gif")));
                type = 1;
            } else if (leaf) {
                if (task.getPriority() == GanttTask.LOW) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/icons/task1.gif")));
                } else if (task.getPriority() == GanttTask.NORMAL) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/icons/task.gif")));
                } else if (task.getPriority() == GanttTask.HIGHT) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/icons/task2.gif")));
                }
                type = 2;
            } else {
                this.setIcon(new ImageIcon(this.getClass().getResource("/icons/mtask.gif")));
                this.setFont(Fonts.GANTT_TREE_FONT2);
            }
            this.setText(task.toString());
            this.setToolTipText(this.getToolTip(task, type));
            this.setBackground(selected ? new Color(0.29f, 0.349f, 0.643f) : (row % 2 == 0 ? Color.white : new Color(0.933f, 0.933f, 0.933f)));
            this.setForeground(selected ? Color.white : Color.black);
            return this;
        }

        public String getToolTip(Task task, int type) {
            String res = "<html><body bgcolor=#EAEAEA>";
            res = res + "<b>" + task.toString() + "</b>" + "<br>" + task.getStart();
            if (type != 1) {
                res = res + "  -  " + task.getEnd();
            }
            if (type == 1) {
                res = res + "<br>" + GanttTree2.this.language.getText("meetingPoint");
            }
            res = res + "<br><b>Pri</b> " + (task.getPriority() == 0 ? GanttTree2.this.language.getText("low") : (task.getPriority() == 1 ? GanttTree2.this.language.getText("normal") : GanttTree2.this.language.getText("hight")));
            ResourceAssignment[] assignments = task.getAssignments();
            if (assignments.length > 0) {
                res = res + "<br><b>Assign to </b><br>";
                for (int j = 0; j < assignments.length; ++j) {
                    res = res + "&nbsp;&nbsp;" + assignments[j].getResource().getName() + "<br>";
                }
            }
            if (task.getNotes() != null && !task.getNotes().equals("")) {
                String notes = task.getNotes();
                res = res + "<br><b>Notes </b>: ";
                int maxLength = 150;
                if (notes.length() > maxLength) {
                    int i;
                    notes = notes.substring(0, maxLength);
                    for (i = maxLength - 1; i >= 0 && notes.charAt(i) != ' '; --i) {
                    }
                    notes = notes.substring(0, i);
                    notes = notes + " <b>( . . . )</b>";
                }
                notes = notes.replaceAll("\n", "<br>");
                res = res + "<font size=\"-2\">" + notes + "</font>";
            }
            res = res + "</body></html>";
            return res;
        }
    }

    private static class GanttTransferableTreePath
    implements Transferable {
        public static final DataFlavor TREEPATH_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "TreePath");
        private TreePath _path;
        private DataFlavor[] _flavors = new DataFlavor[]{TREEPATH_FLAVOR};

        public GanttTransferableTreePath(TreePath path) {
            this._path = path;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this._flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return Arrays.asList(this._flavors).contains(flavor);
        }

        public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor.isMimeTypeEqual(TREEPATH_FLAVOR.getMimeType())) {
                return this._path;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private class GanttTreeDropListener
    implements DropTargetListener {
        private TreePath lastPath = null;
        private Rectangle2D cueLineRect = new Rectangle2D.Float();
        private Rectangle2D ghostImageRect = new Rectangle2D.Float();
        private Color cueLineColor;
        private Point lastEventPoint = new Point();
        private Timer hoverTimer;

        public GanttTreeDropListener() {
            this.cueLineColor = new Color(SystemColor.controlShadow.getRed(), SystemColor.controlShadow.getGreen(), SystemColor.controlShadow.getBlue(), 64);
            this.hoverTimer = new Timer(1000, new ActionListener(this){
                private final /* synthetic */ GanttTreeDropListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (!GanttTree2.access$300(GanttTreeDropListener.access$1100(this.this$1)).getTree().isExpanded(GanttTreeDropListener.access$1000(this.this$1))) {
                        GanttTree2.access$300(GanttTreeDropListener.access$1100(this.this$1)).getTree().expandPath(GanttTreeDropListener.access$1000(this.this$1));
                    }
                }
            });
            this.hoverTimer.setRepeats(false);
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (GanttTree2.this.ghostImage == null) {
                GanttTree2.this.ghostImage = new BufferedImage(1, 1, 3);
            }
            if (!this.isDragAcceptable(dtde)) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(dtde.getDropAction());
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
            Rectangle raPath;
            if (!this.isDragAcceptable(dtde)) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(dtde.getDropAction());
            }
            Point pt = dtde.getLocation();
            if (pt.equals(this.lastEventPoint)) {
                return;
            }
            this.lastEventPoint = pt;
            Graphics2D g2 = (Graphics2D)GanttTree2.this.treetable.getGraphics();
            if (!DragSource.isDragImageSupported()) {
                GanttTree2.this.treetable.paintImmediately(this.ghostImageRect.getBounds());
                this.ghostImageRect.setRect(pt.x - ((GanttTree2)GanttTree2.this).offsetPoint.x, pt.y - ((GanttTree2)GanttTree2.this).offsetPoint.y, GanttTree2.this.ghostImage.getWidth(), GanttTree2.this.ghostImage.getHeight());
                g2.drawImage(GanttTree2.this.ghostImage, AffineTransform.getTranslateInstance(this.ghostImageRect.getX(), this.ghostImageRect.getY()), null);
            } else {
                GanttTree2.this.treetable.paintImmediately(this.cueLineRect.getBounds());
            }
            TreePath path = GanttTree2.this.treetable.getTree().getClosestPathForLocation(pt.x, pt.y);
            if (path != this.lastPath) {
                this.lastPath = path;
                this.hoverTimer.restart();
            }
            if ((raPath = GanttTree2.this.treetable.getTree().getPathBounds(path)) == null) {
                raPath = new Rectangle(1, 1);
            }
            this.cueLineRect.setRect(0.0, raPath.y + (int)raPath.getHeight(), GanttTree2.this.getWidth(), 2.0);
            g2.setColor(this.cueLineColor);
            g2.fill(this.cueLineRect);
            this.ghostImageRect = this.ghostImageRect.createUnion(this.cueLineRect);
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            if (!this.isDragAcceptable(dtde)) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(dtde.getDropAction());
            }
        }

        public void drop(DropTargetDropEvent dtde) {
            if (!this.isDropAcceptable(dtde)) {
                dtde.rejectDrop();
                return;
            }
            this.hoverTimer.stop();
            dtde.acceptDrop(dtde.getDropAction());
            Transferable transferable = dtde.getTransferable();
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                DataFlavor flavor = flavors[i];
                if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
                try {
                    Point pt = dtde.getLocation();
                    DefaultMutableTreeNode target = (DefaultMutableTreeNode)GanttTree2.this.treetable.getTree().getClosestPathForLocation(pt.x, pt.y).getLastPathComponent();
                    TreePath pathSource = (TreePath)transferable.getTransferData(flavor);
                    DefaultMutableTreeNode source = (DefaultMutableTreeNode)pathSource.getLastPathComponent();
                    TreePath pathNewChild = null;
                    TreeNode sourceFather = source.getParent();
                    int index = sourceFather.getIndex(source);
                    source.removeFromParent();
                    GanttTree2.this.treeModel.nodesWereRemoved(sourceFather, new int[]{index}, new Object[]{source});
                    GanttTree2.this.treeModel.insertNodeInto(source, target, 0);
                    pathNewChild = new TreePath(((DefaultMutableTreeNode)pathSource.getLastPathComponent()).getPath());
                    if (pathNewChild != null) {
                        GanttTree2.this.treetable.getTree().setSelectionPath(pathNewChild);
                    }
                    GanttTree2.this.expandRefresh(source);
                    GanttTree2.this.forwardScheduling();
                    GanttTree2.this.area.repaint();
                    GanttTree2.this.appli.setAskForSave(true);
                    break;
                }
                catch (UnsupportedFlavorException ufe) {
                    System.out.println(ufe);
                    dtde.dropComplete(false);
                    return;
                }
                catch (IOException ioe) {
                    System.out.println(ioe);
                    dtde.dropComplete(false);
                    return;
                }
            }
            dtde.dropComplete(true);
        }

        public void dragExit(DropTargetEvent dte) {
            if (!DragSource.isDragImageSupported()) {
                GanttTree2.this.repaint(this.ghostImageRect.getBounds());
            }
            GanttTree2.this.treetable.repaint();
        }

        public boolean isDragAcceptable(DropTargetDragEvent e) {
            if ((e.getDropAction() & 3) == 0) {
                return false;
            }
            if (!e.isDataFlavorSupported(GanttTransferableTreePath.TREEPATH_FLAVOR)) {
                return false;
            }
            Point pt = e.getLocation();
            TreePath path = GanttTree2.this.treetable.getTree().getClosestPathForLocation(pt.x, pt.y);
            if (GanttTree2.this.dragPath.isDescendant(path)) {
                return false;
            }
            if (path.equals(GanttTree2.this.dragPath)) {
                return false;
            }
            Task task = (Task)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            return !task.isMilestone();
        }

        public boolean isDropAcceptable(DropTargetDropEvent e) {
            if ((e.getDropAction() & 3) == 0) {
                return false;
            }
            if (!e.isDataFlavorSupported(GanttTransferableTreePath.TREEPATH_FLAVOR)) {
                return false;
            }
            Point pt = e.getLocation();
            TreePath path = GanttTree2.this.treetable.getTree().getClosestPathForLocation(pt.x, pt.y);
            return !path.equals(GanttTree2.this.dragPath);
        }

        static /* synthetic */ TreePath access$1000(GanttTreeDropListener x0) {
            return x0.lastPath;
        }

        static /* synthetic */ GanttTree2 access$1100(GanttTreeDropListener x0) {
            return x0.GanttTree2.this;
        }
    }

    public class GanttTreeModelListener
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent e) {
            if (GanttTree2.this.area != null) {
                GanttTree2.this.area.repaint();
            }
        }

        public void treeNodesInserted(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
            Task task = (Task)node.getUserObject();
            if (GanttTree2.this.area != null) {
                GanttTree2.this.area.repaint();
            }
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            if (GanttTree2.this.area != null) {
                GanttTree2.this.area.repaint();
            }
        }

        public void treeStructureChanged(TreeModelEvent e) {
            if (GanttTree2.this.area != null) {
                GanttTree2.this.area.repaint();
            }
        }
    }

    public class GanttTreeExpansionListener
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent e) {
            if (GanttTree2.this.area != null) {
                GanttTree2.this.area.repaint();
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
            Task task = (Task)node.getUserObject();
            task.setExpand(true);
            GanttTree2.this.appli.setAskForSave(true);
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            if (GanttTree2.this.area != null) {
                GanttTree2.this.area.repaint();
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
            Task task = (Task)node.getUserObject();
            task.setExpand(false);
            GanttTree2.this.appli.setAskForSave(true);
        }
    }

    public class GanttAdjustmentListener
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (GanttTree2.this.area != null) {
                int v = e.getValue();
                GanttTree2.this.area.setScrollBar(v);
                GanttTree2.this.area.repaint();
            }
        }
    }

    class HiddenTask
    implements Comparable {
        private DefaultMutableTreeNode node = null;
        private DefaultMutableTreeNode parent = null;
        private int index = -1;

        public HiddenTask(DefaultMutableTreeNode node, DefaultMutableTreeNode parent, int index) {
            this.node = node;
            this.parent = parent;
            this.index = index;
        }

        public DefaultMutableTreeNode getNode() {
            return this.node;
        }

        public DefaultMutableTreeNode getParent() {
            return this.parent;
        }

        public int getIndex() {
            return this.index;
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 0;
            }
            if (o instanceof HiddenTask) {
                HiddenTask ht = (HiddenTask)o;
                return this.index - ht.index;
            }
            return 0;
        }
    }

    private class AutoscrollingTree
    extends JTree
    implements Autoscroll {
        public AutoscrollingTree(DefaultTreeModel treeModel) {
            super(treeModel);
        }

        public Insets getAutoscrollInsets() {
            Rectangle raOuter = this.getBounds();
            Rectangle raInner = this.getParent().getBounds();
            return new Insets(raInner.y - raOuter.y + 12, raInner.x - raOuter.x + 12, raOuter.height - raInner.height - raInner.y + raOuter.y + 12, raOuter.width - raInner.width - raInner.x + raOuter.x + 12);
        }

        public void autoscroll(Point pt) {
            int nRow = this.getClosestRowForLocation(pt.x, pt.y);
            if (nRow < 0) {
                return;
            }
            Rectangle raOuter = this.getBounds();
            nRow = pt.y + raOuter.y <= 12 ? (nRow <= 0 ? 0 : nRow - 1) : (nRow < this.getRowCount() - 1 ? nRow + 1 : nRow);
            this.scrollRowToVisible(nRow);
        }
    }
}

