/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.ganttproject.CustomPropertyManager;
import net.sourceforge.ganttproject.GanttTask;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.ProjectEventListener;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.calendar.WeekendCalendarImpl;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.document.DocumentManager;
import net.sourceforge.ganttproject.font.Fonts;
import net.sourceforge.ganttproject.gui.UIConfiguration;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.roles.RoleManager;
import net.sourceforge.ganttproject.task.CustomColumnsManager;
import net.sourceforge.ganttproject.task.CustomColumnsStorage;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskManagerConfig;
import net.sourceforge.ganttproject.time.TimeUnitStack;
import net.sourceforge.ganttproject.time.gregorian.GPTimeUnitStack;

public class GanttProjectImpl
implements IGanttProject {
    private String myProjectName;
    private String myDescription;
    private String myOrganization;
    private String myWebLink;
    private final TaskManager myTaskManager;
    private final HumanResourceManager myResourceManager;
    private final TaskManagerConfigImpl myTaskManagerConfig;
    private Document myDocument;
    private final List myListeners = new ArrayList();
    private UIConfiguration myUIConfiguration;
    private final CustomColumnsManager myTaskCustomColumnManager;
    private final CustomColumnsStorage myTaskCustomColumnStorage;
    private final List myBaselines = new ArrayList();

    public GanttProjectImpl() {
        this.myResourceManager = new HumanResourceManager(RoleManager.Access.getInstance().getDefaultRole());
        this.myTaskManagerConfig = new TaskManagerConfigImpl(this.myResourceManager, GanttLanguage.getInstance());
        this.myTaskManager = TaskManager.Access.newInstance(null, this.myTaskManagerConfig);
        this.myUIConfiguration = new UIConfiguration(Fonts.DEFAULT_MENU_FONT, Fonts.DEFAULT_CHART_FONT, Color.BLUE, true);
        this.myTaskCustomColumnStorage = new CustomColumnsStorage();
        this.myTaskCustomColumnManager = new CustomColumnsManager(this.myTaskCustomColumnStorage);
    }

    public String getProjectName() {
        return this.myProjectName;
    }

    public void setProjectName(String projectName) {
        this.myProjectName = projectName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public String getOrganization() {
        return this.myOrganization;
    }

    public void setOrganization(String organization) {
        this.myOrganization = organization;
    }

    public String getWebLink() {
        return this.myWebLink;
    }

    public void setWebLink(String webLink) {
        this.myWebLink = webLink;
    }

    public Task newTask() {
        GanttTask result = this.getTaskManager().createTask();
        this.getTaskManager().getTaskHierarchy().move(result, this.getTaskManager().getRootTask());
        return result;
    }

    public GanttLanguage getI18n() {
        return GanttLanguage.getInstance();
    }

    public UIConfiguration getUIConfiguration() {
        return this.myUIConfiguration;
    }

    public ResourceManager getHumanResourceManager() {
        return this.myResourceManager;
    }

    public RoleManager getRoleManager() {
        return RoleManager.Access.getInstance();
    }

    public TaskManager getTaskManager() {
        return this.myTaskManager;
    }

    public TaskContainmentHierarchyFacade getTaskContainment() {
        return this.getTaskManager().getTaskHierarchy();
    }

    public GPCalendar getActiveCalendar() {
        return this.myTaskManagerConfig.getCalendar();
    }

    public TimeUnitStack getTimeUnitStack() {
        return this.myTaskManagerConfig.getTimeUnitStack();
    }

    public void setModified() {
    }

    public void setModified(boolean modified) {
    }

    public void close() {
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public void setDocument(Document document) {
        this.myDocument = document;
    }

    public void addProjectEventListener(ProjectEventListener listener) {
        this.myListeners.add(listener);
    }

    public void removeProjectEventListener(ProjectEventListener listener) {
        this.myListeners.remove(listener);
    }

    public boolean isModified() {
        return false;
    }

    public void open(Document document) throws IOException {
    }

    public DocumentManager getDocumentManager() {
        return null;
    }

    public CustomPropertyManager getResourceCustomPropertyManager() {
        return this.myResourceManager;
    }

    public CustomColumnsManager getTaskCustomColumnManager() {
        return this.myTaskCustomColumnManager;
    }

    public CustomColumnsStorage getCustomColumnsStorage() {
        return this.myTaskCustomColumnStorage;
    }

    public List getBaselines() {
        return this.myBaselines;
    }

    private static class TaskManagerConfigImpl
    implements TaskManagerConfig {
        private final ResourceManager myResourceManager;
        private final GPTimeUnitStack myTimeUnitStack;
        private final WeekendCalendarImpl myCalendar;

        private TaskManagerConfigImpl(ResourceManager resourceManager, GanttLanguage i18n) {
            this.myResourceManager = resourceManager;
            this.myTimeUnitStack = new GPTimeUnitStack(i18n);
            this.myCalendar = new WeekendCalendarImpl();
        }

        public Color getDefaultColor() {
            return Color.BLUE;
        }

        public GPCalendar getCalendar() {
            return this.myCalendar;
        }

        public TimeUnitStack getTimeUnitStack() {
            return this.myTimeUnitStack;
        }

        public ResourceManager getResourceManager() {
            return this.myResourceManager;
        }
    }
}

