/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.ganttproject.CustomPropertyManager;
import net.sourceforge.ganttproject.FacadeInvalidator;
import net.sourceforge.ganttproject.GPToolBar;
import net.sourceforge.ganttproject.GPView;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttChartTabContentPanel;
import net.sourceforge.ganttproject.GanttExportSettings;
import net.sourceforge.ganttproject.GanttGraphicArea;
import net.sourceforge.ganttproject.GanttOptions;
import net.sourceforge.ganttproject.GanttPreviousState;
import net.sourceforge.ganttproject.GanttProjectBase;
import net.sourceforge.ganttproject.GanttResourcePanel;
import net.sourceforge.ganttproject.GanttSplash;
import net.sourceforge.ganttproject.GanttTask;
import net.sourceforge.ganttproject.GanttTree2;
import net.sourceforge.ganttproject.GanttTreeTableModel;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.PrjInfos;
import net.sourceforge.ganttproject.ResourceChartTabContentPanel;
import net.sourceforge.ganttproject.TaskContainmentHierarchyFacadeImpl;
import net.sourceforge.ganttproject.TaskModelModificationListener;
import net.sourceforge.ganttproject.action.CalculateCriticalPathAction;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.action.ImportResources;
import net.sourceforge.ganttproject.action.NewArtefactAction;
import net.sourceforge.ganttproject.action.NewHumanAction;
import net.sourceforge.ganttproject.action.NewTaskAction;
import net.sourceforge.ganttproject.action.RedoAction;
import net.sourceforge.ganttproject.action.RefreshViewAction;
import net.sourceforge.ganttproject.action.ResourceActionSet;
import net.sourceforge.ganttproject.action.RolloverAction;
import net.sourceforge.ganttproject.action.ScrollGanttChartLeftAction;
import net.sourceforge.ganttproject.action.ScrollGanttChartRightAction;
import net.sourceforge.ganttproject.action.SwitchViewAction;
import net.sourceforge.ganttproject.action.UndoAction;
import net.sourceforge.ganttproject.action.ZoomInAction;
import net.sourceforge.ganttproject.action.ZoomOutAction;
import net.sourceforge.ganttproject.action.project.ProjectMenu;
import net.sourceforge.ganttproject.action.task.TaskPropertiesAction;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.calendar.WeekendCalendarImpl;
import net.sourceforge.ganttproject.chart.Chart;
import net.sourceforge.ganttproject.chart.GanttChart;
import net.sourceforge.ganttproject.chart.ToggleChartAction;
import net.sourceforge.ganttproject.delay.DelayManager;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.document.DocumentManager;
import net.sourceforge.ganttproject.document.DocumentsMRU;
import net.sourceforge.ganttproject.document.HttpDocument;
import net.sourceforge.ganttproject.document.OpenDocumentAction;
import net.sourceforge.ganttproject.export.CommandLineExportApplication;
import net.sourceforge.ganttproject.export.ExportFileAction;
import net.sourceforge.ganttproject.gui.GanttDialogCalendar;
import net.sourceforge.ganttproject.gui.GanttDialogInfo;
import net.sourceforge.ganttproject.gui.GanttDialogPerson;
import net.sourceforge.ganttproject.gui.GanttLookAndFeelInfo;
import net.sourceforge.ganttproject.gui.GanttLookAndFeels;
import net.sourceforge.ganttproject.gui.ResourceTreeUIFacade;
import net.sourceforge.ganttproject.gui.TaskTreeUIFacade;
import net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import net.sourceforge.ganttproject.gui.TipsDialog;
import net.sourceforge.ganttproject.gui.UIConfiguration;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.about.AboutDialog;
import net.sourceforge.ganttproject.gui.options.SettingsDialog;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.gui.previousState.GanttDialogCompareToPreviousState;
import net.sourceforge.ganttproject.gui.previousState.GanttDialogSaveAsPreviousState;
import net.sourceforge.ganttproject.gui.scrolling.ScrollingManager;
import net.sourceforge.ganttproject.importer.ImportFileAction;
import net.sourceforge.ganttproject.importer.ImportFileWizardImpl;
import net.sourceforge.ganttproject.io.GPSaver;
import net.sourceforge.ganttproject.io.GanttXMLOpen;
import net.sourceforge.ganttproject.io.GanttXMLSaver;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.parser.GPParser;
import net.sourceforge.ganttproject.parser.ParserFactory;
import net.sourceforge.ganttproject.print.PrintManager;
import net.sourceforge.ganttproject.print.PrintPreview;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.resource.ResourceEvent;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.resource.ResourceView;
import net.sourceforge.ganttproject.roles.RoleManager;
import net.sourceforge.ganttproject.task.BlankLineNode;
import net.sourceforge.ganttproject.task.CustomColumnsStorage;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskManagerConfig;
import net.sourceforge.ganttproject.task.TaskNode;
import net.sourceforge.ganttproject.task.TaskSelectionManager;
import net.sourceforge.ganttproject.task.algorithm.AdjustTaskBoundsAlgorithm;
import net.sourceforge.ganttproject.task.algorithm.RecalculateTaskCompletionPercentageAlgorithm;
import net.sourceforge.ganttproject.time.TimeUnitStack;
import net.sourceforge.ganttproject.util.BrowserControl;
import net.sourceforge.helpgui.gui.MainFrame;

public class GanttProject
extends GanttProjectBase
implements ActionListener,
IGanttProject,
ResourceView,
KeyListener,
UIFacade {
    public static final String version = "2.0.5";
    public static boolean byCommandLine = false;
    private GanttLanguage language = GanttLanguage.getInstance();
    private GanttTree2 tree;
    private GanttGraphicArea area;
    private GanttResourcePanel resp;
    public JMenu mProject;
    public JMenu mMRU;
    public JMenu mEdit;
    public JMenu mTask;
    public JMenu mHuman;
    public JMenu mHelp;
    public JMenu mServer;
    public JMenu mCalendar;
    public JMenuItem miPreview;
    public JMenuItem miOptions;
    public JMenuItem miDeleteTask;
    public JMenuItem miDelHuman;
    public JMenuItem miSendMailHuman;
    public JMenuItem miEditCalendar;
    public JMenuItem miPrjCal;
    public JMenuItem miWebPage;
    public JMenuItem miTips;
    public JMenuItem miAbout;
    public JMenuItem miManual;
    public JMenuItem miRefresh;
    public JMenuItem miChartOptions;
    public JMenuItem miUndo;
    public JMenuItem miRedo;
    private static final int maxSizeMRU = 5;
    private DocumentsMRU documentsMRU = new DocumentsMRU(5);
    private TestGanttRolloverButton bNew;
    private TestGanttRolloverButton bOpen;
    private TestGanttRolloverButton bSave;
    private TestGanttRolloverButton bExport;
    private TestGanttRolloverButton bImport;
    private TestGanttRolloverButton bPrint;
    private TestGanttRolloverButton bPreviewPrint;
    private TestGanttRolloverButton bCopy;
    private TestGanttRolloverButton bCut;
    private TestGanttRolloverButton bPaste;
    private TestGanttRolloverButton bNewTask;
    private TestGanttRolloverButton bDelete;
    private TestGanttRolloverButton bProperties;
    private TestGanttRolloverButton bPrev;
    private TestGanttRolloverButton bScrollCenter;
    private TestGanttRolloverButton bNext;
    private TestGanttRolloverButton bZoomFit;
    private TestGanttRolloverButton bAbout;
    private TestGanttRolloverButton bShowHiddens;
    private JPopupMenu menu = new JPopupMenu();
    private TestGanttRolloverButton bZoomIn;
    private TestGanttRolloverButton bZoomOut;
    private TestGanttRolloverButton bUndo;
    private TestGanttRolloverButton bRedo;
    private TestGanttRolloverButton bCritical;
    private TestGanttRolloverButton bSaveCurrent;
    private TestGanttRolloverButton bComparePrev;
    private TestGanttRolloverButton bRefresh;
    public Document projectDocument = null;
    public PrjInfos prjInfos = new PrjInfos();
    public boolean askForSave = false;
    public GanttLookAndFeelInfo lookAndFeel;
    public boolean isOnlyViewer;
    private Hashtable managerHash = new Hashtable();
    private ResourceActionSet myResourceActions;
    private JFrame helpFrame = null;
    private final TaskManager myTaskManager;
    private FacadeInvalidator myFacadeInvalidator;
    private UIConfiguration myUIConfiguration;
    private final GanttOptions options;
    private JMenuBar bar;
    private GPToolBar toolBar;
    private DefaultListModel iconList = new DefaultListModel();
    private DefaultListModel deletedIconList = new DefaultListModel();
    private TaskPropertiesAction myTaskPropertiesAction;
    private NewTaskAction myNewTaskAction;
    private NewHumanAction myNewHumanAction;
    private NewArtefactAction myNewArtefactAction;
    private RefreshViewAction myRefreshAction;
    private Action myDeleteHumanAction;
    private TaskContainmentHierarchyFacadeImpl myCachedFacade;
    private List myRolloverActions = new ArrayList();
    private ArrayList myPreviousStates = new ArrayList();
    private MouseListener myStopEditingMouseListener = null;
    private DelayManager myDelayManager;
    private ProjectMenu myProjectMenu;
    private GanttChartTabContentPanel myGanttChartTabContent;
    private ResourceChartTabContentPanel myResourceChartTabContent;
    private GanttProjectBase.RowHeightAligner myRowHeightAligner;
    public static final String HUMAN_RESOURCE_MANAGER_ID = "HUMAN_RESOURCE";
    public static final String ROLE_MANAGER_ID = "ROLE_MANAGER";
    private GPCalendar myFakeCalendar = new WeekendCalendarImpl();
    private DocumentManager myDocumentManager;
    private ParserFactory myParserFactory;
    private static WindowListener ourWindowListener;
    static /* synthetic */ Class class$net$sourceforge$ganttproject$gui$TestGanttRolloverButton;

    public TaskContainmentHierarchyFacade getTaskContainment() {
        if (this.myFacadeInvalidator == null) {
            return TaskContainmentHierarchyFacade.STUB;
        }
        if (!this.myFacadeInvalidator.isValid() || this.myCachedFacade == null) {
            this.myCachedFacade = new TaskContainmentHierarchyFacadeImpl(this.tree);
            this.myFacadeInvalidator.reset();
        }
        return this.myCachedFacade;
    }

    private void initOptions() {
        this.options.setUIConfiguration(this.myUIConfiguration);
        this.options.setDocumentsMRU(this.documentsMRU);
        this.options.setLookAndFeel(this.lookAndFeel);
        if (this.options.load()) {
            this.language = this.options.getLanguage();
            GanttGraphicArea.taskDefaultColor = this.options.getDefaultColor();
            this.lookAndFeel = this.options.getLnfInfos();
            HttpDocument.setLockDAVMinutes(this.options.getLockDAVMinutes());
        }
        this.myUIConfiguration = this.options.getUIConfiguration();
    }

    public GanttProject(boolean isOnlyViewer, boolean isApplet) {
        System.err.println("Creating main frame...");
        ToolTipManager.sharedInstance().setInitialDelay(200);
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        Mediator.registerRoleManager(this.getRoleManager());
        TaskSelectionManager taskSelectionManager = new TaskSelectionManager();
        Mediator.registerTaskSelectionManager(taskSelectionManager);
        Mediator.registerGanttProject(this);
        this.isOnlyViewer = isOnlyViewer;
        if (!isOnlyViewer) {
            this.setTitle(this.language.getText("appliTitle"));
        } else {
            this.setTitle("GanttViewer");
        }
        this.setFocusable(true);
        System.err.println("1. loading look'n'feels");
        this.lookAndFeel = GanttLookAndFeels.getGanttLookAndFeels().getDefaultInfo();
        this.options = new GanttOptions(this.getRoleManager(), this.getDocumentManager(), isOnlyViewer);
        this.myUIConfiguration = this.options.getUIConfiguration();
        class TaskManagerConfigImpl
        implements TaskManagerConfig {
            TaskManagerConfigImpl() {
            }

            public Color getDefaultColor() {
                return GanttProject.this.myUIConfiguration.getTaskColor();
            }

            public GPCalendar getCalendar() {
                return GanttProject.this.getActiveCalendar();
            }

            public TimeUnitStack getTimeUnitStack() {
                return GanttProject.this.getTimeUnitStack();
            }

            public ResourceManager getResourceManager() {
                return GanttProject.this.getHumanResourceManager();
            }
        }
        TaskManagerConfigImpl taskConfig = new TaskManagerConfigImpl();
        this.myTaskManager = TaskManager.Access.newInstance(new TaskContainmentHierarchyFacade.Factory(){

            public TaskContainmentHierarchyFacade createFacede() {
                return GanttProject.this.getTaskContainment();
            }
        }, taskConfig, this.getCustomColumnsStorage());
        Mediator.registerTaskManager(this.myTaskManager);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/icons/ganttproject.png"));
        this.setIconImage(icon.getImage());
        this.myFacadeInvalidator = new FacadeInvalidator(this.getTree().getJTree().getModel());
        this.getProject().addProjectEventListener(this.myFacadeInvalidator);
        this.area = new GanttGraphicArea(this, this.getTree(), this.getTaskManager(), this.getZoomManager(), this.getUndoManager());
        this.options.addOptionGroups(this.getUIFacade().getGanttChart().getOptionGroups());
        this.options.addOptionGroups(this.getUIFacade().getResourceChart().getOptionGroups());
        this.options.addOptionGroups(new GPOptionGroup[]{this.getProjectUIFacade().getOptionGroup()});
        this.options.addOptionGroups(this.getDocumentManager().getNetworkOptionGroups());
        this.myRowHeightAligner = new GanttProjectBase.RowHeightAligner(this.tree, this.area.getMyChartModel());
        this.area.getMyChartModel().addOptionChangeListener(this.myRowHeightAligner);
        System.err.println("2. loading options");
        this.initOptions();
        this.area.setUIConfiguration(this.myUIConfiguration);
        this.getTree().setGraphicArea(this.area);
        this.miChartOptions = new JMenuItem(this.area.getOptionsDialogAction());
        this.getZoomManager().addZoomListener(this.area.getZoomListener());
        System.err.println("3. creating menu...");
        this.myRefreshAction = new RefreshViewAction(this.getUIFacade(), this.options);
        this.myRolloverActions.add(this.myRefreshAction);
        this.getTree().setActions();
        this.bar = new JMenuBar();
        if (!isOnlyViewer) {
            this.setJMenuBar(this.bar);
        }
        this.mProject = new JMenu();
        this.mMRU = new JMenu();
        this.mMRU.setIcon(new ImageIcon(this.getClass().getResource("/icons/recent_16.gif")));
        this.mEdit = new JMenu();
        this.mTask = new JMenu();
        this.mHuman = new JMenu();
        this.mHelp = new JMenu();
        this.mCalendar = new JMenu();
        this.miUndo = new JMenuItem(new UndoAction(this.getUndoManager(), "16", this));
        this.mEdit.add(this.miUndo);
        this.miRedo = new JMenuItem(new RedoAction(this.getUndoManager(), "16", this));
        this.mEdit.add(this.miRedo);
        this.mEdit.addSeparator();
        this.createProjectMenu();
        this.miRefresh = new JMenuItem(this.myRefreshAction);
        this.mEdit.add(this.miRefresh);
        this.mEdit.addSeparator();
        this.mEdit.add(this.getViewManager().getCutAction());
        this.mEdit.add(this.getViewManager().getCopyAction());
        this.mEdit.add(this.getViewManager().getPasteAction());
        this.mEdit.addSeparator();
        this.miOptions = this.createNewItem("/icons/settings_16.gif");
        this.mEdit.add(this.miOptions);
        this.myNewTaskAction = new NewTaskAction(this);
        this.mTask.add(this.myNewTaskAction);
        this.miDeleteTask = this.createNewItem("/icons/delete_16.gif");
        this.mTask.add(this.miDeleteTask);
        this.myTaskPropertiesAction = new TaskPropertiesAction(this.getProject(), Mediator.getTaskSelectionManager(), this.getUIFacade());
        this.mTask.add(this.myTaskPropertiesAction);
        this.getTree().setTaskPropertiesAction(this.myTaskPropertiesAction);
        this.getResourcePanel().setTaskPropertiesAction(this.myTaskPropertiesAction);
        this.myNewHumanAction = new NewHumanAction(this.getHumanResourceManager(), this.getRoleManager(), this, this){

            public void actionPerformed(ActionEvent event) {
                super.actionPerformed(event);
                GanttProject.this.getTabs().setSelectedIndex(1);
            }
        };
        this.mHuman.add(this.myNewHumanAction);
        this.myDeleteHumanAction = this.getResourceActions().getDeleteHumanAction();
        this.miDelHuman = new JMenuItem(this.myDeleteHumanAction);
        this.mHuman.add(this.miDelHuman);
        this.mHuman.add(this.getResourcePanel().getResourcePropertiesAction());
        this.miSendMailHuman = this.createNewItem("/icons/send_mail_16.gif");
        this.mHuman.add(this.miSendMailHuman);
        this.mHuman.add(new ImportResources(this.getHumanResourceManager(), this.getTaskManager(), this.getRoleManager(), this));
        this.miEditCalendar = this.createNewItem("/icons/clock_16.gif");
        this.mCalendar.add(this.miEditCalendar);
        this.miPrjCal = this.createNewItem("/icons/default_calendar_16.gif");
        this.mCalendar.add(this.miPrjCal);
        this.miWebPage = this.createNewItem("/icons/home_16.gif");
        this.mHelp.add(this.miWebPage);
        this.miManual = this.createNewItem("/icons/help_16.gif");
        try {
            Class.forName("net.sourceforge.helpgui.HelpGui");
            this.mHelp.add(this.miManual);
            this.miManual.setAccelerator(KeyStroke.getKeyStroke("F1"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.miTips = this.createNewItem("/icons/about_16.gif");
        this.mHelp.add(this.miTips);
        this.miAbout = this.createNewItem("/icons/manual_16.gif");
        this.mHelp.add(this.miAbout);
        if (!isApplet) {
            this.bar.add(this.mProject);
        }
        this.bar.add(this.mEdit);
        JMenu viewMenu = this.createViewMenu();
        if (viewMenu != null) {
            this.bar.add(viewMenu);
        }
        this.bar.add(this.mTask);
        this.bar.add(this.mHuman);
        this.bar.add(this.mHelp);
        this.setMemonic();
        System.err.println("4. creating views...");
        this.myGanttChartTabContent = new GanttChartTabContentPanel(this.getProject(), this.getUIFacade(), this.tree, this.area);
        GPView ganttView = this.getViewManager().createView(this.myGanttChartTabContent, new ImageIcon(this.getClass().getResource("/icons/tasks_16.gif")));
        ganttView.setVisible(true);
        this.myResourceChartTabContent = new ResourceChartTabContentPanel(this.getResourcePanel(), this.getResourcePanel().area);
        GPView resourceView = this.getViewManager().createView(this.myResourceChartTabContent, new ImageIcon(this.getClass().getResource("/icons/res_16.gif")));
        resourceView.setVisible(true);
        this.getTabs().setSelectedIndex(0);
        this.resp.setActions();
        this.getTabs().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GanttProject.this.bCritical.setEnabled(GanttProject.this.getTabs().getSelectedIndex() == 0);
                GanttProject.this.bScrollCenter.setEnabled(GanttProject.this.getTabs().getSelectedIndex() == 0);
                GanttProject.this.bComparePrev.setEnabled(GanttProject.this.getTabs().getSelectedIndex() == 0);
                GanttProject.this.bSaveCurrent.setEnabled(GanttProject.this.getTabs().getSelectedIndex() == 0);
                GanttProject.this.bNewTask.setEnabled(GanttProject.this.getTabs().getSelectedIndex() == 0 || GanttProject.this.getTabs().getSelectedIndex() == 1);
                GanttProject.this.bDelete.setEnabled(GanttProject.this.getTabs().getSelectedIndex() == 0 || GanttProject.this.getTabs().getSelectedIndex() == 1);
                GanttProject.this.bProperties.setEnabled(GanttProject.this.getTabs().getSelectedIndex() == 0 || GanttProject.this.getTabs().getSelectedIndex() == 1);
                GanttProject.this.bZoomIn.setEnabled(GanttProject.this.getTabs().getSelectedIndex() == 0 || GanttProject.this.getTabs().getSelectedIndex() == 1);
                GanttProject.this.bZoomOut.setEnabled(GanttProject.this.getTabs().getSelectedIndex() == 0 || GanttProject.this.getTabs().getSelectedIndex() == 1);
                GanttProject.this.bPrev.setEnabled(GanttProject.this.getTabs().getSelectedIndex() == 0 || GanttProject.this.getTabs().getSelectedIndex() == 1);
                GanttProject.this.bNext.setEnabled(GanttProject.this.getTabs().getSelectedIndex() == 0 || GanttProject.this.getTabs().getSelectedIndex() == 1);
                if (GanttProject.this.getTabs().getSelectedIndex() == 0) {
                    GanttProject.this.bNewTask.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(GanttProject.this.language.getText("createTask"))));
                    GanttProject.this.bDelete.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(GanttProject.this.language.getText("deleteTask"))));
                    GanttProject.this.bProperties.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(GanttProject.this.language.getText("propertiesTask"))));
                    if (GanttProject.this.options.getButtonShow() != 0) {
                        GanttProject.this.bNewTask.setText(GanttProject.correctLabel(GanttProject.this.language.getText("createTask")));
                        GanttProject.this.bDelete.setText(GanttProject.correctLabel(GanttProject.this.language.getText("deleteTask")));
                        GanttProject.this.bProperties.setText(GanttProject.correctLabel(GanttProject.this.language.getText("propertiesTask")));
                    }
                } else if (GanttProject.this.getTabs().getSelectedIndex() == 1) {
                    GanttProject.this.bNewTask.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(GanttProject.this.language.getText("newHuman"))));
                    GanttProject.this.bDelete.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(GanttProject.this.language.getText("deleteHuman"))));
                    GanttProject.this.bProperties.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(GanttProject.this.language.getText("propertiesHuman"))));
                    if (GanttProject.this.options.getButtonShow() != 0) {
                        GanttProject.this.bNewTask.setText(GanttProject.correctLabel(GanttProject.this.language.getText("newHuman")));
                        GanttProject.this.bDelete.setText(GanttProject.correctLabel(GanttProject.this.language.getText("deleteHuman")));
                        GanttProject.this.bProperties.setText(GanttProject.correctLabel(GanttProject.this.language.getText("propertiesHuman")));
                    }
                }
            }
        });
        this.getContentPane().add((Component)this.getTabs(), "Center");
        this.toolBar = new GPToolBar("GanttProject", this.options.getToolBarPosition(), this.getOptions());
        this.toolBar.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent arg0) {
                GanttProject.this.setHiddens();
                GanttProject.this.refresh();
            }

            public void componentMoved(ComponentEvent arg0) {
            }

            public void componentShown(ComponentEvent arg0) {
            }

            public void componentHidden(ComponentEvent arg0) {
            }
        });
        this.addButtons(this.toolBar);
        this.getContentPane().add((Component)this.toolBar, this.toolBar.getOrientation() == 0 ? "North" : "West");
        if (!isOnlyViewer) {
            this.getContentPane().add((Component)this.getStatusBar(), "South");
        }
        this.getStatusBar().setVisible(this.options.getShowStatusBar());
        this.addKeyListener(this);
        SwitchViewAction switchAction = new SwitchViewAction(this);
        JMenuItem invisibleItem = new JMenuItem(switchAction);
        invisibleItem.setVisible(false);
        this.bar.add(invisibleItem);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GanttProject.this.exitForm(evt);
            }

            public void windowOpened(WindowEvent e) {
                GanttProject.this.myRowHeightAligner.optionsChanged();
            }
        });
        System.err.println("5. calculating size and packing...");
        this.setDefaultCloseOperation(0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.getPreferredSize();
        this.setLocation(screenSize.width / 2 - windowSize.width / 2, screenSize.height / 2 - windowSize.height / 2);
        this.pack();
        System.err.println("6. changing language ...");
        this.changeLanguage();
        System.err.println("7. changing look'n'feel ...");
        this.changeLookAndFeel(this.lookAndFeel);
        this.changeLookAndFeel(this.lookAndFeel);
        if (this.options.isLoaded()) {
            this.setBounds(this.options.getX(), this.options.getY(), this.options.getWidth(), this.options.getHeight());
        }
        if (this.options.getOpenTips() && !byCommandLine) {
            TipsDialog tips = new TipsDialog(this, this.options.getOpenTips());
            tips.show();
            tips.toFront();
        }
        System.err.println("8. finalizing...");
        this.applyComponentOrientation(GanttLanguage.getInstance().getComponentOrientation());
        this.myTaskManager.addTaskListener(new TaskModelModificationListener(this));
        if (ourWindowListener != null) {
            this.addWindowListener(ourWindowListener);
        }
        this.addMouseListenerToAllContainer(this.getComponents());
        this.myDelayManager = new DelayManager(this.myTaskManager, this.tree);
        Mediator.registerDelayManager(this.myDelayManager);
        this.myDelayManager.addObserver(this.tree);
        this.myTaskManager.addTaskListener(this.myDelayManager);
    }

    private void addMouseListenerToAllContainer(Component[] cont) {
        for (int i = 0; i < cont.length; ++i) {
            cont[i].addMouseListener(this.getStopEditingMouseListener());
            if (!(cont[i] instanceof Container)) continue;
            this.addMouseListenerToAllContainer(((Container)cont[i]).getComponents());
        }
    }

    private MouseListener getStopEditingMouseListener() {
        if (this.myStopEditingMouseListener == null) {
            this.myStopEditingMouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getSource() != GanttProject.this.bNewTask && e.getClickCount() == 1) {
                        GanttProject.this.tree.stopEditing();
                    }
                    if (e.getButton() == 1 && !(e.getSource() instanceof JTable) && !(e.getSource() instanceof AbstractButton)) {
                        Task taskUnderPointer = GanttProject.this.area.new GanttGraphicArea.MouseSupport().findTaskUnderMousePointer(e.getX(), e.getY());
                        if (taskUnderPointer == null) {
                            GanttProject.this.tree.selectTreeRow(-1);
                        }
                    }
                }
            };
        }
        return this.myStopEditingMouseListener;
    }

    private void createProjectMenu() {
        this.mServer = new JMenu();
        this.mServer.setIcon(new ImageIcon(this.getClass().getResource("/icons/server_16.gif")));
        this.myProjectMenu = new ProjectMenu(this);
        this.mProject.add(this.myProjectMenu.getNewProjectAction());
        this.mProject.add(this.myProjectMenu.getOpenProjectAction());
        this.mProject.add(this.mMRU);
        this.updateMenuMRU();
        this.mProject.addSeparator();
        this.mProject.add(this.myProjectMenu.getSaveProjectAction());
        this.mProject.add(this.myProjectMenu.getSaveProjectAsAction());
        this.mProject.addSeparator();
        ImportFileAction importFile = new ImportFileAction(this.getUIFacade(), this);
        this.mProject.add(importFile);
        ExportFileAction exportFile = new ExportFileAction(this.getUIFacade(), this.getProject(), this.options);
        this.mProject.add(exportFile);
        this.mProject.addSeparator();
        this.mServer.add(this.myProjectMenu.getOpenURLAction());
        this.mServer.add(this.myProjectMenu.getSaveURLAction());
        this.mProject.add(this.mServer);
        this.mProject.addSeparator();
        this.mProject.add(this.myProjectMenu.getPrintAction());
        this.miPreview = this.createNewItem("/icons/preview_16.gif");
        this.mProject.add(this.miPreview);
        this.mProject.addSeparator();
        this.mProject.add(this.myProjectMenu.getExitAction());
    }

    private JMenu createViewMenu() {
        JMenu result = this.changeMenuLabel(new JMenu(), this.language.getText("view"));
        result.add(this.miChartOptions);
        Chart[] charts = Mediator.getPluginManager().getCharts();
        if (charts.length > 0) {
            result.addSeparator();
        }
        for (int i = 0; i < charts.length; ++i) {
            result.add(new JCheckBoxMenuItem(new ToggleChartAction(charts[i], this.getViewManager())));
        }
        return result;
    }

    public GanttProject(boolean isOnlyViewer) {
        this(isOnlyViewer, false);
    }

    private void updateMenuMRU() {
        this.mMRU.removeAll();
        int index = 0;
        Iterator iterator = this.documentsMRU.iterator();
        while (iterator.hasNext()) {
            Document document = (Document)iterator.next();
            JMenuItem mi = new JMenuItem(new OpenDocumentAction(++index, document, this));
            this.mMRU.add(mi);
        }
    }

    public String getXslDir() {
        return this.options.getXslDir();
    }

    public GanttOptions getOptions() {
        return this.options;
    }

    public void restoreOptions() {
        this.options.initByDefault();
        this.iconList = this.initIconList();
        this.deletedIconList = this.initDeletedIconList();
        this.addButtons();
        this.myUIConfiguration = this.options.getUIConfiguration();
        GanttGraphicArea.taskDefaultColor = new Color(140, 182, 206);
        this.area.repaint();
    }

    public String getXslFo() {
        return this.options.getXslFo();
    }

    public void setMemonic() {
        int MENU_MASK = GPAction.MENU_MASK;
        this.miUndo.setAccelerator(KeyStroke.getKeyStroke(90, MENU_MASK));
        this.miRedo.setAccelerator(KeyStroke.getKeyStroke(89, MENU_MASK));
        if (!this.isOnlyViewer) {
            this.miOptions.setAccelerator(KeyStroke.getKeyStroke(71, MENU_MASK));
            this.miDeleteTask.setAccelerator(KeyStroke.getKeyStroke(68, MENU_MASK));
        }
    }

    public JMenuItem createNewItemText(String label) {
        JMenuItem item = new JMenuItem(label);
        item.addActionListener(this);
        return item;
    }

    public JMenuItem createNewItem(String icon) {
        URL url = this.getClass().getResource(icon);
        JMenuItem item = url == null ? new JMenuItem() : new JMenuItem(new ImageIcon(url));
        item.addActionListener(this);
        return item;
    }

    public JMenuItem createNewItem(String label, String icon) {
        JMenuItem item = new JMenuItem(label, new ImageIcon(this.getClass().getResource(icon)));
        item.addActionListener(this);
        return item;
    }

    public void changeLanguage() {
        if (this.helpFrame != null) {
            this.helpFrame.dispose();
        }
        this.helpFrame = null;
        this.applyComponentOrientation(this.language.getComponentOrientation());
        this.changeLanguageOfMenu();
        this.area.repaint();
        this.getResourcePanel().area.repaint();
        this.getResourcePanel().refresh(this.language);
        this.tree.changeLanguage(this.language);
        CustomColumnsStorage.changeLanguage(this.language);
        this.applyComponentOrientation(this.language.getComponentOrientation());
        for (int i = 0; i < this.iconList.size(); ++i) {
            if (this.iconList.getElementAt(i).getClass() == (class$net$sourceforge$ganttproject$gui$TestGanttRolloverButton == null ? GanttProject.class$("net.sourceforge.ganttproject.gui.TestGanttRolloverButton") : class$net$sourceforge$ganttproject$gui$TestGanttRolloverButton)) continue;
            this.iconList.removeElementAt(i);
            this.iconList.add(i, GPToolBar.SEPARATOR_OBJECT);
        }
    }

    public void changeLookAndFeel(GanttLookAndFeelInfo lookAndFeel) {
        try {
            UIManager.setLookAndFeel(lookAndFeel.getClassName());
            SwingUtilities.updateComponentTreeUI(this);
            this.lookAndFeel = lookAndFeel;
        }
        catch (Exception e) {
            GanttLookAndFeelInfo info = GanttLookAndFeels.getGanttLookAndFeels().getDefaultInfo();
            System.out.println("Can't find the LookAndFeel\n" + lookAndFeel.getClassName() + "\n" + lookAndFeel.getName() + "\nSetting the default Look'n'Feel" + info.getName());
            try {
                UIManager.setLookAndFeel(info.getClassName());
                SwingUtilities.updateComponentTreeUI(this);
                this.lookAndFeel = info;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.tree.getTable().getRowHeight() <= 22) {
            this.tree.getTable().setRowHeight(20);
        }
    }

    public static String correctLabel(String label) {
        return GanttLanguage.getInstance().correctLabel(label);
    }

    public JMenu changeMenuLabel(JMenu menu, String label) {
        int index = label.indexOf(36);
        if (index != -1 && label.length() - index > 1) {
            menu.setText(label.substring(0, index).concat(label.substring(++index)));
            menu.setMnemonic(Character.toLowerCase(label.charAt(index)));
        } else {
            menu.setText(label);
        }
        return menu;
    }

    public JMenuItem changeMenuLabel(JMenuItem menu, String label) {
        int index = label.indexOf(36);
        if (index != -1 && label.length() - index > 1) {
            menu.setText(label.substring(0, index).concat(label.substring(++index)));
            menu.setMnemonic(Character.toLowerCase(label.charAt(index)));
        } else {
            menu.setText(label);
        }
        return menu;
    }

    public JCheckBoxMenuItem changeMenuLabel(JCheckBoxMenuItem menu, String label) {
        int index = label.indexOf(36);
        if (index != -1 && label.length() - index > 1) {
            menu.setText(label.substring(0, index).concat(label.substring(++index)));
            menu.setMnemonic(Character.toLowerCase(label.charAt(index)));
        } else {
            menu.setText(label);
        }
        return menu;
    }

    private void changeLanguageOfMenu() {
        this.mProject = this.changeMenuLabel(this.mProject, this.language.getText("project"));
        this.mEdit = this.changeMenuLabel(this.mEdit, this.language.getText("edit"));
        this.mTask = this.changeMenuLabel(this.mTask, this.language.getText("task"));
        this.mHuman = this.changeMenuLabel(this.mHuman, this.language.getText("human"));
        this.mHelp = this.changeMenuLabel(this.mHelp, this.language.getText("help"));
        this.mCalendar = this.changeMenuLabel(this.mCalendar, this.language.getText("calendars"));
        this.mMRU = this.changeMenuLabel(this.mMRU, this.language.getText("lastOpen"));
        this.mServer = this.changeMenuLabel(this.mServer, this.language.getText("webServer"));
        this.miPreview = this.changeMenuLabel(this.miPreview, this.language.getText("preview"));
        this.miUndo = this.changeMenuLabel(this.miUndo, this.language.getText("undo"));
        this.miRedo = this.changeMenuLabel(this.miRedo, this.language.getText("redo"));
        this.miOptions = this.changeMenuLabel(this.miOptions, this.language.getText("settings"));
        this.miDeleteTask = this.changeMenuLabel(this.miDeleteTask, this.language.getText("deleteTask"));
        this.mHuman.insert(this.changeMenuLabel(this.mHuman.getItem(0), this.language.getText("newHuman")), 0);
        this.miDelHuman = this.changeMenuLabel(this.miDelHuman, this.language.getText("deleteHuman"));
        this.mHuman.insert(this.changeMenuLabel(this.mHuman.getItem(4), this.language.getText("importResources")), 4);
        this.miSendMailHuman = this.changeMenuLabel(this.miSendMailHuman, this.language.getText("sendMail"));
        this.miEditCalendar = this.changeMenuLabel(this.miEditCalendar, this.language.getText("editCalendars"));
        this.miPrjCal = this.changeMenuLabel(this.miPrjCal, this.language.getText("projectCalendar"));
        this.miWebPage = this.changeMenuLabel(this.miWebPage, this.language.getText("webPage"));
        this.miAbout = this.changeMenuLabel(this.miAbout, this.language.getText("about"));
        this.miTips = this.changeMenuLabel(this.miTips, this.language.getText("tipsOfTheDay"));
        this.miManual = this.changeMenuLabel(this.miManual, this.language.getText("manual"));
        this.miChartOptions = this.changeMenuLabel(this.miChartOptions, this.language.getText("chartOptions"));
        this.miRefresh = this.changeMenuLabel(this.miRefresh, this.language.getText("refresh"));
        this.bPreviewPrint.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("preview"))));
        this.bExport.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("export"))));
        this.bImport.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("import"))));
        this.bNewTask.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("createTask"))));
        this.bDelete.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("deleteTask"))));
        this.bProperties.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("propertiesTask"))));
        this.bPrev.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("backDate"))));
        this.bScrollCenter.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("centerOnSelectedTasks"))));
        this.bNext.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("forwardDate"))));
        this.bZoomIn.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("zoomIn"))));
        this.bZoomOut.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("zoomOut"))));
        this.bAbout.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("about"))));
        this.bUndo.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("undo"))));
        this.bRedo.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(this.language.getText("redo"))));
        this.bCritical.setToolTipText(GanttProject.getToolTip(this.language.getText("criticalPath")));
        this.bComparePrev.setToolTipText(GanttProject.getToolTip(this.language.getText("comparePrev")));
        this.bSaveCurrent.setToolTipText(GanttProject.getToolTip(this.language.getText("saveCurrent")));
        this.bRefresh.setToolTipText(GanttProject.getToolTip(this.language.getText("refresh")));
        this.bShowHiddens.setToolTipText(GanttProject.getToolTip(this.language.getText("showHiddens")));
        this.getTabs().setTitleAt(1, GanttProject.correctLabel(this.language.getText("human")));
        this.setButtonText();
        this.toolBar.updateButtonsLook();
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        int modifiers = e.getModifiersEx();
        if (code == 0) {
            e.consume();
        }
        switch (code) {
            case 127: {
                e.consume();
                if (this.isOnlyViewer) break;
                if (this.getViewIndex() == 0) {
                    this.deleteTasks(true);
                    break;
                }
                if (this.getViewIndex() != 1) break;
                this.deleteResources();
                break;
            }
            case 10: {
                break;
            }
            case 116: {
                e.consume();
                this.repaint2();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public static String getToolTip(String msg) {
        return "<html><body bgcolor=#EAEAEA>" + msg + "</body></html>";
    }

    public void setButtonText() {
        if (this.options.getButtonShow() != 0) {
            this.bImport.setText(GanttProject.correctLabel(this.language.getText("import")));
            this.bExport.setText(GanttProject.correctLabel(this.language.getText("export")));
            this.bPreviewPrint.setText(GanttProject.correctLabel(this.language.getText("preview")));
            this.bNewTask.setText(GanttProject.correctLabel(this.language.getText(this.getTabs().getSelectedIndex() == 0 ? "createTask" : "newHuman")));
            this.bDelete.setText(GanttProject.correctLabel(this.language.getText(this.getTabs().getSelectedIndex() == 0 ? "deleteTask" : "deleteHuman")));
            this.bProperties.setText(GanttProject.correctLabel(this.language.getText(this.getTabs().getSelectedIndex() == 0 ? "propertiesTask" : "propertiesHuman")));
            this.bPrev.setText(GanttProject.correctLabel(this.language.getText("backDate")));
            this.bScrollCenter.setText(GanttProject.correctLabel(this.language.getText("centerOnSelectedTasks")));
            this.bNext.setText(GanttProject.correctLabel(this.language.getText("forwardDate")));
            this.bZoomOut.setText(GanttProject.correctLabel(this.language.getText("zoomOut")));
            this.bZoomIn.setText(GanttProject.correctLabel(this.language.getText("zoomIn")));
            this.bAbout.setText(GanttProject.correctLabel(this.language.getText("about")));
            this.bUndo.setText(GanttProject.correctLabel(this.language.getText("undo")));
            this.bRedo.setText(GanttProject.correctLabel(this.language.getText("redo")));
            this.bCritical.setText(this.language.getText("criticalPath"));
            this.bComparePrev.setText(GanttProject.correctLabel(this.language.getText("comparePrev")));
            this.bSaveCurrent.setText(GanttProject.correctLabel(this.language.getText("saveCurrent")));
            this.bRefresh.setText(GanttProject.correctLabel(this.language.getText("refresh")));
        }
    }

    public void applyButtonOptions() {
        this.setButtonText();
        if (this.options.getButtonShow() == 2) {
            for (int i = 0; i < this.myRolloverActions.size(); ++i) {
                RolloverAction next = (RolloverAction)this.myRolloverActions.get(i);
                next.isIconVisible(false);
                next.setIconSize(this.options.getIconSize());
            }
        } else {
            if (!this.myUIConfiguration.isCriticalPathOn()) {
                this.bCritical.setDefaultIcon(new ImageIcon(this.getClass().getResource("/icons/criticalPathOff_" + this.options.getIconSize() + ".gif")));
            } else {
                this.bCritical.setDefaultIcon(new ImageIcon(this.getClass().getResource("/icons/criticalPathOn_" + this.options.getIconSize() + ".gif")));
            }
            for (int i = 0; i < this.myRolloverActions.size(); ++i) {
                RolloverAction next = (RolloverAction)this.myRolloverActions.get(i);
                next.isIconVisible(true);
                next.setIconSize(this.options.getIconSize());
            }
        }
        this.toolBar.updateButtonsLook();
    }

    public void addButtons(JToolBar toolBar) {
        this.bNew = new TestGanttRolloverButton(this.myProjectMenu.getNewProjectAction());
        this.bOpen = new TestGanttRolloverButton(this.myProjectMenu.getOpenProjectAction());
        this.bSave = new TestGanttRolloverButton(this.myProjectMenu.getSaveProjectAction());
        this.bImport = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/import_" + this.options.getIconSize() + ".gif")));
        this.bImport.addActionListener(this);
        this.bExport = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/export_" + this.options.getIconSize() + ".gif")));
        this.bExport.addActionListener(this);
        this.bPrint = new TestGanttRolloverButton(this.myProjectMenu.getPrintAction());
        this.bPreviewPrint = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/preview_" + this.options.getIconSize() + ".gif")));
        this.bPreviewPrint.addActionListener(this);
        this.bComparePrev = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/comparePrev_" + this.options.getIconSize() + ".gif")));
        this.bComparePrev.setEnabled(false);
        this.bComparePrev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GanttProject.this.compareToPreviousState();
                if (GanttProject.this.myPreviousStates.size() == 0) {
                    GanttProject.this.bComparePrev.setEnabled(false);
                }
            }
        });
        this.bSaveCurrent = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/saveCurrentAsPrev_" + this.options.getIconSize() + ".gif")));
        this.bSaveCurrent.setEnabled(false);
        this.bSaveCurrent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GanttProject.this.saveAsPreviousState();
            }
        });
        this.bCut = new TestGanttRolloverButton(this.getCutAction());
        this.bCopy = new TestGanttRolloverButton(this.getCopyAction());
        this.bPaste = new TestGanttRolloverButton(this.getPasteAction());
        this.myNewArtefactAction = new NewArtefactAction(new NewArtefactAction.ActiveActionProvider(){

            public AbstractAction getActiveAction() {
                return GanttProject.this.getTabs().getSelectedIndex() == 0 ? GanttProject.this.myNewTaskAction : GanttProject.this.myNewHumanAction;
            }
        }, this.options.getIconSize());
        this.bNewTask = new TestGanttRolloverButton(this.myNewArtefactAction);
        this.myRolloverActions.add(this.myNewArtefactAction);
        this.bDelete = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/delete_" + this.options.getIconSize() + ".gif")));
        this.bDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UIFacade.Choice choice;
                Object[] context;
                if (GanttProject.this.getTabs().getSelectedIndex() == 0) {
                    GanttProject.this.deleteTasks(true);
                } else if (GanttProject.this.getTabs().getSelectedIndex() == 1 && (context = GanttProject.this.getResourcePanel().getContext().getResources()).length > 0 && (choice = GanttProject.this.getUIFacade().showConfirmationDialog(GanttProject.this.getLanguage().getText("msg6") + GanttProject.this.getDisplayName(context) + "?", GanttProject.this.getLanguage().getText("question"))) == UIFacade.Choice.YES) {
                    GanttProject.this.getUndoManager().undoableEdit("Delete Human OK", new Runnable(this, (ProjectResource[])context){
                        private final /* synthetic */ ProjectResource[] val$context;
                        private final /* synthetic */ 10 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$context = val$context;
                        }

                        public void run() {
                            for (int i = 0; i < this.val$context.length; ++i) {
                                this.val$context[i].delete();
                            }
                        }
                    });
                    GanttProject.this.repaint2();
                    GanttProject.this.refreshProjectInfos();
                }
            }
        });
        this.bProperties = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/properties_" + this.options.getIconSize() + ".gif")));
        this.bProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GanttProject.this.getTabs().getSelectedIndex() == 0) {
                    GanttProject.this.propertiesTask();
                } else if (GanttProject.this.getTabs().getSelectedIndex() == 1) {
                    GanttProject.this.getResourcePanel().getResourcePropertiesAction().actionPerformed(null);
                }
            }
        });
        ScrollingManager scrollingManager = this.getScrollingManager();
        scrollingManager.addScrollingListener(this.area.getViewState());
        scrollingManager.addScrollingListener(this.getResourcePanel().area.getViewState());
        ScrollGanttChartLeftAction scrollLeft = new ScrollGanttChartLeftAction(scrollingManager, this.options.getIconSize());
        this.myRolloverActions.add(scrollLeft);
        this.bPrev = new TestGanttRolloverButton(scrollLeft);
        this.bPrev.setAutoRepeatMousePressedEvent(300);
        Action scrollCenter = this.area.getScrollCenterAction(scrollingManager, Mediator.getTaskSelectionManager(), this.options.getIconSize());
        this.myRolloverActions.add(scrollCenter);
        this.bScrollCenter = new TestGanttRolloverButton(scrollCenter);
        this.bScrollCenter.setAutoRepeatMousePressedEvent(300);
        ScrollGanttChartRightAction scrollRight = new ScrollGanttChartRightAction(scrollingManager, this.options.getIconSize());
        this.myRolloverActions.add(scrollRight);
        this.bNext = new TestGanttRolloverButton(scrollRight);
        this.bNext.setAutoRepeatMousePressedEvent(300);
        ZoomOutAction zoomOut = new ZoomOutAction(this.getZoomManager(), this.options.getIconSize());
        this.myRolloverActions.add(zoomOut);
        this.bZoomOut = new TestGanttRolloverButton(zoomOut);
        ZoomInAction zoomIn = new ZoomInAction(this.getZoomManager(), this.options.getIconSize());
        this.myRolloverActions.add(zoomIn);
        this.bZoomIn = new TestGanttRolloverButton(zoomIn);
        this.bAbout = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/manual_" + this.options.getIconSize() + ".gif")));
        this.bAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GanttProject.this.aboutDialog();
            }
        });
        UndoAction undo = new UndoAction(this.getUndoManager(), this.options.getIconSize(), this);
        this.myRolloverActions.add(undo);
        this.bUndo = new TestGanttRolloverButton(undo);
        RedoAction redo = new RedoAction(this.getUndoManager(), this.options.getIconSize(), this);
        this.myRolloverActions.add(redo);
        this.bRedo = new TestGanttRolloverButton(redo);
        CalculateCriticalPathAction critic = new CalculateCriticalPathAction(this.getTaskManager(), this.tree, this.options, this.getUIConfiguration(), this);
        this.myRolloverActions.add(critic);
        this.bCritical = new TestGanttRolloverButton(critic);
        this.bRefresh = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/refresh_" + this.options.getIconSize() + ".gif")));
        this.bRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GanttProject.this.getUIFacade().setStatusText(GanttLanguage.getInstance().getText("refresh"));
                GanttProject.this.getUIFacade().refresh();
            }
        });
        this.bShowHiddens = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/showHiddens.gif")));
        this.bShowHiddens.addActionListener(this);
        this.iconList = this.initIconList();
        this.deletedIconList = this.initDeletedIconList();
        this.addButtons();
        this.applyButtonOptions();
    }

    protected void saveAsPreviousState() {
        this.getUIFacade().setStatusText(GanttLanguage.getInstance().getText("saveCurrent"));
        GanttDialogSaveAsPreviousState ps = new GanttDialogSaveAsPreviousState(this);
        ps.show();
        if (ps.isSaved()) {
            this.bSaveCurrent.setEnabled(false);
            this.bComparePrev.setEnabled(true);
            this.myPreviousStates.add(ps.getPreviousState());
        }
    }

    public ArrayList getPreviouStates() {
        return this.myPreviousStates;
    }

    public List getBaselines() {
        return this.getPreviouStates();
    }

    protected void compareToPreviousState() {
        this.getUIFacade().setStatusText(GanttLanguage.getInstance().getText("comparePrev"));
        GanttDialogCompareToPreviousState cp = new GanttDialogCompareToPreviousState(this);
        cp.show();
    }

    private void aboutDialog() {
        AboutDialog agp = new AboutDialog(this);
        agp.show();
    }

    private String getDisplayName(Object[] objs) {
        if (objs.length == 1) {
            return objs[0].toString();
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < objs.length; ++i) {
            result.append(objs[i].toString());
            if (i >= objs.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private void exitForm(WindowEvent evt) {
        this.quitApplication();
    }

    public boolean checkCurrentProject() {
        GanttDialogInfo gdiSaveError = new GanttDialogInfo(this, 0, GanttDialogInfo.YES_NO_CANCEL_OPTION, this.language.getText("msg12"), this.language.getText("error"));
        if (this.askForSave) {
            UIFacade.Choice saveChoice = this.getUIFacade().showConfirmationDialog(this.language.getText("msg1"), this.language.getText("warning"));
            if (UIFacade.Choice.CANCEL == saveChoice) {
                return false;
            }
            if (UIFacade.Choice.YES == saveChoice) {
                boolean trySave = true;
                do {
                    try {
                        trySave = false;
                        this.saveProject();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        e.printStackTrace();
                        gdiSaveError.show();
                        if (gdiSaveError.res == 2) {
                            return false;
                        }
                        boolean bl = trySave = gdiSaveError.res == 0;
                    }
                } while (trySave);
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JMenuItem) {
            String arg = evt.getActionCommand();
            if (arg.equals(this.language.getText("hideTask"))) {
                this.tree.hideSelectedNodes();
            } else if (arg.equals(this.language.getText("displayHiddenTasks"))) {
                this.tree.displayHiddenTasks();
            } else if (arg.equals(GanttProject.correctLabel(this.language.getText("preview")))) {
                this.previewPrint();
            } else if (arg.equals(GanttProject.correctLabel(this.language.getText("deleteTask")))) {
                this.deleteTasks(true);
            } else if (arg.equals(GanttProject.correctLabel(this.language.getText("editCalendars")))) {
                GanttDialogCalendar dialogCalendar = new GanttDialogCalendar(this);
                dialogCalendar.show();
            } else if (arg.equals(GanttProject.correctLabel(this.language.getText("projectCalendar")))) {
                System.out.println("Project calendar");
            } else if (arg.equals(GanttProject.correctLabel(this.language.getText("webPage")))) {
                try {
                    this.openWebPage();
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            } else if (arg.equals(GanttProject.correctLabel(this.language.getText("tipsOfTheDay")))) {
                TipsDialog tips = new TipsDialog(this, this.options.getOpenTips());
                tips.show();
            } else if (arg.equals(GanttProject.correctLabel(this.language.getText("manual")))) {
                if (this.helpFrame == null) {
                    try {
                        this.helpFrame = new MainFrame("/docs/help/", "eclipse");
                        String sl = this.language.getText("shortLanguage");
                        if (sl.equals("fr") || sl.equals("bg")) {
                            this.helpFrame = new MainFrame("/docs/help_" + sl + "/", "eclipse");
                        }
                        this.helpFrame.setTitle(this.language.getText("ganttManual"));
                        ImageIcon icon = new ImageIcon(this.getClass().getResource("/icons/ganttproject.png"));
                        this.helpFrame.setIconImage(icon.getImage());
                        this.helpFrame.setSize((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() * 0.75), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() * 0.75));
                        this.helpFrame.setLocationRelativeTo(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.helpFrame.setVisible(true);
            } else if (arg.equals(GanttProject.correctLabel(this.language.getText("about")))) {
                this.aboutDialog();
            } else if (arg.equals(GanttProject.correctLabel(this.language.getText("sendMail")))) {
                this.getTabs().setSelectedIndex(1);
                this.getResourcePanel().sendMail(this);
            } else if (arg.equals(GanttProject.correctLabel(this.language.getText("settings")))) {
                this.launchOptionsDialog();
            }
        } else if (evt.getSource() instanceof Document) {
            if (this.checkCurrentProject()) {
                final ActionEvent ae = evt;
                this.getUndoManager().undoableEdit("StartupDocument", new Runnable(){

                    public void run() {
                        GanttProject.this.openStartupDocument((Document)ae.getSource());
                    }
                });
            }
        } else if (evt.getSource() == this.bImport) {
            ImportFileWizardImpl wizard = new ImportFileWizardImpl(this.getUIFacade(), this);
            wizard.show();
        } else if (evt.getSource() == this.bPreviewPrint) {
            this.previewPrint();
        } else if (evt.getSource() == this.bShowHiddens) {
            this.showHiddenButtonsPaneMenu();
        }
    }

    public void launchOptionsDialog() {
        this.getUIFacade().setStatusText(this.language.getText("settingsPreferences"));
        SettingsDialog dialogOptions = new SettingsDialog(this);
        dialogOptions.show();
        this.area.repaint();
    }

    public ProjectResource newHumanResource() {
        final HumanResource people = ((HumanResourceManager)this.getHumanResourceManager()).newHumanResource();
        people.setRole(this.getRoleManager().getDefaultRole());
        GanttDialogPerson dp = new GanttDialogPerson(this.getUIFacade(), this.getLanguage(), people);
        dp.setVisible(true);
        if (dp.result()) {
            this.getUndoManager().undoableEdit("new Resource", new Runnable(){

                public void run() {
                    GanttProject.this.getHumanResourceManager().add(people);
                }
            });
        }
        return people;
    }

    public Task newTask() {
        this.getTabs().setSelectedIndex(0);
        int index = -1;
        DefaultMutableTreeNode selectedNode = this.getTree().getSelectedNode();
        if (selectedNode != null) {
            DefaultMutableTreeNode parent1 = (DefaultMutableTreeNode)selectedNode.getParent();
            index = parent1.getIndex(selectedNode) + 1;
            this.tree.getTreeTable().getTree().setSelectionPath(new TreePath(parent1.getPath()));
            this.tree.getTreeTable().getTreeTable().editingStopped(new ChangeEvent(this.tree.getTreeTable().getTreeTable()));
        }
        GanttCalendar cal = new GanttCalendar(this.area.getViewState().getStartDate());
        DefaultMutableTreeNode node = this.tree.getSelectedNode();
        GanttLanguage lang = GanttLanguage.getInstance();
        String nameOfTask = this.options.getTaskNamePrefix();
        GanttTask task = this.getTaskManager().createTask();
        task.setStart(cal);
        task.setLength(1);
        this.getTaskManager().registerTask(task);
        task.setName(nameOfTask + "_" + task.getTaskID());
        task.setColor(this.area.getTaskColor());
        TaskNode taskNode = this.tree.addObject(task, node, index);
        this.getCustomColumnsStorage().processNewTask(task);
        AdjustTaskBoundsAlgorithm alg = this.getTaskManager().getAlgorithmCollection().getAdjustTaskBoundsAlgorithm();
        alg.run(task);
        RecalculateTaskCompletionPercentageAlgorithm alg2 = this.getTaskManager().getAlgorithmCollection().getRecalculateTaskCompletionPercentageAlgorithm();
        alg2.run(task);
        this.area.repaint();
        this.setAskForSave(true);
        this.getUIFacade().setStatusText(this.language.getText("createNewTask"));
        this.tree.setEditingTask(task);
        if (this.options.getAutomatic()) {
            this.propertiesTask();
        }
        this.repaint2();
        return task;
    }

    public void deleteResources() {
        this.myDeleteHumanAction.actionPerformed(null);
    }

    public void deleteTasks(boolean confirmation) {
        this.getTabs().setSelectedIndex(0);
        final DefaultMutableTreeNode[] cdmtn = this.tree.getSelectedNodes();
        if (cdmtn == null || cdmtn.length == 0) {
            this.getUIFacade().setStatusText(this.language.getText("msg21"));
            return;
        }
        UIFacade.Choice choice = this.getUIFacade().showConfirmationDialog(this.language.getText("msg19"), this.language.getText("question"));
        if (choice == UIFacade.Choice.YES) {
            this.getUndoManager().undoableEdit("Task removed", new Runnable(){

                public void run() {
                    int i;
                    ArrayList<DefaultMutableTreeNode> fathers = new ArrayList<DefaultMutableTreeNode>();
                    for (i = 0; i < cdmtn.length; ++i) {
                        if (cdmtn[i] != null && cdmtn[i] instanceof TaskNode) {
                            Task ttask = (Task)cdmtn[i].getUserObject();
                            GanttProject.this.getTaskManager().deleteTask(ttask);
                            ttask.delete();
                            DefaultMutableTreeNode father = GanttProject.this.tree.getFatherNode(ttask);
                            GanttProject.this.tree.removeCurrentNode(cdmtn[i]);
                            if (father == null) continue;
                            GanttTask taskFather = (GanttTask)father.getUserObject();
                            AdjustTaskBoundsAlgorithm alg = GanttProject.this.getTaskManager().getAlgorithmCollection().getAdjustTaskBoundsAlgorithm();
                            alg.run(taskFather);
                            father.setUserObject(taskFather);
                            fathers.add(father);
                            continue;
                        }
                        if (cdmtn[i] == null || !(cdmtn[i] instanceof BlankLineNode)) continue;
                        ((GanttTreeTableModel)GanttProject.this.tree.getTreeTable().getTreeTableModel()).removeNodeFromParent(cdmtn[i]);
                    }
                    for (i = 0; i < fathers.size(); ++i) {
                        DefaultMutableTreeNode father = (DefaultMutableTreeNode)fathers.get(i);
                        if (father.getChildCount() != 0) continue;
                        ((Task)father.getUserObject()).setProjectTask(false);
                    }
                }
            });
            this.refreshProjectInfos();
            this.area.repaint();
            this.repaint2();
            this.getResourcePanel().area.repaint();
            this.setAskForSave(true);
        }
    }

    public void propertiesTask() {
        this.myTaskPropertiesAction.actionPerformed(null);
    }

    public void refreshProjectInfos() {
        if (this.getTaskManager().getTaskCount() == 0 && this.resp.nbPeople() == 0) {
            this.getStatusBar().setSecondText("");
        } else {
            this.getStatusBar().setSecondText(GanttProject.correctLabel(this.language.getText("task")) + " : " + this.getTaskManager().getTaskCount() + "  " + GanttProject.correctLabel(this.language.getText("resources")) + " : " + this.resp.nbPeople());
        }
    }

    public void printProject() {
        Chart chart = this.getUIFacade().getActiveChart();
        if (chart == null) {
            this.getUIFacade().showErrorDialog("Failed to find active chart.\nPlease report this problem to GanttProject development team");
            return;
        }
        try {
            PrintManager.printChart(chart, this.options.getExportSettings());
        }
        catch (OutOfMemoryError e) {
            this.getUIFacade().showErrorDialog(GanttLanguage.getInstance().getText("printing.out_of_memory"));
        }
    }

    public void previewPrint() {
        Date endDate;
        Date startDate;
        Chart chart = this.getUIFacade().getActiveChart();
        if (chart == null) {
            this.getUIFacade().showErrorDialog("Failed to find active chart.\nPlease report this problem to GanttProject development team");
            return;
        }
        try {
            startDate = chart.getStartDate();
            endDate = chart.getEndDate();
        }
        catch (UnsupportedOperationException e) {
            startDate = null;
            endDate = null;
        }
        if (this.getTabs().getSelectedIndex() == 0) {
            startDate = this.area.getChartModel().getStartDate();
            endDate = this.area.getChartModel().getEndDate();
        } else if (this.getTabs().getSelectedIndex() == 1) {
            startDate = this.getResourcePanel().area.getChartModel().getStartDate();
            endDate = this.getResourcePanel().area.getChartModel().getEndDate();
        }
        try {
            PrintPreview preview = new PrintPreview(this.getProject(), this.getUIFacade(), chart, startDate, endDate);
            if (preview != null) {
                preview.setVisible(true);
            }
        }
        catch (OutOfMemoryError e) {
            this.getUIFacade().showErrorDialog(GanttLanguage.getInstance().getText("printing.out_of_memory"));
            return;
        }
    }

    public void newProject() {
        this.getProjectUIFacade().createProject(this.getProject());
    }

    public void openFile() throws IOException {
        this.getProjectUIFacade().openProject(this);
    }

    public void openURL() {
        this.getProjectUIFacade().openRemoteProject(this.getProject());
    }

    public void open(Document document) throws IOException {
        this.openDocument(document);
        if (document.getPortfolio() != null) {
            Document defaultDocument = document.getPortfolio().getDefaultDocument();
            this.openDocument(defaultDocument);
        }
    }

    private void openDocument(Document document) throws IOException {
        if (document.getDescription().endsWith(".xml") || document.getDescription().endsWith(".gan")) {
            boolean locked = document.acquireLock();
            if (!locked) {
                this.getUIFacade().logErrorMessage(new Exception(this.language.getText("msg13")));
            }
            document.read();
            if (this.documentsMRU.add(document)) {
                this.updateMenuMRU();
            }
            if (locked) {
                this.projectDocument = document;
            }
            this.setTitle(this.language.getText("appliTitle") + " [" + document.getDescription() + "]");
            this.setAskForSave(false);
            if (this.myPreviousStates.size() != 0) {
                this.bComparePrev.setEnabled(true);
            }
        } else {
            String errorMessage = this.language.getText("msg2") + "\n" + document.getDescription();
            this.getUIFacade().showErrorDialog(errorMessage);
            return;
        }
        Chart[] charts = Mediator.getPluginManager().getCharts();
        for (int i = 0; i < charts.length; ++i) {
            charts[i].setTaskManager(this.myTaskManager);
            charts[i].reset();
        }
        this.addMouseListenerToAllContainer(this.getComponents());
        this.getTaskManager().processCriticalPath((TaskNode)this.tree.getRoot());
        ArrayList projectTasks = this.tree.getProjectTasks();
        if (projectTasks.size() != 0) {
            for (int i = 0; i < projectTasks.size(); ++i) {
                this.getTaskManager().processCriticalPath((TaskNode)projectTasks.get(i));
            }
        }
    }

    public void openStartupDocument(String path) {
        if (path != null) {
            Document document = this.getDocumentManager().getDocument(path);
            this.getProjectUIFacade().openProject(document, this.getProject());
        }
    }

    private void openStartupDocument(Document document) {
        this.getProjectUIFacade().openProject(document, this.getProject());
    }

    public boolean saveAsProject() throws IOException {
        this.tree.displayHiddenTasks();
        this.getProjectUIFacade().saveProjectAs(this.getProject());
        return true;
    }

    public boolean saveAsURLProject() throws IOException {
        this.getProjectUIFacade().saveProjectRemotely(this.getProject());
        return true;
    }

    public void saveProject() throws IOException {
        this.tree.displayHiddenTasks();
        this.getProjectUIFacade().saveProject(this.getProject());
    }

    public void changeWorkingDirectory(String newWorkDir) {
        if (null != newWorkDir) {
            this.options.setWorkingDirectory(newWorkDir);
        }
    }

    public UIConfiguration getUIConfiguration() {
        return this.myUIConfiguration;
    }

    public void quitApplication() {
        this.options.setWindowPosition(this.getX(), this.getY());
        this.options.setWindowSize(this.getWidth(), this.getHeight());
        this.options.setUIConfiguration(this.myUIConfiguration);
        this.options.setDocumentsMRU(this.documentsMRU);
        this.options.setLookAndFeel(this.lookAndFeel);
        this.options.setToolBarPosition(this.toolBar.getOrientation());
        this.options.save();
        if (this.checkCurrentProject()) {
            this.getProject().close();
            this.setVisible(false);
            this.dispose();
            System.exit(0);
        } else {
            this.setVisible(true);
        }
    }

    public void openWebPage() throws IOException {
        if (!BrowserControl.displayURL("http://ganttproject.org/")) {
            GanttDialogInfo gdi = new GanttDialogInfo(this, 0, GanttDialogInfo.YES_OPTION, this.language.getText("msg4"), this.language.getText("error"));
            gdi.show();
            return;
        }
        this.getUIFacade().setStatusText(GanttLanguage.getInstance().getText("opening") + " www.ganttproject.org");
    }

    public void setAskForSave(boolean afs) {
        if (this.isOnlyViewer) {
            return;
        }
        this.fireProjectModified(afs);
        String title = this.getTitle();
        if (this.getTabs().getSelectedIndex() == 0) {
            if (afs) {
                this.bSaveCurrent.setEnabled(afs);
            }
            if (this.myPreviousStates.size() != 0) {
                this.bComparePrev.setEnabled(true);
            }
        }
        this.askForSave = afs;
        try {
            if (System.getProperty("mrj.version") != null) {
                this.rootPane.putClientProperty("windowModified", afs);
            } else if (this.askForSave && !title.endsWith(" *")) {
                this.setTitle(this.getTitle() + " *");
            }
        }
        catch (AccessControlException e) {
            System.err.println(e + ": " + e.getMessage());
        }
    }

    private static void usage() {
        System.out.println();
        System.out.println("GanttProject usage : java -jar ganttproject-(VERSION).jar <OPTIONS>");
        System.out.println();
        System.out.println("  Here are the possible options:");
        System.out.println("    -h, --help : Print this message");
        System.out.println("    [project_file_name] a XML file based on ganttproject format to directly open (project.xml or project.gan)");
        System.out.println("    -html [project_file_name] [export_directory_name], export directly a ganttproject file to web pages");
        System.out.println("         -xsl-dir [xsl_directory]                        localisation of the xsl directory for html export");
        System.out.println("    -pdf  [project_file_name] [pdf_file_name],         export directly a ganttproject file to web pages");
        System.out.println("         -xsl-fo [xsl_fo_file]                           localisation of the xsl-fo file for pdf export");
        System.out.println("    -csv  [project_file_name] [csv_image_filename],    export directly a ganttproject file to csv document compatible with spreadsheets");
        System.out.println("    -png  [project_file_name] [png_image_filename],    export directly a ganttproject file to png image");
        System.out.println("    -jpg  [project_file_name] [jpg_image_filename],    export directly a ganttproject file to jpg image");
        System.out.println("    -fig/-xfig  [project_file_name] [fig_image_filename],    export directly a ganttproject file to xfig image");
        System.out.println();
        System.out.println("    In all these cases the project_file_name can either be a file on local disk or an URL.");
        System.out.println("    If the URL is password-protected, you can give credentials this way:");
        System.out.println("      http://username:password@example.com/filename");
        System.out.println(" ");
    }

    public GanttResourcePanel getResourcePanel() {
        if (this.resp == null) {
            this.resp = new GanttResourcePanel(this, this.getTree(), this.getUIFacade());
            this.resp.setResourceActions(this.getResourceActions());
            this.getHumanResourceManager().addView(this.resp);
        }
        return this.resp;
    }

    public GanttLanguage getLanguage() {
        return this.language;
    }

    public GanttGraphicArea getArea() {
        return this.area;
    }

    public GanttTree2 getTree() {
        if (this.tree == null) {
            this.tree = new GanttTree2(this, this.getTaskManager(), this.getUIFacade());
        }
        return this.tree;
    }

    public Action getCopyAction() {
        return this.getViewManager().getCopyAction();
    }

    public Action getCutAction() {
        return this.getViewManager().getCutAction();
    }

    public Action getPasteAction() {
        return this.getViewManager().getPasteAction();
    }

    private ResourceActionSet getResourceActions() {
        if (this.myResourceActions == null) {
            this.myResourceActions = new ResourceActionSet(this, this.getResourcePanel(), this, this.getUIFacade());
        }
        return this.myResourceActions;
    }

    public static void main(String[] arg) {
        CommandLineExportApplication cmdlineApplication;
        if (arg.length > 0 && "-pdelaunch".equals(arg[0])) {
            String[] newArgs = new String[arg.length - 1];
            if (newArgs.length > 0) {
                System.arraycopy(arg, 1, newArgs, 0, newArgs.length);
            }
            arg = newArgs;
        }
        if (arg.length > 0 && ("-h".equals(arg[0]) || "--help".equals(arg[0]))) {
            GanttProject.usage();
            System.exit(0);
        }
        if (!(cmdlineApplication = new CommandLineExportApplication()).export(arg)) {
            GanttSplash splash = new GanttSplash();
            splash.setVisible(true);
            GanttProject ganttFrame = new GanttProject(false);
            System.err.println("Main frame created");
            if (arg.length > 0) {
                ganttFrame.openStartupDocument(arg[0]);
            }
            splash.close();
            System.err.println("Splash closed");
            ganttFrame.setVisible(true);
        }
    }

    static boolean checkProjectFile(String[] arg) {
        if (arg.length <= 1) {
            System.out.println("ERROR...\nMust pass a project file");
            return false;
        }
        return true;
    }

    public String getProjectName() {
        return this.prjInfos._sProjectName;
    }

    public void setProjectName(String projectName) {
        this.prjInfos._sProjectName = projectName;
        this.setAskForSave(true);
    }

    public String getDescription() {
        return this.prjInfos.getDescription();
    }

    public void setDescription(String description) {
        this.prjInfos._sDescription = description;
        this.setAskForSave(true);
    }

    public String getOrganization() {
        return this.prjInfos.getOrganization();
    }

    public void setOrganization(String organization) {
        this.prjInfos._sOrganization = organization;
        this.setAskForSave(true);
    }

    public String getWebLink() {
        return this.prjInfos.getWebLink();
    }

    public void setWebLink(String webLink) {
        this.prjInfos._sWebLink = webLink;
        this.setAskForSave(true);
    }

    public ResourceManager getHumanResourceManager() {
        ResourceManager result = (ResourceManager)this.managerHash.get(HUMAN_RESOURCE_MANAGER_ID);
        if (result == null) {
            result = new HumanResourceManager(this.getRoleManager().getDefaultRole());
            this.managerHash.put(HUMAN_RESOURCE_MANAGER_ID, result);
            result.addView(this);
        }
        return result;
    }

    public TaskManager getTaskManager() {
        return this.myTaskManager;
    }

    public RoleManager getRoleManager() {
        RoleManager result = (RoleManager)this.managerHash.get(ROLE_MANAGER_ID);
        if (result == null) {
            result = RoleManager.Access.getInstance();
            this.managerHash.put(ROLE_MANAGER_ID, result);
        }
        return result;
    }

    public Document getDocument() {
        return this.projectDocument;
    }

    public void setDocument(Document document) {
        this.projectDocument = document;
    }

    public GanttLanguage getI18n() {
        return this.getLanguage();
    }

    public GPCalendar getActiveCalendar() {
        return this.myFakeCalendar;
    }

    public void setModified() {
        this.setAskForSave(true);
    }

    public void setModified(boolean modified) {
        this.setAskForSave(modified);
    }

    public boolean isModified() {
        return this.askForSave;
    }

    public void close() {
        this.fireProjectClosed();
        this.prjInfos = new PrjInfos();
        RoleManager.Access.getInstance().clear();
        if (null != this.projectDocument) {
            this.projectDocument.releaseLock();
        }
        this.projectDocument = null;
        this.setModified(false);
        this.getTaskManager().clear();
        this.getCustomColumnsStorage().reset();
        for (int i = 0; i < this.myPreviousStates.size(); ++i) {
            ((GanttPreviousState)this.myPreviousStates.get(i)).remove();
        }
        this.myPreviousStates = new ArrayList();
        this.bComparePrev.setEnabled(false);
    }

    protected ParserFactory getParserFactory() {
        if (this.myParserFactory == null) {
            this.myParserFactory = new ParserFactoryImpl();
        }
        return this.myParserFactory;
    }

    public void resourceAdded(ResourceEvent event) {
        if (this.getStatusBar() != null) {
            this.getUIFacade().setStatusText(GanttLanguage.getInstance().correctLabel(GanttLanguage.getInstance().getText("newHuman")));
            this.setAskForSave(true);
            this.refreshProjectInfos();
        }
    }

    public void resourcesRemoved(ResourceEvent event) {
        this.refreshProjectInfos();
        this.setAskForSave(true);
    }

    public void resourceChanged(ResourceEvent e) {
        this.setAskForSave(true);
    }

    public void resourceAssignmentsChanged(ResourceEvent e) {
        this.setAskForSave(true);
    }

    public Chart getActiveChart() {
        Chart resourcesChart = this.getResourceChart();
        GanttChart ganttChart = this.getGanttChart();
        Chart visibleChart = this.getTabs().getSelectedIndex() == 1 ? resourcesChart : ganttChart;
        return visibleChart;
    }

    public GanttChart getGanttChart() {
        return this.getArea();
    }

    public Chart getResourceChart() {
        return this.getResourcePanel().area;
    }

    public int getGanttDividerLocation() {
        return this.myGanttChartTabContent.getDividerLocation();
    }

    public void setGanttDividerLocation(int location) {
        this.myGanttChartTabContent.setDividerLocation(location);
    }

    public int getResourceDividerLocation() {
        return this.getResourcePanel().getDividerLocation();
    }

    public void setResourceDividerLocation(int location) {
        this.getResourcePanel().setDividerLocation(location);
    }

    public TaskTreeUIFacade getTaskTree() {
        return this.getTree();
    }

    public ResourceTreeUIFacade getResourceTree() {
        return this.getResourcePanel();
    }

    public void setRowHeight(int value) {
        this.tree.getTreeTable().getTable().setRowHeight(value);
    }

    public void changeOrder(DefaultListModel buttonList, DefaultListModel deletedButtonList) {
        int i;
        this.iconList = new DefaultListModel();
        for (i = 0; i < buttonList.size(); ++i) {
            this.iconList.addElement(buttonList.getElementAt(i));
        }
        this.deletedIconList = new DefaultListModel();
        for (i = 0; i < deletedButtonList.size(); ++i) {
            this.deletedIconList.addElement(deletedButtonList.getElementAt(i));
        }
        this.addButtons();
        this.options.setIconList(this.getIconPositions(this.iconList));
        this.options.setDeletedIconList(this.getIconPositions(this.deletedIconList));
        this.setHiddens();
        this.refresh();
    }

    private String getIconPositions(DefaultListModel list) {
        String sIcons = "";
        if (list != null) {
            int i = 0;
            if (list.equals(this.deletedIconList)) {
                ++i;
            }
            while (i < list.size()) {
                if (!sIcons.equals("")) {
                    sIcons = sIcons + ",";
                }
                if (list.elementAt(i).equals(GPToolBar.SEPARATOR_OBJECT)) {
                    sIcons = sIcons + 0;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bNew) {
                    sIcons = sIcons + 2;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bOpen) {
                    sIcons = sIcons + 3;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bSave) {
                    sIcons = sIcons + 4;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bImport) {
                    sIcons = sIcons + 6;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bExport) {
                    sIcons = sIcons + 7;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bPrint) {
                    sIcons = sIcons + 8;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bPreviewPrint) {
                    sIcons = sIcons + 33;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bCut) {
                    sIcons = sIcons + 9;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bCopy) {
                    sIcons = sIcons + 10;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bPaste) {
                    sIcons = sIcons + 11;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bNewTask) {
                    sIcons = sIcons + 12;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bDelete) {
                    sIcons = sIcons + 13;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bProperties) {
                    sIcons = sIcons + 14;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bPrev) {
                    sIcons = sIcons + 21;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bScrollCenter) {
                    sIcons = sIcons + 22;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bNext) {
                    sIcons = sIcons + 23;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bZoomOut) {
                    sIcons = sIcons + 24;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bZoomIn) {
                    sIcons = sIcons + 25;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bUndo) {
                    sIcons = sIcons + 26;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bRedo) {
                    sIcons = sIcons + 27;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bCritical) {
                    sIcons = sIcons + 28;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bAbout) {
                    sIcons = sIcons + 29;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bSaveCurrent) {
                    sIcons = sIcons + 30;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bComparePrev) {
                    sIcons = sIcons + 31;
                } else if ((TestGanttRolloverButton)list.elementAt(i) == this.bRefresh) {
                    sIcons = sIcons + 32;
                }
                ++i;
            }
        }
        return sIcons;
    }

    public DefaultListModel initIconList() {
        DefaultListModel list = new DefaultListModel();
        int[] icons = this.options.getIconList();
        for (int i = 0; i < icons.length; ++i) {
            this.addButton(icons[i], list);
        }
        return list;
    }

    public DefaultListModel initDeletedIconList() {
        DefaultListModel list = new DefaultListModel();
        if (this.options.getDeletedIconList() != null) {
            int[] icons = this.options.getDeletedIconList();
            for (int i = 0; i < icons.length; ++i) {
                this.addButton(icons[i], list);
            }
        }
        return list;
    }

    public void addButton(int icon, DefaultListModel list) {
        switch (icon) {
            case 0: {
                list.addElement(GPToolBar.SEPARATOR_OBJECT);
                break;
            }
            case 2: {
                list.addElement(this.bNew);
                break;
            }
            case 3: {
                list.addElement(this.bOpen);
                break;
            }
            case 4: {
                list.addElement(this.bSave);
                break;
            }
            case 6: {
                list.addElement(this.bImport);
                break;
            }
            case 7: {
                list.addElement(this.bExport);
                break;
            }
            case 8: {
                list.addElement(this.bPrint);
                break;
            }
            case 33: {
                list.addElement(this.bPreviewPrint);
                break;
            }
            case 9: {
                list.addElement(this.bCut);
                break;
            }
            case 10: {
                list.addElement(this.bCopy);
                break;
            }
            case 11: {
                list.addElement(this.bPaste);
                break;
            }
            case 12: {
                list.addElement(this.bNewTask);
                break;
            }
            case 13: {
                list.addElement(this.bDelete);
                break;
            }
            case 14: {
                list.addElement(this.bProperties);
                break;
            }
            case 21: {
                list.addElement(this.bPrev);
                break;
            }
            case 22: {
                list.addElement(this.bScrollCenter);
                break;
            }
            case 23: {
                list.addElement(this.bNext);
                break;
            }
            case 24: {
                list.addElement(this.bZoomOut);
                break;
            }
            case 25: {
                list.addElement(this.bZoomIn);
                break;
            }
            case 26: {
                list.addElement(this.bUndo);
                break;
            }
            case 27: {
                list.addElement(this.bRedo);
                break;
            }
            case 28: {
                list.addElement(this.bCritical);
                break;
            }
            case 29: {
                list.addElement(this.bAbout);
                break;
            }
            case 30: {
                list.addElement(this.bSaveCurrent);
                break;
            }
            case 31: {
                list.addElement(this.bComparePrev);
                break;
            }
            case 32: {
                list.addElement(this.bRefresh);
                break;
            }
        }
    }

    private void addButtons() {
        ArrayList buttons = new ArrayList(this.iconList.getSize());
        for (int i = 0; i < this.iconList.getSize(); ++i) {
            buttons.add(this.iconList.get(i));
        }
        this.toolBar.populate(buttons);
    }

    public DefaultListModel getButtonList() {
        return this.iconList;
    }

    public DefaultListModel getDeletedButtonList() {
        return this.deletedIconList;
    }

    public void repaint2() {
        this.getResourcePanel().getResourceTreeTableModel().updateResources();
        this.getResourcePanel().getResourceTreeTable().setRowHeight(20);
        if (this.myDelayManager != null) {
            this.myDelayManager.fireDelayObservation();
        }
        super.repaint();
    }

    public void recalculateCriticalPath() {
        if (this.myUIConfiguration.isCriticalPathOn()) {
            this.getTaskManager().processCriticalPath((TaskNode)this.tree.getRoot());
            ArrayList projectTasks = this.tree.getProjectTasks();
            if (projectTasks.size() != 0) {
                for (int i = 0; i < projectTasks.size(); ++i) {
                    this.getTaskManager().processCriticalPath((TaskNode)projectTasks.get(i));
                }
            }
            this.repaint();
        }
    }

    public int getViewIndex() {
        if (this.getTabs() == null) {
            return -1;
        }
        return this.getTabs().getSelectedIndex();
    }

    public void setViewIndex(int viewIndex) {
        if (this.getTabs().getTabCount() > viewIndex) {
            this.getTabs().setSelectedIndex(viewIndex);
        }
    }

    public static void setWindowListener(WindowListener windowListener) {
        ourWindowListener = windowListener;
    }

    public void refresh() {
        this.getTaskManager().processCriticalPath((TaskNode)this.tree.getRoot());
        ArrayList projectTasks = this.tree.getProjectTasks();
        if (projectTasks.size() != 0) {
            for (int i = 0; i < projectTasks.size(); ++i) {
                this.getTaskManager().processCriticalPath((TaskNode)projectTasks.get(i));
            }
        }
        this.getResourcePanel().getResourceTreeTableModel().updateResources();
        this.getResourcePanel().getResourceTreeTable().setRowHeight(20);
        if (this.myDelayManager != null) {
            this.myDelayManager.fireDelayObservation();
        }
        super.repaint();
    }

    public void showHiddenButtonsPaneMenu() {
        this.menu.applyComponentOrientation(this.language.getComponentOrientation());
        this.menu.show(this.toolBar, this.bShowHiddens.getX(), this.bShowHiddens.getY());
    }

    public void setHiddens() {
        int i;
        this.menu.removeAll();
        this.addButtons();
        int separatorSize = Integer.parseInt(this.options.getIconSize());
        double toolBarlength = 0.0;
        int buttonSize = 0;
        int lastDisplayedIndex = 0;
        Component[] buttons = this.toolBar.getComponents();
        toolBarlength = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().getWidth() : this.toolBar.getSize().getHeight();
        int position = 10;
        for (i = 0; i < buttons.length; ++i) {
            if (buttons[i].getClass() == (class$net$sourceforge$ganttproject$gui$TestGanttRolloverButton == null ? GanttProject.class$("net.sourceforge.ganttproject.gui.TestGanttRolloverButton") : class$net$sourceforge$ganttproject$gui$TestGanttRolloverButton)) {
                buttonSize = this.toolBar.getOrientation() == 0 ? buttons[i].getWidth() : buttons[i].getHeight();
                if ((double)((position += buttonSize) + 2 * this.bShowHiddens.getWidth() / 3) < toolBarlength) {
                    lastDisplayedIndex = i;
                    continue;
                }
                this.menu.add(buttons[i]);
                continue;
            }
            position += separatorSize;
        }
        if (this.menu.getComponentCount() != 0) {
            for (i = lastDisplayedIndex + 1; i < buttons.length; ++i) {
                this.toolBar.remove(buttons[i]);
            }
            this.toolBar.add(this.bShowHiddens);
        }
    }

    public CustomPropertyManager getResourceCustomPropertyManager() {
        return this.getResourcePanel().getResourceTreeTable();
    }

    private class ParserFactoryImpl
    implements ParserFactory {
        private ParserFactoryImpl() {
        }

        public GPParser newParser() {
            return new GanttXMLOpen(GanttProject.this.prjInfos, GanttProject.this.getUIConfiguration(), GanttProject.this.getTaskManager(), GanttProject.this.getUIFacade());
        }

        public GPSaver newSaver() {
            return new GanttXMLSaver(GanttProject.this, GanttProject.this.getTree(), GanttProject.this.getResourcePanel(), GanttProject.this.getArea(), GanttProject.this.getUIFacade());
        }
    }

    public static class ExportFileInfo {
        private static final String[] FILE_EXTENSIONS = new String[]{"html", "png", "jpg", "pdf", "xfig", "csv", "mpx"};
        public final File myFile;
        public final int myFormat;
        public final GanttExportSettings myStorageOptions;
        public static final int FORMAT_HTML = 1;
        public static final int FORMAT_PNG = 2;
        public static final int FORMAT_JPG = 3;
        public static final int FORMAT_PDF = 4;
        public static final int FORMAT_XFIG = 5;
        public static final int FORMAT_CSV = 6;
        public static final int FORMAT_MSPROJECT = 7;
        public static final ExportFileInfo EMPTY = new ExportFileInfo(null, -1, null);

        public ExportFileInfo(File file, int format, GanttExportSettings options) {
            this.myFile = file;
            this.myFormat = format;
            this.myStorageOptions = options;
        }

        public String getFileExtension() {
            return FILE_EXTENSIONS[this.myFormat];
        }
    }
}

