/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.ganttproject.GanttExportSettings;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.document.DocumentManager;
import net.sourceforge.ganttproject.document.DocumentsMRU;
import net.sourceforge.ganttproject.gui.GanttLookAndFeelInfo;
import net.sourceforge.ganttproject.gui.GanttLookAndFeels;
import net.sourceforge.ganttproject.gui.UIConfiguration;
import net.sourceforge.ganttproject.gui.options.model.GP1XOptionConverter;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.io.CSVOptions;
import net.sourceforge.ganttproject.io.GanttXMLOpen;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.parser.IconPositionTagHandler;
import net.sourceforge.ganttproject.parser.RoleTagHandler;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.roles.RoleManager;
import net.sourceforge.ganttproject.roles.RoleSet;
import net.sourceforge.ganttproject.util.ColorConvertion;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class GanttOptions {
    private GanttLanguage language = GanttLanguage.getInstance();
    private int x = 0;
    private int y = 0;
    private int width = 800;
    private int height = 600;
    private String styleClass = "";
    private String styleName = "";
    private GanttLookAndFeelInfo lookAndFeel;
    private boolean isloaded;
    private boolean automatic;
    private boolean openTips;
    private boolean redline;
    private int lockDAVMinutes;
    private int undoNumber;
    private String xslDir;
    private String xslFo;
    private String workingDir = "";
    private final RoleManager myRoleManager;
    private DocumentsMRU documentsMRU;
    private UIConfiguration myUIConfig;
    private Font myChartMainFont;
    private String sTaskNamePrefix;
    private int toolBarPosition;
    private boolean bShowStatusBar;
    private String iconSize;
    public static final int ICONS = 0;
    public static final int ICONS_TEXT = 1;
    public static final int TEXT = 2;
    private int buttonsshow;
    private String FTPUrl = "";
    private String FTPDirectory = "";
    private String FTPUser = "";
    private String FTPPwd = "";
    private boolean bExportName;
    private boolean bExportComplete;
    private boolean bExportRelations;
    private boolean bExport3DBorders;
    private CSVOptions csvOptions;
    private int[] iconListAsIntArray;
    private int[] deletedIconListAsIntArray;
    private String iconListAsString;
    private String deletedIconListAsString;
    private boolean isOnlyViewer;
    public static final int SEPARATOR = 0;
    public static final int EXIT = 1;
    public static final int NEW = 2;
    public static final int OPEN = 3;
    public static final int SAVE = 4;
    public static final int SAVEAS = 5;
    public static final int IMPORT = 6;
    public static final int EXPORT = 7;
    public static final int PRINT = 8;
    public static final int CUT = 9;
    public static final int COPY = 10;
    public static final int PASTE = 11;
    public static final int NEWTASK = 12;
    public static final int DELETE = 13;
    public static final int PROPERTIES = 14;
    public static final int UNLINK = 15;
    public static final int LINK = 16;
    public static final int IND = 17;
    public static final int UNIND = 18;
    public static final int UP = 19;
    public static final int DOWN = 20;
    public static final int PREV = 21;
    public static final int CENTER = 22;
    public static final int NEXT = 23;
    public static final int ZOOMOUT = 24;
    public static final int ZOOMIN = 25;
    public static final int UNDO = 26;
    public static final int REDO = 27;
    public static final int CRITICAL = 28;
    public static final int ABOUT = 29;
    public static final int SAVECURRENT = 30;
    public static final int COMPAREPREV = 31;
    public static final int REFRESH = 32;
    public static final int PREVIEWPRINT = 33;
    private Map myGPOptions = new LinkedHashMap();
    private Map myTagDotAttribute_Converter = new HashMap();
    private final DocumentManager myDocumentManager;
    private Font myMenuFont;

    public GanttOptions(RoleManager roleManager, DocumentManager documentManager, boolean isOnlyViewer) {
        this.myDocumentManager = documentManager;
        this.myRoleManager = roleManager;
        this.isOnlyViewer = isOnlyViewer;
        this.initByDefault();
        try {
            this.workingDir = System.getProperty("user.home");
        }
        catch (AccessControlException e) {
            System.err.println(e + ": " + e.getMessage());
        }
    }

    public void initByDefault() {
        this.automatic = false;
        this.openTips = true;
        this.redline = false;
        this.lockDAVMinutes = 240;
        this.undoNumber = 50;
        this.xslDir = GanttOptions.class.getResource("/xslt").toString();
        this.xslFo = GanttOptions.class.getResource("/xslfo/ganttproject.xsl").toString();
        this.sTaskNamePrefix = "";
        this.toolBarPosition = 0;
        this.bShowStatusBar = true;
        this.iconSize = "16";
        this.buttonsshow = 0;
        this.bExportName = true;
        this.bExportComplete = true;
        this.bExportRelations = true;
        this.bExport3DBorders = false;
        this.csvOptions = new CSVOptions();
        this.iconListAsString = this.getDefaultIconListAsString();
        this.iconListAsIntArray = this.getDefaultIconListIntArray();
        this.deletedIconListAsString = this.getDefaultDeletedIconListAsString();
        this.deletedIconListAsIntArray = this.getDefaultDeletedIconListIntArray();
    }

    private void startElement(String name, Attributes attrs, TransformerHandler handler) throws SAXException {
        handler.startElement("", name, name, attrs);
    }

    private void endElement(String name, TransformerHandler handler) throws SAXException {
        handler.endElement("", name, name);
    }

    private void addAttribute(String name, String value, AttributesImpl attrs) {
        if (value != null) {
            attrs.addAttribute("", name, name, "CDATA", value);
        } else {
            System.err.println("[GanttOptions] attribute '" + name + "' is null");
        }
    }

    private void emptyElement(String name, AttributesImpl attrs, TransformerHandler handler) throws SAXException {
        this.startElement(name, attrs, handler);
        this.endElement(name, handler);
        attrs.clear();
    }

    public void save() {
        try {
            Color daysOffColor;
            Color weekEndColor;
            Color resourceUnderloadColor;
            Color resourceOverloadColor;
            String sFileName = ".ganttproject";
            File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + sFileName);
            TransformerHandler handler = ((SAXTransformerFactory)SAXTransformerFactory.newInstance()).newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            handler.setResult(new StreamResult(file));
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            handler.startElement("", "ganttproject-options", "ganttproject-options", attrs);
            attrs.addAttribute("", "selection", "selection", "CDATA", this.language.getText("shortLanguage"));
            handler.startElement("", "language", "language", attrs);
            handler.endElement("", "language", "language");
            attrs.clear();
            Color resourceColor = this.myUIConfig.getResourceColor();
            if (resourceColor != null) {
                attrs.addAttribute("", "resources", "resources", "CDATA", "" + ColorConvertion.getColor(resourceColor));
            }
            if ((resourceOverloadColor = this.myUIConfig.getResourceOverloadColor()) != null) {
                attrs.addAttribute("", "resourcesOverload", "resourcesOverload", "CDATA", "" + ColorConvertion.getColor(resourceOverloadColor));
            }
            if ((resourceUnderloadColor = this.myUIConfig.getResourceUnderloadColor()) != null) {
                attrs.addAttribute("", "resourcesUnderload", "resourcesUnderload", "CDATA", "" + ColorConvertion.getColor(resourceUnderloadColor));
            }
            if ((weekEndColor = this.myUIConfig.getWeekEndColor()) != null) {
                attrs.addAttribute("", "weekEnd", "weekEnd", "CDATA", "" + ColorConvertion.getColor(weekEndColor));
            }
            if ((daysOffColor = this.myUIConfig.getDayOffColor()) != null) {
                attrs.addAttribute("", "daysOff", "daysOff", "CDATA", "" + ColorConvertion.getColor(daysOffColor));
            }
            handler.startElement("", "colors", "colors", attrs);
            handler.endElement("", "colors", "colors");
            attrs.clear();
            this.addAttribute("x", "" + this.x, attrs);
            this.addAttribute("y", "" + this.y, attrs);
            this.addAttribute("width", "" + this.width, attrs);
            this.addAttribute("height", "" + this.height, attrs);
            this.emptyElement("geometry", attrs, handler);
            this.addAttribute("name", this.lookAndFeel.getName(), attrs);
            this.addAttribute("class", this.lookAndFeel.getClassName(), attrs);
            this.emptyElement("looknfeel", attrs, handler);
            this.addAttribute("position", "" + this.toolBarPosition, attrs);
            this.addAttribute("icon-size", "" + this.iconSize, attrs);
            this.addAttribute("show", "" + this.buttonsshow, attrs);
            this.emptyElement("toolBar", attrs, handler);
            this.addAttribute("show", "" + this.bShowStatusBar, attrs);
            this.emptyElement("statusBar", attrs, handler);
            this.addAttribute("name", "" + this.bExportName, attrs);
            this.addAttribute("complete", "" + this.bExportComplete, attrs);
            this.addAttribute("border3d", "" + this.bExport3DBorders, attrs);
            this.addAttribute("relations", "" + this.bExportRelations, attrs);
            this.emptyElement("export", attrs, handler);
            this.startElement("csv-export", attrs, handler);
            this.addAttribute("fixed", "" + this.csvOptions.bFixedSize, attrs);
            this.addAttribute("separatedChar", "" + this.csvOptions.sSeparatedChar, attrs);
            this.addAttribute("separatedTextChar", "" + this.csvOptions.sSeparatedTextChar, attrs);
            this.emptyElement("csv-general", attrs, handler);
            this.addAttribute("id", "" + this.csvOptions.bExportTaskID, attrs);
            this.addAttribute("name", "" + this.csvOptions.bExportTaskName, attrs);
            this.addAttribute("start-date", "" + this.csvOptions.bExportTaskStartDate, attrs);
            this.addAttribute("end-date", "" + this.csvOptions.bExportTaskEndDate, attrs);
            this.addAttribute("percent", "" + this.csvOptions.bExportTaskPercent, attrs);
            this.addAttribute("duration", "" + this.csvOptions.bExportTaskDuration, attrs);
            this.addAttribute("webLink", "" + this.csvOptions.bExportTaskWebLink, attrs);
            this.addAttribute("resources", "" + this.csvOptions.bExportTaskResources, attrs);
            this.addAttribute("notes", "" + this.csvOptions.bExportTaskNotes, attrs);
            this.emptyElement("csv-tasks", attrs, handler);
            this.addAttribute("id", "" + this.csvOptions.bExportResourceID, attrs);
            this.addAttribute("name", "" + this.csvOptions.bExportResourceName, attrs);
            this.addAttribute("mail", "" + this.csvOptions.bExportResourceMail, attrs);
            this.addAttribute("phone", "" + this.csvOptions.bExportResourcePhone, attrs);
            this.addAttribute("role", "" + this.csvOptions.bExportResourceRole, attrs);
            this.emptyElement("csv-resources", attrs, handler);
            this.endElement("csv-export", handler);
            this.addAttribute("value", "" + this.automatic, attrs);
            this.emptyElement("automatic-launch", attrs, handler);
            this.emptyElement("dragTime", attrs, handler);
            this.addAttribute("value", "" + this.openTips, attrs);
            this.emptyElement("tips-on-startup", attrs, handler);
            this.addAttribute("value", "" + this.lockDAVMinutes, attrs);
            this.emptyElement("lockdavminutes", attrs, handler);
            this.addAttribute("dir", this.xslDir, attrs);
            this.emptyElement("xsl-dir", attrs, handler);
            this.addAttribute("file", this.xslFo, attrs);
            this.emptyElement("xsl-fo", attrs, handler);
            this.addAttribute("dir", this.workingDir, attrs);
            this.emptyElement("working-dir", attrs, handler);
            this.addAttribute("prefix", this.sTaskNamePrefix, attrs);
            this.emptyElement("task-name", attrs, handler);
            this.startElement("files", attrs, handler);
            Iterator iterator = this.documentsMRU.iterator();
            while (iterator.hasNext()) {
                Document document = (Document)iterator.next();
                this.addAttribute("path", document.getPath(), attrs);
                this.emptyElement("file", attrs, handler);
            }
            this.endElement("files", handler);
            this.addAttribute("category", "menu", attrs);
            this.addAttribute("spec", this.getFontSpec(this.getUIConfiguration().getMenuFont()), attrs);
            this.emptyElement("font", attrs, handler);
            this.addAttribute("category", "chart-main", attrs);
            this.addAttribute("spec", this.getFontSpec(this.getUIConfiguration().getChartMainFont()), attrs);
            this.emptyElement("font", attrs, handler);
            this.saveIconPositions(handler);
            this.saveRoleSets(handler);
            Iterator options = this.myGPOptions.entrySet().iterator();
            while (options.hasNext()) {
                Map.Entry nextEntry = options.next();
                GPOption nextOption = (GPOption)nextEntry.getValue();
                if (nextOption.getPersistentValue() == null) continue;
                this.addAttribute("id", nextEntry.getKey().toString(), attrs);
                this.addAttribute("value", nextOption.getPersistentValue(), attrs);
                this.emptyElement("option", attrs, handler);
            }
            this.endElement("ganttproject-options", handler);
            System.err.println("[GanttOptions] save(): finished!!");
            handler.endDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getFontSpec(Font font) {
        return font.getFamily() + "-" + this.getFontStyle(font) + "-" + font.getSize();
    }

    /*
     * WARNING - void declaration
     */
    private String getFontStyle(Font font) {
        void var2_3;
        int BOLDITALIC = 3;
        switch (font.getStyle()) {
            case 0: {
                String result = "plain";
                break;
            }
            case 1: {
                String result = "bold";
                break;
            }
            case 2: {
                String result = "italic";
                break;
            }
            case 3: {
                String result = "bolditalic";
                break;
            }
            default: {
                throw new RuntimeException("Illegal value of font style. style=" + font.getStyle() + " font=" + font);
            }
        }
        return var2_3;
    }

    public String correct(String s) {
        String res = s.replaceAll("&", "&#38;");
        res = res.replaceAll("<", "&#60;");
        res = res.replaceAll(">", "&#62;");
        res = res.replaceAll("/", "&#47;");
        res = res.replaceAll("\"", "&#34;");
        return res;
    }

    public boolean load() {
        GanttXMLOptionsParser handler = new GanttXMLOptionsParser();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            String sFileName = ".ganttproject";
            File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + sFileName);
            if (!file.exists()) {
                return false;
            }
            this.documentsMRU.clear();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(file, (DefaultHandler)handler);
            GanttLookAndFeelInfo info = GanttLookAndFeels.getGanttLookAndFeels().getInfoByClass(this.styleClass);
            if (null == info) {
                info = GanttLookAndFeels.getGanttLookAndFeels().getInfoByName(this.styleName);
            }
            if (null != info) {
                this.lookAndFeel = info;
            }
            if (null == this.lookAndFeel) {
                this.lookAndFeel = GanttLookAndFeels.getGanttLookAndFeels().getDefaultInfo();
            }
            this.loadRoleSets(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.isloaded = true;
        return true;
    }

    private void loadRoleSets(File optionsFile) {
        GanttXMLOpen loader = new GanttXMLOpen(null);
        IconPositionTagHandler iconHandler = new IconPositionTagHandler();
        loader.addTagHandler(iconHandler);
        loader.addTagHandler(new RoleTagHandler(this.getRoleManager()));
        loader.load(optionsFile);
        if (iconHandler.getList() != null) {
            this.iconListAsIntArray = iconHandler.getList();
            this.iconListAsString = iconHandler.getPositions();
        }
        if (iconHandler.getDeletedList() != null) {
            this.deletedIconListAsIntArray = iconHandler.getDeletedList();
            this.deletedIconListAsString = iconHandler.getDeletedPositions();
        }
    }

    private void saveRoleSets(TransformerHandler handler) throws TransformerConfigurationException, TransformerFactoryConfigurationError, SAXException {
        RoleSet[] roleSets = this.getRoleManager().getRoleSets();
        for (int i = 0; i < roleSets.length; ++i) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "roleset-name", "roleset-name", "CDATA", roleSets[i].getName());
            handler.startElement("", "roles", "roles", attrs);
            this.saveRoles(roleSets[i], handler);
            handler.endElement("", "roles", "roles");
        }
    }

    private void saveRoles(RoleSet roleSet, TransformerHandler handler) throws SAXException {
        Role[] roles = roleSet.getRoles();
        AttributesImpl attrs = new AttributesImpl();
        for (int i = 0; i < roles.length; ++i) {
            Role next = roles[i];
            this.addAttribute("id", "" + next.getID(), attrs);
            this.addAttribute("name", next.getName(), attrs);
            this.emptyElement("role", attrs, handler);
        }
    }

    private void saveIconPositions(TransformerHandler handler) throws TransformerConfigurationException, TransformerFactoryConfigurationError, SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addAttribute("icons-list", this.iconListAsString, attrs);
        this.addAttribute("deletedIcons-list", this.deletedIconListAsString, attrs);
        this.emptyElement("positions", attrs, handler);
    }

    public UIConfiguration getUIConfiguration() {
        if (this.myUIConfig == null) {
            this.myUIConfig = new UIConfiguration(null, null, new Color(140, 182, 206), this.redline){

                public Font getMenuFont() {
                    return GanttOptions.this.myMenuFont == null ? super.getMenuFont() : GanttOptions.this.myMenuFont;
                }

                public Font getChartMainFont() {
                    return GanttOptions.this.myChartMainFont == null ? super.getChartMainFont() : GanttOptions.this.myChartMainFont;
                }
            };
        }
        return this.myUIConfig;
    }

    private RoleManager getRoleManager() {
        return this.myRoleManager;
    }

    private String getFilePath(String value) {
        String filePath;
        String result = null;
        try {
            URL fileUrl = new URL(value);
            filePath = fileUrl.getPath();
        }
        catch (MalformedURLException e) {
            filePath = value;
        }
        if (new File(filePath).exists()) {
            result = filePath;
        }
        return result;
    }

    public GanttLanguage getLanguage() {
        return this.language;
    }

    public Color getDefaultColor() {
        return this.getUIConfiguration().getTaskColor();
    }

    public Color getResourceColor() {
        return this.getUIConfiguration().getResourceColor();
    }

    public int getLockDAVMinutes() {
        return this.lockDAVMinutes;
    }

    public int getUndoNumber() {
        return this.undoNumber;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getXslDir() {
        return this.xslDir;
    }

    public String getXslFo() {
        return new File(this.xslFo).exists() ? this.xslFo : this.getClass().getResource("/xslfo/ganttproject.xsl").toString();
    }

    public boolean getOpenTips() {
        return this.openTips;
    }

    public boolean getAutomatic() {
        return this.automatic;
    }

    public GanttLookAndFeelInfo getLnfInfos() {
        return this.lookAndFeel;
    }

    public boolean isLoaded() {
        return this.isloaded;
    }

    public boolean getShowStatusBar() {
        return this.bShowStatusBar;
    }

    public void setShowStatusBar(boolean showStatusBar) {
        this.bShowStatusBar = showStatusBar;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public CSVOptions getCSVOptions() {
        return this.csvOptions;
    }

    public String getTaskNamePrefix() {
        if (this.sTaskNamePrefix == null || this.sTaskNamePrefix.equals("")) {
            return this.language.getText("newTask");
        }
        return this.sTaskNamePrefix;
    }

    public String getTrueTaskNamePrefix() {
        if (this.sTaskNamePrefix == null || this.sTaskNamePrefix.equals("") || this.sTaskNamePrefix.equals(this.language.getText("newTask"))) {
            return null;
        }
        return this.sTaskNamePrefix;
    }

    public int getToolBarPosition() {
        return this.toolBarPosition;
    }

    public String getIconSize() {
        return this.iconSize;
    }

    public boolean getExportName() {
        return this.bExportName;
    }

    public boolean getExportComplete() {
        return this.bExportComplete;
    }

    public boolean getExportRelations() {
        return this.bExportRelations;
    }

    public boolean getExport3dBorders() {
        return this.bExport3DBorders;
    }

    public GanttExportSettings getExportSettings() {
        return new GanttExportSettings(this.bExportName, this.bExportComplete, this.bExportRelations, this.bExport3DBorders);
    }

    public void setExportName(boolean exportName) {
        this.bExportName = exportName;
    }

    public void setExportComplete(boolean exportComplete) {
        this.bExportComplete = exportComplete;
    }

    public void setExportRelations(boolean eportRelations) {
        this.bExportRelations = eportRelations;
    }

    public void setExport3dBorders(boolean borders3d) {
        this.bExport3DBorders = borders3d;
    }

    public int[] getIconList() {
        return this.iconListAsIntArray;
    }

    public int[] getDeletedIconList() {
        return this.deletedIconListAsIntArray;
    }

    public void setIconList(String list) {
        this.iconListAsString = list;
    }

    public void setDeletedIconList(String list) {
        this.deletedIconListAsString = list;
    }

    public int getButtonShow() {
        return this.buttonsshow;
    }

    public void setButtonShow(int buttonShow) {
        if (buttonShow != 0 && buttonShow != 2 && buttonShow != 1) {
            buttonShow = 0;
        }
        this.buttonsshow = buttonShow;
    }

    public void setIconSize(String sIconSize) {
        this.iconSize = sIconSize;
    }

    public void setToolBarPosition(int iToolBarPosition) {
        this.toolBarPosition = iToolBarPosition;
    }

    public void setWindowPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setWindowSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDir = workingDirectory;
    }

    public void setLockDAVMinutes(int minuteslock) {
        this.lockDAVMinutes = minuteslock;
    }

    public void setUndoNumber(int number) {
        this.undoNumber = number;
    }

    public void setDefaultTaskColor(Color color) {
        this.getUIConfiguration().setTaskColor(color);
    }

    public void setResourceColor(Color color) {
        this.getUIConfiguration().setResourceColor(color);
    }

    public void setResourceOverloadColor(Color color) {
        this.getUIConfiguration().setResourceOverloadColor(color);
    }

    public void setResourceUnderloadColor(Color color) {
        this.getUIConfiguration().setResourceUnderloadColor(color);
    }

    public void setPreviousTaskColor(Color color) {
        this.getUIConfiguration().setPreviousTaskColor(color);
    }

    public void setEarlierPreviousTaskColor(Color color) {
        this.getUIConfiguration().setEarlierPreviousTaskColor(color);
    }

    public void setLaterPreviousTaskColor(Color color) {
        this.getUIConfiguration().setLaterPreviousTaskColor(color);
    }

    public void setWeekEndColor(Color color) {
        this.getUIConfiguration().setWeekEndColor(color);
    }

    public void setDaysOffColor(Color color) {
        this.getUIConfiguration().setDayOffColor(color);
    }

    public void setXslDir(String xslDir) {
        this.xslDir = xslDir;
    }

    public void setXslFo(String xslFo) {
        this.xslFo = xslFo;
    }

    public void setDocumentsMRU(DocumentsMRU documentsMRU) {
        this.documentsMRU = documentsMRU;
    }

    public void setUIConfiguration(UIConfiguration uiConfiguration) {
        this.myUIConfig = uiConfiguration;
    }

    public void setOpenTips(boolean openTips) {
        this.openTips = openTips;
    }

    public void setAutomatic(boolean automatic) {
        this.automatic = automatic;
    }

    public void setLookAndFeel(GanttLookAndFeelInfo lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public void setTaskNamePrefix(String taskNamePrefix) {
        this.sTaskNamePrefix = taskNamePrefix;
    }

    public void setRedline(boolean isOn) {
        this.redline = isOn;
        this.getUIConfiguration().setRedlineOn(isOn);
    }

    public String getFTPDirectory() {
        return this.FTPDirectory;
    }

    public String getFTPPwd() {
        return this.FTPPwd;
    }

    public String getFTPUrl() {
        return this.FTPUrl;
    }

    public String getFTPUser() {
        return this.FTPUser;
    }

    public void setFTPDirectory(String pvString) {
        this.FTPDirectory = pvString;
    }

    public void setFTPPwd(String pvString) {
        this.FTPPwd = pvString;
    }

    public void setFTPUrl(String pvString) {
        this.FTPUrl = pvString;
    }

    public void setFTPUser(String pvString) {
        this.FTPUser = pvString;
    }

    public String getDefaultIconListAsString() {
        return GanttOptions.getStringList(this.getDefaultIconListIntArray());
    }

    private static String getStringList(int[] tabInt) {
        String res = "";
        int i = 0;
        for (i = 0; i < tabInt.length - 1; ++i) {
            res = res + tabInt[i] + ",";
        }
        res = res + tabInt[i];
        return res;
    }

    public int[] getDefaultIconListIntArray() {
        if (!this.isOnlyViewer) {
            return new int[]{4, 0, 9, 10, 11, 0, 26, 27, 0, 12, 13, 14, 15, 16, 17, 18, 19, 20, 0, 21, 22, 23, 24, 25, 0, 30, 31, 0, 28};
        }
        return new int[]{1, 3, 4, 5, 6, 7, 8, 33, 0, 21, 22, 23, 24, 25, 0, 28, 0, 29};
    }

    public String getDefaultDeletedIconListAsString() {
        return "";
    }

    public int[] getDefaultDeletedIconListIntArray() {
        return null;
    }

    public void addOptionGroups(GPOptionGroup[] optionGroups) {
        for (int i = 0; i < optionGroups.length; ++i) {
            GPOptionGroup nextGroup = optionGroups[i];
            this.addOptions(nextGroup);
        }
    }

    private void addOptions(GPOptionGroup optionGroup) {
        GPOption[] options = optionGroup.getOptions();
        for (int i = 0; i < options.length; ++i) {
            GPOption nextOption = options[i];
            this.myGPOptions.put(optionGroup.getID() + "." + nextOption.getID(), nextOption);
            if (!(nextOption instanceof GP1XOptionConverter)) continue;
            GP1XOptionConverter nextConverter = (GP1XOptionConverter)((Object)nextOption);
            this.myTagDotAttribute_Converter.put(nextConverter.getTagName() + "." + nextConverter.getAttributeName(), nextConverter);
        }
    }

    class GanttXMLOptionsParser
    extends DefaultHandler {
        GanttXMLOptionsParser() {
        }

        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            int r = 0;
            int g = 0;
            int b = 0;
            if ("option".equals(qName)) {
                GPOption option = (GPOption)GanttOptions.this.myGPOptions.get(attrs.getValue("id"));
                if (option != null) {
                    option.lock();
                    option.loadPersistentValue(attrs.getValue("value"));
                    option.commit();
                }
                return;
            }
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getQName(i);
                    String value = attrs.getValue(i);
                    String tagDotAttribute = qName + "." + aName;
                    GP1XOptionConverter converter = (GP1XOptionConverter)GanttOptions.this.myTagDotAttribute_Converter.get(tagDotAttribute);
                    if (converter != null) {
                        converter.loadValue(value);
                        continue;
                    }
                    if (qName.equals("language")) {
                        if (aName != "selection") continue;
                        if (value.equals("English") || value.equals("en")) {
                            GanttOptions.this.language.setLocale(Locale.US);
                            continue;
                        }
                        if (value.equals("English (UK)") || value.equals("en_GB")) {
                            GanttOptions.this.language.setLocale(Locale.UK);
                            continue;
                        }
                        if (value.equals("Fran\u00e7ais") || value.equals("fr")) {
                            GanttOptions.this.language.setLocale(Locale.FRANCE);
                            continue;
                        }
                        if (value.equals("Espa\u00f1ol") || value.equals("es")) {
                            GanttOptions.this.language.setLocale(new Locale("es", "ES"));
                            continue;
                        }
                        if (value.equals("Portugues") || value.equals("pt")) {
                            GanttOptions.this.language.setLocale(new Locale("pt", "PT"));
                            continue;
                        }
                        if (value.equals("Portugu\u00eas do Brasil") || value.equals("pt_BR")) {
                            GanttOptions.this.language.setLocale(new Locale("pt", "BR"));
                            continue;
                        }
                        if (value.equals("Deutsch") || value.equals("de")) {
                            GanttOptions.this.language.setLocale(Locale.GERMANY);
                            continue;
                        }
                        if (value.equals("Norsk") || value.equals("no")) {
                            GanttOptions.this.language.setLocale(new Locale("no", "NO"));
                            continue;
                        }
                        if (value.equals("Italiano") || value.equals("it")) {
                            GanttOptions.this.language.setLocale(Locale.ITALY);
                            continue;
                        }
                        if (value.equals("Japanese") || value.equals("jpn")) {
                            GanttOptions.this.language.setLocale(new Locale("ja", "JP"));
                            continue;
                        }
                        if (value.equals("T\u00fcrk\u00e7e") || value.equals("tr")) {
                            GanttOptions.this.language.setLocale(new Locale("tr", "TR"));
                            continue;
                        }
                        if (value.equals("Simplified Chinese") || value.equals("SIMPLIFIED_CHINESE") || value.equals("CHINA") || value.equals("zh_CN")) {
                            GanttOptions.this.language.setLocale(Locale.CHINA);
                            continue;
                        }
                        if (value.equals("Traditional Chinese") || value.equals("TRADITIONAL_CHINESE") || value.equals("TAIWAN") || value.equals("zh_TW")) {
                            GanttOptions.this.language.setLocale(Locale.TAIWAN);
                            continue;
                        }
                        if (value.equals("Polski") || value.equals("pl")) {
                            GanttOptions.this.language.setLocale(new Locale("pl", "PL"));
                            continue;
                        }
                        if (value.equals("\u0420\u0443\u0441\u0441\u043a\u0438\u0439") || value.equals("ru")) {
                            GanttOptions.this.language.setLocale(new Locale("ru", "RU"));
                            continue;
                        }
                        if (value.equals("Estonian") || value.equals("et")) {
                            GanttOptions.this.language.setLocale(new Locale("et", "ET"));
                            continue;
                        }
                        if (value.equals("fi")) {
                            GanttOptions.this.language.setLocale(new Locale("fi", "FI"));
                            continue;
                        }
                        if (value.equals("Hungarian") || value.equals("hu")) {
                            GanttOptions.this.language.setLocale(new Locale("hu", "HU"));
                            continue;
                        }
                        if (value.equals("\u05d0\u05e0\u05d2\u05dc\u05d9\u05ea") || value.equals("iw")) {
                            GanttOptions.this.language.setLocale(new Locale("iw", "IW"));
                            continue;
                        }
                        if (value.equals("Sloven\u0161\u010dina") || value.equals("si")) {
                            GanttOptions.this.language.setLocale(new Locale("si", "SI"));
                            continue;
                        }
                        if (value.equals("Slovensky") || value.equals("sk")) {
                            GanttOptions.this.language.setLocale(new Locale("sk", "SK"));
                            continue;
                        }
                        if (value.equals("Svenska") || value.equals("sv")) {
                            GanttOptions.this.language.setLocale(new Locale("sv", "SV"));
                            continue;
                        }
                        if (value.equals("Romanian") || value.equals("ro")) {
                            GanttOptions.this.language.setLocale(new Locale("ro", "RO"));
                            continue;
                        }
                        if (value.equals("Nederlands") || value.equals("nl")) {
                            GanttOptions.this.language.setLocale(new Locale("nl", "NL"));
                            continue;
                        }
                        if (value.equals("\u010cesky") || value.equals("cz")) {
                            GanttOptions.this.language.setLocale(new Locale("cs", "CZ"));
                            continue;
                        }
                        if (!value.equals("Dansk") && !value.equals("da")) continue;
                        GanttOptions.this.language.setLocale(new Locale("da", "DK"));
                        continue;
                    }
                    if (qName.equals("task-color")) {
                        if (aName.equals("red")) {
                            r = new Integer(value).hashCode();
                            continue;
                        }
                        if (aName.equals("green")) {
                            g = new Integer(value).hashCode();
                            continue;
                        }
                        if (!aName.equals("blue")) continue;
                        b = new Integer(value).hashCode();
                        continue;
                    }
                    if (qName.equals("geometry")) {
                        if (aName.equals("x")) {
                            GanttOptions.this.x = new Integer(value).hashCode();
                        }
                        if (aName.equals("y")) {
                            GanttOptions.this.y = new Integer(value).hashCode();
                        }
                        if (aName.equals("width")) {
                            GanttOptions.this.width = new Integer(value).hashCode();
                        }
                        if (!aName.equals("height")) continue;
                        GanttOptions.this.height = new Integer(value).hashCode();
                        continue;
                    }
                    if (qName.equals("looknfeel")) {
                        if (aName.equals("name")) {
                            GanttOptions.this.styleName = value;
                        }
                        if (!aName.equals("class")) continue;
                        GanttOptions.this.styleClass = value;
                        continue;
                    }
                    if (qName.equals("file")) {
                        if (!aName.equals("path")) continue;
                        GanttOptions.this.documentsMRU.append(GanttOptions.this.myDocumentManager.getDocument(value));
                        continue;
                    }
                    if (qName.equals("automatic-launch")) {
                        if (!aName.equals("value")) continue;
                        GanttOptions.this.automatic = new Boolean(value);
                        continue;
                    }
                    if (qName.equals("tips-on-startup")) {
                        if (!aName.equals("value")) continue;
                        GanttOptions.this.openTips = new Boolean(value);
                        continue;
                    }
                    if (qName.equals("lockdavminutes")) {
                        if (!aName.equals("value")) continue;
                        GanttOptions.this.lockDAVMinutes = new Integer(value);
                        continue;
                    }
                    if (qName.equals("xsl-dir")) {
                        if (!aName.equals("dir") || !new File(value).exists()) continue;
                        GanttOptions.this.xslDir = value;
                        continue;
                    }
                    if (qName.equals("xsl-fo")) {
                        if (!aName.equals("file") || !new File(value).exists()) continue;
                        GanttOptions.this.xslFo = value;
                        continue;
                    }
                    if (qName.equals("working-dir")) {
                        if (!aName.equals("dir") || !new File(value).exists()) continue;
                        GanttOptions.this.workingDir = value;
                        continue;
                    }
                    if (qName.equals("task-name")) {
                        if (!aName.equals("prefix")) continue;
                        GanttOptions.this.sTaskNamePrefix = value;
                        continue;
                    }
                    if (qName.equals("toolBar")) {
                        if (aName.equals("position")) {
                            GanttOptions.this.toolBarPosition = new Integer(value);
                            continue;
                        }
                        if (aName.equals("icon-size")) {
                            GanttOptions.this.iconSize = value;
                            continue;
                        }
                        if (!aName.equals("show")) continue;
                        GanttOptions.this.buttonsshow = new Integer(value);
                        continue;
                    }
                    if (qName.equals("statusBar")) {
                        if (!aName.equals("show")) continue;
                        GanttOptions.this.bShowStatusBar = new Boolean(value);
                        continue;
                    }
                    if (qName.equals("export")) {
                        if (aName.equals("name")) {
                            GanttOptions.this.bExportName = new Boolean(value);
                            continue;
                        }
                        if (aName.equals("complete")) {
                            GanttOptions.this.bExportComplete = new Boolean(value);
                            continue;
                        }
                        if (aName.equals("relations")) {
                            GanttOptions.this.bExportRelations = new Boolean(value);
                            continue;
                        }
                        if (!aName.equals("border3d")) continue;
                        GanttOptions.this.bExport3DBorders = new Boolean(value);
                        continue;
                    }
                    if (qName.equals("colors")) {
                        Color colorD;
                        Color colorR;
                        if (aName.equals("resources")) {
                            colorR = ColorConvertion.determineColor(value);
                            if (colorR == null) continue;
                            GanttOptions.this.setResourceColor(colorR);
                            continue;
                        }
                        if (aName.equals("resourcesOverload")) {
                            colorR = ColorConvertion.determineColor(value);
                            if (colorR == null) continue;
                            GanttOptions.this.setResourceOverloadColor(colorR);
                            continue;
                        }
                        if (aName.equals("resourcesUnderload")) {
                            colorR = ColorConvertion.determineColor(value);
                            if (colorR == null) continue;
                            GanttOptions.this.setResourceUnderloadColor(colorR);
                            continue;
                        }
                        if (aName.equals("weekEnd")) {
                            colorR = ColorConvertion.determineColor(value);
                            if (colorR == null) continue;
                            GanttOptions.this.setWeekEndColor(colorR);
                            continue;
                        }
                        if (!aName.equals("daysOff") || (colorD = ColorConvertion.determineColor(value)) == null) continue;
                        GanttOptions.this.setDaysOffColor(colorD);
                        continue;
                    }
                    if (qName.equals("csv-general")) {
                        if (aName.equals("fixed")) {
                            ((GanttOptions)GanttOptions.this).csvOptions.bFixedSize = new Boolean(value);
                        }
                        if (aName.equals("separatedChar")) {
                            ((GanttOptions)GanttOptions.this).csvOptions.sSeparatedChar = value;
                        }
                        if (!aName.equals("separatedTextChar")) continue;
                        ((GanttOptions)GanttOptions.this).csvOptions.sSeparatedTextChar = value;
                        continue;
                    }
                    if (qName.equals("csv-tasks")) {
                        if (aName.equals("id")) {
                            ((GanttOptions)GanttOptions.this).csvOptions.bExportTaskID = new Boolean(value);
                        }
                        if (aName.equals("name")) {
                            ((GanttOptions)GanttOptions.this).csvOptions.bExportTaskName = new Boolean(value);
                        }
                        if (aName.equals("start-date")) {
                            ((GanttOptions)GanttOptions.this).csvOptions.bExportTaskStartDate = new Boolean(value);
                        }
                        if (aName.equals("end-date")) {
                            ((GanttOptions)GanttOptions.this).csvOptions.bExportTaskEndDate = new Boolean(value);
                        }
                        if (aName.equals("percent")) {
                            ((GanttOptions)GanttOptions.this).csvOptions.bExportTaskPercent = new Boolean(value);
                        }
                        if (aName.equals("duration")) {
                            ((GanttOptions)GanttOptions.this).csvOptions.bExportTaskDuration = new Boolean(value);
                        }
                        if (aName.equals("webLink")) {
                            ((GanttOptions)GanttOptions.this).csvOptions.bExportTaskWebLink = new Boolean(value);
                        }
                        if (aName.equals("resources")) {
                            ((GanttOptions)GanttOptions.this).csvOptions.bExportTaskResources = new Boolean(value);
                        }
                        if (!aName.equals("notes")) continue;
                        ((GanttOptions)GanttOptions.this).csvOptions.bExportTaskNotes = new Boolean(value);
                        continue;
                    }
                    if (!qName.equals("csv-resources")) continue;
                    if (aName.equals("id")) {
                        ((GanttOptions)GanttOptions.this).csvOptions.bExportResourceID = new Boolean(value);
                    }
                    if (aName.equals("name")) {
                        ((GanttOptions)GanttOptions.this).csvOptions.bExportResourceName = new Boolean(value);
                    }
                    if (aName.equals("mail")) {
                        ((GanttOptions)GanttOptions.this).csvOptions.bExportResourceMail = new Boolean(value);
                    }
                    if (aName.equals("phone")) {
                        ((GanttOptions)GanttOptions.this).csvOptions.bExportResourcePhone = new Boolean(value);
                    }
                    if (!aName.equals("role")) continue;
                    ((GanttOptions)GanttOptions.this).csvOptions.bExportResourceRole = new Boolean(value);
                }
            }
            if (qName.equals("task-color")) {
                GanttOptions.this.setDefaultTaskColor(new Color(r, g, b));
            }
            if (qName.equals("font")) {
                String category = attrs.getValue("category");
                if ("menu".equals(category)) {
                    GanttOptions.this.myMenuFont = Font.decode(attrs.getValue("spec"));
                } else if ("chart-main".equals(category)) {
                    GanttOptions.this.myChartMainFont = Font.decode(attrs.getValue("spec"));
                }
            }
        }
    }
}

