/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.table.JTableHeader;
import net.sourceforge.ganttproject.ChartComponentBase;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttExportSettings;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.GanttTree2;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.ProjectEventListener;
import net.sourceforge.ganttproject.TaskTreeImageGenerator;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.chart.ChartModelBase;
import net.sourceforge.ganttproject.chart.ChartModelImpl;
import net.sourceforge.ganttproject.chart.ChartSelection;
import net.sourceforge.ganttproject.chart.DependencyInteractionRenderer;
import net.sourceforge.ganttproject.chart.GanttChart;
import net.sourceforge.ganttproject.chart.PublicHolidayDialogAction;
import net.sourceforge.ganttproject.chart.RenderedChartImage;
import net.sourceforge.ganttproject.chart.RenderedGanttChartImage;
import net.sourceforge.ganttproject.chart.TaskInteractionHintRenderer;
import net.sourceforge.ganttproject.chart.VisibleNodesFilter;
import net.sourceforge.ganttproject.chart.item.ChartItem;
import net.sourceforge.ganttproject.chart.item.TaskBoundaryChartItem;
import net.sourceforge.ganttproject.chart.item.TaskProgressChartItem;
import net.sourceforge.ganttproject.chart.item.TaskRegularAreaChartItem;
import net.sourceforge.ganttproject.font.Fonts;
import net.sourceforge.ganttproject.gui.UIConfiguration;
import net.sourceforge.ganttproject.gui.options.model.ChangeValueDispatcher;
import net.sourceforge.ganttproject.gui.options.model.ChangeValueEvent;
import net.sourceforge.ganttproject.gui.options.model.ChangeValueListener;
import net.sourceforge.ganttproject.gui.options.model.GPOptionChangeListener;
import net.sourceforge.ganttproject.gui.scrolling.ScrollingManager;
import net.sourceforge.ganttproject.gui.zoom.ZoomListener;
import net.sourceforge.ganttproject.gui.zoom.ZoomManager;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.CustomColumEvent;
import net.sourceforge.ganttproject.task.CustomColumsListener;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskMutator;
import net.sourceforge.ganttproject.task.TaskSelectionManager;
import net.sourceforge.ganttproject.task.algorithm.RecalculateTaskScheduleAlgorithm;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyException;
import net.sourceforge.ganttproject.task.dependency.constraint.FinishStartConstraintImpl;
import net.sourceforge.ganttproject.task.event.TaskDependencyEvent;
import net.sourceforge.ganttproject.task.event.TaskListenerAdapter;
import net.sourceforge.ganttproject.task.event.TaskScheduleEvent;
import net.sourceforge.ganttproject.time.TimeUnit;
import net.sourceforge.ganttproject.time.gregorian.GregorianCalendar;
import net.sourceforge.ganttproject.undo.GPUndoManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GanttGraphicArea
extends ChartComponentBase
implements GanttChart,
CustomColumsListener,
ProjectEventListener {
    private static final Cursor W_RESIZE_CURSOR;
    private static final Cursor E_RESIZE_CURSOR;
    private static final Cursor CHANGE_PROGRESS_CURSOR;
    private static final int HEADER_OFFSET = 44;
    public GanttTree2 tree;
    public static Color taskDefaultColor;
    private int margY;
    private GanttProject appli;
    private UIConfiguration myUIConfiguration;
    private Color myProjectLevelTaskColor;
    private final ChartModelImpl myChartModel;
    private final TaskManager myTaskManager;
    private GPUndoManager myUndoManager;
    private JTableHeader myTableHeader = null;
    private MouseEvent myLastMouseEvent = null;
    private JPanel myPreviewPanel = new ChartOptionsPreviewPanel();
    private TaskTreeImageGenerator myTaskImageGenerator;
    private ChartImplementation myChartComponentImpl;
    private ScrollGanttChartCenterAction myScrollCenterAction;

    public GanttGraphicArea(GanttProject app, GanttTree2 ttree, TaskManager taskManager, ZoomManager zoomManager, GPUndoManager undoManager) {
        super(app, app, zoomManager);
        this.setBackground(Color.WHITE);
        this.myTaskManager = taskManager;
        this.myUndoManager = undoManager;
        this.myChartModel = new ChartModelImpl(this.getTaskManager(), app.getTimeUnitStack(), app.getUIConfiguration());
        this.myChartModel.addOptionChangeListener(new GPOptionChangeListener(){

            public void optionsChanged() {
                GanttGraphicArea.this.repaint();
            }
        });
        this.getViewState().addStateListener(this.myChartModel);
        this.getViewState().setStartDate(GregorianCalendar.getInstance().getTime());
        this.myTaskManager.addTaskListener(new TaskListenerAdapter(){

            public void taskScheduleChanged(TaskScheduleEvent e) {
                this.adjustDependencies((Task)e.getSource());
            }

            public void dependencyAdded(TaskDependencyEvent e) {
                this.adjustDependencies(e.getDependency().getDependee());
                GanttGraphicArea.this.repaint();
            }

            public void dependencyRemoved(TaskDependencyEvent e) {
                GanttGraphicArea.this.repaint();
            }

            private void adjustDependencies(Task task) {
                RecalculateTaskScheduleAlgorithm alg = GanttGraphicArea.this.myTaskManager.getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm();
                if (!alg.isRunning()) {
                    try {
                        alg.run(task);
                    }
                    catch (TaskDependencyException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.tree = ttree;
        this.margY = 0;
        this.appli = app;
        this.myTableHeader = this.tree.getTreeTable().getTable().getTableHeader();
        this.getProject().getTaskCustomColumnManager().addCustomColumnsListener(this);
        this.myTaskImageGenerator = new TaskTreeImageGenerator(ttree, app.getUIConfiguration());
    }

    public Color getTaskColor() {
        return this.myUIConfiguration.getTaskColor();
    }

    public void setProjectLevelTaskColor(Color c) {
        this.myUIConfiguration.setProjectLevelTaskColor(c);
    }

    public Dimension getPreferredSize() {
        return new Dimension(465, 600);
    }

    public void paintComponent(Graphics g) {
        this.myChartModel.setBounds(this.getSize());
        this.myChartComponentImpl.paintComponent(g);
    }

    public ChartModelImpl getMyChartModel() {
        return this.myChartModel;
    }

    public void drawGPVersion(Graphics g) {
        g.setColor(Color.black);
        g.setFont(Fonts.GP_VERSION_FONT);
        g.drawString("GanttProject (2.0.5)", 3, this.getHeight() + 18);
    }

    public void setScrollBar(int v) {
        this.margY = v;
    }

    public int getScrollBar() {
        return this.margY;
    }

    public String getName() {
        return GanttLanguage.getInstance().getText("gantt");
    }

    public Date getStartDate() {
        GanttCalendar pstart = new GanttCalendar(this.getTaskManager().getProjectStart());
        GanttCalendar st = pstart.Clone();
        return st.getTime();
    }

    public Date getEndDate() {
        TaskLength projectLength = this.getTaskManager().getProjectLength();
        GanttCalendar pstart = new GanttCalendar(this.getTaskManager().getProjectStart());
        pstart.add((int)projectLength.getLength());
        GanttCalendar end = pstart.Clone();
        return end.getTime();
    }

    public BufferedImage getChart(GanttExportSettings settings) {
        RenderedChartImage renderedImage = (RenderedChartImage)this.getRenderedImage(settings);
        BufferedImage result = renderedImage.getWholeImage();
        this.repaint();
        return result;
    }

    public RenderedImage getRenderedImage(GanttExportSettings settings) {
        Date dateStart = null;
        Date dateEnd = null;
        List myItemsToConsider = this.myTaskImageGenerator.getPrintableNodes(settings);
        TimeUnit unit = this.getViewState().getBottomTimeUnit();
        dateStart = settings.getStartDate() == null ? this.getStartDate() : settings.getStartDate();
        Date date = dateEnd = settings.getEndDate() == null ? this.getEndDate() : settings.getEndDate();
        if (dateStart.after(dateEnd)) {
            Date tmp = (Date)dateStart.clone();
            dateStart = (Date)dateEnd.clone();
            dateEnd = tmp;
        }
        TaskLength printedLength = this.getTaskManager().createLength(unit, dateStart, dateEnd);
        BufferedImage taskImage = (BufferedImage)this.myTaskImageGenerator.createImage(myItemsToConsider);
        int chartWidth = (int)((printedLength.getLength(this.getViewState().getBottomTimeUnit()) + 1.0f) * (float)this.getViewState().getBottomUnitWidth());
        if (chartWidth < this.getWidth()) {
            chartWidth = this.getWidth();
        }
        int chartHeight = taskImage.getHeight(null);
        return new RenderedGanttChartImage(this.myChartModel, this.myChartComponentImpl, GanttTree2.convertNodesListToItemList(myItemsToConsider), taskImage, chartWidth, chartHeight);
    }

    private GanttTree2 getTree() {
        return this.tree;
    }

    IGanttProject getProject() {
        return this.appli;
    }

    GPUndoManager getUndoManager() {
        return this.myUndoManager;
    }

    protected ChartModelBase getChartModel() {
        return this.myChartModel;
    }

    protected MouseListener getMouseListener() {
        return this.getChartImplementation().getMouseListener();
    }

    protected MouseMotionListener getMouseMotionListener() {
        return this.getChartImplementation().getMouseMotionListener();
    }

    private Action[] getPopupMenuActions() {
        return new Action[]{this.getOptionsDialogAction(), new PublicHolidayDialogAction(this.getProject(), this.getUIFacade())};
    }

    protected Component createPreviewComponent() {
        return this.myPreviewPanel;
    }

    public void repaint() {
        try {
            this.myChartModel.setHeaderHeight(this.myTableHeader.getHeight() + 44);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        super.repaint();
    }

    protected ChartComponentBase.AbstractChartImplementation getImplementation() {
        return (ChartComponentBase.AbstractChartImplementation)((Object)this.getChartImplementation());
    }

    private ChartImplementation getChartImplementation() {
        if (this.myChartComponentImpl == null) {
            this.myChartComponentImpl = new NewChartComponentImpl();
        }
        return this.myChartComponentImpl;
    }

    public Action getScrollCenterAction(ScrollingManager scrollMgr, TaskSelectionManager taskSelMgr, String iconSize) {
        if (this.myScrollCenterAction == null) {
            this.myScrollCenterAction = new ScrollGanttChartCenterAction(scrollMgr, taskSelMgr, iconSize);
        }
        return this.myScrollCenterAction;
    }

    public void setPreviousStateTasks(ArrayList tasks) {
        int rowHeight = this.myChartModel.setPreviousStateTasks(tasks);
        this.appli.getTree().getTable().setRowHeight(rowHeight);
    }

    public void setTaskManager(TaskManager taskManager) {
    }

    public void reset() {
    }

    public Icon getIcon() {
        return null;
    }

    public void customColumsChange(CustomColumEvent event) {
        this.repaint();
    }

    public void setUIConfiguration(UIConfiguration configuration) {
        this.myUIConfiguration = configuration;
    }

    public void appendBlankRow() {
        this.tree.addBlankLine(null, -1);
    }

    public void projectModified() {
    }

    public void projectSaved() {
    }

    public void projectClosed() {
        this.repaint();
        this.setProjectLevelTaskColor(null);
        this.setPreviousStateTasks(null);
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL cursorResource = GanttGraphicArea.class.getClassLoader().getResource("icons/cursorpercent.gif");
        Image image = toolkit.getImage(cursorResource);
        CHANGE_PROGRESS_CURSOR = toolkit.createCustomCursor(image, new Point(10, 5), "CursorPercent");
        W_RESIZE_CURSOR = new Cursor(10);
        E_RESIZE_CURSOR = new Cursor(11);
        taskDefaultColor = new Color(140, 182, 206);
    }

    private static class ChartOptionsPreviewPanel
    extends JPanel
    implements ChangeValueListener {
        Text upText;
        Text downText;
        Text leftText;
        Text rightText;
        TaskBar taskBar;

        public ChartOptionsPreviewPanel() {
            this.addToDispatchers();
            this.setBackground(Color.WHITE);
            this.setPreferredSize(new Dimension(450, 70));
            this.taskBar = new TaskBar();
            this.upText = new Text(2, this.taskBar);
            this.downText = new Text(3, this.taskBar);
            this.leftText = new Text(0, this.taskBar);
            this.rightText = new Text(1, this.taskBar);
        }

        void refresh() {
        }

        private void addToDispatchers() {
            List dispatchers = Mediator.getChangeValueDispatchers();
            for (int i = 0; i < dispatchers.size(); ++i) {
                ((ChangeValueDispatcher)dispatchers.get(i)).addChangeValueListener(this);
            }
        }

        public void paint(Graphics g) {
            super.paint(g);
            this.taskBar.paintMe(g);
            this.upText.paintMe(g);
            this.downText.paintMe(g);
            this.leftText.paintMe(g);
            this.rightText.paintMe(g);
        }

        public void changeValue(ChangeValueEvent event) {
            Object id = event.getID();
            if (id.equals("up")) {
                this.upText.text = ChartOptionsPreviewPanel.getI18n(event.getNewValue().toString());
            } else if (id.equals("down")) {
                this.downText.text = ChartOptionsPreviewPanel.getI18n(event.getNewValue().toString());
            } else if (id.equals("left")) {
                this.leftText.text = ChartOptionsPreviewPanel.getI18n(event.getNewValue().toString());
            } else if (id.equals("right")) {
                this.rightText.text = ChartOptionsPreviewPanel.getI18n(event.getNewValue().toString());
            }
            this.repaint();
        }

        static String getI18n(String id) {
            String res = GanttLanguage.getInstance().getText("optionValue." + id + ".label");
            if (res.startsWith("Missing Resource")) {
                res = id;
            }
            return res;
        }

        private static class Text {
            static final Font FONT = Fonts.PREVIEW_BAR_FONT;
            static final int LEFT = 0;
            static final int RIGHT = 1;
            static final int UP = 2;
            static final int DOWN = 3;
            static final int MARGIN = 3;
            String text = "";
            int position;
            private int x;
            private int y;
            TaskBar taskBar;

            Text(int position, TaskBar refBar) {
                this.position = position;
                this.taskBar = refBar;
            }

            void paintMe(Graphics g) {
                this.calculateCoordinates(g);
                g.setFont(FONT);
                g.drawString(this.text, this.x, this.y);
            }

            private void calculateCoordinates(Graphics g) {
                int textHeight = g.getFontMetrics(FONT).getHeight();
                int textWidth = g.getFontMetrics(FONT).stringWidth(this.text);
                switch (this.position) {
                    case 2: {
                        this.y = this.taskBar.y - 3;
                        this.x = this.taskBar.x + this.taskBar.width / 2 - textWidth / 2;
                        break;
                    }
                    case 3: {
                        this.x = this.taskBar.x + this.taskBar.width / 2 - textWidth / 2;
                        this.y = this.taskBar.y + this.taskBar.height + textHeight - 3;
                        break;
                    }
                    case 0: {
                        this.y = this.taskBar.y + this.taskBar.height / 2 + textHeight / 2 - 3;
                        this.x = this.taskBar.x - 3 - textWidth;
                        break;
                    }
                    case 1: {
                        this.y = this.taskBar.y + this.taskBar.height / 2 + textHeight / 2 - 3;
                        this.x = this.taskBar.x + this.taskBar.width + 3;
                    }
                }
            }
        }

        class TaskBar {
            int width = 100;
            int height = 12;
            int x;
            int y;
            Color color;

            TaskBar() {
                this.x = (int)(ChartOptionsPreviewPanel.this.getPreferredSize().getWidth() / 2.0 - (double)(this.width / 2));
                this.y = (int)(ChartOptionsPreviewPanel.this.getPreferredSize().getHeight() / 2.0 - (double)(this.height / 2));
                this.color = new Color(140, 182, 206);
            }

            void paintMe(Graphics g) {
                g.setColor(this.color);
                g.fillRect(this.x, this.y, this.width, this.height);
                g.setColor(Color.BLACK);
                g.drawRect(this.x, this.y, this.width, this.height);
            }
        }
    }

    private class OldMouseMotionListenerImpl
    extends ChartComponentBase.MouseMotionListenerBase {
        private MouseSupport myMouseSupport;

        private OldMouseMotionListenerImpl() {
            this.myMouseSupport = new MouseSupport();
        }

        public void mouseDragged(MouseEvent e) {
            ChartComponentBase.MouseInteraction mi;
            if (((GanttGraphicArea)GanttGraphicArea.this).appli.isOnlyViewer) {
                return;
            }
            super.mouseDragged(e);
            if (GanttGraphicArea.this.myUIConfiguration.isCriticalPathOn() && ((mi = GanttGraphicArea.this.myChartComponentImpl.getActiveInteraction()) instanceof ChangeTaskBoundaryInteraction || mi instanceof MoveTaskInteraction || mi instanceof MoveTaskInteractions)) {
                GanttGraphicArea.this.appli.recalculateCriticalPath();
            }
            GanttGraphicArea.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            Task taskUnderPoint;
            ChartItem itemUnderPoint = this.myMouseSupport.getChartItemUnderMousePoint(e.getX(), e.getY());
            Task task = taskUnderPoint = itemUnderPoint == null ? null : itemUnderPoint.getTask();
            if (taskUnderPoint == null) {
                GanttGraphicArea.this.setDefaultCursor();
            } else {
                if (itemUnderPoint instanceof TaskBoundaryChartItem) {
                    Cursor cursor = ((TaskBoundaryChartItem)itemUnderPoint).isStartBoundary() ? W_RESIZE_CURSOR : E_RESIZE_CURSOR;
                    GanttGraphicArea.this.setCursor(cursor);
                } else if (itemUnderPoint instanceof TaskProgressChartItem) {
                    GanttGraphicArea.this.setCursor(CHANGE_PROGRESS_CURSOR);
                } else {
                    GanttGraphicArea.this.setDefaultCursor();
                }
                GanttGraphicArea.this.appli.repaint();
            }
        }
    }

    private class OldChartMouseListenerImpl
    extends ChartComponentBase.MouseListenerBase
    implements MouseListener {
        private MouseSupport myMouseSupport;

        private OldChartMouseListenerImpl() {
            this.myMouseSupport = new MouseSupport();
        }

        public void mouseClicked(MouseEvent e) {
            Task taskUnderPointer;
            if (e.getButton() == 1 && (taskUnderPointer = this.myMouseSupport.findTaskUnderMousePointer(e.getX(), e.getY())) == null) {
                GanttGraphicArea.this.tree.selectTreeRow(-1);
            }
            if (e.getClickCount() == 2 && e.getButton() == 1 && !((GanttGraphicArea)GanttGraphicArea.this).appli.isOnlyViewer) {
                GanttGraphicArea.this.appli.propertiesTask();
            }
        }

        protected Action[] getPopupMenuActions() {
            Action[] treeActions = GanttGraphicArea.this.tree.getPopupMenuActions();
            int sep = 0;
            if (treeActions.length != 0) {
                sep = 1;
            }
            Action[] chartActions = GanttGraphicArea.this.getPopupMenuActions();
            Action[] result = new Action[treeActions.length + sep + chartActions.length];
            System.arraycopy(treeActions, 0, result, 0, treeActions.length);
            System.arraycopy(chartActions, 0, result, treeActions.length + sep, chartActions.length);
            return result;
        }

        public void mousePressed(MouseEvent e) {
            GanttGraphicArea.this.tree.stopEditing();
            if (((GanttGraphicArea)GanttGraphicArea.this).appli.isOnlyViewer) {
                return;
            }
            Task taskUnderPointer = this.myMouseSupport.findTaskUnderMousePointer(e.getX(), e.getY());
            if (taskUnderPointer != null && !Mediator.getTaskSelectionManager().isTaskSelected(taskUnderPointer)) {
                boolean ctrl = (e.getModifiersEx() & 0x80) == 128;
                GanttGraphicArea.this.tree.selectTask(taskUnderPointer, ctrl);
            }
            super.mousePressed(e);
            if (taskUnderPointer == null) {
                return;
            }
            if (e.getButton() == 1) {
                ChartItem itemUnderPoint = this.myMouseSupport.getChartItemUnderMousePoint(e.getX(), e.getY());
                if (itemUnderPoint instanceof TaskBoundaryChartItem) {
                    TaskBoundaryChartItem taskBoundary = (TaskBoundaryChartItem)itemUnderPoint;
                    if (taskBoundary.isStartBoundary()) {
                        GanttGraphicArea.this.getChartImplementation().beginChangeTaskStartInteraction(e, taskBoundary);
                    } else {
                        GanttGraphicArea.this.getChartImplementation().beginChangeTaskEndInteraction(e, taskBoundary);
                    }
                } else if (itemUnderPoint instanceof TaskProgressChartItem) {
                    GanttGraphicArea.this.getChartImplementation().beginChangeTaskProgressInteraction(e, (TaskProgressChartItem)itemUnderPoint);
                } else if (itemUnderPoint instanceof TaskRegularAreaChartItem) {
                    GanttGraphicArea.this.getChartImplementation().beginDrawDependencyInteraction(e, (TaskRegularAreaChartItem)itemUnderPoint, this.myMouseSupport);
                }
                GanttGraphicArea.this.repaint();
                GanttGraphicArea.this.appli.recalculateCriticalPath();
            } else if (e.getButton() == 2) {
                if (!Mediator.getTaskSelectionManager().isTaskSelected(taskUnderPointer)) {
                    GanttGraphicArea.this.tree.selectTask(taskUnderPointer, false);
                }
                List l = Mediator.getTaskSelectionManager().getSelectedTasks();
                GanttGraphicArea.this.getChartImplementation().beginMoveTaskInteractions(e, l);
            }
        }
    }

    protected class ScrollGanttChartCenterAction
    extends GPAction {
        private final ScrollingManager myScrollingManager;
        private final TaskSelectionManager myTaskSelectionManager;

        public ScrollGanttChartCenterAction(ScrollingManager scrollingManager, TaskSelectionManager taskSelectionManager, String iconSize) {
            super("ScrollCenter", iconSize);
            this.myScrollingManager = scrollingManager;
            this.myTaskSelectionManager = taskSelectionManager;
        }

        public void actionPerformed(ActionEvent e) {
            GanttGraphicArea.this.getUIFacade().setStatusText(GanttLanguage.getInstance().getText("centerOnSelectedTasks"));
            this.scroll();
        }

        private void scroll() {
            GanttCalendar min = null;
            Calendar max = null;
            Date scrollDate = null;
            Iterator<Object> it = null;
            it = this.myTaskSelectionManager.getSelectedTasks().isEmpty() ? Arrays.asList(GanttGraphicArea.this.getTaskManager().getTasks()).iterator() : this.myTaskSelectionManager.getSelectedTasks().iterator();
            while (it.hasNext()) {
                Task t = (Task)it.next();
                GanttCalendar dStart = t.getStart();
                GanttCalendar dEnd = t.getEnd();
                GanttCalendar ganttCalendar = min == null ? dStart.Clone() : (min = min.compareTo(dStart) > 0 ? dStart.Clone() : min);
                max = max == null ? dEnd.Clone() : (((GanttCalendar)max).compareTo(dEnd) < 0 ? dEnd.Clone() : max);
            }
            if (min == null || max == null) {
                return;
            }
            TimeUnit defaultUnit = GanttGraphicArea.this.getTimeUnitStack().getDefaultTimeUnit();
            TaskLength selectionLength = GanttGraphicArea.this.getTaskManager().createLength(defaultUnit, min.getTime(), max.getTime());
            TaskLength viewLength = GanttGraphicArea.this.getChartModel().getVisibleLength();
            float viewLengthInDefaultUnits = viewLength.getLength(defaultUnit);
            float delta = (selectionLength.getValue() - viewLengthInDefaultUnits) / 2.0f;
            scrollDate = GPCalendar.PLAIN.shiftDate(min.getTime(), GanttGraphicArea.this.getTaskManager().createLength(defaultUnit, delta));
            this.myScrollingManager.scrollLeft(scrollDate);
        }

        protected String getIconFilePrefix() {
            return "scrollcenter_";
        }

        protected String getLocalizedName() {
            return super.getLocalizedName();
        }
    }

    private class NewChartComponentImpl
    extends ChartImplementationBase
    implements ChartImplementation {
        private OldChartMouseListenerImpl myMouseListener;
        private OldMouseMotionListenerImpl myMouseMotionListener;

        private NewChartComponentImpl() {
            this.myMouseListener = new OldChartMouseListenerImpl();
            this.myMouseMotionListener = new OldMouseMotionListenerImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g, List visibleTasks) {
            Object object = ChartModelBase.STATIC_MUTEX;
            synchronized (object) {
                GanttGraphicArea.super.paintComponent(g);
                ChartModelImpl model = GanttGraphicArea.this.myChartModel;
                model.setTaskContainment(GanttGraphicArea.this.appli.getTaskContainment());
                model.setBottomUnitWidth(GanttGraphicArea.this.getViewState().getBottomUnitWidth());
                model.setRowHeight(GanttGraphicArea.this.tree.getTreeTable().getRowHeight());
                model.setTopTimeUnit(GanttGraphicArea.this.getViewState().getTopTimeUnit());
                model.setBottomTimeUnit(GanttGraphicArea.this.getViewState().getBottomTimeUnit());
                model.setVisibleTasks(visibleTasks);
                model.paint(g);
                if (this.getActiveInteraction() != null) {
                    this.getActiveInteraction().paint(g);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            Object object = ChartModelBase.STATIC_MUTEX;
            synchronized (object) {
                GanttGraphicArea.super.paintComponent(g);
                ChartModelImpl model = GanttGraphicArea.this.myChartModel;
                model.setTaskContainment(GanttGraphicArea.this.appli.getTaskContainment());
                model.setBottomUnitWidth(GanttGraphicArea.this.getViewState().getBottomUnitWidth());
                model.setRowHeight(GanttGraphicArea.this.tree.getTreeTable().getRowHeight());
                model.setTopTimeUnit(GanttGraphicArea.this.getViewState().getTopTimeUnit());
                model.setBottomTimeUnit(GanttGraphicArea.this.getViewState().getBottomTimeUnit());
                VisibleNodesFilter visibleNodesFilter = new VisibleNodesFilter();
                List visibleTasks = visibleNodesFilter.getVisibleNodes(GanttGraphicArea.this.tree.getJTree(), GanttGraphicArea.this.getScrollBar(), GanttGraphicArea.this.getHeight(), GanttGraphicArea.this.tree.getTreeTable().getRowHeight());
                model.setVisibleTasks(visibleTasks);
                model.setVerticalOffset(GanttGraphicArea.this.getScrollBar() % GanttGraphicArea.this.tree.getTreeTable().getRowHeight());
                model.paint(g);
                if (this.getActiveInteraction() != null) {
                    this.getActiveInteraction().paint(g);
                }
            }
        }

        public MouseListener getMouseListener() {
            return this.myMouseListener;
        }

        public MouseMotionListener getMouseMotionListener() {
            return this.myMouseMotionListener;
        }

        public IStatus canPaste(ChartSelection selection) {
            return Status.OK_STATUS;
        }

        public ChartSelection getSelection() {
            ChartComponentBase.ChartSelectionImpl result = new ChartComponentBase.ChartSelectionImpl(this){
                private final /* synthetic */ NewChartComponentImpl this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isEmpty() {
                    return false;
                }

                public void startCopyClipboardTransaction() {
                    super.startCopyClipboardTransaction();
                    NewChartComponentImpl.access$1700((NewChartComponentImpl)this.this$1).tree.copySelectedNode();
                }

                public void startMoveClipboardTransaction() {
                    super.startMoveClipboardTransaction();
                    NewChartComponentImpl.access$1700((NewChartComponentImpl)this.this$1).tree.cutSelectedNode();
                }
            };
            return result;
        }

        public void paste(ChartSelection selection) {
            GanttGraphicArea.this.tree.pasteNode();
        }

        static /* synthetic */ GanttGraphicArea access$1700(NewChartComponentImpl x0) {
            return x0.GanttGraphicArea.this;
        }
    }

    private class ChartImplementationBase
    extends ChartComponentBase.AbstractChartImplementation {
        private ChartImplementationBase() {
        }

        public void beginChangeTaskEndInteraction(MouseEvent initiatingEvent, TaskBoundaryChartItem taskBoundary) {
            this.setActiveInteraction(new ChangeTaskEndInteraction(initiatingEvent, taskBoundary));
        }

        public void beginChangeTaskStartInteraction(MouseEvent e, TaskBoundaryChartItem taskBoundary) {
            this.setActiveInteraction(new ChangeTaskStartInteraction(e, taskBoundary));
        }

        public void beginChangeTaskProgressInteraction(MouseEvent e, TaskProgressChartItem taskProgress) {
            this.setActiveInteraction(new ChangeTaskProgressInteraction(e, taskProgress));
        }

        public void beginDrawDependencyInteraction(MouseEvent initiatingEvent, TaskRegularAreaChartItem taskArea, MouseSupport mouseSupport) {
            this.setActiveInteraction(new DrawDependencyInteraction(initiatingEvent, taskArea, mouseSupport));
        }

        public void beginMoveTaskInteraction(MouseEvent e, Task task) {
            this.setActiveInteraction(new MoveTaskInteraction(e, task));
        }

        public void beginMoveTaskInteractions(MouseEvent e, List tasks) {
            this.setActiveInteraction(new MoveTaskInteractions(e, tasks));
        }
    }

    public static interface ChartImplementation
    extends ZoomListener {
        public void paintComponent(Graphics var1);

        public void paintComponent(Graphics var1, List var2);

        public MouseListener getMouseListener();

        public MouseMotionListener getMouseMotionListener();

        public void beginChangeTaskEndInteraction(MouseEvent var1, TaskBoundaryChartItem var2);

        public ChartComponentBase.MouseInteraction getActiveInteraction();

        public void beginChangeTaskStartInteraction(MouseEvent var1, TaskBoundaryChartItem var2);

        public ChartComponentBase.MouseInteraction finishInteraction();

        public void beginChangeTaskProgressInteraction(MouseEvent var1, TaskProgressChartItem var2);

        public void beginDrawDependencyInteraction(MouseEvent var1, TaskRegularAreaChartItem var2, MouseSupport var3);

        public void beginMoveTaskInteraction(MouseEvent var1, Task var2);

        public void beginMoveTaskInteractions(MouseEvent var1, List var2);

        public void beginScrollViewInteraction(MouseEvent var1);
    }

    class MoveTaskInteractions
    extends ChartComponentBase.MouseInteractionBase
    implements ChartComponentBase.MouseInteraction {
        private List myTasks;
        private List myMutators;
        private List myInitialStarts;

        MoveTaskInteractions(MouseEvent e, List tasks) {
            super(e);
            this.myTasks = tasks;
            this.myMutators = new ArrayList(this.myTasks.size());
            this.myInitialStarts = new ArrayList(this.myTasks.size());
            Iterator itTasks = this.myTasks.iterator();
            while (itTasks.hasNext()) {
                Task t = (Task)itTasks.next();
                this.myMutators.add(t.createMutator());
                this.myInitialStarts.add(t.getStart());
            }
        }

        public void apply(MouseEvent event) {
            float diff = this.getLengthDiff(event);
            TaskLength bottomUnitLength = GanttGraphicArea.this.getTaskManager().createLength(GanttGraphicArea.this.getViewState().getBottomTimeUnit(), diff);
            for (int i = 0; i < this.myTasks.size(); ++i) {
                Task task = (Task)this.myTasks.get(i);
                TaskLength taskLength = task.translateDuration(bottomUnitLength);
                int dayDiff = (int)taskLength.getValue();
                if (dayDiff == 0) continue;
                ((TaskMutator)this.myMutators.get(i)).shift(dayDiff);
            }
        }

        public void finish() {
            Iterator itMutators = this.myMutators.iterator();
            while (itMutators.hasNext()) {
                ((TaskMutator)itMutators.next()).setIsolationLevel(1);
            }
            GanttGraphicArea.this.getUndoManager().undoableEdit("Task moved", new Runnable(this){
                private final /* synthetic */ MoveTaskInteractions this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    MoveTaskInteractions.access$1300(this.this$1);
                }
            });
        }

        private void doFinish() {
            Iterator itMutators = this.myMutators.iterator();
            while (itMutators.hasNext()) {
                ((TaskMutator)itMutators.next()).commit();
            }
            try {
                GanttGraphicArea.this.getTaskManager().getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm().run();
            }
            catch (TaskDependencyException e) {
                e.printStackTrace();
            }
            Iterator itTasks = this.myTasks.iterator();
            while (itTasks.hasNext()) {
                Task t = (Task)itTasks.next();
                t.applyThirdDateConstraint();
            }
            GanttGraphicArea.this.repaint();
        }

        static /* synthetic */ void access$1300(MoveTaskInteractions x0) {
            x0.doFinish();
        }
    }

    class MoveTaskInteraction
    extends ChartComponentBase.MouseInteractionBase
    implements ChartComponentBase.MouseInteraction {
        private Task myTask;
        private TaskMutator myMutator;
        private GanttCalendar myInitialStart;

        MoveTaskInteraction(MouseEvent e, Task task) {
            super(e);
            this.myTask = task;
            this.myMutator = task.createMutator();
            this.myInitialStart = this.myTask.getStart();
        }

        public void apply(MouseEvent event) {
            float diff = GanttGraphicArea.this.getChartModel().calculateLengthNoWeekends(this.getStartX(), event.getX());
            TaskLength bottomUnitLength = GanttGraphicArea.this.getTaskManager().createLength(GanttGraphicArea.this.getViewState().getBottomTimeUnit(), diff);
            TaskLength taskLength = this.myTask.translateDuration(bottomUnitLength);
            int dayDiff = (int)taskLength.getValue();
            if (dayDiff != 0) {
                this.myMutator.shift(dayDiff);
            }
        }

        public void finish() {
            this.myMutator.setIsolationLevel(1);
            GanttGraphicArea.this.getUndoManager().undoableEdit("Task moved", new Runnable(this){
                private final /* synthetic */ MoveTaskInteraction this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    MoveTaskInteraction.access$1200(this.this$1);
                }
            });
        }

        private void doFinish() {
            this.myMutator.commit();
            try {
                GanttGraphicArea.this.getTaskManager().getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm().run();
            }
            catch (TaskDependencyException e) {
                e.printStackTrace();
            }
            GanttGraphicArea.this.repaint();
        }

        static /* synthetic */ void access$1200(MoveTaskInteraction x0) {
            x0.doFinish();
        }
    }

    class DrawDependencyInteraction
    extends ChartComponentBase.MouseInteractionBase
    implements ChartComponentBase.MouseInteraction {
        private final Task myTask;
        private Point myStartPoint;
        private DependencyInteractionRenderer myArrow;
        private MouseSupport myMouseSupport;
        private Task myDependant;

        public DrawDependencyInteraction(MouseEvent initiatingEvent, TaskRegularAreaChartItem taskArea, MouseSupport mouseSupport) {
            super(initiatingEvent);
            this.myStartPoint = initiatingEvent.getPoint();
            this.myTask = taskArea.getTask();
            this.myArrow = new DependencyInteractionRenderer(this.myStartPoint.x, this.myStartPoint.y, this.myStartPoint.x, this.myStartPoint.y);
            this.myMouseSupport = mouseSupport;
        }

        public void apply(MouseEvent event) {
            this.myArrow.changePoint2(event.getX(), event.getY());
            GanttGraphicArea.this.myLastMouseEvent = event;
        }

        public void finish() {
            if (GanttGraphicArea.this.myLastMouseEvent != null) {
                this.myDependant = this.myMouseSupport.findTaskUnderMousePointer(GanttGraphicArea.this.myLastMouseEvent.getX(), GanttGraphicArea.this.myLastMouseEvent.getY());
                Task dependee = this.myTask;
                if (this.myDependant != null) {
                    if (GanttGraphicArea.this.getTaskManager().getDependencyCollection().canCreateDependency(this.myDependant, dependee)) {
                        GanttGraphicArea.this.getUndoManager().undoableEdit("Draw dependency", new Runnable(this, dependee){
                            private final /* synthetic */ Task val$dependee;
                            private final /* synthetic */ DrawDependencyInteraction this$1;
                            {
                                this.this$1 = this$1;
                                this.val$dependee = val$dependee;
                            }

                            public void run() {
                                try {
                                    DrawDependencyInteraction.access$1000(this.this$1).getTaskManager().getDependencyCollection().createDependency(DrawDependencyInteraction.access$900(this.this$1), this.val$dependee, new FinishStartConstraintImpl());
                                }
                                catch (TaskDependencyException e1) {
                                    e1.printStackTrace();
                                }
                                GanttGraphicArea.access$1100(DrawDependencyInteraction.access$1000(this.this$1)).setAskForSave(true);
                            }
                        });
                    }
                } else {
                    this.myArrow = new DependencyInteractionRenderer();
                    GanttGraphicArea.this.repaint();
                }
            }
        }

        public void paint(Graphics g) {
            this.myArrow.paint(g);
        }

        static /* synthetic */ Task access$900(DrawDependencyInteraction x0) {
            return x0.myDependant;
        }

        static /* synthetic */ GanttGraphicArea access$1000(DrawDependencyInteraction x0) {
            return x0.GanttGraphicArea.this;
        }
    }

    class ChangeTaskProgressInteraction
    extends ChartComponentBase.MouseInteractionBase
    implements ChartComponentBase.MouseInteraction {
        private TaskProgressChartItem myTaskProgrssItem;
        private TaskMutator myMutator;
        private TaskInteractionHintRenderer myLastNotes;
        private int myProgressWas;
        private int myProgressIs;

        public ChangeTaskProgressInteraction(MouseEvent e, TaskProgressChartItem taskProgress) {
            super(e);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            try {
                GanttGraphicArea.this.setCursor(CHANGE_PROGRESS_CURSOR);
            }
            catch (Exception exept) {
                GanttGraphicArea.this.setCursor(E_RESIZE_CURSOR);
            }
            this.myTaskProgrssItem = taskProgress;
            this.myMutator = this.myTaskProgrssItem.getTask().createMutator();
            this.myProgressWas = this.myTaskProgrssItem.getTask().getCompletionPercentage();
        }

        public void apply(MouseEvent event) {
            float deltaUnits = this.getLengthDiff(event);
            int deltaPercents = (int)(100.0f * deltaUnits / this.myTaskProgrssItem.getTask().getDuration().getLength(GanttGraphicArea.this.getViewState().getBottomTimeUnit()));
            int newProgress = this.myProgressWas + deltaPercents;
            if (newProgress > 100) {
                newProgress = 100;
            }
            if (newProgress < 0) {
                newProgress = 0;
            }
            this.myProgressIs = newProgress;
            this.myMutator.setCompletionPercentage(newProgress);
            this.myLastNotes = new TaskInteractionHintRenderer(newProgress + "%", event.getX(), event.getY() - 30);
        }

        public void finish() {
            this.myMutator.setIsolationLevel(1);
            GanttGraphicArea.this.getUndoManager().undoableEdit("Task progress changed", new Runnable(this){
                private final /* synthetic */ ChangeTaskProgressInteraction this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    ChangeTaskProgressInteraction.access$700(this.this$1, ChangeTaskProgressInteraction.access$600(this.this$1));
                }
            });
            GanttGraphicArea.this.repaint();
        }

        private void doFinish(TaskMutator mutator) {
            mutator.commit();
            this.myLastNotes = null;
            try {
                GanttGraphicArea.this.getTaskManager().getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm().run();
            }
            catch (TaskDependencyException e) {
                e.printStackTrace();
            }
            if (this.myProgressIs == this.myProgressWas) {
                this.myMutator.commit();
                GanttGraphicArea.this.repaint();
                int myProgressIs = this.myTaskProgrssItem.getTask().getCompletionPercentage();
                if (myProgressIs != this.myProgressWas) {
                    // empty if block
                }
            }
        }

        public void paint(Graphics g) {
            if (this.myLastNotes != null) {
                this.myLastNotes.paint(g);
            }
        }

        static /* synthetic */ TaskMutator access$600(ChangeTaskProgressInteraction x0) {
            return x0.myMutator;
        }

        static /* synthetic */ void access$700(ChangeTaskProgressInteraction x0, TaskMutator x1) {
            x0.doFinish(x1);
        }
    }

    class ChangeTaskStartInteraction
    extends ChangeTaskBoundaryInteraction
    implements ChartComponentBase.MouseInteraction {
        private TaskLength myInitialLength;
        private TaskMutator myMutator;
        private GanttCalendar myInitialStart;

        ChangeTaskStartInteraction(MouseEvent e, TaskBoundaryChartItem taskBoundary) {
            super(e, taskBoundary);
            GanttGraphicArea.this.setCursor(W_RESIZE_CURSOR);
            this.myInitialLength = this.getTask().getDuration();
            this.myMutator = this.getTask().createMutator();
            this.myInitialStart = this.getTask().getStart();
        }

        protected void apply(float diff) {
            TaskLength newLength = GanttGraphicArea.this.getTaskManager().createLength(GanttGraphicArea.this.getViewState().getBottomTimeUnit(), this.getInitialDuration() + diff);
            TaskLength translated = this.getTask().translateDuration(newLength);
            int dayDiff = (int)(translated.getValue() - this.myInitialLength.getValue());
            if (dayDiff != 0) {
                GanttCalendar newStart = this.myInitialStart.newAdd(dayDiff);
                this.myMutator.setStart(newStart);
                if (this.getTask().getThird() != null && this.getTask().getThirdDateConstraint() == 1) {
                    this.myMutator.setEnd(this.getTask().getEnd().Clone());
                }
            }
        }

        public void finish() {
            super.finish(this.myMutator);
            this.getTask().applyThirdDateConstraint();
        }

        protected String getNotesText() {
            return this.getTask().getStart().toString();
        }
    }

    class ChangeTaskEndInteraction
    extends ChangeTaskBoundaryInteraction
    implements ChartComponentBase.MouseInteraction {
        private TaskMutator myMutator;
        private GanttCalendar myInitialEnd;

        public ChangeTaskEndInteraction(MouseEvent initiatingEvent, TaskBoundaryChartItem taskBoundary) {
            super(initiatingEvent, taskBoundary);
            GanttGraphicArea.this.setCursor(E_RESIZE_CURSOR);
            this.myMutator = this.getTask().createMutator();
            this.myInitialEnd = this.getTask().getEnd();
        }

        protected void apply(float diff) {
            TaskLength newLength = GanttGraphicArea.this.getTaskManager().createLength(GanttGraphicArea.this.getViewState().getBottomTimeUnit(), this.getInitialDuration() + diff);
            TaskLength translated = this.getTask().translateDuration(newLength);
            if (translated.getLength() != 0L) {
                this.myMutator.setDuration(translated);
            }
        }

        protected String getNotesText() {
            return this.getTask().getEnd().toString();
        }

        public void finish() {
            super.finish(this.myMutator);
        }
    }

    abstract class ChangeTaskBoundaryInteraction
    extends ChartComponentBase.MouseInteractionBase {
        private TaskInteractionHintRenderer myLastNotes;
        private final Task myTask;
        private final float myInitialDuration;
        private GanttCalendar myInitialEnd;
        private GanttCalendar myInitialStart;

        protected ChangeTaskBoundaryInteraction(MouseEvent initiatingEvent, TaskBoundaryChartItem taskBoundary) {
            super(initiatingEvent);
            this.myTask = taskBoundary.getTask();
            this.myInitialDuration = this.myTask.getDuration().getLength(GanttGraphicArea.this.getViewState().getBottomTimeUnit());
            this.myInitialEnd = this.getTask().getEnd();
            this.myInitialStart = this.getTask().getStart();
        }

        public void apply(MouseEvent e) {
            if (this.myLastNotes == null) {
                this.myLastNotes = new TaskInteractionHintRenderer("", e.getX(), e.getY());
            }
            float diff = this.getLengthDiff(e);
            this.apply(diff);
            this.myLastNotes.setString(this.getNotesText());
            this.myLastNotes.setX(e.getX());
        }

        protected Task getTask() {
            return this.myTask;
        }

        protected float getInitialDuration() {
            return this.myInitialDuration;
        }

        public void finish(TaskMutator mutator) {
            mutator.setIsolationLevel(1);
            GanttGraphicArea.this.getUndoManager().undoableEdit("Task boundary changed", new Runnable(this, mutator){
                private final /* synthetic */ TaskMutator val$mutator;
                private final /* synthetic */ ChangeTaskBoundaryInteraction this$1;
                {
                    this.this$1 = this$1;
                    this.val$mutator = val$mutator;
                }

                public void run() {
                    ChangeTaskBoundaryInteraction.access$200(this.this$1, this.val$mutator);
                }
            });
        }

        private void doFinish(TaskMutator mutator) {
            mutator.commit();
            this.myLastNotes = null;
            try {
                GanttGraphicArea.this.getTaskManager().getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm().run();
            }
            catch (TaskDependencyException e) {
                e.printStackTrace();
            }
            GanttGraphicArea.this.repaint();
        }

        public void paint(Graphics g) {
            if (this.myLastNotes != null) {
                this.myLastNotes.paint(g);
            }
        }

        protected abstract void apply(float var1);

        protected abstract String getNotesText();

        static /* synthetic */ void access$200(ChangeTaskBoundaryInteraction x0, TaskMutator x1) {
            x0.doFinish(x1);
        }
    }

    class MouseSupport {
        MouseSupport() {
        }

        protected Task findTaskUnderMousePointer(int xpos, int ypos) {
            ChartItem chartItem = GanttGraphicArea.this.myChartModel.getChartItemWithCoordinates(xpos, ypos);
            return chartItem == null ? null : chartItem.getTask();
        }

        protected ChartItem getChartItemUnderMousePoint(int xpos, int ypos) {
            ChartItem result = GanttGraphicArea.this.myChartModel.getChartItemWithCoordinates(xpos, ypos);
            return result;
        }
    }
}

