/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.TreeTableCellEditorImpl;
import net.sourceforge.ganttproject.language.GanttLanguage;
import org.jdesktop.jdnc.JNTreeTable;
import org.jdesktop.swing.JXTreeTable;
import org.jdesktop.swing.table.TableColumnExt;
import org.jdesktop.swing.treetable.TreeTableModel;

class GPTreeTableBase
extends JNTreeTable {
    private final IGanttProject myProject;

    protected IGanttProject getProject() {
        return this.myProject;
    }

    protected GPTreeTableBase(IGanttProject project, TreeTableModel model) {
        super(new JXTreeTable(model){

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.isAltDown() || e.isControlDown()) {
                    this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
                }
                boolean result = super.processKeyBinding(ks, e, condition, pressed);
                this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
                return result;
            }
        });
        this.myProject = project;
    }

    protected TableColumnExt newTableColumnExt(int modelIndex) {
        TableColumnExt result = new TableColumnExt(modelIndex);
        TableCellEditor defaultEditor = this.getTreeTable().getDefaultEditor(this.getTreeTableModel().getColumnClass(modelIndex));
        if (defaultEditor != null) {
            result.setCellEditor((TableCellEditor)new TreeTableCellEditorImpl(defaultEditor));
        }
        return result;
    }

    protected TableCellEditor newDateCellEditor() {
        return new DateCellEditor(){

            protected Date parseDate(String dateString) {
                DateFormat[] formats = new DateFormat[]{GanttLanguage.getInstance().getLongDateFormat(), GanttLanguage.getInstance().getMediumDateFormat(), GanttLanguage.getInstance().getShortDateFormat()};
                for (int i = 0; i < formats.length; ++i) {
                    try {
                        Date typedDate = formats[i].parse(dateString);
                        Calendar typedCal = GanttLanguage.getInstance().newCalendar();
                        typedCal.setTime(typedDate);
                        Calendar projectStartCal = GanttLanguage.getInstance().newCalendar();
                        projectStartCal.setTime(GPTreeTableBase.this.myProject.getTaskManager().getProjectStart());
                        int yearDiff = Math.abs(typedCal.get(1) - projectStartCal.get(1));
                        if (yearDiff > 1500) {
                            AttributedCharacterIterator iter = formats[i].formatToCharacterIterator(typedDate);
                            int additionalZeroes = -1;
                            StringBuffer result = new StringBuffer();
                            char c = iter.first();
                            while (true) {
                                if (c == '\uffff') break;
                                if (iter.getAttribute(DateFormat.Field.YEAR) != null && additionalZeroes == -1) {
                                    additionalZeroes = iter.getRunLimit(DateFormat.Field.YEAR) - iter.getIndex();
                                    for (int j = 0; j < additionalZeroes; ++j) {
                                        result.append('0');
                                    }
                                }
                                result.append(c);
                                c = iter.next();
                            }
                            if (!result.toString().equals(dateString)) {
                                typedCal.add(1, 2000);
                                return typedCal.getTime();
                            }
                        }
                        return typedDate;
                    }
                    catch (ParseException e) {
                        if (i + 1 != formats.length) continue;
                        return null;
                    }
                }
                return null;
            }
        };
    }

    private static abstract class DateCellEditor
    extends DefaultCellEditor {
        private final Color colorNormal = null;
        private final Color colorError = new Color(255, 125, 125);
        private Date myDate;

        public DateCellEditor() {
            super(new JTextField());
        }

        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            JTextField result = (JTextField)super.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
            result.selectAll();
            return result;
        }

        public Object getCellEditorValue() {
            return new GanttCalendar(this.myDate == null ? new Date() : this.myDate);
        }

        protected abstract Date parseDate(String var1);

        public boolean stopCellEditing() {
            String dateString = ((JTextComponent)this.getComponent()).getText();
            Date parsedDate = this.parseDate(dateString);
            if (parsedDate == null) {
                this.getComponent().setBackground(this.colorError);
                return false;
            }
            this.myDate = parsedDate;
            this.getComponent().setBackground(this.colorNormal);
            super.fireEditingStopped();
            return true;
        }
    }
}

