/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class UpItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public UpItem() {
        super("upload", 2, -1, 70, "Peers");
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        long sort_value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long data_value = 0L;
        long prot_value = 0L;
        if (peer != null) {
            data_value = peer.getStats().getTotalDataBytesSent();
            prot_value = peer.getStats().getTotalProtocolBytesSent();
        }
        if (!cell.setSortValue(sort_value = (data_value << 32) + prot_value) && cell.isValid()) {
            return;
        }
        cell.setText(DisplayFormatters.formatDataProtByteCountToKiBEtc(data_value, prot_value));
    }
}

