/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class NameItem
extends CoreTableColumn
implements TableCellRefreshListener,
ObfusticateCellText {
    private static boolean bShowIcon;

    public NameItem(String sTableID) {
        super("name", -2, 250, sTableID);
        this.setObfustication(true);
        this.setRefreshInterval(-2);
        this.setType(1);
    }

    public void refresh(TableCell cell) {
        String name = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            name = dm.getDisplayName();
        }
        if (name == null) {
            name = "";
        }
        if ((cell.setText(name) || !cell.isValid()) && dm != null && bShowIcon) {
            Image icon = ImageRepository.getPathIcon(dm.getSaveLocation().toString());
            ((TableCellCore)cell).setImage(icon);
        }
    }

    public String getObfusticatedText(TableCell cell) {
        int i;
        String name = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null && (i = (name = dm.toString()).indexOf(35)) > 0) {
            name = name.substring(i + 1);
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    static {
        COConfigurationManager.addAndFireParameterListener("NameColumn.showProgramIcon", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                bShowIcon = COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon");
            }
        });
    }
}

