/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import java.util.Comparator;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.impl.TableRowImpl;

public class TableRowComparator
implements Comparator {
    private String sColumnName;
    private TableColumnCore tc;
    private boolean bAscending;

    public TableRowComparator(TableColumnCore tc, boolean bAscending) {
        this.tc = tc;
        this.sColumnName = tc.getName();
        this.bAscending = bAscending;
    }

    public int compare(Object arg0, Object arg1) {
        TableCellCore cell0 = ((TableRowImpl)arg0).getTableCellCore(this.sColumnName);
        TableCellCore cell1 = ((TableRowImpl)arg1).getTableCellCore(this.sColumnName);
        Object c0 = cell0 == null ? "" : cell0.getSortValue();
        Object c1 = cell1 == null ? "" : cell1.getSortValue();
        try {
            boolean c0isString = c0 instanceof String;
            boolean c1isString = c1 instanceof String;
            if (c0isString && c1isString) {
                if (this.bAscending) {
                    return ((String)c0).compareToIgnoreCase((String)c1);
                }
                return ((String)c1).compareToIgnoreCase((String)c0);
            }
            if (this.bAscending) {
                if (c0isString && !c1isString) {
                    return -1;
                }
                return c0.compareTo(c1);
            }
            if (c1isString && !c0isString) {
                return 1;
            }
            return c1.compareTo(c0);
        }
        catch (ClassCastException e) {
            System.err.println("Can't compare " + c0.getClass().getName() + "(" + c0.toString() + ") from row #" + cell0.getTableRowCore().getIndex() + " to " + c1.getClass().getName() + "(" + c1.toString() + ") from row #" + cell1.getTableRowCore().getIndex() + " while sorting column " + this.sColumnName);
            e.printStackTrace();
            return 0;
        }
    }

    public void setColumn(TableColumnCore tc) {
        if (tc == this.tc) {
            return;
        }
        this.tc = tc;
        tc.setLastSortValueChange(SystemTime.getCurrentTime());
        this.sColumnName = tc.getName();
    }

    public String getColumnName() {
        return this.sColumnName;
    }

    public TableColumnCore getColumn() {
        return this.tc;
    }

    public void setAscending(boolean bAscending) {
        if (this.bAscending == bAscending) {
            return;
        }
        this.tc.setLastSortValueChange(SystemTime.getCurrentTime());
        this.bAscending = bAscending;
    }

    public boolean isAscending() {
        return this.bAscending;
    }
}

