/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.IViewExtension;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AvailabilityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AvgAvailItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CategoryItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CompletionItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DateAddedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DownItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DownSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DownSpeedLimitItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ETAItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.FilesDoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.HealthItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.MaxUploadsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.NetworksItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.OnlyCDing4Item;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PeerSourcesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PeersItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.RankItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.RemainingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SavePathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SecondsDownloadingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SecondsSeedingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SeedToPeerRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SeedsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SendToItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ShareRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.StatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SwarmAverageCompletion;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SwarmAverageSpeed;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TimeSinceDownloadItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TimeSinceUploadItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TorrentPathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TotalSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerNameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerNextAccessItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerStatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpSpeedLimitItem;

public class MyTorrentsSuperView
extends AbstractIView
implements ObfusticateImage,
IViewExtension {
    private AzureusCore azureus_core;
    private MyTorrentsView torrentview;
    private MyTorrentsView seedingview;
    private SashForm form;
    static final TableColumnCore[] tableIncompleteItems = new TableColumnCore[]{new HealthItem("MyTorrents"), new RankItem("MyTorrents"), new SendToItem("MyTorrents"), new NameItem("MyTorrents"), new SizeItem("MyTorrents"), new DownItem(), new DoneItem("MyTorrents"), new StatusItem("MyTorrents"), new SeedsItem("MyTorrents"), new PeersItem("MyTorrents"), new DownSpeedItem(), new UpSpeedItem("MyTorrents"), new ETAItem(), new ShareRatioItem("MyTorrents"), new UpItem("MyTorrents"), new UpSpeedLimitItem("MyTorrents"), new TrackerStatusItem("MyTorrents"), new RemainingItem(), new PiecesItem(), new CompletionItem(), new MaxUploadsItem("MyTorrents"), new TotalSpeedItem("MyTorrents"), new FilesDoneItem("MyTorrents"), new SavePathItem("MyTorrents"), new TorrentPathItem("MyTorrents"), new CategoryItem("MyTorrents"), new NetworksItem("MyTorrents"), new PeerSourcesItem("MyTorrents"), new AvailabilityItem("MyTorrents"), new AvgAvailItem("MyTorrents"), new SecondsSeedingItem("MyTorrents"), new SecondsDownloadingItem("MyTorrents"), new TimeSinceDownloadItem("MyTorrents"), new TimeSinceUploadItem("MyTorrents"), new OnlyCDing4Item("MyTorrents"), new TrackerNextAccessItem("MyTorrents"), new TrackerNameItem("MyTorrents"), new SeedToPeerRatioItem("MyTorrents"), new DownSpeedLimitItem("MyTorrents"), new SwarmAverageSpeed("MyTorrents"), new SwarmAverageCompletion("MyTorrents"), new DateAddedItem("MyTorrents")};
    static final TableColumnCore[] tableCompleteItems = new TableColumnCore[]{new HealthItem("MySeeders"), new RankItem("MySeeders"), new SendToItem("MySeeders"), new NameItem("MySeeders"), new SizeItem("MySeeders"), new DoneItem("MySeeders"), new StatusItem("MySeeders"), new SeedsItem("MySeeders"), new PeersItem("MySeeders"), new UpSpeedItem("MySeeders"), new ShareRatioItem("MySeeders"), new UpItem("MySeeders"), new UpSpeedLimitItem("MySeeders"), new MaxUploadsItem("MySeeders"), new TotalSpeedItem("MySeeders"), new FilesDoneItem("MySeeders"), new SavePathItem("MySeeders"), new TorrentPathItem("MySeeders"), new CategoryItem("MySeeders"), new NetworksItem("MySeeders"), new PeerSourcesItem("MySeeders"), new AvailabilityItem("MySeeders"), new AvgAvailItem("MySeeders"), new SecondsSeedingItem("MySeeders"), new SecondsDownloadingItem("MySeeders"), new TimeSinceUploadItem("MySeeders"), new OnlyCDing4Item("MySeeders"), new TrackerStatusItem("MySeeders"), new TrackerNextAccessItem("MySeeders"), new TrackerNameItem("MySeeders"), new SeedToPeerRatioItem("MySeeders"), new SwarmAverageSpeed("MySeeders"), new SwarmAverageCompletion("MySeeders"), new DateAddedItem("MySeeders")};

    public MyTorrentsSuperView(AzureusCore _azureus_core) {
        int i;
        this.azureus_core = _azureus_core;
        TableColumnManager tcExtensions = TableColumnManager.getInstance();
        for (i = 0; i < tableCompleteItems.length; ++i) {
            tcExtensions.addColumn(tableCompleteItems[i]);
        }
        for (i = 0; i < tableIncompleteItems.length; ++i) {
            tcExtensions.addColumn(tableIncompleteItems[i]);
        }
    }

    public Composite getComposite() {
        return this.form;
    }

    public void delete() {
        if (this.torrentview != null) {
            this.torrentview.delete();
        }
        if (this.seedingview != null) {
            this.seedingview.delete();
        }
        super.delete();
    }

    public void initialize(Composite composite0) {
        if (this.form != null) {
            return;
        }
        this.form = new SashForm(composite0, 512);
        this.form.SASH_WIDTH = 5;
        GridData gridData = new GridData(1808);
        this.form.setLayoutData((Object)gridData);
        Composite child1 = new Composite((Composite)this.form, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        child1.setLayout((Layout)layout);
        this.torrentview = new MyTorrentsView(this.azureus_core, false, tableIncompleteItems);
        this.torrentview.initialize(child1);
        child1.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                int[] weights = MyTorrentsSuperView.this.form.getWeights();
                int iSashValue = weights[0] * 10000 / (weights[0] + weights[1]);
                if (iSashValue < 100) {
                    iSashValue = 100;
                }
                COConfigurationManager.setParameter("MyTorrents.SplitAt", iSashValue);
            }
        });
        Composite child2 = new Composite((Composite)this.form, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        child2.setLayout((Layout)layout);
        this.seedingview = new MyTorrentsView(this.azureus_core, true, tableCompleteItems);
        this.seedingview.initialize(child2);
        int weight = (int)COConfigurationManager.getFloatParameter("MyTorrents.SplitAt");
        if (weight > 10000) {
            weight = 10000;
        } else if (weight < 100) {
            weight *= 100;
        }
        if (weight < 100) {
            weight = 100;
        } else if (weight > 9000) {
            weight = 9000;
        }
        this.form.setWeights(new int[]{weight, 10000 - weight});
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.seedingview.refresh();
        this.torrentview.refresh();
    }

    public void updateLanguage() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.seedingview.updateLanguage();
        this.torrentview.updateLanguage();
    }

    public String getFullTitle() {
        return MessageText.getString("MyTorrentsView.mytorrents");
    }

    private IView getCurrentView() {
        try {
            if (this.torrentview.getTable().isFocusControl()) {
                return this.torrentview;
            }
            if (this.seedingview.getTable().isFocusControl()) {
                return this.seedingview;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isEnabled(String itemKey) {
        IView currentView = this.getCurrentView();
        if (currentView != null) {
            return currentView.isEnabled(itemKey);
        }
        return false;
    }

    public void itemActivated(String itemKey) {
        IView currentView = this.getCurrentView();
        if (currentView != null) {
            currentView.itemActivated(itemKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDiagnostics(IndentWriter writer) {
        super.generateDiagnostics(writer);
        try {
            writer.indent();
            writer.println("Downloading");
            writer.indent();
            this.torrentview.generateDiagnostics(writer);
        }
        finally {
            writer.exdent();
            writer.exdent();
        }
        try {
            writer.indent();
            writer.println("Seeding");
            writer.indent();
            this.seedingview.generateDiagnostics(writer);
        }
        finally {
            writer.exdent();
            writer.exdent();
        }
    }

    public Image obfusticatedImage(Image image, Point shellOffset) {
        this.torrentview.obfusticatedImage(image, shellOffset);
        this.seedingview.obfusticatedImage(image, shellOffset);
        return image;
    }

    public Menu getPrivateMenu() {
        return null;
    }

    public void viewActivated() {
        IView currentView = this.getCurrentView();
        if (currentView instanceof IViewExtension) {
            ((IViewExtension)((Object)currentView)).viewActivated();
        }
    }

    public void viewDeactivated() {
        IView currentView = this.getCurrentView();
        if (currentView instanceof IViewExtension) {
            ((IViewExtension)((Object)currentView)).viewDeactivated();
        }
    }
}

