/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import java.io.File;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.ui.swt.MessageBoxWindow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.file.FileInfoView;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.tableitems.files.DoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FirstPieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.ModeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PercentItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PieceCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PriorityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.ProgressGraphItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.RemainingPiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.StorageTypeItem;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class FilesView
extends TableView {
    boolean refreshing = false;
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new PathItem(), new SizeItem(), new DoneItem(), new PercentItem(), new FirstPieceItem(), new PieceCountItem(), new RemainingPiecesItem(), new ProgressGraphItem(), new ModeItem(), new PriorityItem(), new StorageTypeItem()};
    private DownloadManager manager = null;
    public static boolean show_full_path = COConfigurationManager.getBooleanParameter("FilesView.show.full.path", false);
    private MenuItem path_item;

    public FilesView() {
        super("Files", "FilesView", basicItems, "firstpiece", 0x10010002);
        this.setRowDefaultIconSize(new Point(16, 16));
        this.bEnableTabViews = true;
        this.coreTabViews = new IView[]{new FileInfoView()};
    }

    public void dataSourceChanged(Object newDataSource) {
        this.manager = newDataSource == null ? null : (newDataSource instanceof Object[] ? (DownloadManager)((Object[])newDataSource)[0] : (DownloadManager)newDataSource);
        this.removeAllTableRows();
    }

    public void runDefaultAction() {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)this.getFirstSelectedDataSource();
        if (fileInfo2 != null && fileInfo2.getAccessMode() == 1) {
            Program.launch((String)fileInfo2.getFile(true).toString());
        }
    }

    public void fillMenu(Menu menu) {
        Object[] infos = this.getSelectedDataSources();
        boolean hasSelection = infos.length > 0;
        MenuItem itemOpen = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemOpen, "FilesView.menu.open");
        Utils.setMenuItemImage(itemOpen, "run");
        menu.setDefaultItem(itemOpen);
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu.explore");
        itemExplore.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Object[] dataSources = FilesView.this.getSelectedDataSources();
                for (int i = dataSources.length - 1; i >= 0; --i) {
                    DiskManagerFileInfo info = (DiskManagerFileInfo)dataSources[i];
                    if (info == null) continue;
                    ManagerUtils.open(info.getFile(true));
                }
            }
        });
        itemExplore.setEnabled(hasSelection);
        MenuItem itemRename = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRename, "FilesView.menu.rename");
        MenuItem itemPriority = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemPriority, "FilesView.menu.setpriority");
        Menu menuPriority = new Menu((Decorations)this.getComposite().getShell(), 4);
        itemPriority.setMenu(menuPriority);
        MenuItem itemHigh = new MenuItem(menuPriority, 64);
        itemHigh.setData("Priority", (Object)new Integer(0));
        Messages.setLanguageText((Widget)itemHigh, "FilesView.menu.setpriority.high");
        MenuItem itemLow = new MenuItem(menuPriority, 64);
        itemLow.setData("Priority", (Object)new Integer(1));
        Messages.setLanguageText((Widget)itemLow, "FilesView.menu.setpriority.normal");
        MenuItem itemSkipped = new MenuItem(menuPriority, 64);
        itemSkipped.setData("Priority", (Object)new Integer(2));
        Messages.setLanguageText((Widget)itemSkipped, "FilesView.menu.setpriority.skipped");
        MenuItem itemDelete = new MenuItem(menuPriority, 64);
        itemDelete.setData("Priority", (Object)new Integer(3));
        Messages.setLanguageText((Widget)itemDelete, "wizard.multitracker.delete");
        new MenuItem(menu, 2);
        super.fillMenu(menu);
        if (!hasSelection) {
            itemOpen.setEnabled(false);
            itemPriority.setEnabled(false);
            itemRename.setEnabled(false);
            return;
        }
        boolean open = true;
        boolean all_compact = true;
        boolean all_skipped = true;
        boolean all_priority = true;
        boolean all_not_priority = true;
        for (int i = 0; i < infos.length; ++i) {
            DiskManagerFileInfo file_info = (DiskManagerFileInfo)infos[i];
            if (file_info.getAccessMode() != 1) {
                open = false;
            }
            if (file_info.getStorageType() != 2) {
                all_compact = false;
            }
            if (file_info.isSkipped()) {
                all_priority = false;
                all_not_priority = false;
                continue;
            }
            all_skipped = false;
            if (!file_info.isPriority()) {
                all_priority = false;
                continue;
            }
            all_not_priority = false;
        }
        itemOpen.setEnabled(open);
        itemRename.setEnabled(this.manager.isPersistent());
        itemSkipped.setEnabled(!all_skipped);
        itemHigh.setEnabled(!all_priority);
        itemLow.setEnabled(!all_not_priority);
        itemDelete.setEnabled(!all_compact);
        itemOpen.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)row.getDataSource(true);
                if (fileInfo2.getAccessMode() == 1) {
                    Program.launch((String)fileInfo2.getFile(true).toString());
                }
            }
        });
        itemRename.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                FilesView.this.rename(FilesView.this.getSelectedRows());
            }
        });
        Listener priorityListener = new Listener(){

            public void handleEvent(Event event2) {
                FilesView.this.changePriority((Integer)event2.widget.getData("Priority"), FilesView.this.getSelectedRows());
            }
        };
        itemHigh.addListener(13, priorityListener);
        itemLow.addListener(13, priorityListener);
        itemSkipped.addListener(13, priorityListener);
        itemDelete.addListener(13, priorityListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rename(TableRowCore[] rows) {
        if (this.manager == null) {
            return;
        }
        boolean paused = false;
        try {
            for (int i = 0; i < rows.length; ++i) {
                TableRowCore row = rows[i];
                final DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)row.getDataSource(true);
                FileDialog fDialog = new FileDialog(this.getComposite().getShell(), 139264);
                File existing_file = fileInfo2.getFile(true);
                fDialog.setFilterPath(existing_file.getParent());
                fDialog.setFileName(existing_file.getName());
                fDialog.setText(MessageText.getString("FilesView.rename.choose.path"));
                String res = fDialog.open();
                if (res == null) continue;
                if (!paused) {
                    paused = this.manager.pause();
                }
                final File target = new File(res);
                boolean ok = false;
                if (target.exists()) {
                    if (!target.equals(existing_file)) {
                        if (!existing_file.exists()) {
                            ok = true;
                        } else if (MessageBoxWindow.open("FilesView.messagebox.rename.id", 288, 32, true, this.getComposite().getDisplay(), "warning", MessageText.getString("FilesView.rename.confirm.delete.title"), MessageText.getString("FilesView.rename.confirm.delete.text", new String[]{existing_file.toString()})) == 32) {
                            ok = true;
                        }
                    }
                } else {
                    ok = true;
                }
                if (!ok) continue;
                final boolean[] result = new boolean[]{false};
                FileUtil.runAsTask(new AzureusCoreOperationTask(){

                    public void run(AzureusCoreOperation operation) {
                        result[0] = fileInfo2.setLink(target);
                    }
                });
                if (!result[0]) {
                    MessageBox mb = new MessageBox(this.getComposite().getShell(), 33);
                    mb.setText(MessageText.getString("FilesView.rename.failed.title"));
                    mb.setMessage(MessageText.getString("FilesView.rename.failed.text"));
                    mb.open();
                }
                row.invalidate();
            }
        }
        finally {
            if (paused) {
                this.manager.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changePriority(int type, TableRowCore[] rows) {
        if (this.manager == null) {
            return;
        }
        boolean paused = false;
        try {
            for (int i = 0; i < rows.length; ++i) {
                boolean this_paused;
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)rows[i].getDataSource(true);
                if (type == 0) {
                    fileInfo2.setPriority(true);
                    this_paused = this.setSkipped(fileInfo2, false, false);
                } else if (type == 1) {
                    fileInfo2.setPriority(false);
                    this_paused = this.setSkipped(fileInfo2, false, false);
                } else {
                    this_paused = type == 2 ? this.setSkipped(fileInfo2, true, false) : this.setSkipped(fileInfo2, true, true);
                }
                paused = paused || this_paused;
            }
        }
        finally {
            if (paused) {
                this.manager.resume();
            }
        }
    }

    protected boolean setSkipped(DiskManagerFileInfo info, boolean skipped, boolean delete_action) {
        boolean ok;
        int new_storage_type;
        if (!this.manager.isPersistent()) {
            info.setSkipped(skipped);
            return false;
        }
        File existing_file = info.getFile(true);
        int existing_storage_type = info.getStorageType();
        if (existing_file.exists()) {
            boolean delete_file;
            new_storage_type = !skipped ? 1 : ((delete_file = delete_action ? MessageBoxWindow.open("FilesView.messagebox.delete.id", 288, 32, true, this.getComposite().getDisplay(), "warning", MessageText.getString("FilesView.rename.confirm.delete.title"), MessageText.getString("FilesView.rename.confirm.delete.text", new String[]{existing_file.toString()})) == 32 : false) ? 2 : 1);
        } else if (skipped) {
            boolean compact_disabled;
            boolean bl = compact_disabled = MessageBoxWindow.getRememberedDecision("FilesView.messagebox.skip.id", 192) == 128;
            new_storage_type = compact_disabled ? 1 : 2;
        } else {
            new_storage_type = 1;
        }
        boolean paused = false;
        if (existing_storage_type != new_storage_type) {
            if (new_storage_type == 2) {
                paused = this.manager.pause();
            }
            ok = info.setStorageType(new_storage_type);
        } else {
            ok = true;
        }
        if (ok) {
            info.setSkipped(skipped);
        }
        return paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh(boolean bForceSort) {
        if (this.refreshing) {
            return;
        }
        try {
            this.refreshing = true;
            if (this.getComposite() == null || this.getComposite().isDisposed()) {
                return;
            }
            this.removeInvalidFileItems();
            DiskManagerFileInfo[] files = this.getFileInfo();
            if (files != null && this.getTable().getItemCount() != files.length && files.length > 0) {
                Object[] filesCopy = new Object[files.length];
                System.arraycopy(files, 0, filesCopy, 0, files.length);
                this.addDataSources(filesCopy);
                this.processDataSourceQueue();
            }
            super.refresh(bForceSort);
        }
        finally {
            this.refreshing = false;
        }
    }

    private void removeInvalidFileItems() {
        final DiskManagerFileInfo[] files = this.getFileInfo();
        this.runForAllRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)row.getDataSource(true);
                if (fileInfo2 != null && !FilesView.this.containsFileInfo(files, fileInfo2)) {
                    FilesView.this.removeDataSource(fileInfo2);
                }
            }
        });
    }

    private boolean containsFileInfo(DiskManagerFileInfo[] files, DiskManagerFileInfo file) {
        if (files == null || file == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i] != file) continue;
            return true;
        }
        return false;
    }

    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        if (sColumnName.equals("path")) {
            this.path_item = new MenuItem(menuThisColumn, 32);
            menuThisColumn.addListener(22, new Listener(){

                public void handleEvent(Event e) {
                    FilesView.this.path_item.setSelection(show_full_path);
                }
            });
            Messages.setLanguageText((Widget)this.path_item, "FilesView.fullpath");
            this.path_item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    show_full_path = FilesView.this.path_item.getSelection();
                    FilesView.this.columnInvalidate("path");
                    FilesView.this.refreshTable(false);
                    COConfigurationManager.setParameter("FilesView.show.full.path", show_full_path);
                }
            });
        }
    }

    private DiskManagerFileInfo[] getFileInfo() {
        if (this.manager == null) {
            return null;
        }
        return this.manager.getDiskManagerFileInfo();
    }
}

