/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class InputShell {
    private String sTitleKey;
    private String[] p0;
    private String sLabelKey;
    private String[] p1;
    private String textValue;
    private boolean bMultiLine;

    public InputShell(String sTitleKey, String sLabelKey) {
        this(sTitleKey, null, sLabelKey, null, false);
    }

    public InputShell(String sTitleKey, String sLabelKey, boolean bMultiLine) {
        this(sTitleKey, null, sLabelKey, null, bMultiLine);
    }

    public InputShell(String sTitleKey, String[] p0, String sLabelKey, String[] p1) {
        this(sTitleKey, p1, sLabelKey, p1, false);
    }

    public InputShell(String sTitleKey, String[] p0, String sLabelKey, String[] p1, boolean bMultiLine) {
        this.sTitleKey = sTitleKey;
        this.p0 = p0;
        this.sLabelKey = sLabelKey;
        this.p1 = p1;
        this.bMultiLine = bMultiLine;
        this.setTextValue("");
    }

    public String open() {
        Display display = SWTThread.getInstance().getDisplay();
        if (display == null) {
            return null;
        }
        final Shell shell = ShellFactory.createShell(display.getActiveShell(), 67696);
        Messages.setLanguageText((Widget)shell, this.sTitleKey, this.p0);
        Utils.setShellIcon(shell);
        GridLayout layout = new GridLayout();
        shell.setLayout((Layout)layout);
        Label label = new Label((Composite)shell, 64);
        Messages.setLanguageText((Widget)label, this.sLabelKey, this.p1);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        label.setLayoutData((Object)gridData);
        int style = 2048;
        if (this.bMultiLine) {
            style |= 2;
        }
        final Text text = new Text((Composite)shell, style);
        gridData = new GridData(1808);
        gridData.widthHint = 300;
        if (this.bMultiLine) {
            gridData.heightHint = 100;
        }
        text.setLayoutData((Object)gridData);
        text.setText(this.textValue);
        text.selectAll();
        Composite panel = new Composite((Composite)shell, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 1024;
        panel.setLayoutData((Object)gridData);
        Button ok = new Button(panel, 8);
        ok.setText(MessageText.getString("Button.ok"));
        gridData = new GridData();
        gridData.widthHint = 70;
        ok.setLayoutData((Object)gridData);
        shell.setDefaultButton(ok);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    InputShell.this.setTextValue(text.getText());
                    shell.dispose();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        Button cancel = new Button(panel, 8);
        cancel.setText(MessageText.getString("Button.cancel"));
        gridData = new GridData();
        gridData.widthHint = 70;
        cancel.setLayoutData((Object)gridData);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                shell.dispose();
            }
        });
        shell.pack();
        Utils.centreWindow(shell);
        Utils.createURLDropTarget((Composite)shell, text);
        this.setTextValue(null);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.getTextValue();
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setLabelParameters(String[] p1) {
        this.p1 = p1;
    }

    public boolean isMultiLine() {
        return this.bMultiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.bMultiLine = multiLine;
    }
}

