/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsinstaller;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.installer.FilePluginInstaller;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.pluginsinstaller.IPWInstallModePanel;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class IPWFilePanel
extends AbstractWizardPanel {
    Text txtFile;
    boolean valid = false;

    public IPWFilePanel(Wizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        this.wizard.setTitle(MessageText.getString("installPluginsWizard.file.title"));
        this.wizard.setErrorMessage("");
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "installPluginsWizard.file.file");
        this.txtFile = new Text(panel, 2048);
        GridData data = new GridData(768);
        this.txtFile.setLayoutData((Object)data);
        this.txtFile.addListener(24, new Listener(){

            public void handleEvent(Event event2) {
                IPWFilePanel.this.checkValidFile();
            }
        });
        Button btnBrowse = new Button(panel, 8);
        Messages.setLanguageText((Widget)btnBrowse, "installPluginsWizard.file.browse");
        btnBrowse.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                FileDialog fd = new FileDialog(IPWFilePanel.this.wizard.getWizardWindow());
                fd.setFilterExtensions(new String[]{"*.zip;*.jar"});
                fd.setFilterNames(new String[]{"Azureus Plugins"});
                String fileName = fd.open();
                if (fileName != null) {
                    IPWFilePanel.this.txtFile.setText(fileName);
                }
            }
        });
        this.checkValidFile();
    }

    private void checkValidFile() {
        String fileName = this.txtFile.getText();
        try {
            File f = new File(fileName);
            if (f.exists() && (f.getName().endsWith(".jar") || f.getName().endsWith(".zip"))) {
                this.wizard.setErrorMessage("");
                this.wizard.setNextEnabled(true);
                ArrayList<FilePluginInstaller> list = new ArrayList<FilePluginInstaller>();
                FilePluginInstaller plugin = this.wizard.getAzureusCore().getPluginManager().getPluginInstaller().installFromFile(f);
                list.add(plugin);
                ((InstallPluginWizard)this.wizard).plugins = list;
                this.valid = true;
                return;
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        this.valid = false;
        this.wizard.setErrorMessage(MessageText.getString("installPluginsWizard.file.invalidfile"));
        this.wizard.setNextEnabled(false);
    }

    public boolean isNextEnabled() {
        return this.valid;
    }

    public IWizardPanel getNextPanel() {
        return new IPWInstallModePanel(this.wizard, this);
    }
}

