/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ColorUtils {
    public static final Color getShade(Color original, int delta) {
        RGB newRGB = new RGB(Math.min(255, Math.max(0, original.getRed() + delta)), Math.min(255, Math.max(0, original.getGreen() + delta)), Math.min(255, Math.max(0, original.getBlue() + delta)));
        return new Color((Device)Display.getDefault(), newRGB);
    }

    public static final Color getBoundedShade(Color original, int delta) {
        RGB newRGB = new RGB(ColorUtils.getBoundedShade(original.getRed(), delta), ColorUtils.getBoundedShade(original.getGreen(), delta), ColorUtils.getBoundedShade(original.getBlue(), delta));
        return new Color((Device)Display.getDefault(), newRGB);
    }

    private static int getBoundedShade(int origValue, int delta) {
        int result = origValue + delta;
        if (result > 255) {
            result = origValue - delta;
            if (result < 0) {
                result = origValue;
            }
        } else if (result < 0 && (result = origValue - delta) > 255) {
            result = origValue;
        }
        return result;
    }
}

