/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.ui.swt.ImageRepository;

public class PasswordWindow {
    private Shell shell;
    private static boolean bOk;
    protected static AESemaphore class_sem;
    private static PasswordWindow window;

    public static boolean showPasswordWindow(final Display display) {
        final boolean bSWTThread = display.getThread() == Thread.currentThread();
        display.syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (window == null) {
                    window = new PasswordWindow(display);
                } else {
                    window.shell.forceActive();
                }
                if (bSWTThread) {
                    window.run();
                }
            }
        });
        if (!bSWTThread) {
            class_sem.reserve();
        }
        return bOk;
    }

    protected PasswordWindow(Display display) {
        bOk = false;
        this.shell = new Shell(display, 65632);
        this.shell.setText(MessageText.getString("PasswordWindow.title"));
        if (!Constants.isOSX) {
            this.shell.setImage(ImageRepository.getImage("azureus"));
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.shell.setLayout((Layout)layout);
        Label label = new Label((Composite)this.shell, 0);
        label.setText(MessageText.getString("PasswordWindow.passwordprotected"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        final Text password = new Text((Composite)this.shell, 2048);
        password.setEchoChar('*');
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        password.setLayoutData((Object)gridData);
        Button ok = new Button((Composite)this.shell, 8);
        ok.setText(MessageText.getString("Button.ok"));
        gridData = new GridData(64);
        gridData.widthHint = 70;
        ok.setLayoutData((Object)gridData);
        this.shell.setDefaultButton(ok);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    SHA1Hasher hasher = new SHA1Hasher();
                    byte[] passwordText = password.getText().getBytes();
                    byte[] encoded = hasher.calculateHash(passwordText);
                    byte[] correct = COConfigurationManager.getByteParameter("Password", "".getBytes());
                    boolean same = true;
                    for (int i = 0; i < correct.length; ++i) {
                        if (correct[i] == encoded[i]) continue;
                        same = false;
                    }
                    if (same) {
                        bOk = same;
                        PasswordWindow.this.shell.dispose();
                    } else {
                        PasswordWindow.this.close();
                    }
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        Button cancel = new Button((Composite)this.shell, 8);
        cancel.setText(MessageText.getString("Button.cancel"));
        gridData = new GridData(64);
        gridData.widthHint = 70;
        cancel.setLayoutData((Object)gridData);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                PasswordWindow.this.close();
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                window = null;
                class_sem.releaseAllWaiters();
            }
        });
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    PasswordWindow.this.close();
                    e.doit = false;
                }
            }
        });
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event arg0) {
                PasswordWindow.this.close();
            }
        });
        this.shell.pack();
        this.shell.open();
    }

    protected void run() {
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void close() {
        Shell mainShell;
        UIFunctionsSWT uiFunctions;
        this.shell.dispose();
        if (Constants.isOSX && (uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null && (mainShell = uiFunctions.getMainShell()) != null) {
            mainShell.setMinimized(true);
            mainShell.setVisible(true);
        }
    }

    public static void main(String[] args) {
        final Display display = new Display();
        new Thread(new Runnable(){

            public void run() {
                System.out.println("2: " + PasswordWindow.showPasswordWindow(display));
            }
        }).start();
        new Thread(new Runnable(){

            public void run() {
                display.syncExec(new Runnable(this){
                    private final /* synthetic */ 8 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        System.out.println("3: " + PasswordWindow.showPasswordWindow(8.access$400(this.this$0)));
                    }
                });
            }

            static /* synthetic */ Display access$400(8 x0) {
                return x0.display;
            }
        }).start();
        display.asyncExec(new Runnable(){

            public void run() {
                System.out.println("4: " + PasswordWindow.showPasswordWindow(display));
            }
        });
        System.out.println("1: " + PasswordWindow.showPasswordWindow(display));
    }

    static {
        class_sem = new AESemaphore("PasswordWindow");
        window = null;
    }
}

