/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderCandidate;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.internat.LocaleUtilListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class LocaleUtilSWT
implements LocaleUtilListener {
    protected static boolean rememberEncodingDecision = true;
    protected static LocaleUtilDecoder rememberedDecoder = null;
    protected static Object remembered_on_behalf_of;

    public LocaleUtilSWT(AzureusCore core) {
        LocaleTorrentUtil.addListener(this);
    }

    public LocaleUtilDecoderCandidate selectDecoder(LocaleUtil locale_util, Object decision_owner, LocaleUtilDecoderCandidate[] candidates) throws LocaleUtilEncodingException {
        int i;
        if (decision_owner != remembered_on_behalf_of) {
            remembered_on_behalf_of = decision_owner;
            rememberedDecoder = null;
        }
        if (rememberEncodingDecision && rememberedDecoder != null) {
            for (int i2 = 0; i2 < candidates.length; ++i2) {
                if (candidates[i2].getValue() == null || rememberedDecoder != candidates[i2].getDecoder()) continue;
                return candidates[i2];
            }
        }
        LocaleUtilDecoderCandidate default_candidate = candidates[0];
        String defaultString = candidates[0].getValue();
        Arrays.sort(candidates);
        boolean always_prompt = COConfigurationManager.getBooleanParameter("File.Decoder.Prompt", false);
        if (!always_prompt) {
            int minlength = candidates[0].getValue().length();
            if (defaultString != null && defaultString.length() == minlength) {
                return null;
            }
            String default_name = COConfigurationManager.getStringParameter("File.Decoder.Default", "");
            if (default_name.length() > 0) {
                for (i = 0; i < candidates.length; ++i) {
                    if (candidates[i].getValue() == null || !candidates[i].getDecoder().getName().equals(default_name)) continue;
                    return candidates[i];
                }
            }
        }
        ArrayList<LocaleUtilDecoderCandidate> choosableCandidates = new ArrayList<LocaleUtilDecoderCandidate>();
        if (defaultString != null) {
            choosableCandidates.add(default_candidate);
        }
        LocaleUtilDecoder[] general_decoders = locale_util.getGeneralDecoders();
        block2: for (int j = 0; j < general_decoders.length; ++j) {
            for (int i3 = 0; i3 < candidates.length; ++i3) {
                if (candidates[i3].getValue() == null || candidates[i3].getDecoder() == null || general_decoders[j] == null || !general_decoders[j].getName().equals(candidates[i3].getDecoder().getName()) || choosableCandidates.contains(candidates[i3])) continue;
                choosableCandidates.add(candidates[i3]);
                continue block2;
            }
        }
        for (i = 0; i < candidates.length; ++i) {
            if (candidates[i].getValue() == null || candidates[i].getDecoder() == null || choosableCandidates.contains(candidates[i])) continue;
            choosableCandidates.add(candidates[i]);
        }
        final LocaleUtilDecoderCandidate[] candidatesToChoose = choosableCandidates.toArray(new LocaleUtilDecoderCandidate[choosableCandidates.size()]);
        final LocaleUtilDecoderCandidate[] selected_candidate = new LocaleUtilDecoderCandidate[]{null};
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    LocaleUtilSWT.this.showChoosableEncodingWindow(Utils.findAnyShell(), candidatesToChoose, selected_candidate);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }, false);
        if (selected_candidate[0] == null) {
            throw new LocaleUtilEncodingException(true);
        }
        return selected_candidate[0];
    }

    private void showChoosableEncodingWindow(Shell shell, final LocaleUtilDecoderCandidate[] candidates, final LocaleUtilDecoderCandidate[] selected_candidate) {
        int i;
        final Shell s = ShellFactory.createShell(shell, 34928);
        Utils.setShellIcon(s);
        s.setText(MessageText.getString("LocaleUtil.title"));
        s.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label((Composite)s, 16384);
        Messages.setLanguageText((Widget)label, "LocaleUtil.label.chooseencoding");
        final Table table = new Table((Composite)s, 68100);
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] titlesPieces = new String[]{"encoding", "text"};
        for (i = 0; i < titlesPieces.length; ++i) {
            TableColumn column = new TableColumn(table, 16384);
            Messages.setLanguageText((Widget)column, "LocaleUtil.column." + titlesPieces[i]);
        }
        for (i = 0; i < candidates.length; ++i) {
            TableItem item = new TableItem(table, 0);
            String name = candidates[i].getDecoder().getName();
            item.setText(0, name);
            item.setText(1, candidates[i].getValue());
        }
        int lastSelectedIndex = 0;
        for (int i2 = 1; i2 < candidates.length; ++i2) {
            if (candidates[i2].getValue() == null || candidates[i2].getDecoder() != rememberedDecoder) continue;
            lastSelectedIndex = i2;
            break;
        }
        table.select(lastSelectedIndex);
        table.getColumn(0).pack();
        table.getColumn(1).pack();
        label = new Label((Composite)s, 16384);
        Messages.setLanguageText((Widget)label, "LocaleUtil.label.hint.doubleclick");
        Composite composite = new Composite((Composite)s, 0);
        gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout subLayout = new GridLayout();
        subLayout.numColumns = 2;
        composite.setLayout((Layout)subLayout);
        final Button checkBox = new Button(composite, 32);
        checkBox.setLayoutData((Object)new GridData(32));
        checkBox.setSelection(rememberEncodingDecision);
        Messages.setLanguageText((Widget)checkBox, "LocaleUtil.label.checkbox.rememberdecision");
        Button ok = new Button(composite, 8);
        ok.setText(" ".concat(MessageText.getString("Button.next")).concat(" "));
        gridData = new GridData(3);
        gridData.widthHint = 100;
        ok.setLayoutData((Object)gridData);
        s.setSize(500, 500);
        s.layout();
        Utils.centreWindow(s);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                LocaleUtilSWT.this.setSelectedIndex(s, table, checkBox, candidates, selected_candidate);
                s.dispose();
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mEvent) {
                LocaleUtilSWT.this.setSelectedIndex(s, table, checkBox, candidates, selected_candidate);
                s.dispose();
            }
        });
        s.open();
        while (!s.isDisposed()) {
            if (s.getDisplay().readAndDispatch()) continue;
            s.getDisplay().sleep();
        }
    }

    private void setSelectedIndex(Shell s, Table table, Button checkBox, LocaleUtilDecoderCandidate[] candidates, LocaleUtilDecoderCandidate[] selected_candidate) {
        int selectedIndex = table.getSelectionIndex();
        if (-1 == selectedIndex) {
            return;
        }
        rememberEncodingDecision = checkBox.getSelection();
        selected_candidate[0] = candidates[selectedIndex];
        rememberedDecoder = rememberEncodingDecision ? selected_candidate[0].getDecoder() : null;
        s.dispose();
    }

    private void abandonSelection(Shell s) {
        s.dispose();
    }
}

