/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import com.aelitis.azureus.core.AzureusCoreException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.download.DownloadManager;

public class TorrentFilter {
    private static final Pattern rangePattern = Pattern.compile("([0-9]+)\\s*((-)|(-\\s*([0-9]+)))?");

    private List matchRange(List torrents, String filter) {
        Matcher matcher = rangePattern.matcher(filter);
        ArrayList list = new ArrayList();
        if (matcher.matches()) {
            int minId = Integer.parseInt(matcher.group(1));
            if (minId == 0) {
                throw new AzureusCoreException("lower range must be greater than 0");
            }
            if (minId > torrents.size()) {
                throw new AzureusCoreException("lower range specified (" + minId + ") is outside number of torrents (" + torrents.size() + ")");
            }
            if (matcher.group(2) == null) {
                list.add(torrents.get(minId - 1));
                return list;
            }
            int maxId = matcher.group(3) == null ? Integer.parseInt(matcher.group(5)) : torrents.size();
            if (minId > maxId) {
                throw new AzureusCoreException("when specifying a range, the max value must be greater than or equal to the min value");
            }
            for (int i = minId - 1; i < maxId && i < torrents.size(); ++i) {
                list.add(torrents.get(i));
            }
        }
        return list;
    }

    private List matchWildcard(List torrents, String filter) {
        Pattern pattern = Pattern.compile(this.wildcardToPattern(filter), 2);
        ArrayList<DownloadManager> list = new ArrayList<DownloadManager>();
        Iterator iter = torrents.iterator();
        while (iter.hasNext()) {
            DownloadManager dm = (DownloadManager)iter.next();
            if (!pattern.matcher(dm.getDisplayName()).matches()) continue;
            list.add(dm);
        }
        return list;
    }

    private String wildcardToPattern(String wild) {
        if (wild == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        char[] chars = wild.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '*') {
                buffer.append(".*");
                continue;
            }
            if (chars[i] == '?') {
                buffer.append(".");
                continue;
            }
            if ("+()^$.{}[]|\\".indexOf(chars[i]) != -1) {
                buffer.append('\\').append(chars[i]);
                continue;
            }
            buffer.append(chars[i]);
        }
        return buffer.toString().toLowerCase();
    }

    public List getTorrents(List torrentsToMatch, String filter) {
        ArrayList torrents = new ArrayList();
        torrents.addAll(this.matchRange(torrentsToMatch, filter));
        torrents.addAll(this.matchWildcard(torrentsToMatch, filter));
        return torrents;
    }

    public List getTorrents(List torrentsToMatch, List args) {
        StringBuffer allArgs = new StringBuffer();
        boolean first = true;
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            if (!first) {
                allArgs.append(",");
            } else {
                first = false;
            }
            allArgs.append(iter.next());
        }
        List torrents = this.matchWildcard(torrentsToMatch, allArgs.toString());
        if (torrents.size() > 0) {
            return torrents;
        }
        torrents = this.matchRange(torrentsToMatch, allArgs.toString());
        if (torrents.size() > 0) {
            return torrents;
        }
        Iterator iter2 = args.iterator();
        while (iter2.hasNext()) {
            torrents.addAll(this.getTorrents(torrentsToMatch, (String)iter2.next()));
        }
        return torrents;
    }
}

