/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.rss;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSChannel;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSItem;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSItemImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSUtils;

public class RSSChannelImpl
implements RSSChannel {
    private SimpleXMLParserDocumentNode node;
    private RSSItem[] items;

    protected RSSChannelImpl(SimpleXMLParserDocumentNode _node) {
        this.node = _node;
        SimpleXMLParserDocumentNode[] xml_items = this.node.getChildren();
        ArrayList<RSSItemImpl> its = new ArrayList<RSSItemImpl>();
        for (int i = 0; i < xml_items.length; ++i) {
            SimpleXMLParserDocumentNode xml_item = xml_items[i];
            if (!xml_item.getName().equalsIgnoreCase("item")) continue;
            its.add(new RSSItemImpl(xml_item));
        }
        this.items = new RSSItem[its.size()];
        its.toArray(this.items);
    }

    public String getTitle() {
        return this.node.getChild("title").getValue();
    }

    public String getDescription() {
        return this.node.getChild("description").getValue();
    }

    public URL getLink() {
        try {
            return new URL(this.node.getChild("link").getValue());
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public Date getPublicationDate() {
        SimpleXMLParserDocumentNode pd = this.node.getChild("pubdate");
        if (pd == null) {
            return null;
        }
        return RSSUtils.parseDate(pd.getValue());
    }

    public RSSItem[] getItems() {
        return this.items;
    }

    public SimpleXMLParserDocumentNode getNode() {
        return this.node;
    }
}

