/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.config.ConfigParameterListener;
import org.gudy.azureus2.plugins.ui.config.EnablerParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterGroupImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImplListener;

public class ParameterImpl
implements EnablerParameter,
org.gudy.azureus2.core3.config.ParameterListener {
    protected PluginConfig config;
    private String key;
    private String labelKey;
    private String label;
    private boolean enabled = true;
    private boolean visible = true;
    private List toDisable = new ArrayList();
    private List toEnable = new ArrayList();
    private List listeners = new ArrayList();
    private List impl_listeners = new ArrayList();
    private ParameterGroupImpl parameter_group;

    public ParameterImpl(PluginConfig _config, String _key, String _label) {
        this.config = _config;
        this.key = _key;
        this.labelKey = _label;
        this.label = MessageText.getString(this.labelKey);
    }

    public String getKey() {
        return this.key;
    }

    public void addDisabledOnSelection(Parameter parameter) {
        this.toDisable.add(parameter);
    }

    public void addEnabledOnSelection(Parameter parameter) {
        this.toEnable.add(parameter);
    }

    public List getDisabledOnSelectionParameters() {
        return this.toDisable;
    }

    public List getEnabledOnSelectionParameters() {
        return this.toEnable;
    }

    public void parameterChanged(String key) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object o = this.listeners.get(i);
            if (o instanceof ParameterListener) {
                ((ParameterListener)o).parameterChanged(this);
                continue;
            }
            ((ConfigParameterListener)o).configParameterChanged(this);
        }
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
        for (int i = 0; i < this.impl_listeners.size(); ++i) {
            try {
                ((ParameterImplListener)this.impl_listeners.get(i)).enabledChanged(this);
                continue;
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setVisible(boolean _visible) {
        this.visible = _visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setGroup(ParameterGroupImpl _group) {
        this.parameter_group = _group;
    }

    public ParameterGroupImpl getGroup() {
        return this.parameter_group;
    }

    public void addListener(ParameterListener l) {
        this.listeners.add(l);
        if (this.listeners.size() == 1) {
            COConfigurationManager.addParameterListener(this.key, this);
        }
    }

    public void removeListener(ParameterListener l) {
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            COConfigurationManager.removeParameterListener(this.key, this);
        }
    }

    public void addImplListener(ParameterImplListener l) {
        this.impl_listeners.add(l);
    }

    public void removeImplListener(ParameterImplListener l) {
        this.impl_listeners.remove(l);
    }

    public void addConfigParameterListener(ConfigParameterListener l) {
        this.listeners.add(l);
        if (this.listeners.size() == 1) {
            COConfigurationManager.addParameterListener(this.key, this);
        }
    }

    public void removeConfigParameterListener(ConfigParameterListener l) {
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            COConfigurationManager.removeParameterListener(this.key, this);
        }
    }

    public String getLabelText() {
        return this.label;
    }

    public void setLabelText(String sText) {
        this.labelKey = null;
        this.label = sText;
        for (int i = 0; i < this.impl_listeners.size(); ++i) {
            try {
                ((ParameterImplListener)this.impl_listeners.get(i)).labelChanged(this, sText, false);
                continue;
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
        }
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public void setLabelKey(String sLabelKey) {
        this.labelKey = sLabelKey;
        this.label = MessageText.getString(sLabelKey);
        for (int i = 0; i < this.impl_listeners.size(); ++i) {
            try {
                ((ParameterImplListener)this.impl_listeners.get(i)).labelChanged(this, this.labelKey, true);
                continue;
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
        }
    }
}

