/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.tracker.host.TRHostAuthenticationListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerAuthenticationListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWebPageRequestImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWebPageResponseImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public abstract class TrackerWCHelper
implements TrackerWebContext,
TRHostAuthenticationListener,
TRTrackerServerAuthenticationListener {
    private PluginInterface plugin_interface;
    private Tracker tracker;
    private List generators = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TrackerWCHelper");

    protected TrackerWCHelper() {
        this.plugin_interface = UtilitiesImpl.getPluginThreadContext();
    }

    protected void setTracker(Tracker _tracker) {
        this.tracker = _tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleExternalRequest(InetSocketAddress _client_address, String _user, String _url, URL _absolute_url, String _header, InputStream _is, OutputStream _os) throws IOException {
        UtilitiesImpl.setPluginThreadContext(this.plugin_interface);
        TrackerWebPageRequestImpl request2 = new TrackerWebPageRequestImpl(this.tracker, this, _client_address, _user, _url, _absolute_url, _header, _is);
        TrackerWebPageResponseImpl reply = new TrackerWebPageResponseImpl(_os);
        for (int i = 0; i < this.generators.size(); ++i) {
            TrackerWebPageGenerator generator;
            try {
                this.this_mon.enter();
                if (i >= this.generators.size()) break;
                generator = (TrackerWebPageGenerator)this.generators.get(i);
            }
            finally {
                this.this_mon.exit();
            }
            if (!generator.generate(request2, reply)) continue;
            reply.complete();
            return true;
        }
        return false;
    }

    public TrackerWebPageGenerator[] getPageGenerators() {
        TrackerWebPageGenerator[] res = new TrackerWebPageGenerator[this.generators.size()];
        this.generators.toArray(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPageGenerator(TrackerWebPageGenerator generator) {
        try {
            this.this_mon.enter();
            this.generators.add(generator);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePageGenerator(TrackerWebPageGenerator generator) {
        try {
            this.this_mon.enter();
            this.generators.remove(generator);
        }
        finally {
            this.this_mon.exit();
        }
    }
}

