/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.network;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import java.nio.ByteBuffer;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.network.ConnectionListener;
import org.gudy.azureus2.plugins.network.IncomingMessageQueue;
import org.gudy.azureus2.plugins.network.OutgoingMessageQueue;
import org.gudy.azureus2.plugins.network.Transport;
import org.gudy.azureus2.pluginsimpl.local.network.IncomingMessageQueueImpl;
import org.gudy.azureus2.pluginsimpl.local.network.OutgoingMessageQueueImpl;
import org.gudy.azureus2.pluginsimpl.local.network.TransportImpl;

public class ConnectionImpl
implements Connection {
    private final NetworkConnection core_connection;
    private final OutgoingMessageQueueImpl out_queue;
    private final IncomingMessageQueueImpl in_queue;
    private final TransportImpl tcp_transport;

    public ConnectionImpl(NetworkConnection core_connection) {
        this.core_connection = core_connection;
        this.out_queue = new OutgoingMessageQueueImpl(core_connection.getOutgoingMessageQueue());
        this.in_queue = new IncomingMessageQueueImpl(core_connection.getIncomingMessageQueue());
        this.tcp_transport = new TransportImpl(core_connection);
    }

    public void connect(final ConnectionListener listener) {
        this.core_connection.connect(new NetworkConnection.ConnectionListener(){

            public void connectStarted() {
                listener.connectStarted();
            }

            public void connectSuccess(ByteBuffer remaining_initial_data) {
                listener.connectSuccess();
            }

            public void connectFailure(Throwable failure_msg) {
                listener.connectFailure(failure_msg);
            }

            public void exceptionThrown(Throwable error) {
                listener.exceptionThrown(error);
            }
        });
    }

    public void close() {
        this.core_connection.close();
    }

    public OutgoingMessageQueue getOutgoingMessageQueue() {
        return this.out_queue;
    }

    public IncomingMessageQueue getIncomingMessageQueue() {
        return this.in_queue;
    }

    public void startMessageProcessing() {
        this.core_connection.startMessageProcessing(new LimitedRateGroup(){

            public int getRateLimitBytesPerSecond() {
                return 0;
            }
        }, new LimitedRateGroup(){

            public int getRateLimitBytesPerSecond() {
                return 0;
            }
        });
        this.core_connection.enableEnhancedMessageProcessing(true);
    }

    public Transport getTransport() {
        return this.tcp_transport;
    }

    public NetworkConnection getCoreConnection() {
        return this.core_connection;
    }
}

