/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.installer;

import java.util.List;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.pluginsimpl.local.installer.InstallablePluginImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;

public class StandardPluginImpl
implements StandardPlugin,
InstallablePluginImpl {
    private PluginInstallerImpl installer;
    private SFPluginDetails details;
    private String version;

    protected StandardPluginImpl(PluginInstallerImpl _installer, SFPluginDetails _details, String _version) {
        this.installer = _installer;
        this.details = _details;
        this.version = _version == null ? "" : _version;
    }

    public String getId() {
        return this.details.getId();
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.details.getName();
    }

    public String getDescription() {
        try {
            List lines = HTMLUtils.convertHTMLToText("", this.details.getDescription());
            String res = "";
            for (int i = 0; i < lines.size(); ++i) {
                res = res + (i == 0 ? "" : "\n") + lines.get(i);
            }
            return res;
        }
        catch (Throwable e) {
            return Debug.getNestedExceptionMessage(e);
        }
    }

    public PluginInterface getAlreadyInstalledPlugin() {
        return this.installer.getAlreadyInstalledPlugin(this.getId());
    }

    public void install(boolean shared) throws PluginException {
        this.installer.install(this, shared);
    }

    public void uninstall() throws PluginException {
        this.installer.uninstall(this);
    }

    public PluginInstaller getInstaller() {
        return this.installer;
    }

    public void addUpdate(UpdateCheckInstance inst, PluginUpdatePlugin plugin_update_plugin, Plugin plugin, PluginInterface plugin_interface) {
        inst.addUpdatableComponent(plugin_update_plugin.getCustomUpdateableComponent(this.getId(), false), false);
    }
}

